/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractPeerProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements PeerProcedureInterface {
    protected String peerId;
    private volatile boolean locked;
    protected ProcedurePrepareLatch latch;

    protected AbstractPeerProcedure() {
    }

    protected AbstractPeerProcedure(String peerId) {
        this.peerId = peerId;
        this.latch = ProcedurePrepareLatch.createLatch(2, 0);
    }

    public ProcedurePrepareLatch getLatch() {
        return this.latch;
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitPeerExclusiveLock((Procedure<?>)this, this.peerId)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        this.locked = true;
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        this.locked = false;
        env.getProcedureScheduler().wakePeerExclusiveLock((Procedure<?>)this, this.peerId);
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    protected boolean hasLock(MasterProcedureEnv env) {
        return this.locked;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.PeerProcedureStateData.newBuilder().setPeerId(this.peerId).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        this.peerId = ((MasterProcedureProtos.PeerProcedureStateData)serializer.deserialize(MasterProcedureProtos.PeerProcedureStateData.class)).getPeerId();
    }
}

