/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.CacheEvictionStatsBuilder;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hadoop.hbase.quotas.ActivePolicyEnforcement;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerIdGenerator;
import org.apache.hadoop.hbase.regionserver.Shipper;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenPriorityRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSRpcServices
implements HBaseRPCErrorHandler,
AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
PriorityFunction,
ConfigurationObserver {
    protected static final Logger LOG = LoggerFactory.getLogger(RSRpcServices.class);
    public static final String REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS = "hbase.region.server.rpc.scheduler.factory.class";
    private static final String REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = "hbase.region.server.rpc.minimum.scan.time.limit.delta";
    private static final long DEFAULT_REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = 10L;
    static final String BATCH_ROWS_THRESHOLD_NAME = "hbase.rpc.rows.warning.threshold";
    static final int BATCH_ROWS_THRESHOLD_DEFAULT = 5000;
    protected static final String RESERVOIR_ENABLED_KEY = "hbase.ipc.server.reservoir.enabled";
    final LongAdder requestCount = new LongAdder();
    final LongAdder rpcGetRequestCount = new LongAdder();
    final LongAdder rpcScanRequestCount = new LongAdder();
    final LongAdder rpcMultiRequestCount = new LongAdder();
    final LongAdder rpcMutateRequestCount = new LongAdder();
    final RpcServerInterface rpcServer;
    final InetSocketAddress isa;
    private final HRegionServer regionServer;
    private final long maxScannerResultSize;
    private final PriorityFunction priority;
    private ScannerIdGenerator scannerIdGenerator;
    private final ConcurrentMap<String, RegionScannerHolder> scanners = new ConcurrentHashMap<String, RegionScannerHolder>();
    private final Cache<String, String> closedScanners;
    private final int scannerLeaseTimeoutPeriod;
    private final int rpcTimeout;
    private final long minimumScanTimeLimitDelta;
    private final int rowSizeWarnThreshold;
    final AtomicBoolean clearCompactionQueues = new AtomicBoolean(false);
    protected AccessChecker accessChecker;
    public static final String REGIONSERVER_ADMIN_SERVICE_CONFIG = "hbase.regionserver.admin.executorService";
    public static final String REGIONSERVER_CLIENT_SERVICE_CONFIG = "hbase.regionserver.client.executorService";
    private static LogDelegate DEFAULT_LOG_DELEGATE = new LogDelegate(){

        @Override
        public void logBatchWarning(String firstRegionName, int sum, int rowSizeWarnThreshold) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Large batch operation detected (greater than " + rowSizeWarnThreshold + ") (HBASE-18023). Requested Number of Rows: " + sum + " Client: " + (String)RpcServer.getRequestUserName().orElse(null) + "/" + RpcServer.getRemoteAddress().orElse(null) + " first region in multi=" + firstRegionName);
            }
        }
    };
    private final LogDelegate ld;
    @Deprecated
    private static final IOException SCANNER_ALREADY_CLOSED = new IOException(){
        private static final long serialVersionUID = -4305297078988180130L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.Result r, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((ClientProtos.Result)r), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(Exception e, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((Throwable)e), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.ResultOrException.Builder builder, int index) {
        return builder.setIndex(index).build();
    }

    private void rpcPreCheck(String requestName) throws ServiceException {
        try {
            this.checkOpen();
            this.requirePermission(requestName, Permission.Action.ADMIN);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    private boolean startNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup) throws IOException {
        if (this.regionServer.nonceManager == null || !mutation.hasNonce()) {
            return true;
        }
        boolean canProceed = false;
        try {
            canProceed = this.regionServer.nonceManager.startOperation(nonceGroup, mutation.getNonce(), this.regionServer);
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException("Nonce start operation interrupted");
        }
        return canProceed;
    }

    private void endNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup, boolean success) {
        if (this.regionServer.nonceManager != null && mutation.hasNonce()) {
            this.regionServer.nonceManager.endOperation(nonceGroup, mutation.getNonce(), success);
        }
    }

    private boolean isClientCellBlockSupport(RpcCallContext context) {
        return context != null && context.isClientCellBlockSupported();
    }

    private void addResult(ClientProtos.MutateResponse.Builder builder, Result result, HBaseRpcController rpcc, boolean clientCellBlockSupported) {
        if (result == null) {
            return;
        }
        if (clientCellBlockSupported) {
            builder.setResult(ProtobufUtil.toResultNoData((Result)result));
            rpcc.setCellScanner(result.cellScanner());
        } else {
            ClientProtos.Result pbr = ProtobufUtil.toResult((Result)result);
            builder.setResult(pbr);
        }
    }

    private void addResults(ClientProtos.ScanResponse.Builder builder, List<Result> results, HBaseRpcController controller, boolean isDefaultRegion, boolean clientCellBlockSupported) {
        builder.setStale(!isDefaultRegion);
        if (results.isEmpty()) {
            return;
        }
        if (clientCellBlockSupported) {
            for (Result res : results) {
                builder.addCellsPerResult(res.size());
                builder.addPartialFlagPerResult(res.mayHaveMoreCellsInRow());
            }
            controller.setCellScanner(CellUtil.createCellScanner(results));
        } else {
            for (Result res : results) {
                ClientProtos.Result pbr = ProtobufUtil.toResult((Result)res);
                builder.addResults(pbr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndRowMutate(HRegion region, List<ClientProtos.Action> actions, CellScanner cellScanner, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, TimeRange timeRange, ClientProtos.RegionActionResult.Builder builder, ActivePolicyEnforcement spaceQuotaEnforcement) throws IOException {
        int countOfCompleteMutation = 0;
        try {
            if (!region.getRegionInfo().isMetaRegion()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            RowMutations rm = null;
            int i = 0;
            ClientProtos.ResultOrException.Builder resultOrExceptionOrBuilder = ClientProtos.ResultOrException.newBuilder();
            for (ClientProtos.Action action : actions) {
                if (action.hasGet()) {
                    throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
                }
                ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                if (rm == null) {
                    rm = new RowMutations(action.getMutation().getRow().toByteArray(), actions.size());
                }
                switch (type) {
                    case PUT: {
                        Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                        ++countOfCompleteMutation;
                        this.checkCellSizeLimit(region, (Mutation)put);
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check((Mutation)put);
                        rm.add(put);
                        break;
                    }
                    case DELETE: {
                        Delete del = ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                        ++countOfCompleteMutation;
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check((Mutation)del);
                        rm.add(del);
                        break;
                    }
                    default: {
                        throw new DoNotRetryIOException("Atomic put and/or delete only, not " + type.name());
                    }
                }
                resultOrExceptionOrBuilder.clear();
                resultOrExceptionOrBuilder.setIndex(i++);
                builder.addResultOrException(resultOrExceptionOrBuilder.build());
            }
            boolean bl = region.checkAndRowMutate(row, family, qualifier, op, comparator, timeRange, rm);
            return bl;
        }
        finally {
            for (int i = countOfCompleteMutation; i < actions.size(); ++i) {
                this.skipCellsForMutation(actions.get(i), cellScanner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result append(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cellScanner, long nonceGroup, ActivePolicyEnforcement spaceQuota) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
        this.checkCellSizeLimit(region, (Mutation)append);
        spaceQuota.getPolicyEnforcement(region).check((Mutation)append);
        quota.addMutation((Mutation)append);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preAppend(append);
        }
        if (r == null) {
            boolean canProceed = this.startNonceOperation(mutation, nonceGroup);
            boolean success = false;
            try {
                long nonce;
                long l = nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
                if (canProceed) {
                    r = region.append(append, nonceGroup, nonce);
                } else {
                    List<Cell> results = region.get(ProtobufUtil.toGet((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner), false, nonceGroup, nonce);
                    r = Result.create(results);
                }
                success = true;
            }
            finally {
                if (canProceed) {
                    this.endNonceOperation(mutation, nonceGroup, success);
                }
            }
            if (region.getCoprocessorHost() != null) {
                r = region.getCoprocessorHost().postAppend(append, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateAppend(region.getTableDescriptor().getTableName(), EnvironmentEdgeManager.currentTime() - before);
        }
        return r == null ? Result.EMPTY_RESULT : r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result increment(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cells, long nonceGroup, ActivePolicyEnforcement spaceQuota) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Increment increment = ProtobufUtil.toIncrement((ClientProtos.MutationProto)mutation, (CellScanner)cells);
        this.checkCellSizeLimit(region, (Mutation)increment);
        spaceQuota.getPolicyEnforcement(region).check((Mutation)increment);
        quota.addMutation((Mutation)increment);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preIncrement(increment);
        }
        if (r == null) {
            boolean canProceed = this.startNonceOperation(mutation, nonceGroup);
            boolean success = false;
            try {
                long nonce;
                long l = nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
                if (canProceed) {
                    r = region.increment(increment, nonceGroup, nonce);
                } else {
                    List<Cell> results = region.get(ProtobufUtil.toGet((ClientProtos.MutationProto)mutation, (CellScanner)cells), false, nonceGroup, nonce);
                    r = Result.create(results);
                }
                success = true;
            }
            finally {
                if (canProceed) {
                    this.endNonceOperation(mutation, nonceGroup, success);
                }
            }
            if (region.getCoprocessorHost() != null) {
                r = region.getCoprocessorHost().postIncrement(increment, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateIncrement(region.getTableDescriptor().getTableName(), EnvironmentEdgeManager.currentTime() - before);
        }
        return r == null ? Result.EMPTY_RESULT : r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CellScannable> doNonAtomicRegionMutation(HRegion region, OperationQuota quota, ClientProtos.RegionAction actions, CellScanner cellScanner, ClientProtos.RegionActionResult.Builder builder, List<CellScannable> cellsToReturn, long nonceGroup, RegionScannersCloseCallBack closeCallBack, RpcCallContext context, ActivePolicyEnforcement spaceQuotaEnforcement) {
        ArrayList<ClientProtos.Action> mutations = null;
        long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
        MultiActionResultTooLarge sizeIOE = null;
        Object lastBlock = null;
        ClientProtos.ResultOrException.Builder resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder();
        boolean hasResultOrException = false;
        for (ClientProtos.Action action : actions.getActionList()) {
            HBaseProtos.NameBytesPair pair;
            hasResultOrException = false;
            resultOrExceptionBuilder.clear();
            try {
                Result r = null;
                if (context != null && context.isRetryImmediatelySupported() && (context.getResponseCellSize() > maxQuotaResultSize || context.getResponseBlockSize() + context.getResponseExceptionSize() > maxQuotaResultSize)) {
                    if (sizeIOE == null) {
                        sizeIOE = new MultiActionResultTooLarge("Max size exceeded CellSize: " + context.getResponseCellSize() + " BlockSize: " + context.getResponseBlockSize());
                        this.rpcServer.getMetrics().exception((Throwable)sizeIOE);
                    }
                    pair = ResponseConverter.buildException(sizeIOE);
                    resultOrExceptionBuilder.setException(pair);
                    context.incrementResponseExceptionSize(pair.getSerializedSize());
                    resultOrExceptionBuilder.setIndex(action.getIndex());
                    builder.addResultOrException(resultOrExceptionBuilder.build());
                    this.skipCellsForMutation(action, cellScanner);
                    continue;
                }
                if (action.hasGet()) {
                    long before = EnvironmentEdgeManager.currentTime();
                    ClientProtos.Get pbGet = action.getGet();
                    if (pbGet.hasClosestRowBefore() && pbGet.getClosestRowBefore()) {
                        throw new UnknownProtocolException("Is this a pre-hbase-1.0.0 or asynchbase client? Client is invoking getClosestRowBefore removed in hbase-2.0.0 replaced by reverse Scan.");
                    }
                    try {
                        Get get = ProtobufUtil.toGet((ClientProtos.Get)pbGet);
                        if (context != null) {
                            r = this.get(get, region, closeCallBack, context);
                        }
                        r = region.get(get);
                    }
                    finally {
                        if (this.regionServer.metricsRegionServer != null) {
                            this.regionServer.metricsRegionServer.updateGet(region.getTableDescriptor().getTableName(), EnvironmentEdgeManager.currentTime() - before);
                        }
                    }
                } else if (action.hasServiceCall()) {
                    hasResultOrException = true;
                    com.google.protobuf.Message result = this.execServiceOnRegion(region, action.getServiceCall());
                    ClientProtos.CoprocessorServiceResult.Builder serviceResultBuilder = ClientProtos.CoprocessorServiceResult.newBuilder();
                    resultOrExceptionBuilder.setServiceResult(serviceResultBuilder.setValue(serviceResultBuilder.getValueBuilder().setName(result.getClass().getName()).setValue(UnsafeByteOperations.unsafeWrap((byte[])result.toByteArray()))));
                } else if (action.hasMutation()) {
                    ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                    if (type != ClientProtos.MutationProto.MutationType.PUT && type != ClientProtos.MutationProto.MutationType.DELETE && mutations != null && !mutations.isEmpty()) {
                        this.doNonAtomicBatchOp(builder, region, quota, mutations, cellScanner, spaceQuotaEnforcement);
                        mutations.clear();
                    }
                    switch (type) {
                        case APPEND: {
                            r = this.append(region, quota, action.getMutation(), cellScanner, nonceGroup, spaceQuotaEnforcement);
                            break;
                        }
                        case INCREMENT: {
                            r = this.increment(region, quota, action.getMutation(), cellScanner, nonceGroup, spaceQuotaEnforcement);
                            break;
                        }
                        case PUT: 
                        case DELETE: {
                            if (mutations == null) {
                                mutations = new ArrayList<ClientProtos.Action>(actions.getActionCount());
                            }
                            mutations.add(action);
                            break;
                        }
                        default: {
                            throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                        }
                    }
                } else {
                    throw new HBaseIOException("Unexpected Action type");
                }
                if (r != null) {
                    ClientProtos.Result pbResult = null;
                    if (this.isClientCellBlockSupport(context)) {
                        pbResult = ProtobufUtil.toResultNoData((Result)r);
                        if (cellsToReturn == null) {
                            cellsToReturn = new ArrayList<CellScannable>();
                        }
                        cellsToReturn.add((CellScannable)r);
                    } else {
                        pbResult = ProtobufUtil.toResult((Result)r);
                    }
                    lastBlock = this.addSize(context, r, lastBlock);
                    hasResultOrException = true;
                    resultOrExceptionBuilder.setResult(pbResult);
                }
            }
            catch (IOException ie) {
                this.rpcServer.getMetrics().exception(ie);
                hasResultOrException = true;
                pair = ResponseConverter.buildException((Throwable)ie);
                resultOrExceptionBuilder.setException(pair);
                context.incrementResponseExceptionSize(pair.getSerializedSize());
            }
            if (!hasResultOrException) continue;
            resultOrExceptionBuilder.setIndex(action.getIndex());
            builder.addResultOrException(resultOrExceptionBuilder.build());
        }
        if (!CollectionUtils.isEmpty(mutations)) {
            this.doNonAtomicBatchOp(builder, region, quota, mutations, cellScanner, spaceQuotaEnforcement);
        }
        return cellsToReturn;
    }

    private void checkCellSizeLimit(HRegion r, Mutation m) throws IOException {
        if (r.maxCellSize > 0L) {
            CellScanner cells = m.cellScanner();
            while (cells.advance()) {
                int size = PrivateCellUtil.estimatedSerializedSizeOf((Cell)cells.current());
                if ((long)size <= r.maxCellSize) continue;
                String msg = "Cell with size " + size + " exceeds limit of " + r.maxCellSize + " bytes";
                if (LOG.isDebugEnabled()) {
                    LOG.debug(msg);
                }
                throw new DoNotRetryIOException(msg);
            }
        }
    }

    private void doAtomicBatchOp(ClientProtos.RegionActionResult.Builder builder, HRegion region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells, ActivePolicyEnforcement spaceQuotaEnforcement) throws IOException {
        this.doBatchOp(builder, region, quota, mutations, cells, spaceQuotaEnforcement, true);
    }

    private void doNonAtomicBatchOp(ClientProtos.RegionActionResult.Builder builder, HRegion region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells, ActivePolicyEnforcement spaceQuotaEnforcement) {
        try {
            this.doBatchOp(builder, region, quota, mutations, cells, spaceQuotaEnforcement, false);
        }
        catch (IOException e) {
            for (ClientProtos.Action mutation : mutations) {
                builder.addResultOrException(RSRpcServices.getResultOrException(e, mutation.getIndex()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatchOp(ClientProtos.RegionActionResult.Builder builder, HRegion region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells, ActivePolicyEnforcement spaceQuotaEnforcement, boolean atomic) throws IOException {
        Mutation[] mArray = new Mutation[mutations.size()];
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            HashMap<Put, ClientProtos.Action> mutationActionMap = new HashMap<Put, ClientProtos.Action>();
            int i = 0;
            for (ClientProtos.Action action : mutations) {
                Put mutation;
                if (action.hasGet()) {
                    throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
                }
                ClientProtos.MutationProto m = action.getMutation();
                if (m.getMutateType() == ClientProtos.MutationProto.MutationType.PUT) {
                    mutation = ProtobufUtil.toPut((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsPuts = true;
                } else {
                    mutation = ProtobufUtil.toDelete((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsDelete = true;
                }
                mutationActionMap.put(mutation, action);
                mArray[i++] = mutation;
                this.checkCellSizeLimit(region, (Mutation)mutation);
                spaceQuotaEnforcement.getPolicyEnforcement(region).check((Mutation)mutation);
                quota.addMutation((Mutation)mutation);
            }
            if (!region.getRegionInfo().isMetaRegion()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            if (!atomic) {
                Arrays.sort(mArray, (v1, v2) -> Row.COMPARATOR.compare(v1, v2));
            }
            OperationStatus[] codes = region.batchMutate(mArray, atomic, 0L, 0L);
            block10: for (i = 0; i < codes.length; ++i) {
                Mutation currentMutation = mArray[i];
                ClientProtos.Action currentAction = (ClientProtos.Action)mutationActionMap.get(currentMutation);
                int index = currentAction.hasIndex() || !atomic ? currentAction.getIndex() : i;
                NoSuchColumnFamilyException e = null;
                switch (codes[i].getOperationStatusCode()) {
                    case BAD_FAMILY: {
                        e = new NoSuchColumnFamilyException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block10;
                    }
                    case SANITY_CHECK_FAILURE: {
                        e = new FailedSanityCheckException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block10;
                    }
                    default: {
                        e = new DoNotRetryIOException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block10;
                    }
                    case SUCCESS: {
                        builder.addResultOrException(RSRpcServices.getResultOrException(ClientProtos.Result.getDefaultInstance(), index));
                        continue block10;
                    }
                    case STORE_TOO_BUSY: {
                        e = new RegionTooBusyException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                    }
                }
            }
        }
        finally {
            int processedMutationIndex = 0;
            for (ClientProtos.Action mutation : mutations) {
                if (mArray[processedMutationIndex++] != null) continue;
                this.skipCellsForMutation(mutation, cells);
            }
            this.updateMutationMetrics(region, before, batchContainsPuts, batchContainsDelete);
        }
    }

    private void updateMutationMetrics(HRegion region, long starttime, boolean batchContainsPuts, boolean batchContainsDelete) {
        if (this.regionServer.metricsRegionServer != null) {
            long after = EnvironmentEdgeManager.currentTime();
            if (batchContainsPuts) {
                this.regionServer.metricsRegionServer.updatePutBatch(region.getTableDescriptor().getTableName(), after - starttime);
            }
            if (batchContainsDelete) {
                this.regionServer.metricsRegionServer.updateDeleteBatch(region.getTableDescriptor().getTableName(), after - starttime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus[] doReplayBatchOp(HRegion region, List<WALSplitter.MutationReplay> mutations, long replaySeqId) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            Iterator<WALSplitter.MutationReplay> it = mutations.iterator();
            while (it.hasNext()) {
                NavigableMap map;
                List metaCells;
                WALSplitter.MutationReplay m = it.next();
                if (m.type == ClientProtos.MutationProto.MutationType.PUT) {
                    batchContainsPuts = true;
                } else {
                    batchContainsDelete = true;
                }
                if ((metaCells = (List)(map = m.mutation.getFamilyCellMap()).get(WALEdit.METAFAMILY)) == null || metaCells.isEmpty()) continue;
                for (Cell metaCell : metaCells) {
                    WALProtos.CompactionDescriptor compactionDesc = WALEdit.getCompaction(metaCell);
                    boolean isDefaultReplica = RegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo());
                    HRegion hRegion = region;
                    if (compactionDesc != null) {
                        hRegion.replayWALCompactionMarker(compactionDesc, !isDefaultReplica, isDefaultReplica, replaySeqId);
                        continue;
                    }
                    WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor(metaCell);
                    if (flushDesc != null && !isDefaultReplica) {
                        hRegion.replayWALFlushMarker(flushDesc, replaySeqId);
                        continue;
                    }
                    WALProtos.RegionEventDescriptor regionEvent = WALEdit.getRegionEventDescriptor(metaCell);
                    if (regionEvent != null && !isDefaultReplica) {
                        hRegion.replayWALRegionEventMarker(regionEvent);
                        continue;
                    }
                    WALProtos.BulkLoadDescriptor bulkLoadEvent = WALEdit.getBulkLoadDescriptor(metaCell);
                    if (bulkLoadEvent == null) continue;
                    hRegion.replayWALBulkLoadEventMarker(bulkLoadEvent);
                }
                it.remove();
            }
            this.requestCount.increment();
            if (!region.getRegionInfo().isMetaRegion()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            OperationStatus[] operationStatusArray = region.batchReplay(mutations.toArray(new WALSplitter.MutationReplay[mutations.size()]), replaySeqId);
            return operationStatusArray;
        }
        finally {
            this.updateMutationMetrics(region, before, batchContainsPuts, batchContainsDelete);
        }
    }

    private void closeAllScanners() {
        for (Map.Entry e : this.scanners.entrySet()) {
            try {
                ((RegionScannerHolder)e.getValue()).s.close();
            }
            catch (IOException ioe) {
                LOG.warn("Closing scanner " + (String)e.getKey(), (Throwable)ioe);
            }
        }
    }

    public RSRpcServices(HRegionServer rs) throws IOException {
        this(rs, DEFAULT_LOG_DELEGATE);
    }

    RSRpcServices(HRegionServer rs, LogDelegate ld) throws IOException {
        InetSocketAddress bindAddress;
        InetSocketAddress initialIsa;
        int port;
        String hostname;
        RpcSchedulerFactory rpcSchedulerFactory;
        this.ld = ld;
        this.regionServer = rs;
        this.rowSizeWarnThreshold = rs.conf.getInt(BATCH_ROWS_THRESHOLD_NAME, 5000);
        try {
            Class cls = rs.conf.getClass(REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS, SimpleRpcSchedulerFactory.class);
            rpcSchedulerFactory = cls.asSubclass(RpcSchedulerFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        if (this instanceof MasterRpcServices) {
            hostname = RSRpcServices.getHostname(rs.conf, true);
            port = rs.conf.getInt("hbase.master.port", 16000);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.master.ipc.address", hostname), port);
        } else {
            hostname = RSRpcServices.getHostname(rs.conf, false);
            port = rs.conf.getInt("hbase.regionserver.port", 16020);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.regionserver.ipc.address", hostname), port);
        }
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.priority = this.createPriority();
        String name = rs.getProcessName() + "/" + Address.fromParts((String)initialIsa.getHostName(), (int)initialIsa.getPort()).toStringWithoutDomain();
        ConnectionUtils.setServerSideHConnectionRetriesConfig((Configuration)rs.conf, (String)name, (Logger)LOG);
        this.rpcServer = this.createRpcServer(rs, rs.conf, rpcSchedulerFactory, bindAddress, name);
        this.rpcServer.setRsRpcServices(this);
        this.scannerLeaseTimeoutPeriod = rs.conf.getInt("hbase.client.scanner.timeout.period", 60000);
        this.maxScannerResultSize = rs.conf.getLong("hbase.server.scanner.max.result.size", 0x6400000L);
        this.rpcTimeout = rs.conf.getInt("hbase.rpc.timeout", 60000);
        this.minimumScanTimeLimitDelta = rs.conf.getLong(REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA, 10L);
        InetSocketAddress address = this.rpcServer.getListenerAddress();
        if (address == null) {
            throw new IOException("Listener channel is closed");
        }
        this.isa = new InetSocketAddress(initialIsa.getHostName(), address.getPort());
        this.rpcServer.setErrorHandler(this);
        rs.setName(name);
        this.closedScanners = CacheBuilder.newBuilder().expireAfterAccess((long)this.scannerLeaseTimeoutPeriod, TimeUnit.MILLISECONDS).build();
    }

    protected RpcServerInterface createRpcServer(Server server, Configuration conf, RpcSchedulerFactory rpcSchedulerFactory, InetSocketAddress bindAddress, String name) throws IOException {
        boolean reservoirEnabled = conf.getBoolean(RESERVOIR_ENABLED_KEY, true);
        try {
            return RpcServerFactory.createRpcServer(server, name, this.getServices(), bindAddress, conf, rpcSchedulerFactory.create(conf, this, server), reservoirEnabled);
        }
        catch (BindException be) {
            throw new IOException(be.getMessage() + ". To switch ports use the '" + "hbase.regionserver.port" + "' configuration property.", be.getCause() != null ? be.getCause() : be);
        }
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        if (this.rpcServer instanceof ConfigurationObserver) {
            ((ConfigurationObserver)((Object)this.rpcServer)).onConfigurationChange(newConf);
        }
    }

    protected PriorityFunction createPriority() {
        return new AnnotationReadingPriorityFunction(this);
    }

    protected void requirePermission(String request, Permission.Action perm) throws IOException {
        if (this.accessChecker != null) {
            this.accessChecker.requirePermission(RpcServer.getRequestUser().orElse(null), request, perm);
        }
    }

    public static String getHostname(Configuration conf, boolean isMaster) throws UnknownHostException {
        String hostname = conf.get(isMaster ? "hbase.master.hostname" : "hbase.regionserver.hostname");
        if (hostname == null || hostname.isEmpty()) {
            String masterOrRS = isMaster ? "master" : "regionserver";
            return Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase." + masterOrRS + ".dns.interface", "default"), (String)conf.get("hbase." + masterOrRS + ".dns.nameserver", "default")));
        }
        LOG.info("hostname is configured to be " + hostname);
        return hostname;
    }

    @VisibleForTesting
    public int getScannersCount() {
        return this.scanners.size();
    }

    public RegionScanner getScanner(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = (RegionScannerHolder)this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.s;
        }
        return null;
    }

    public String getScanDetailsWithId(long scannerId) {
        RegionScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("table: ").append(scanner.getRegionInfo().getTable().getNameAsString());
        builder.append(" region: ").append(scanner.getRegionInfo().getRegionNameAsString());
        return builder.toString();
    }

    long getScannerVirtualTime(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = (RegionScannerHolder)this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.getNextCallSeq();
        }
        return 0L;
    }

    Object addSize(RpcCallContext context, Result r, Object lastBlock) {
        if (context != null && r != null && !r.isEmpty()) {
            for (Cell c : r.rawCells()) {
                context.incrementResponseCellSize(PrivateCellUtil.estimatedSerializedSizeOf((Cell)c));
                if (c instanceof ByteBufferExtendedCell) {
                    ByteBufferExtendedCell bbCell = (ByteBufferExtendedCell)c;
                    ByteBuffer bb = bbCell.getValueByteBuffer();
                    if (bb == lastBlock) continue;
                    context.incrementResponseBlockSize(bb.capacity());
                    lastBlock = bb;
                    continue;
                }
                byte[] valueArray = c.getValueArray();
                if (valueArray == lastBlock) continue;
                context.incrementResponseBlockSize(valueArray.length);
                lastBlock = valueArray;
            }
        }
        return lastBlock;
    }

    private RegionScannerHolder addScanner(String scannerName, RegionScanner s, Shipper shipper, HRegion r, boolean needCursor) throws Leases.LeaseStillHeldException {
        Leases.Lease lease = this.regionServer.leases.createLease(scannerName, this.scannerLeaseTimeoutPeriod, new ScannerListener(scannerName));
        RegionScannerShippedCallBack shippedCallback = new RegionScannerShippedCallBack(scannerName, shipper, lease);
        RpcCallback closeCallback = s instanceof RpcCallback ? (RpcCallback)((Object)s) : new RegionScannerCloseCallBack(s);
        RegionScannerHolder rsh = new RegionScannerHolder(scannerName, s, r, closeCallback, shippedCallback, needCursor);
        RegionScannerHolder existing = this.scanners.putIfAbsent(scannerName, rsh);
        assert (existing == null) : "scannerId must be unique within regionserver's whole lifecycle! " + scannerName;
        return rsh;
    }

    @VisibleForTesting
    public HRegion getRegion(HBaseProtos.RegionSpecifier regionSpecifier) throws IOException {
        return this.regionServer.getRegion(regionSpecifier.getValue().toByteArray());
    }

    private List<HRegion> getRegions(List<HBaseProtos.RegionSpecifier> regionSpecifiers, CacheEvictionStatsBuilder stats) {
        ArrayList regions = Lists.newArrayListWithCapacity((int)regionSpecifiers.size());
        for (HBaseProtos.RegionSpecifier regionSpecifier : regionSpecifiers) {
            try {
                regions.add(this.regionServer.getRegion(regionSpecifier.getValue().toByteArray()));
            }
            catch (NotServingRegionException e) {
                stats.addException(regionSpecifier.getValue().toByteArray(), (Throwable)e);
            }
        }
        return regions;
    }

    @VisibleForTesting
    public PriorityFunction getPriority() {
        return this.priority;
    }

    @VisibleForTesting
    public Configuration getConfiguration() {
        return this.regionServer.getConfiguration();
    }

    private RegionServerRpcQuotaManager getRpcQuotaManager() {
        return this.regionServer.getRegionServerRpcQuotaManager();
    }

    private RegionServerSpaceQuotaManager getSpaceQuotaManager() {
        return this.regionServer.getRegionServerSpaceQuotaManager();
    }

    void start(ZKWatcher zkWatcher) {
        if (AccessChecker.isAuthorizationSupported(this.getConfiguration())) {
            this.accessChecker = new AccessChecker(this.getConfiguration(), zkWatcher);
        }
        this.scannerIdGenerator = new ScannerIdGenerator(this.regionServer.serverName);
        this.rpcServer.start();
    }

    void stop() {
        if (this.accessChecker != null) {
            this.accessChecker.stop();
        }
        this.closeAllScanners();
        this.rpcServer.stop();
    }

    protected void checkOpen() throws IOException {
        if (this.regionServer.isAborted()) {
            throw new RegionServerAbortedException("Server " + this.regionServer.serverName + " aborting");
        }
        if (this.regionServer.isStopped()) {
            throw new RegionServerStoppedException("Server " + this.regionServer.serverName + " stopping");
        }
        if (!this.regionServer.fsOk) {
            throw new RegionServerStoppedException("File system not available");
        }
        if (!this.regionServer.isOnline()) {
            throw new ServerNotRunningYetException("Server " + this.regionServer.serverName + " is not running yet");
        }
    }

    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        boolean admin = this.getConfiguration().getBoolean(REGIONSERVER_ADMIN_SERVICE_CONFIG, true);
        boolean client = this.getConfiguration().getBoolean(REGIONSERVER_CLIENT_SERVICE_CONFIG, true);
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>();
        if (client) {
            bssi.add(new RpcServer.BlockingServiceAndInterface(ClientProtos.ClientService.newReflectiveBlockingService((ClientProtos.ClientService.BlockingInterface)this), ClientProtos.ClientService.BlockingInterface.class));
        }
        if (admin) {
            bssi.add(new RpcServer.BlockingServiceAndInterface(AdminProtos.AdminService.newReflectiveBlockingService((AdminProtos.AdminService.BlockingInterface)this), AdminProtos.AdminService.BlockingInterface.class));
        }
        return new ImmutableList.Builder().addAll(bssi).build();
    }

    public InetSocketAddress getSocketAddress() {
        return this.isa;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        return this.priority.getPriority(header, param, user);
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        return this.priority.getDeadline(header, param);
    }

    @Override
    public boolean checkOOME(Throwable e) {
        return RSRpcServices.exitIfOOME(e);
    }

    public static boolean exitIfOOME(Throwable e) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.error(HBaseMarkers.FATAL, "Run out of memory; " + RSRpcServices.class.getSimpleName() + " will abort itself immediately", e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }

    @QosPriority(priority=100)
    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        ServerName sn = request.hasDestinationServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getDestinationServer()) : null;
        try {
            this.checkOpen();
            if (request.hasServerStartCode()) {
                long serverStartCode = request.getServerStartCode();
                if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                    throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
                }
            }
            String encodedRegionName = ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)request.getRegion());
            this.requestCount.increment();
            if (sn == null) {
                LOG.info("Close " + encodedRegionName + " without moving");
            } else {
                LOG.info("Close " + encodedRegionName + ", moving to " + sn);
            }
            boolean closed = this.regionServer.closeRegion(encodedRegionName, false, sn);
            AdminProtos.CloseRegionResponse.Builder builder = AdminProtos.CloseRegionResponse.newBuilder().setClosed(closed);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            boolean major;
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            if (QuotaUtil.isQuotaEnabled(this.getConfiguration()) && !Superusers.isSuperUser((User)RpcServer.getRequestUser().orElse(null)) && this.regionServer.getRegionServerSpaceQuotaManager().areCompactionsDisabled(region.getTableDescriptor().getTableName())) {
                throw new DoNotRetryIOException("Compactions on this region are disabled due to a space quota violation.");
            }
            region.startRegionOperation(Region.Operation.COMPACT_REGION);
            LOG.info("Compacting " + region.getRegionInfo().getRegionNameAsString());
            boolean bl = major = request.hasMajor() && request.getMajor();
            if (request.hasFamily()) {
                byte[] family = request.getFamily().toByteArray();
                String log = "User-triggered " + (major ? "major " : "") + "compaction for region " + region.getRegionInfo().getRegionNameAsString() + " and family " + Bytes.toString((byte[])family);
                LOG.trace(log);
                region.requestCompaction(family, log, 1, major, CompactionLifeCycleTracker.DUMMY);
            } else {
                String log = "User-triggered " + (major ? "major " : "") + "compaction for region " + region.getRegionInfo().getRegionNameAsString();
                LOG.trace(log);
                region.requestCompaction(log, 1, major, CompactionLifeCycleTracker.DUMMY);
            }
            return AdminProtos.CompactRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            LOG.info("Flushing " + region.getRegionInfo().getRegionNameAsString());
            boolean shouldFlush = true;
            if (request.hasIfOlderThanTs()) {
                shouldFlush = region.getEarliestFlushTimeForAllStores() < request.getIfOlderThanTs();
            }
            AdminProtos.FlushRegionResponse.Builder builder = AdminProtos.FlushRegionResponse.newBuilder();
            if (shouldFlush) {
                boolean writeFlushWalMarker = request.hasWriteFlushWalMarker() ? request.getWriteFlushWalMarker() : false;
                HRegion.FlushResultImpl flushResult = region.flushcache(true, writeFlushWalMarker, FlushLifeCycleTracker.DUMMY);
                boolean compactionNeeded = flushResult.isCompactionNeeded();
                if (compactionNeeded) {
                    this.regionServer.compactSplitThread.requestSystemCompaction(region, "Compaction through user triggered flush");
                }
                builder.setFlushed(flushResult.isFlushSucceeded());
                builder.setWroteFlushWalMarker(flushResult.wroteFlushWalMarker);
            }
            builder.setLastFlushTime(region.getEarliestFlushTimeForAllStores());
            return builder.build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Map<String, HRegion> onlineRegions = this.regionServer.onlineRegions;
            ArrayList<RegionInfo> list = new ArrayList<RegionInfo>(onlineRegions.size());
            for (HRegion region : onlineRegions.values()) {
                list.add(region.getRegionInfo());
            }
            Collections.sort(list, RegionInfo.COMPARATOR);
            return ResponseConverter.buildGetOnlineRegionResponse(list);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            RegionInfo info = region.getRegionInfo();
            byte[] bestSplitRow = null;
            boolean shouldSplit = true;
            if (request.hasBestSplitRow() && request.getBestSplitRow()) {
                HRegion r = region;
                region.startRegionOperation(Region.Operation.SPLIT_REGION);
                r.forceSplit(null);
                shouldSplit = region.getSplitPolicy().shouldSplit() && !info.isMetaRegion();
                bestSplitRow = r.checkSplit();
                if (bestSplitRow == null) {
                    r.flush(true);
                    bestSplitRow = r.checkSplit();
                }
                r.clearSplit();
            }
            AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
            builder.setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)info));
            if (request.hasCompactionState() && request.getCompactionState()) {
                builder.setCompactionState(ProtobufUtil.createCompactionState((CompactionState)region.getCompactionState()));
            }
            builder.setSplittable(region.isSplittable() && shouldSplit);
            builder.setMergeable(region.isMergeable());
            if (request.hasBestSplitRow() && request.getBestSplitRow() && bestSplitRow != null) {
                builder.setBestSplitRow(UnsafeByteOperations.unsafeWrap((byte[])bestSplitRow));
            }
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetRegionLoadResponse getRegionLoad(RpcController controller, AdminProtos.GetRegionLoadRequest request) throws ServiceException {
        List<HRegion> regions;
        if (request.hasTableName()) {
            TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
            regions = this.regionServer.getRegions(tableName);
        } else {
            regions = this.regionServer.getRegions();
        }
        ArrayList<ClusterStatusProtos.RegionLoad> rLoads = new ArrayList<ClusterStatusProtos.RegionLoad>(regions.size());
        ClusterStatusProtos.RegionLoad.Builder regionLoadBuilder = ClusterStatusProtos.RegionLoad.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifier = HBaseProtos.RegionSpecifier.newBuilder();
        try {
            for (HRegion region : regions) {
                rLoads.add(this.regionServer.createRegionLoad(region, regionLoadBuilder, regionSpecifier));
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        AdminProtos.GetRegionLoadResponse.Builder builder = AdminProtos.GetRegionLoadResponse.newBuilder();
        builder.addAllRegionLoads(rLoads);
        return builder.build();
    }

    @QosPriority(priority=100)
    public AdminProtos.ClearCompactionQueuesResponse clearCompactionQueues(RpcController controller, AdminProtos.ClearCompactionQueuesRequest request) throws ServiceException {
        LOG.debug("Client=" + (String)RpcServer.getRequestUserName().orElse(null) + "/" + RpcServer.getRemoteAddress().orElse(null) + " clear compactions queue");
        AdminProtos.ClearCompactionQueuesResponse.Builder respBuilder = AdminProtos.ClearCompactionQueuesResponse.newBuilder();
        this.requestCount.increment();
        if (this.clearCompactionQueues.compareAndSet(false, true)) {
            try {
                this.checkOpen();
                this.regionServer.getRegionServerCoprocessorHost().preClearCompactionQueues();
                block13: for (String queueName : request.getQueueNameList()) {
                    LOG.debug("clear " + queueName + " compaction queue");
                    switch (queueName) {
                        case "long": {
                            this.regionServer.compactSplitThread.clearLongCompactionsQueue();
                            continue block13;
                        }
                        case "short": {
                            this.regionServer.compactSplitThread.clearShortCompactionsQueue();
                            continue block13;
                        }
                    }
                    LOG.warn("Unknown queue name " + queueName);
                    throw new IOException("Unknown queue name " + queueName);
                }
                this.regionServer.getRegionServerCoprocessorHost().postClearCompactionQueues();
            }
            catch (IOException ie) {
                throw new ServiceException((Throwable)ie);
            }
            finally {
                this.clearCompactionQueues.set(false);
            }
        } else {
            LOG.warn("Clear compactions queue is executing by other admin.");
        }
        return respBuilder.build();
    }

    @QosPriority(priority=100)
    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        this.requestCount.increment();
        int infoPort = this.regionServer.infoServer != null ? this.regionServer.infoServer.getPort() : -1;
        return ResponseConverter.buildGetServerInfoResponse((ServerName)this.regionServer.serverName, (int)infoPort);
    }

    @QosPriority(priority=100)
    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        try {
            TreeSet<byte[]> columnFamilies;
            this.checkOpen();
            HRegion region = this.getRegion(request.getRegion());
            this.requestCount.increment();
            if (request.getFamilyCount() == 0) {
                columnFamilies = region.getTableDescriptor().getColumnFamilyNames();
            } else {
                columnFamilies = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
                for (ByteString cf : request.getFamilyList()) {
                    columnFamilies.add(cf.toByteArray());
                }
            }
            int nCF = columnFamilies.size();
            List<String> fileList = region.getStoreFileList((byte[][])columnFamilies.toArray((T[])new byte[nCF][]));
            AdminProtos.GetStoreFileResponse.Builder builder = AdminProtos.GetStoreFileResponse.newBuilder();
            builder.addAllStoreFile(fileList);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @QosPriority(priority=100)
    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        this.requestCount.increment();
        if (request.hasServerStartCode()) {
            long serverStartCode = request.getServerStartCode();
            if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
            }
        }
        AdminProtos.OpenRegionResponse.Builder builder = AdminProtos.OpenRegionResponse.newBuilder();
        int regionCount = request.getOpenInfoCount();
        HashMap<TableName, TableDescriptor> htds = new HashMap<TableName, TableDescriptor>(regionCount);
        boolean isBulkAssign = regionCount > 1;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            HBaseProtos.RegionInfo ri;
            TableName tableName = null;
            if (regionCount == 1 && (ri = request.getOpenInfo(0).getRegion()) != null) {
                tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)ri.getTableName());
            }
            if (!TableName.META_TABLE_NAME.equals(tableName)) {
                throw new ServiceException((Throwable)ie);
            }
            int timeout = this.regionServer.conf.getInt("hbase.rpc.timeout", 60000) >> 2;
            long endTime = System.currentTimeMillis() + (long)timeout;
            AtomicBoolean atomicBoolean = this.regionServer.online;
            synchronized (atomicBoolean) {
                try {
                    while (System.currentTimeMillis() <= endTime && !this.regionServer.isStopped() && !this.regionServer.isOnline()) {
                        this.regionServer.online.wait(this.regionServer.msgInterval);
                    }
                    this.checkOpen();
                }
                catch (InterruptedException t) {
                    Thread.currentThread().interrupt();
                    throw new ServiceException((Throwable)t);
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        }
        long masterSystemTime = request.hasMasterSystemTime() ? request.getMasterSystemTime() : -1L;
        for (AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo : request.getOpenInfoList()) {
            RegionInfo region = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)regionOpenInfo.getRegion());
            try {
                String encodedName = region.getEncodedName();
                byte[] encodedNameBytes = region.getEncodedNameAsBytes();
                HRegion onlineRegion = this.regionServer.getRegion(encodedName);
                if (onlineRegion != null) {
                    String error = "Received OPEN for the region:" + region.getRegionNameAsString() + ", which is already online";
                    LOG.warn(error);
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
                    continue;
                }
                LOG.info("Open " + region.getRegionNameAsString());
                Boolean previous = this.regionServer.regionsInTransitionInRS.putIfAbsent(encodedNameBytes, Boolean.TRUE);
                if (Boolean.FALSE.equals(previous)) {
                    if (this.regionServer.getRegion(encodedName) != null) {
                        String error = "Received OPEN for the region:" + region.getRegionNameAsString() + ", which we are already trying to CLOSE";
                        this.regionServer.abort(error);
                        throw new IOException(error);
                    }
                    this.regionServer.regionsInTransitionInRS.put(encodedNameBytes, Boolean.TRUE);
                }
                if (Boolean.TRUE.equals(previous)) {
                    LOG.info("Receiving OPEN for the region:" + region.getRegionNameAsString() + ", which we are already trying to OPEN - ignoring this new request for this region.");
                }
                this.regionServer.removeFromMovedRegions(region.getEncodedName());
                if (previous == null || !previous.booleanValue()) {
                    TableDescriptor htd = (TableDescriptor)htds.get(region.getTable());
                    if (htd == null) {
                        htd = this.regionServer.tableDescriptors.get(region.getTable());
                        htds.put(region.getTable(), htd);
                    }
                    if (htd == null) {
                        throw new IOException("Missing table descriptor for " + region.getEncodedName());
                    }
                    if (this.regionServer.executorService == null) {
                        LOG.info("No executor executorService; skipping open request");
                    } else if (region.isMetaRegion()) {
                        this.regionServer.executorService.submit(new OpenMetaHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime));
                    } else {
                        if (regionOpenInfo.getFavoredNodesCount() > 0) {
                            this.regionServer.updateRegionFavoredNodesMapping(region.getEncodedName(), regionOpenInfo.getFavoredNodesList());
                        }
                        if (htd.getPriority() >= 100 || region.getTable().isSystemTable()) {
                            this.regionServer.executorService.submit(new OpenPriorityRegionHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime));
                        } else {
                            this.regionServer.executorService.submit(new OpenRegionHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime));
                        }
                    }
                }
                builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
            }
            catch (IOException ie) {
                LOG.warn("Failed opening region " + region.getRegionNameAsString(), (Throwable)ie);
                if (isBulkAssign) {
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING);
                    continue;
                }
                throw new ServiceException((Throwable)ie);
            }
        }
        return builder.build();
    }

    public AdminProtos.WarmupRegionResponse warmupRegion(RpcController controller, AdminProtos.WarmupRegionRequest request) throws ServiceException {
        RegionInfo region = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)request.getRegionInfo());
        AdminProtos.WarmupRegionResponse response = AdminProtos.WarmupRegionResponse.getDefaultInstance();
        try {
            this.checkOpen();
            String encodedName = region.getEncodedName();
            byte[] encodedNameBytes = region.getEncodedNameAsBytes();
            HRegion onlineRegion = this.regionServer.getRegion(encodedName);
            if (onlineRegion != null) {
                LOG.info("Region already online. Skipping warming up " + region);
                return response;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Warming up Region " + region.getRegionNameAsString());
            }
            TableDescriptor htd = this.regionServer.tableDescriptors.get(region.getTable());
            if (this.regionServer.getRegionsInTransitionInRS().containsKey(encodedNameBytes)) {
                LOG.info("Region is in transition. Skipping warmup " + region);
                return response;
            }
            HRegion.warmupHRegion(region, htd, this.regionServer.getWAL(region), this.regionServer.getConfiguration(), this.regionServer, null);
        }
        catch (IOException ie) {
            LOG.error("Failed warming up region " + region.getRegionNameAsString(), (Throwable)ie);
            throw new ServiceException((Throwable)ie);
        }
        return response;
    }

    @QosPriority(priority=6)
    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTime();
        CellScanner cells = ((HBaseRpcController)controller).cellScanner();
        try {
            this.checkOpen();
            List entries = request.getEntryList();
            if (entries == null || entries.isEmpty()) {
                AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
                return replicateWALEntryResponse;
            }
            ByteString regionName = ((AdminProtos.WALEntry)entries.get(0)).getKey().getEncodedRegionName();
            HRegion region = this.regionServer.getRegionByEncodedName(regionName.toStringUtf8());
            RegionCoprocessorHost coprocessorHost = ServerRegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo()) ? region.getCoprocessorHost() : null;
            ArrayList<Pair> walEntries = new ArrayList<Pair>();
            boolean isPrimary = RegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo());
            Durability durability = isPrimary ? Durability.USE_DEFAULT : Durability.SKIP_WAL;
            for (AdminProtos.WALEntry entry : entries) {
                if (!regionName.equals((Object)entry.getKey().getEncodedRegionName())) {
                    throw new NotServingRegionException("Replay request contains entries from multiple regions. First region:" + regionName.toStringUtf8() + " , other region:" + entry.getKey().getEncodedRegionName());
                }
                if (this.regionServer.nonceManager != null && isPrimary) {
                    long nonceGroup = entry.getKey().hasNonceGroup() ? entry.getKey().getNonceGroup() : 0L;
                    long nonce = entry.getKey().hasNonce() ? entry.getKey().getNonce() : 0L;
                    this.regionServer.nonceManager.reportOperationFromWal(nonceGroup, nonce, entry.getKey().getWriteTime());
                }
                Pair walEntry = coprocessorHost == null ? null : new Pair();
                List<WALSplitter.MutationReplay> edits = WALSplitter.getMutationsFromWALEntry(entry, cells, (Pair<WALKey, WALEdit>)walEntry, durability);
                if (coprocessorHost != null) {
                    if (coprocessorHost.preWALRestore(region.getRegionInfo(), (WALKey)walEntry.getFirst(), (WALEdit)walEntry.getSecond())) continue;
                    walEntries.add(walEntry);
                }
                if (edits == null || edits.isEmpty()) continue;
                Collections.sort(edits, (v1, v2) -> Row.COMPARATOR.compare(v1.mutation, v2.mutation));
                long replaySeqId = entry.getKey().hasOrigSequenceNumber() ? entry.getKey().getOrigSequenceNumber() : entry.getKey().getLogSequenceNumber();
                OperationStatus[] result = this.doReplayBatchOp(region, edits, replaySeqId);
                for (int i = 0; result != null && i < result.length; ++i) {
                    if (result[i] == OperationStatus.SUCCESS) continue;
                    throw new IOException(result[i].getExceptionMsg());
                }
            }
            WAL wal = region.getWAL();
            if (wal != null) {
                wal.sync();
            }
            if (coprocessorHost != null) {
                for (Pair entry : walEntries) {
                    coprocessorHost.postWALRestore(region.getRegionInfo(), (WALKey)entry.getFirst(), (WALEdit)entry.getSecond());
                }
            }
            AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            return replicateWALEntryResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateReplay(EnvironmentEdgeManager.currentTime() - before);
            }
        }
    }

    @QosPriority(priority=5)
    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        try {
            this.checkOpen();
            if (this.regionServer.replicationSinkHandler != null) {
                this.requestCount.increment();
                List entries = request.getEntryList();
                CellScanner cellScanner = ((HBaseRpcController)controller).cellScanner();
                this.regionServer.getRegionServerCoprocessorHost().preReplicateLogEntries();
                this.regionServer.replicationSinkHandler.replicateLogEntries(entries, cellScanner, request.getReplicationClusterId(), request.getSourceBaseNamespaceDirPath(), request.getSourceHFileArchiveDirPath());
                this.regionServer.getRegionServerCoprocessorHost().postReplicateLogEntries();
                return AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            }
            throw new ServiceException("Replication services are not initialized yet");
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            this.regionServer.getRegionServerCoprocessorHost().preRollWALWriterRequest();
            this.regionServer.walRoller.requestRollAll();
            this.regionServer.getRegionServerCoprocessorHost().postRollWALWriterRequest();
            AdminProtos.RollWALWriterResponse.Builder builder = AdminProtos.RollWALWriterResponse.newBuilder();
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        this.requestCount.increment();
        String reason = request.getReason();
        this.regionServer.stop(reason);
        return AdminProtos.StopServerResponse.newBuilder().build();
    }

    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        List openInfoList = request.getUpdateInfoList();
        AdminProtos.UpdateFavoredNodesResponse.Builder respBuilder = AdminProtos.UpdateFavoredNodesResponse.newBuilder();
        for (AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo regionUpdateInfo : openInfoList) {
            RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)regionUpdateInfo.getRegion());
            if (regionUpdateInfo.getFavoredNodesCount() <= 0) continue;
            this.regionServer.updateRegionFavoredNodesMapping(hri.getEncodedName(), regionUpdateInfo.getFavoredNodesList());
        }
        respBuilder.setResponse(openInfoList.size());
        return respBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        long start = EnvironmentEdgeManager.currentTime();
        try {
            ActivePolicyEnforcement activeSpaceQuotas;
            Object enforcement;
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            Map<byte[], List<Path>> map = null;
            if (QuotaUtil.isQuotaEnabled(this.getConfiguration()) && (enforcement = (activeSpaceQuotas = this.getSpaceQuotaManager().getActiveEnforcements()).getPolicyEnforcement(region)) != null) {
                ArrayList<String> filePaths = new ArrayList<String>(request.getFamilyPathCount());
                for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                    filePaths.add(familyPath.getPath());
                }
                enforcement.checkBulkLoad(this.regionServer.getFileSystem(), filePaths);
            }
            ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>(request.getFamilyPathCount());
            for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                familyPaths.add((Pair<byte[], String>)new Pair((Object)familyPath.getFamily().toByteArray(), (Object)familyPath.getPath()));
            }
            if (!request.hasBulkToken()) {
                if (region.getCoprocessorHost() != null) {
                    region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
                }
                try {
                    map = region.bulkLoadHFiles(familyPaths, request.getAssignSeqNum(), null, request.getCopyFile());
                }
                finally {
                    if (region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postBulkLoadHFile(familyPaths, map);
                    }
                }
            } else {
                map = this.regionServer.secureBulkLoadManager.secureBulkLoadHFiles(region, request);
            }
            ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
            builder.setLoaded(map != null);
            ClientProtos.BulkLoadHFileResponse bulkLoadHFileResponse = builder.build();
            return bulkLoadHFileResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateBulkLoad(EnvironmentEdgeManager.currentTime() - start);
            }
        }
    }

    public ClientProtos.PrepareBulkLoadResponse prepareBulkLoad(RpcController controller, ClientProtos.PrepareBulkLoadRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            String bulkToken = this.regionServer.secureBulkLoadManager.prepareBulkLoad(region, request);
            ClientProtos.PrepareBulkLoadResponse.Builder builder = ClientProtos.PrepareBulkLoadResponse.newBuilder();
            builder.setBulkToken(bulkToken);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.CleanupBulkLoadResponse cleanupBulkLoad(RpcController controller, ClientProtos.CleanupBulkLoadRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            this.regionServer.secureBulkLoadManager.cleanupBulkLoad(region, request);
            ClientProtos.CleanupBulkLoadResponse response = ClientProtos.CleanupBulkLoadResponse.newBuilder().build();
            return response;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            com.google.protobuf.Message result = this.execServiceOnRegion(region, request.getCall());
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])region.getRegionInfo().getRegionName()));
            builder.setValue(builder.getValueBuilder().setName(result.getClass().getName()).setValue(ByteString.copyFrom((byte[])result.toByteArray())));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    private com.google.protobuf.Message execServiceOnRegion(HRegion region, ClientProtos.CoprocessorServiceCall serviceCall) throws IOException {
        ServerRpcController execController = new ServerRpcController();
        return region.execService((com.google.protobuf.RpcController)execController, serviceCall);
    }

    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        ClientProtos.GetResponse getResponse;
        OperationQuota quota;
        block20: {
            TableDescriptor td;
            MetricsRegionServer mrs;
            long before = EnvironmentEdgeManager.currentTime();
            quota = null;
            HRegion region = null;
            try {
                this.checkOpen();
                this.requestCount.increment();
                this.rpcGetRequestCount.increment();
                region = this.getRegion(request.getRegion());
                ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
                ClientProtos.Get get = request.getGet();
                if (get.hasClosestRowBefore() && get.getClosestRowBefore()) {
                    throw new UnknownProtocolException("Is this a pre-hbase-1.0.0 or asynchbase client? Client is invoking getClosestRowBefore removed in hbase-2.0.0 replaced by reverse Scan.");
                }
                Boolean existence = null;
                Result r = null;
                RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
                quota = this.getRpcQuotaManager().checkQuota((Region)region, OperationQuota.OperationType.GET);
                Get clientGet = ProtobufUtil.toGet((ClientProtos.Get)get);
                if (get.getExistenceOnly() && region.getCoprocessorHost() != null) {
                    existence = region.getCoprocessorHost().preExists(clientGet);
                }
                if (existence == null) {
                    r = context != null ? this.get(clientGet, region, null, context) : region.get(clientGet);
                    if (get.getExistenceOnly()) {
                        boolean exists = r.getExists();
                        if (region.getCoprocessorHost() != null) {
                            exists = region.getCoprocessorHost().postExists(clientGet, exists);
                        }
                        existence = exists;
                    }
                }
                if (existence != null) {
                    ClientProtos.Result pbr = ProtobufUtil.toResult((boolean)existence, (region.getRegionInfo().getReplicaId() != 0 ? 1 : 0) != 0);
                    builder.setResult(pbr);
                } else if (r != null) {
                    ClientProtos.Result pbr;
                    if (this.isClientCellBlockSupport(context) && controller instanceof HBaseRpcController && VersionInfoUtil.hasMinimumVersion(context.getClientVersionInfo(), 1, 3)) {
                        pbr = ProtobufUtil.toResultNoData((Result)r);
                        ((HBaseRpcController)controller).setCellScanner(CellUtil.createCellScanner((Cell[])r.rawCells()));
                        this.addSize(context, r, null);
                    } else {
                        pbr = ProtobufUtil.toResult((Result)r);
                    }
                    builder.setResult(pbr);
                }
                if (r != null) {
                    quota.addGetResult(r);
                }
                getResponse = builder.build();
                mrs = this.regionServer.metricsRegionServer;
                if (mrs == null) break block20;
                TableDescriptor tableDescriptor = td = region != null ? region.getTableDescriptor() : null;
            }
            catch (IOException ie) {
                try {
                    throw new ServiceException((Throwable)ie);
                }
                catch (Throwable throwable) {
                    MetricsRegionServer mrs2 = this.regionServer.metricsRegionServer;
                    if (mrs2 != null) {
                        TableDescriptor td2;
                        TableDescriptor tableDescriptor = td2 = region != null ? region.getTableDescriptor() : null;
                        if (td2 != null) {
                            mrs2.updateGet(td2.getTableName(), EnvironmentEdgeManager.currentTime() - before);
                        }
                    }
                    if (quota != null) {
                        quota.close();
                    }
                    throw throwable;
                }
            }
            if (td != null) {
                mrs.updateGet(td.getTableName(), EnvironmentEdgeManager.currentTime() - before);
            }
        }
        if (quota != null) {
            quota.close();
        }
        return getResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result get(Get get, HRegion region, RegionScannersCloseCallBack closeCallBack, RpcCallContext context) throws IOException {
        region.prepareGet(get);
        boolean stale = region.getRegionInfo().getReplicaId() != 0;
        ArrayList<Cell> results = new ArrayList<Cell>();
        long before = EnvironmentEdgeManager.currentTime();
        if (region.getCoprocessorHost() != null && region.getCoprocessorHost().preGet(get, results)) {
            region.metricsUpdateForGet(results, before);
            return Result.create(results, get.isCheckExistenceOnly() ? Boolean.valueOf(!results.isEmpty()) : null, (boolean)stale);
        }
        Scan scan = new Scan(get);
        if (scan.getLoadColumnFamiliesOnDemandValue() == null) {
            scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
        }
        HRegion.RegionScannerImpl scanner = null;
        try {
            scanner = region.getScanner(scan);
            scanner.next(results);
        }
        finally {
            if (scanner != null) {
                if (closeCallBack == null) {
                    context.setCallBack(scanner);
                } else {
                    closeCallBack.addScanner(scanner);
                }
            }
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().postGet(get, results);
        }
        region.metricsUpdateForGet(results, before);
        return Result.create(results, get.isCheckExistenceOnly() ? Boolean.valueOf(!results.isEmpty()) : null, (boolean)stale);
    }

    private void checkBatchSizeAndLogLargeSize(ClientProtos.MultiRequest request) {
        int sum = 0;
        String firstRegionName = null;
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            if (sum == 0) {
                firstRegionName = Bytes.toStringBinary((byte[])regionAction.getRegion().getValue().toByteArray());
            }
            sum += regionAction.getActionCount();
        }
        if (sum > this.rowSizeWarnThreshold) {
            this.ld.logBatchWarning(firstRegionName, sum, this.rowSizeWarnThreshold);
        }
    }

    public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        CellScanner cellScanner;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        this.checkBatchSizeAndLogLargeSize(request);
        HBaseRpcController controller = (HBaseRpcController)rpcc;
        CellScanner cellScanner2 = cellScanner = controller != null ? controller.cellScanner() : null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
        List<CellScannable> cellsToReturn = null;
        ClientProtos.MultiResponse.Builder responseBuilder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        Boolean processed = null;
        RegionScannersCloseCallBack closeCallBack = null;
        RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
        this.rpcMultiRequestCount.increment();
        this.requestCount.increment();
        HashMap<HBaseProtos.RegionSpecifier, ClientProtos.RegionLoadStats> regionStats = new HashMap<HBaseProtos.RegionSpecifier, ClientProtos.RegionLoadStats>(request.getRegionActionCount());
        ActivePolicyEnforcement spaceQuotaEnforcement = this.getSpaceQuotaManager().getActiveEnforcements();
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            OperationQuota quota;
            HRegion region;
            HBaseProtos.RegionSpecifier regionSpecifier;
            block15: {
                regionActionResultBuilder.clear();
                regionSpecifier = regionAction.getRegion();
                try {
                    region = this.getRegion(regionSpecifier);
                    quota = this.getRpcQuotaManager().checkQuota((Region)region, regionAction.getActionList());
                }
                catch (IOException e) {
                    this.rpcServer.getMetrics().exception(e);
                    regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
                    this.skipCellsForMutations(regionAction.getActionList(), cellScanner);
                    continue;
                }
                if (regionAction.hasAtomic() && regionAction.getAtomic()) {
                    try {
                        if (request.hasCondition()) {
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareOperator op = CompareOperator.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            TimeRange timeRange = condition.hasTimeRange() ? ProtobufUtil.toTimeRange((HBaseProtos.TimeRange)condition.getTimeRange()) : TimeRange.allTime();
                            processed = this.checkAndRowMutate(region, regionAction.getActionList(), cellScanner, row, family, qualifier, op, comparator, timeRange, regionActionResultBuilder, spaceQuotaEnforcement);
                            break block15;
                        }
                        this.doAtomicBatchOp(regionActionResultBuilder, region, quota, regionAction.getActionList(), cellScanner, spaceQuotaEnforcement);
                        processed = Boolean.TRUE;
                    }
                    catch (IOException e) {
                        this.rpcServer.getMetrics().exception(e);
                        regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    }
                } else {
                    if (context != null && closeCallBack == null) {
                        closeCallBack = new RegionScannersCloseCallBack();
                        context.setCallBack(closeCallBack);
                    }
                    cellsToReturn = this.doNonAtomicRegionMutation(region, quota, regionAction, cellScanner, regionActionResultBuilder, cellsToReturn, nonceGroup, closeCallBack, context, spaceQuotaEnforcement);
                }
            }
            responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
            quota.close();
            ClientProtos.RegionLoadStats regionLoadStats = region.getLoadStatistics();
            if (regionLoadStats == null) continue;
            regionStats.put(regionSpecifier, regionLoadStats);
        }
        if (cellsToReturn != null && !cellsToReturn.isEmpty() && controller != null) {
            controller.setCellScanner(CellUtil.createCellScanner((List)cellsToReturn));
        }
        if (processed != null) {
            responseBuilder.setProcessed(processed.booleanValue());
        }
        ClientProtos.MultiRegionLoadStats.Builder builder = ClientProtos.MultiRegionLoadStats.newBuilder();
        for (Map.Entry stat : regionStats.entrySet()) {
            builder.addRegion((HBaseProtos.RegionSpecifier)stat.getKey());
            builder.addStat((ClientProtos.RegionLoadStats)stat.getValue());
        }
        responseBuilder.setRegionStatistics(builder);
        return responseBuilder.build();
    }

    private void skipCellsForMutations(List<ClientProtos.Action> actions, CellScanner cellScanner) {
        if (cellScanner == null) {
            return;
        }
        for (ClientProtos.Action action : actions) {
            this.skipCellsForMutation(action, cellScanner);
        }
    }

    private void skipCellsForMutation(ClientProtos.Action action, CellScanner cellScanner) {
        if (cellScanner == null) {
            return;
        }
        try {
            ClientProtos.MutationProto m;
            if (action.hasMutation() && (m = action.getMutation()).hasAssociatedCellCount()) {
                for (int i = 0; i < m.getAssociatedCellCount(); ++i) {
                    cellScanner.advance();
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error while skipping Cells in CellScanner for invalid Region Mutations", (Throwable)e);
        }
    }

    public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
        ClientProtos.MutateResponse mutateResponse;
        block35: {
            HBaseRpcController controller = (HBaseRpcController)rpcc;
            CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
            OperationQuota quota = null;
            RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
            ActivePolicyEnforcement spaceQuotaEnforcement = null;
            ClientProtos.MutationProto.MutationType type = null;
            HRegion region = null;
            long before = EnvironmentEdgeManager.currentTime();
            if (controller != null) {
                controller.setCellScanner(null);
            }
            try {
                this.checkOpen();
                this.requestCount.increment();
                this.rpcMutateRequestCount.increment();
                region = this.getRegion(request.getRegion());
                ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
                ClientProtos.MutationProto mutation = request.getMutation();
                if (!region.getRegionInfo().isMetaRegion()) {
                    this.regionServer.cacheFlusher.reclaimMemStoreMemory();
                }
                long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
                Result r = null;
                Boolean processed = null;
                type = mutation.getMutateType();
                quota = this.getRpcQuotaManager().checkQuota((Region)region, OperationQuota.OperationType.MUTATE);
                spaceQuotaEnforcement = this.getSpaceQuotaManager().getActiveEnforcements();
                switch (type) {
                    case APPEND: {
                        r = this.append(region, quota, mutation, cellScanner, nonceGroup, spaceQuotaEnforcement);
                        break;
                    }
                    case INCREMENT: {
                        r = this.increment(region, quota, mutation, cellScanner, nonceGroup, spaceQuotaEnforcement);
                        break;
                    }
                    case PUT: {
                        Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                        this.checkCellSizeLimit(region, (Mutation)put);
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check((Mutation)put);
                        quota.addMutation((Mutation)put);
                        if (request.hasCondition()) {
                            TimeRange timeRange;
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareOperator compareOp = CompareOperator.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            TimeRange timeRange2 = timeRange = condition.hasTimeRange() ? ProtobufUtil.toTimeRange((HBaseProtos.TimeRange)condition.getTimeRange()) : TimeRange.allTime();
                            if (region.getCoprocessorHost() != null) {
                                processed = region.getCoprocessorHost().preCheckAndPut(row, family, qualifier, compareOp, comparator, put);
                            }
                            if (processed != null) break;
                            boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, timeRange, (Mutation)put);
                            if (region.getCoprocessorHost() != null) {
                                result = region.getCoprocessorHost().postCheckAndPut(row, family, qualifier, compareOp, comparator, put, result);
                            }
                            processed = result;
                            break;
                        }
                        region.put(put);
                        processed = Boolean.TRUE;
                        break;
                    }
                    case DELETE: {
                        Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                        this.checkCellSizeLimit(region, (Mutation)delete);
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check((Mutation)delete);
                        quota.addMutation((Mutation)delete);
                        if (request.hasCondition()) {
                            TimeRange timeRange;
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareOperator op = CompareOperator.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            TimeRange timeRange3 = timeRange = condition.hasTimeRange() ? ProtobufUtil.toTimeRange((HBaseProtos.TimeRange)condition.getTimeRange()) : TimeRange.allTime();
                            if (region.getCoprocessorHost() != null) {
                                processed = region.getCoprocessorHost().preCheckAndDelete(row, family, qualifier, op, comparator, delete);
                            }
                            if (processed != null) break;
                            boolean result = region.checkAndMutate(row, family, qualifier, op, comparator, timeRange, (Mutation)delete);
                            if (region.getCoprocessorHost() != null) {
                                result = region.getCoprocessorHost().postCheckAndDelete(row, family, qualifier, op, comparator, delete, result);
                            }
                            processed = result;
                            break;
                        }
                        region.delete(delete);
                        processed = Boolean.TRUE;
                        break;
                    }
                    default: {
                        throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                    }
                }
                if (processed != null) {
                    builder.setProcessed(processed.booleanValue());
                }
                boolean clientCellBlockSupported = this.isClientCellBlockSupport(context);
                this.addResult(builder, r, controller, clientCellBlockSupported);
                if (clientCellBlockSupported) {
                    this.addSize(context, r, null);
                }
                mutateResponse = builder.build();
                if (quota != null) {
                    quota.close();
                }
                if (this.regionServer.metricsRegionServer == null || type == null) break block35;
            }
            catch (IOException ie) {
                try {
                    this.regionServer.checkFileSystem();
                    throw new ServiceException((Throwable)ie);
                }
                catch (Throwable throwable) {
                    if (quota != null) {
                        quota.close();
                    }
                    if (this.regionServer.metricsRegionServer != null && type != null) {
                        long after = EnvironmentEdgeManager.currentTime();
                        switch (type) {
                            case DELETE: {
                                if (request.hasCondition()) {
                                    this.regionServer.metricsRegionServer.updateCheckAndDelete(after - before);
                                    break;
                                }
                                this.regionServer.metricsRegionServer.updateDelete(region == null ? null : region.getRegionInfo().getTable(), after - before);
                                break;
                            }
                            case PUT: {
                                if (request.hasCondition()) {
                                    this.regionServer.metricsRegionServer.updateCheckAndPut(after - before);
                                    break;
                                }
                                this.regionServer.metricsRegionServer.updatePut(region == null ? null : region.getRegionInfo().getTable(), after - before);
                                break;
                            }
                        }
                    }
                    throw throwable;
                }
            }
            long after = EnvironmentEdgeManager.currentTime();
            switch (type) {
                case DELETE: {
                    if (request.hasCondition()) {
                        this.regionServer.metricsRegionServer.updateCheckAndDelete(after - before);
                        break;
                    }
                    this.regionServer.metricsRegionServer.updateDelete(region == null ? null : region.getRegionInfo().getTable(), after - before);
                    break;
                }
                case PUT: {
                    if (request.hasCondition()) {
                        this.regionServer.metricsRegionServer.updateCheckAndPut(after - before);
                        break;
                    }
                    this.regionServer.metricsRegionServer.updatePut(region == null ? null : region.getRegionInfo().getTable(), after - before);
                    break;
                }
            }
        }
        return mutateResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScannerHolder getRegionScanner(ClientProtos.ScanRequest request) throws IOException {
        String scannerName = Long.toString(request.getScannerId());
        RegionScannerHolder rsh = (RegionScannerHolder)this.scanners.get(scannerName);
        if (rsh == null) {
            if (this.closedScanners.getIfPresent((Object)scannerName) != null) {
                throw SCANNER_ALREADY_CLOSED;
            }
            LOG.warn("Client tried to access missing scanner " + scannerName);
            throw new UnknownScannerException("Unknown scanner '" + scannerName + "'. This can happen due to any of the following reasons: a) Scanner id given is wrong, b) Scanner lease expired because of long wait between consecutive client checkins, c) Server may be closing down, d) RegionServer restart during upgrade.\nIf the issue is due to reason (b), a possible fix would be increasing the value of'hbase.client.scanner.timeout.period' configuration.");
        }
        RegionInfo hri = rsh.s.getRegionInfo();
        if (this.regionServer.getOnlineRegion(hri.getRegionName()) != rsh.r) {
            String msg = "Region has changed on the scanner " + scannerName + ": regionName=" + hri.getRegionNameAsString() + ", scannerRegionName=" + rsh.r;
            LOG.warn(msg + ", closing...");
            this.scanners.remove(scannerName);
            try {
                rsh.s.close();
            }
            catch (IOException e) {
                LOG.warn("Getting exception closing " + scannerName, (Throwable)e);
            }
            finally {
                try {
                    this.regionServer.leases.cancelLease(scannerName);
                }
                catch (LeaseException e) {
                    LOG.warn("Getting exception closing " + scannerName, (Throwable)e);
                }
            }
            throw new NotServingRegionException(msg);
        }
        return rsh;
    }

    private RegionScannerHolder newRegionScanner(ClientProtos.ScanRequest request, ClientProtos.ScanResponse.Builder builder) throws IOException {
        HRegion.RegionScannerImpl coreScanner;
        HRegion region = this.getRegion(request.getRegion());
        ClientProtos.Scan protoScan = request.getScan();
        boolean isLoadingCfsOnDemandSet = protoScan.hasLoadColumnFamiliesOnDemand();
        Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)protoScan);
        if (!isLoadingCfsOnDemandSet) {
            scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
        }
        if (!scan.hasFamilies()) {
            for (byte[] family : region.getTableDescriptor().getColumnFamilyNames()) {
                scan.addFamily(family);
            }
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().preScannerOpen(scan);
        }
        HRegion.RegionScannerImpl shipper = coreScanner = region.getScanner(scan);
        RegionScanner scanner = coreScanner;
        if (region.getCoprocessorHost() != null) {
            scanner = region.getCoprocessorHost().postScannerOpen(scan, scanner);
        }
        long scannerId = this.scannerIdGenerator.generateNewScannerId();
        builder.setScannerId(scannerId);
        builder.setMvccReadPoint(scanner.getMvccReadPoint());
        builder.setTtl(this.scannerLeaseTimeoutPeriod);
        String scannerName = String.valueOf(scannerId);
        return this.addScanner(scannerName, scanner, shipper, region, scan.isNeedCursorResult());
    }

    private void checkScanNextCallSeq(ClientProtos.ScanRequest request, RegionScannerHolder rsh) throws OutOfOrderScannerNextException {
        long callSeq;
        if (request.hasNextCallSeq() && !rsh.incNextCallSeq(callSeq = request.getNextCallSeq())) {
            throw new OutOfOrderScannerNextException("Expected nextCallSeq: " + rsh.getNextCallSeq() + " But the nextCallSeq got from client: " + request.getNextCallSeq() + "; request=" + TextFormat.shortDebugString((MessageOrBuilder)request));
        }
    }

    private void addScannerLeaseBack(Leases.Lease lease) {
        try {
            this.regionServer.leases.addLease(lease);
        }
        catch (Leases.LeaseStillHeldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private long getTimeLimit(HBaseRpcController controller, boolean allowHeartbeatMessages) {
        if (allowHeartbeatMessages && (this.scannerLeaseTimeoutPeriod > 0 || this.rpcTimeout > 0)) {
            long timeLimitDelta;
            if (this.scannerLeaseTimeoutPeriod > 0 && this.rpcTimeout > 0) {
                timeLimitDelta = Math.min(this.scannerLeaseTimeoutPeriod, this.rpcTimeout);
            } else {
                long l = timeLimitDelta = this.scannerLeaseTimeoutPeriod > 0 ? (long)this.scannerLeaseTimeoutPeriod : (long)this.rpcTimeout;
            }
            if (controller != null && controller.getCallTimeout() > 0) {
                timeLimitDelta = Math.min(timeLimitDelta, (long)controller.getCallTimeout());
            }
            timeLimitDelta = Math.max(timeLimitDelta / 2L, this.minimumScanTimeLimitDelta);
            return System.currentTimeMillis() + timeLimitDelta;
        }
        return -1L;
    }

    private void checkLimitOfRows(int numOfCompleteRows, int limitOfRows, boolean moreRows, ScannerContext scannerContext, ClientProtos.ScanResponse.Builder builder) {
        if (numOfCompleteRows >= limitOfRows) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Done scanning, limit of rows reached, moreRows: " + moreRows + " scannerContext: " + scannerContext);
            }
            builder.setMoreResults(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(HBaseRpcController controller, ClientProtos.ScanRequest request, RegionScannerHolder rsh, long maxQuotaResultSize, int maxResults, int limitOfRows, List<Result> results, ClientProtos.ScanResponse.Builder builder, MutableObject lastBlock, RpcCallContext context) throws IOException {
        HRegion region = rsh.r;
        RegionScanner scanner = rsh.s;
        long maxResultSize = scanner.getMaxResultSize() > 0L ? Math.min(scanner.getMaxResultSize(), maxQuotaResultSize) : maxQuotaResultSize;
        ArrayList<Cell> values = new ArrayList<Cell>(32);
        region.startRegionOperation(Region.Operation.SCAN);
        try {
            int numOfResults = 0;
            int numOfCompleteRows = 0;
            long before = EnvironmentEdgeManager.currentTime();
            RegionScanner regionScanner = scanner;
            synchronized (regionScanner) {
                boolean stale = region.getRegionInfo().getReplicaId() != 0;
                boolean clientHandlesPartials = request.hasClientHandlesPartials() && request.getClientHandlesPartials();
                boolean clientHandlesHeartbeats = request.hasClientHandlesHeartbeats() && request.getClientHandlesHeartbeats();
                boolean serverGuaranteesOrderOfPartials = results.isEmpty();
                boolean allowPartialResults = clientHandlesPartials && serverGuaranteesOrderOfPartials;
                boolean moreRows = false;
                boolean allowHeartbeatMessages = clientHandlesHeartbeats && allowPartialResults;
                long timeLimit = this.getTimeLimit(controller, allowHeartbeatMessages);
                ScannerContext.LimitScope sizeScope = allowPartialResults ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                ScannerContext.LimitScope timeScope = allowHeartbeatMessages ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                boolean trackMetrics = request.hasTrackScanMetrics() && request.getTrackScanMetrics();
                ScannerContext.Builder contextBuilder = ScannerContext.newBuilder(true);
                contextBuilder.setSizeLimit(sizeScope, maxResultSize, maxResultSize);
                contextBuilder.setBatchLimit(scanner.getBatch());
                contextBuilder.setTimeLimit(timeScope, timeLimit);
                contextBuilder.setTrackMetrics(trackMetrics);
                ScannerContext scannerContext = contextBuilder.build();
                boolean limitReached = false;
                while (numOfResults < maxResults) {
                    scannerContext.setBatchProgress(0);
                    moreRows = scanner.nextRaw(values, scannerContext);
                    if (!values.isEmpty()) {
                        if (limitOfRows > 0) {
                            if (results.isEmpty()) {
                                if (rsh.rowOfLastPartialResult != null && !CellUtil.matchingRows((Cell)((Cell)values.get(0)), (byte[])rsh.rowOfLastPartialResult)) {
                                    this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                                }
                            } else {
                                Result lastResult = results.get(results.size() - 1);
                                if (lastResult.mayHaveMoreCellsInRow() && !CellUtil.matchingRows((Cell)((Cell)values.get(0)), (byte[])lastResult.getRow())) {
                                    this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                                }
                            }
                            if (builder.hasMoreResults() && !builder.getMoreResults()) break;
                        }
                        boolean mayHaveMoreCellsInRow = scannerContext.mayHaveMoreCellsInRow();
                        Result r = Result.create(values, null, (boolean)stale, (boolean)mayHaveMoreCellsInRow);
                        lastBlock.setValue(this.addSize(context, r, lastBlock.getValue()));
                        results.add(r);
                        ++numOfResults;
                        if (!mayHaveMoreCellsInRow && limitOfRows > 0) {
                            this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                            if (builder.hasMoreResults() && !builder.getMoreResults()) break;
                        }
                    }
                    boolean sizeLimitReached = scannerContext.checkSizeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                    boolean timeLimitReached = scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                    boolean resultsLimitReached = numOfResults >= maxResults;
                    boolean bl = limitReached = sizeLimitReached || timeLimitReached || resultsLimitReached;
                    if (limitReached || !moreRows) {
                        Cell cursorCell;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Done scanning. limitReached: " + limitReached + " moreRows: " + moreRows + " scannerContext: " + scannerContext);
                        }
                        if (!moreRows) break;
                        builder.setHeartbeatMessage(timeLimitReached);
                        if (!timeLimitReached || !rsh.needCursor || (cursorCell = scannerContext.getLastPeekedCell()) == null) break;
                        builder.setCursor(ProtobufUtil.toCursor((Cell)cursorCell));
                        break;
                    }
                    values.clear();
                }
                builder.setMoreResultsInRegion(moreRows);
                if (trackMetrics) {
                    Map metrics = scannerContext.getMetrics().getMetricsMap();
                    MapReduceProtos.ScanMetrics.Builder metricBuilder = MapReduceProtos.ScanMetrics.newBuilder();
                    HBaseProtos.NameInt64Pair.Builder pairBuilder = HBaseProtos.NameInt64Pair.newBuilder();
                    for (Map.Entry entry : metrics.entrySet()) {
                        pairBuilder.setName((String)entry.getKey());
                        pairBuilder.setValue(((Long)entry.getValue()).longValue());
                        metricBuilder.addMetrics(pairBuilder.build());
                    }
                    builder.setScanMetrics(metricBuilder.build());
                }
            }
            long end = EnvironmentEdgeManager.currentTime();
            long responseCellSize = context != null ? context.getResponseCellSize() : 0L;
            region.getMetrics().updateScanTime(end - before);
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateScanSize(region.getTableDescriptor().getTableName(), responseCellSize);
                this.regionServer.metricsRegionServer.updateScanTime(region.getTableDescriptor().getTableName(), end - before);
            }
        }
        finally {
            region.closeRegionOperation();
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().postScannerNext(scanner, results, maxResults, true);
        }
    }

    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        boolean closeScanner;
        OperationQuota quota;
        Leases.Lease lease;
        RegionScannerHolder rsh;
        if (controller != null && !(controller instanceof HBaseRpcController)) {
            throw new UnsupportedOperationException("We only do HBaseRpcControllers! FIX IF A PROBLEM: " + controller);
        }
        if (!request.hasScannerId() && !request.hasScan()) {
            throw new ServiceException((Throwable)new DoNotRetryIOException("Missing required input: scannerId or scan"));
        }
        try {
            this.checkOpen();
        }
        catch (IOException e) {
            block51: {
                if (request.hasScannerId()) {
                    String scannerName = Long.toString(request.getScannerId());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Server shutting down and client tried to access missing scanner " + scannerName);
                    }
                    if (this.regionServer.leases != null) {
                        try {
                            this.regionServer.leases.cancelLease(scannerName);
                        }
                        catch (LeaseException le) {
                            if (!LOG.isTraceEnabled()) break block51;
                            LOG.trace("Un-able to cancel lease of scanner. It could already be closed.");
                        }
                    }
                }
            }
            throw new ServiceException((Throwable)e);
        }
        this.requestCount.increment();
        this.rpcScanRequestCount.increment();
        ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        try {
            if (request.hasScannerId()) {
                builder.setScannerId(request.getScannerId());
                rsh = this.getRegionScanner(request);
            } else {
                rsh = this.newRegionScanner(request, builder);
            }
        }
        catch (IOException e) {
            if (e == SCANNER_ALREADY_CLOSED) {
                return builder.build();
            }
            throw new ServiceException((Throwable)e);
        }
        HRegion region = rsh.r;
        String scannerName = rsh.scannerName;
        try {
            lease = this.regionServer.leases.removeLease(scannerName);
        }
        catch (LeaseException e) {
            throw new ServiceException((Throwable)e);
        }
        if (request.hasRenew() && request.getRenew()) {
            this.addScannerLeaseBack(lease);
            try {
                this.checkScanNextCallSeq(request, rsh);
            }
            catch (OutOfOrderScannerNextException e) {
                throw new ServiceException((Throwable)e);
            }
            return builder.build();
        }
        try {
            quota = this.getRpcQuotaManager().checkQuota((Region)region, OperationQuota.OperationType.SCAN);
        }
        catch (IOException e) {
            this.addScannerLeaseBack(lease);
            throw new ServiceException((Throwable)e);
        }
        try {
            this.checkScanNextCallSeq(request, rsh);
        }
        catch (OutOfOrderScannerNextException e) {
            this.addScannerLeaseBack(lease);
            throw new ServiceException((Throwable)e);
        }
        boolean bl = closeScanner = request.hasCloseScanner() ? request.getCloseScanner() : false;
        int rows = request.hasNumberOfRows() ? request.getNumberOfRows() : (closeScanner ? 0 : 1);
        RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
        long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
        RegionScanner scanner = rsh.s;
        int limitOfRows = request.hasLimitOfRows() ? request.getLimitOfRows() : -1;
        MutableObject lastBlock = new MutableObject();
        boolean scannerClosed = false;
        try {
            ArrayList<Result> results = new ArrayList<Result>();
            if (rows > 0) {
                boolean done = false;
                if (region.getCoprocessorHost() != null) {
                    Boolean bypass = region.getCoprocessorHost().preScannerNext(scanner, results, rows);
                    if (!results.isEmpty()) {
                        for (Result r : results) {
                            lastBlock.setValue(this.addSize(context, r, lastBlock.getValue()));
                        }
                    }
                    if (bypass != null && bypass.booleanValue()) {
                        done = true;
                    }
                }
                if (!done) {
                    this.scan((HBaseRpcController)controller, request, rsh, maxQuotaResultSize, rows, limitOfRows, results, builder, lastBlock, context);
                } else {
                    builder.setMoreResultsInRegion(!results.isEmpty());
                }
            } else {
                builder.setMoreResultsInRegion(true);
            }
            quota.addScanResult(results);
            this.addResults(builder, results, (HBaseRpcController)controller, RegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo()), this.isClientCellBlockSupport(context));
            if (scanner.isFilterDone() && results.isEmpty()) {
                builder.setMoreResults(false);
            }
            assert (builder.hasMoreResultsInRegion());
            if (!builder.hasMoreResults()) {
                builder.setMoreResults(true);
            }
            if (builder.getMoreResults() && builder.getMoreResultsInRegion() && !results.isEmpty()) {
                Result lastResult = (Result)results.get(results.size() - 1);
                if (lastResult.mayHaveMoreCellsInRow()) {
                    RegionScannerHolder.access$402(rsh, lastResult.getRow());
                } else {
                    RegionScannerHolder.access$402(rsh, null);
                }
            }
            if (!builder.getMoreResults() || !builder.getMoreResultsInRegion() || closeScanner) {
                scannerClosed = true;
                this.closeScanner(region, scanner, scannerName, context);
            }
            ClientProtos.ScanResponse lastResult = builder.build();
            return lastResult;
        }
        catch (IOException e) {
            try {
                scannerClosed = true;
                this.closeScanner(region, scanner, scannerName, context);
                if (e instanceof DoNotRetryIOException) {
                    throw e;
                }
                if (e instanceof FileNotFoundException) {
                    throw new DoNotRetryIOException((Throwable)e);
                }
                if (VersionInfoUtil.hasMinimumVersion(context.getClientVersionInfo(), 1, 4)) {
                    throw new ScannerResetException("Scanner is closed on the server-side", (Exception)e);
                }
                throw new UnknownScannerException("Throwing UnknownScannerException to reset the client scanner state for clients older than 1.3.", (Exception)e);
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }
        finally {
            if (!scannerClosed) {
                if (context != null) {
                    context.setCallBack(rsh.shippedCallback);
                } else {
                    this.addScannerLeaseBack(lease);
                }
            }
            quota.close();
        }
    }

    private void closeScanner(HRegion region, RegionScanner scanner, String scannerName, RpcCallContext context) throws IOException {
        if (region.getCoprocessorHost() != null && region.getCoprocessorHost().preScannerClose(scanner)) {
            return;
        }
        RegionScannerHolder rsh = (RegionScannerHolder)this.scanners.remove(scannerName);
        if (rsh != null) {
            if (context != null) {
                context.setCallBack(rsh.closeCallBack);
            } else {
                rsh.s.close();
            }
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postScannerClose(scanner);
            }
            this.closedScanners.put((Object)scannerName, (Object)scannerName);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        this.rpcPreCheck("execRegionServerService");
        return this.regionServer.execRegionServerService(controller, request);
    }

    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        try {
            this.regionServer.updateConfiguration();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        return AdminProtos.UpdateConfigurationResponse.getDefaultInstance();
    }

    public QuotaProtos.GetSpaceQuotaSnapshotsResponse getSpaceQuotaSnapshots(RpcController controller, QuotaProtos.GetSpaceQuotaSnapshotsRequest request) throws ServiceException {
        try {
            RegionServerSpaceQuotaManager manager = this.regionServer.getRegionServerSpaceQuotaManager();
            QuotaProtos.GetSpaceQuotaSnapshotsResponse.Builder builder = QuotaProtos.GetSpaceQuotaSnapshotsResponse.newBuilder();
            if (manager != null) {
                Map<TableName, SpaceQuotaSnapshot> snapshots = manager.copyQuotaSnapshots();
                for (Map.Entry<TableName, SpaceQuotaSnapshot> snapshot : snapshots.entrySet()) {
                    builder.addSnapshots(QuotaProtos.GetSpaceQuotaSnapshotsResponse.TableQuotaSnapshot.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)snapshot.getKey())).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot((SpaceQuotaSnapshot)snapshot.getValue())).build());
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public AdminProtos.ClearRegionBlockCacheResponse clearRegionBlockCache(RpcController controller, AdminProtos.ClearRegionBlockCacheRequest request) {
        AdminProtos.ClearRegionBlockCacheResponse.Builder builder = AdminProtos.ClearRegionBlockCacheResponse.newBuilder();
        CacheEvictionStatsBuilder stats = CacheEvictionStats.builder();
        List<HRegion> regions = this.getRegions(request.getRegionList(), stats);
        for (HRegion region : regions) {
            try {
                stats = stats.append(this.regionServer.clearRegionBlockCache(region));
            }
            catch (Exception e) {
                stats.addException(region.getRegionInfo().getRegionName(), (Throwable)e);
            }
        }
        stats.withMaxCacheSize(this.regionServer.getCacheConfig().getBlockCache().getMaxSize());
        return builder.setStats(ProtobufUtil.toCacheEvictionStats((CacheEvictionStats)stats.build())).build();
    }

    @QosPriority(priority=100)
    public AdminProtos.ExecuteProceduresResponse executeProcedures(RpcController controller, AdminProtos.ExecuteProceduresRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.regionServer.getRegionServerCoprocessorHost().preExecuteProcedures();
            if (request.getOpenRegionCount() > 0) {
                for (AdminProtos.OpenRegionRequest req : request.getOpenRegionList()) {
                    this.openRegion(controller, req);
                }
            }
            if (request.getCloseRegionCount() > 0) {
                for (AdminProtos.OpenRegionRequest req : request.getCloseRegionList()) {
                    this.closeRegion(controller, (AdminProtos.CloseRegionRequest)req);
                }
            }
            if (request.getProcCount() > 0) {
                for (AdminProtos.OpenRegionRequest req : request.getProcList()) {
                    RSProcedureCallable callable;
                    try {
                        callable = Class.forName(req.getProcClass()).asSubclass(RSProcedureCallable.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        this.regionServer.remoteProcedureComplete(req.getProcId(), e);
                        continue;
                    }
                    callable.init(req.getProcData().toByteArray(), this.regionServer);
                    this.regionServer.executeProcedure(req.getProcId(), callable);
                }
            }
            this.regionServer.getRegionServerCoprocessorHost().postExecuteProcedures();
            return AdminProtos.ExecuteProceduresResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    static interface LogDelegate {
        public void logBatchWarning(String var1, int var2, int var3);
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void leaseExpired() {
            RegionScannerHolder rsh = (RegionScannerHolder)RSRpcServices.this.scanners.remove(this.scannerName);
            if (rsh != null) {
                RegionScanner s = rsh.s;
                LOG.info("Scanner " + this.scannerName + " lease expired on region " + s.getRegionInfo().getRegionNameAsString());
                HRegion region = null;
                try {
                    region = RSRpcServices.this.regionServer.getRegion(s.getRegionInfo().getRegionName());
                    if (region == null || region.getCoprocessorHost() == null) return;
                    region.getCoprocessorHost().preScannerClose(s);
                    return;
                }
                catch (IOException e) {
                    LOG.error("Closing scanner for " + s.getRegionInfo().getRegionNameAsString(), (Throwable)e);
                    return;
                }
                finally {
                    try {
                        s.close();
                        if (region != null && region.getCoprocessorHost() != null) {
                            region.getCoprocessorHost().postScannerClose(s);
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Closing scanner for " + s.getRegionInfo().getRegionNameAsString(), (Throwable)e);
                    }
                }
            }
            LOG.warn("Scanner " + this.scannerName + " lease expired, but no related scanner found, hence no chance to close that related scanner!");
        }
    }

    private static final class RegionScannerHolder {
        private final AtomicLong nextCallSeq = new AtomicLong(0L);
        private final String scannerName;
        private final RegionScanner s;
        private final HRegion r;
        private final RpcCallback closeCallBack;
        private final RpcCallback shippedCallback;
        private byte[] rowOfLastPartialResult;
        private boolean needCursor;

        public RegionScannerHolder(String scannerName, RegionScanner s, HRegion r, RpcCallback closeCallBack, RpcCallback shippedCallback, boolean needCursor) {
            this.scannerName = scannerName;
            this.s = s;
            this.r = r;
            this.closeCallBack = closeCallBack;
            this.shippedCallback = shippedCallback;
            this.needCursor = needCursor;
        }

        public long getNextCallSeq() {
            return this.nextCallSeq.get();
        }

        public boolean incNextCallSeq(long currentSeq) {
            return this.nextCallSeq.compareAndSet(currentSeq, currentSeq + 1L);
        }

        static /* synthetic */ byte[] access$402(RegionScannerHolder x0, byte[] x1) {
            x0.rowOfLastPartialResult = x1;
            return x1;
        }
    }

    static class RegionScannersCloseCallBack
    implements RpcCallback {
        private final List<RegionScanner> scanners = new ArrayList<RegionScanner>();

        RegionScannersCloseCallBack() {
        }

        public void addScanner(RegionScanner scanner) {
            this.scanners.add(scanner);
        }

        @Override
        public void run() {
            for (RegionScanner scanner : this.scanners) {
                try {
                    scanner.close();
                }
                catch (IOException e) {
                    LOG.error("Exception while closing the scanner " + scanner, (Throwable)e);
                }
            }
        }
    }

    private class RegionScannerShippedCallBack
    implements RpcCallback {
        private final String scannerName;
        private final Shipper shipper;
        private final Leases.Lease lease;

        public RegionScannerShippedCallBack(String scannerName, Shipper shipper, Leases.Lease lease) {
            this.scannerName = scannerName;
            this.shipper = shipper;
            this.lease = lease;
        }

        @Override
        public void run() throws IOException {
            this.shipper.shipped();
            if (RSRpcServices.this.scanners.containsKey(this.scannerName) && this.lease != null) {
                ((RSRpcServices)RSRpcServices.this).regionServer.leases.addLease(this.lease);
            }
        }
    }

    private static final class RegionScannerCloseCallBack
    implements RpcCallback {
        private final RegionScanner scanner;

        public RegionScannerCloseCallBack(RegionScanner scanner) {
            this.scanner = scanner;
        }

        @Override
        public void run() throws IOException {
            this.scanner.close();
        }
    }
}

