/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.yetus.audience.InterfaceAudience;

/**
 * Gets or Scans throw this exception if running without in-row scan flag
 * set and row size appears to exceed max configured size (configurable via
 * hbase.table.max.rowsize).
 *
 * @deprecated use {@link org.apache.hadoop.hbase.client.RowTooBigException} instead.
 */
@InterfaceAudience.Public
@Deprecated
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value="NM_SAME_SIMPLE_NAME_AS_SUPERCLASS",
  justification="Temporary glue. To be removed")
public class RowTooBigException extends org.apache.hadoop.hbase.client.RowTooBigException {
  public RowTooBigException(String message) {
    super(message);
  }
}
