// Autogenerated Jamon implementation
// /home/zhangduo/hbase/code/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/common/TaskMonitorTmpl.jamon

package org.apache.hadoop.hbase.tmpl.common;

// 20, 1
import java.util.*;
// 21, 1
import org.apache.hadoop.hbase.monitoring.*;
// 22, 1
import org.apache.hadoop.util.StringUtils;

public class TaskMonitorTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.Intf

{
  private final String filter;
  private final String format;
  private final TaskMonitor taskMonitor;
  protected static org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getTaskMonitor__IsNotDefault())
    {
      p_implData.setTaskMonitor(TaskMonitor.get());
    }
    return p_implData;
  }
  public TaskMonitorTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    taskMonitor = p_implData.getTaskMonitor();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 30, 1
    if (format.equals("json"))
    {
      // 30, 29
      jamonWriter.write("\n    ");
      // 31, 5
      {
        // 31, 5
        __jamon_innerUnit__renderTasks(jamonWriter, filter );
      }
      // 31, 37
      jamonWriter.write("\n");
    }
    // 32, 1
    else
    {
      // 32, 8
      jamonWriter.write("\n  <h2><a name=\"tasks\">Tasks</a></h2>\n\n  <div class=\"tabbable\">\n      <ul class=\"nav nav-pills\">\n        <li class=\"\">\n            <a href=\"#tab_alltasks\" data-toggle=\"tab\">Show All Monitored Tasks</a>\n        </li>\n        <li class=\"active\">\n            <a href=\"#tab_generaltasks\" data-toggle=\"tab\">Show non-RPC Tasks</a>\n        </li>\n        <li class=\"\">\n            <a href=\"#tab_handlertasks\" data-toggle=\"tab\">Show All RPC Handler Tasks</a>\n        </li>\n        <li class=\"\">\n            <a href=\"#tab_rpctasks\" data-toggle=\"tab\">Show Active RPC Calls</a>\n        </li>\n        <li>\n            <a href=\"#tab_operationtasks\" data-toggle=\"tab\">Show Client Operations</a>\n        </li>\n      </ul>\n      <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane\" id=\"tab_alltasks\">\n            ");
      // 55, 13
      {
        // 55, 13
        __jamon_innerUnit__jsonView(jamonWriter, "all" );
      }
      // 55, 41
      jamonWriter.write("\n            ");
      // 56, 13
      {
        // 56, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "all" );
      }
      // 56, 44
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane active\" id=\"tab_generaltasks\">\n            ");
      // 59, 13
      {
        // 59, 13
        __jamon_innerUnit__jsonView(jamonWriter, "general" );
      }
      // 59, 45
      jamonWriter.write("\n            ");
      // 60, 13
      {
        // 60, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "general" );
      }
      // 60, 48
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_handlertasks\">\n            ");
      // 63, 13
      {
        // 63, 13
        __jamon_innerUnit__jsonView(jamonWriter, "handler" );
      }
      // 63, 45
      jamonWriter.write("\n            ");
      // 64, 13
      {
        // 64, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "handler" );
      }
      // 64, 48
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rpctasks\">\n            ");
      // 67, 13
      {
        // 67, 13
        __jamon_innerUnit__jsonView(jamonWriter, "rpc" );
      }
      // 67, 41
      jamonWriter.write("\n            ");
      // 68, 13
      {
        // 68, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "rpc" );
      }
      // 68, 44
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_operationtasks\">\n            ");
      // 71, 13
      {
        // 71, 13
        __jamon_innerUnit__jsonView(jamonWriter, "operation" );
      }
      // 71, 47
      jamonWriter.write("\n            ");
      // 72, 13
      {
        // 72, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "operation" );
      }
      // 72, 50
      jamonWriter.write("\n        </div>\n      </div>\n  </div>\n");
    }
    // 76, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 78, 1
  private void __jamon_innerUnit__jsonView(final java.io.Writer jamonWriter, final String filter)
    throws java.io.IOException
  {
    // 82, 5
    jamonWriter.write("<a href=\"?format=json&filter=");
    // 82, 34
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(filter), jamonWriter);
    // 82, 46
    jamonWriter.write("\">View as JSON</a>\n");
  }
  
  
  // 85, 1
  private void __jamon_innerUnit__renderTasks(final java.io.Writer jamonWriter, final String filter)
    throws java.io.IOException
  {
    // 89, 5
    
       List<? extends MonitoredTask> tasks = taskMonitor.getTasks(filter);
       long now = System.currentTimeMillis();
       Collections.sort(tasks, (t1, t2) -> Long.compare(t1.getStateTime(), t2.getStateTime()));
       boolean first = true;
    
    // 95, 5
    if (format.equals("json") )
    {
      // 95, 34
      jamonWriter.write("\n        [");
      // 96, 10
      for (MonitoredTask task : tasks)
      {
        // 96, 44
        if (first)
        {
          // 96, 56
          first = false;
        }
        // 96, 85
        else
        {
          // 96, 92
          jamonWriter.write(",");
        }
        // 96, 99
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.toJSON()), jamonWriter);
      }
      // 96, 125
      jamonWriter.write("]\n    ");
    }
    // 97, 5
    else
    {
      // 97, 12
      jamonWriter.write("\n        ");
      // 98, 9
      if (tasks.isEmpty())
      {
        // 98, 31
        jamonWriter.write("\n            <p>No tasks currently running on this node.</p>\n        ");
      }
      // 100, 9
      else
      {
        // 100, 16
        jamonWriter.write("\n            <table class=\"table table-striped\">\n                <tr>\n                      <th>Start Time</th>\n                      <th>Description</th>\n                      <th>State</th>\n                      <th>Status</th>\n                </tr>\n                ");
        // 108, 17
        for (MonitoredTask task : tasks )
        {
          // 108, 52
          jamonWriter.write("\n                    <tr class=\"");
          // 109, 32
          {
            // 109, 32
            __jamon_innerUnit__stateCss(jamonWriter, task.getState() );
          }
          // 109, 71
          jamonWriter.write("\">\n                      <td>");
          // 110, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(task.getStartTime())), jamonWriter);
          // 110, 62
          jamonWriter.write("</td>\n                      <td>");
          // 111, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getDescription()), jamonWriter);
          // 111, 54
          jamonWriter.write("</td>\n                      <td>");
          // 112, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getState()), jamonWriter);
          // 112, 48
          jamonWriter.write("\n                          (since ");
          // 113, 34
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStateTime())), jamonWriter);
          // 113, 92
          jamonWriter.write(" ago)\n                      </td>\n                      <td>");
          // 115, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getStatus()), jamonWriter);
          // 115, 49
          jamonWriter.write("\n                          (since ");
          // 116, 34
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStatusTime())), jamonWriter);
          // 116, 93
          jamonWriter.write("\n                          ago)</td>\n                    </tr>\n                ");
        }
        // 119, 24
        jamonWriter.write("\n            </table>\n        ");
      }
      // 121, 15
      jamonWriter.write("\n    ");
    }
    // 122, 11
    jamonWriter.write("\n");
  }
  
  
  // 125, 1
  private void __jamon_innerUnit__stateCss(final java.io.Writer jamonWriter, final MonitoredTask.State state)
    throws java.io.IOException
  {
    // 129, 1
           if (state == MonitoredTask.State.COMPLETE) { 
    // 129, 68
    jamonWriter.write("alert alert-success");
    // 129, 87
     } 
    // 130, 1
      else if (state == MonitoredTask.State.ABORTED)  { 
    // 130, 68
    jamonWriter.write("alert alert-error");
    // 130, 85
       } 
  }
  
  
}
