// Autogenerated Jamon implementation
// /home/zhangduo/hbase/code/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/AssignmentManagerStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 20, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 21, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager.RegionInTransitionStat;
// 22, 1
import org.apache.hadoop.hbase.master.assignment.RegionStates.RegionFailedOpen;
// 23, 1
import org.apache.hadoop.hbase.master.RegionState;
// 24, 1
import org.apache.hadoop.conf.Configuration;
// 25, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 26, 1
import org.apache.hadoop.hbase.HConstants;
// 27, 1
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
// 28, 1
import java.util.HashSet;
// 29, 1
import java.util.SortedSet;
// 30, 1
import java.util.Map;
// 31, 1
import java.util.concurrent.atomic.AtomicInteger;

public class AssignmentManagerStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.Intf

{
  private final AssignmentManager assignmentManager;
  private final int limit;
  protected static org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getLimit__IsNotDefault())
    {
      p_implData.setLimit(100);
    }
    return p_implData;
  }
  public AssignmentManagerStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    assignmentManager = p_implData.getAssignmentManager();
    limit = p_implData.getLimit();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 38, 1
    SortedSet<RegionState> rit = assignmentManager
  .getRegionStates().getRegionsInTransitionOrderedByTimestamp();

    // 42, 1
    if (!rit.isEmpty() )
    {
      // 42, 23
      jamonWriter.write("\n");
      // 43, 1
      
long currentTime = System.currentTimeMillis();
RegionInTransitionStat ritStat = assignmentManager.computeRegionInTransitionStat();

int numOfRITs = rit.size();
int ritsPerPage = Math.min(5, numOfRITs);
int numOfPages = (int) Math.ceil(numOfRITs * 1.0 / ritsPerPage);

      // 51, 5
      jamonWriter.write("<section>\n    <h2><a name=\"rit\">Regions in Transition</a></h2>\n     <p><a href=\"/rits.jsp\">");
      // 53, 29
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numOfRITs), jamonWriter);
      // 53, 44
      jamonWriter.write(" region(s) in transition.</a>\n     ");
      // 54, 6
      if (ritStat.hasRegionsTwiceOverThreshold()  )
      {
        // 54, 53
        jamonWriter.write("\n         <span class=\"label label-danger\" style=\"font-size:100%;font-weight:normal\">\n     ");
      }
      // 56, 6
      else if (ritStat.hasRegionsOverThreshold() )
      {
        // 56, 51
        jamonWriter.write("\n         <span class=\"label label-warning\" style=\"font-size:100%;font-weight:normal\">\n     ");
      }
      // 58, 6
      else
      {
        // 58, 13
        jamonWriter.write("\n         <span>\n     ");
      }
      // 60, 12
      jamonWriter.write("\n         ");
      // 61, 10
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(ritStat.getTotalRITsOverThreshold()), jamonWriter);
      // 61, 51
      jamonWriter.write(" region(s) in transition for\n             more than ");
      // 62, 24
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(ritStat.getRITThreshold()), jamonWriter);
      // 62, 55
      jamonWriter.write(" milliseconds.\n         </span>\n     </p>\n     <div class=\"tabbable\">\n         <div class=\"tab-content\">\n         ");
      // 67, 10
      int recordItr = 0; 
      // 68, 10
      for (RegionState rs : rit )
      {
        // 68, 39
        jamonWriter.write("\n             ");
        // 69, 14
        if ((recordItr % ritsPerPage) == 0 )
        {
          // 69, 52
          jamonWriter.write("\n                 ");
          // 70, 18
          if (recordItr == 0 )
          {
            // 70, 40
            jamonWriter.write("\n             <div class=\"tab-pane active\" id=\"tab_rits");
            // 71, 55
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((recordItr / ritsPerPage) + 1), jamonWriter);
            // 71, 90
            jamonWriter.write("\">\n                 ");
          }
          // 72, 18
          else
          {
            // 72, 25
            jamonWriter.write("\n             <div class=\"tab-pane\" id=\"tab_rits");
            // 73, 48
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((recordItr / ritsPerPage) + 1), jamonWriter);
            // 73, 83
            jamonWriter.write("\">\n                 ");
          }
          // 74, 24
          jamonWriter.write("\n                 <table class=\"table table-striped\" style=\"margin-bottom:0px;\"><tr><th>Region</th>\n                     <th>State</th><th>Retries </th></tr>\n             ");
        }
        // 77, 20
        jamonWriter.write("\n\n             ");
        // 79, 14
        if (ritStat.isRegionTwiceOverThreshold(rs.getRegion()) )
        {
          // 79, 72
          jamonWriter.write("\n                     <tr class=\"alert alert-danger\" role=\"alert\">\n             ");
        }
        // 81, 14
        else if (ritStat.isRegionOverThreshold(rs.getRegion()) )
        {
          // 81, 71
          jamonWriter.write("\n                     <tr class=\"alert alert-warning\" role=\"alert\">\n            ");
        }
        // 83, 13
        else
        {
          // 83, 20
          jamonWriter.write("\n                    <tr>\n            ");
        }
        // 85, 19
        jamonWriter.write("\n                        ");
        // 86, 25
        
                          String retryStatus = "0";
                          RegionFailedOpen regionFailedOpen = assignmentManager
                            .getRegionStates().getFailedOpen(rs.getRegion());
                          if (regionFailedOpen != null) {
                            retryStatus = Integer.toString(regionFailedOpen.getRetries());
                          } else if (rs.getState() ==  RegionState.State.FAILED_OPEN) {
                            retryStatus = "Failed";
                          }
                        
        // 96, 25
        jamonWriter.write("<td>");
        // 96, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rs.getRegion().getEncodedName()), jamonWriter);
        // 96, 66
        jamonWriter.write("</td><td>\n                        ");
        // 97, 25
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(RegionInfoDisplay.getDescriptiveNameFromRegionStateForDisplay(rs,
                            assignmentManager.getConfiguration())), jamonWriter);
        // 98, 69
        jamonWriter.write("</td>\n                        <td> ");
        // 99, 30
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(retryStatus), jamonWriter);
        // 99, 47
        jamonWriter.write(" </td>\n                     </tr>\n                     ");
        // 101, 22
        recordItr++; 
        // 102, 14
        if ((recordItr % ritsPerPage) == 0 )
        {
          // 102, 52
          jamonWriter.write("\n                 </table>\n             </div>\n         ");
        }
        // 105, 16
        jamonWriter.write("\n         ");
      }
      // 106, 17
      jamonWriter.write("\n\n         ");
      // 108, 10
      if ((recordItr % ritsPerPage) != 0 )
      {
        // 108, 48
        jamonWriter.write("\n             ");
        // 109, 14
        for (; (recordItr % ritsPerPage) != 0 ; recordItr++ )
        {
          // 109, 69
          jamonWriter.write("\n             <tr><td colspan=\"3\" style=\"height:61px\"></td></tr>\n             ");
        }
        // 111, 21
        jamonWriter.write("\n                   </table>\n             </div>\n         ");
      }
      // 114, 16
      jamonWriter.write("\n         </div>\n         <nav>\n             <ul class=\"nav nav-pills pagination\">\n             ");
      // 118, 14
      for (int i = 1 ; i <= numOfPages; i++ )
      {
        // 118, 55
        jamonWriter.write("\n                 ");
        // 119, 18
        if (i == 1 )
        {
          // 119, 32
          jamonWriter.write("\n                 <li class=\"active\">\n                 ");
        }
        // 121, 18
        else
        {
          // 121, 25
          jamonWriter.write("\n                 <li>\n                 ");
        }
        // 123, 24
        jamonWriter.write("\n                 <a href=\"#tab_rits");
        // 124, 36
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(i), jamonWriter);
        // 124, 43
        jamonWriter.write("\">");
        // 124, 45
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(i), jamonWriter);
        // 124, 52
        jamonWriter.write("</a></li>\n             ");
      }
      // 125, 21
      jamonWriter.write("\n             </ul>\n         </nav>\n     </div>\n   </section>\n ");
    }
    // 130, 8
    jamonWriter.write("\n\n");
  }
  
  
}
