// Autogenerated Jamon implementation
// /home/zhangduo/hbase/code/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import java.io.IOException;
// 34, 1
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
// 35, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 36, 1
import org.apache.hadoop.hbase.client.TableDescriptor;
// 37, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
// 38, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
// 39, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 40, 1
import org.apache.hadoop.hbase.HConstants;
// 41, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 42, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 43, 1
import org.apache.hadoop.hbase.ServerName;
// 44, 1
import org.apache.hadoop.hbase.TableName;
// 45, 1
import org.apache.hadoop.hbase.client.Admin;
// 46, 1
import org.apache.hadoop.hbase.client.MasterSwitchType;
// 47, 1
import org.apache.hadoop.hbase.client.TableState;
// 48, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 49, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 50, 1
import org.apache.hadoop.hbase.master.HMaster;
// 51, 1
import org.apache.hadoop.hbase.master.RegionState;
// 52, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 53, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 54, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;
// 55, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;
// 56, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 57, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos.SnapshotDescription;
// 58, 1
import org.apache.hadoop.hbase.tool.Canary;
// 59, 1
import org.apache.hadoop.hbase.util.Bytes;
// 60, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 61, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 62, 1
import org.apache.hadoop.util.StringUtils;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final AssignmentManager assignmentManager;
  private final boolean catalogJanitorEnabled;
  private final Set<ServerName> deadServers;
  private final String filter;
  private final String format;
  private final Map<String,Integer> frags;
  private final ServerName metaLocation;
  private final ServerManager serverManager;
  private final List<ServerName> servers;
  // 74, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  // 101, 1
  
  public static String getUserTables(HMaster master, List<TableDescriptor> tables){
    if (master.isInitialized()){
      try {
        Map<String, TableDescriptor> descriptorMap = master.getTableDescriptors().getAll();
        if (descriptorMap != null) {
          for (TableDescriptor desc : descriptorMap.values()) {
            if (!desc.getTableName().isSystemTable()) {
             tables.add(desc);
            }
          }
        }
      } catch (IOException e) {
        return "Got user tables error, " + e.getMessage();
      }
    }
    return null;
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    assignmentManager = p_implData.getAssignmentManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    deadServers = p_implData.getDeadServers();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    frags = p_implData.getFrags();
    metaLocation = p_implData.getMetaLocation();
    serverManager = p_implData.getServerManager();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 65, 1
    if (format.equals("json") )
    {
      // 65, 30
      jamonWriter.write("\n  ");
      // 66, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_7.setFilter(filter);
        __jamon__var_7.setFormat("json" );
        __jamon__var_7.renderNoFlush(jamonWriter);
      }
      // 66, 68
      jamonWriter.write("\n  ");
      // 67, 3
      return; 
    }
    // 68, 7
    jamonWriter.write("\n");
    // 69, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 121, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 126, 12
    if (master.isActiveMaster() )
    {
      // 126, 43
      jamonWriter.write("Master: ");
    }
    // 126, 51
    else
    {
      // 126, 58
      jamonWriter.write("Backup Master: ");
    }
    // 126, 79
    jamonWriter.write("\n    ");
    // 127, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 127, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                ");
    // 151, 17
    if (master.isActiveMaster() )
    {
      // 151, 48
      jamonWriter.write("\n                <li><a href=\"/procedures.jsp\">Procedures &amp; Locks</a></li>\n                ");
    }
    // 153, 23
    jamonWriter.write("\n                <li><a href=\"/processMaster.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 159, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 159, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 161, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 168, 2
    if (master.isActiveMaster() )
    {
      // 168, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 171, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 171, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 177, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 177, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 179, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 179, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://hbase.apache.org/book.html#trouble.log.gc\">HBase Reference Guide</a>\n          for details.\n          </div>\n        ");
      }
      // 184, 15
      jamonWriter.write("\n        ");
      // 185, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 185, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 190, 15
      jamonWriter.write("\n        ");
      // 191, 9
      if (master.isInMaintenanceMode() )
      {
        // 191, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This may be because of HBCK aborting while\n          running in repair mode. Please re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 196, 15
      jamonWriter.write("\n        ");
      // 197, 9
      if (!master.isBalancerOn() )
      {
        // 197, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 203, 15
      jamonWriter.write("\n        ");
      // 204, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT) )
      {
        // 204, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 210, 15
      jamonWriter.write("\n        ");
      // 211, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.MERGE) )
      {
        // 211, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 217, 15
      jamonWriter.write("\n        ");
      // 218, 9
      if (master.getAssignmentManager() != null )
      {
        // 218, 54
        jamonWriter.write("\n          ");
        // 219, 11
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_8.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 219, 92
        jamonWriter.write("\n        ");
      }
      // 220, 15
      jamonWriter.write("\n        ");
      // 221, 9
      if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null )
      {
        // 221, 98
        jamonWriter.write("\n          <section>\n            <h2><a name=\"rsgroup\">RSGroup</a></h2>\n            ");
        // 224, 13
        {
          org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl(this.getTemplateManager());
          __jamon__var_9.renderNoFlush(jamonWriter, master, serverManager);
        }
        // 224, 79
        jamonWriter.write("\n          </section>\n        ");
      }
      // 226, 15
      jamonWriter.write("\n        <section>\n            <h2><a name=\"regionservers\">Region Servers</a></h2>\n            ");
      // 229, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_10.setServers(servers );
        __jamon__var_10.renderNoFlush(jamonWriter, master);
      }
      // 229, 74
      jamonWriter.write("\n\n            ");
      // 231, 13
      if ((deadServers != null) )
      {
        // 231, 42
        jamonWriter.write("\n                ");
        // 232, 17
        {
          // 232, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 232, 40
        jamonWriter.write("\n            ");
      }
      // 233, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 236, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_11.renderNoFlush(jamonWriter, master );
      }
      // 236, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"tables\">Tables</a></h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 254, 25
      if ((metaLocation != null) )
      {
        // 254, 55
        jamonWriter.write("\n                            ");
        // 255, 29
        {
          // 255, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 255, 45
        jamonWriter.write("\n                        ");
      }
      // 256, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 259, 25
      if ((metaLocation != null) )
      {
        // 259, 55
        jamonWriter.write("\n                            ");
        // 260, 29
        {
          // 260, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 260, 48
        jamonWriter.write("\n                        ");
      }
      // 261, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 264, 25
      {
        // 264, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 264, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        <section>\n            <h2><a name=\"peers\">Peers</a></h2>\n            ");
      // 271, 13
      {
        // 271, 13
        __jamon_innerUnit__peerConfigs(jamonWriter);
      }
      // 271, 30
      jamonWriter.write("\n        </section>\n\t");
    }
    // 273, 2
    else
    {
      // 273, 9
      jamonWriter.write("\n        <section>\n            ");
      // 275, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_12 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_12.renderNoFlush(jamonWriter, master );
      }
      // 275, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 277, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 281, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_13 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_13.setFilter(filter );
      __jamon__var_13.renderNoFlush(jamonWriter);
    }
    // 281, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2><a name=\"attributes\">Software Attributes</a></h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 294, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 294, 84
    jamonWriter.write(", revision=");
    // 294, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 294, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 298, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 298, 81
    jamonWriter.write(", ");
    // 298, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 298, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 303, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 303, 88
    jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 308, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 308, 78
    jamonWriter.write(", revision=");
    // 308, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 308, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 313, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 313, 75
    jamonWriter.write(", ");
    // 313, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 313, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 318, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 318, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 323, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 323, 72
    jamonWriter.write(", revision=");
    // 323, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevision()), jamonWriter);
    // 323, 131
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 328, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 328, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Quorum</td>\n                    <td> ");
    // 334, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 334, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Base Path</td>\n                    <td> ");
    // 339, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 339, 79
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>Cluster Key</td>\n                    <td> ");
    // 344, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 344, 48
    jamonWriter.write(":");
    // 344, 49
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 344, 102
    jamonWriter.write("</td>\n                    <td>Key to add this cluster as a peer for replication. Use 'help \"add_peer\"' in the shell for details.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 349, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 349, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 354, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 354, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 357, 17
    if (master.isActiveMaster() )
    {
      // 357, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 360, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 360, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 365, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 365, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 370, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 371, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 374, 18
      if (frags != null )
      {
        // 374, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 377, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 377, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 380, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 383, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 384, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 389, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 389, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 392, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script>\n    $(document).ready(function()\n        {\n            $(\"#baseStatsTable\").tablesorter();\n            $(\"#memoryStatsTable\").tablesorter();\n            $(\"#requestStatsTable\").tablesorter();\n            $(\"#storeStatsTable\").tablesorter();\n            $(\"#compactionStatsTable\").tablesorter();\n\n            $(\"#userTables\").tablesorter();\n        }\n    );\n    </script>\n  </body>\n</html>\n\n");
  }
  
  
  // 418, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 419, 1
    
 List<TableDescriptor> sysTables = master.isInitialized() ?
   master.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;

    // 423, 1
    if ((sysTables != null && sysTables.size() > 0))
    {
      // 423, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 427, 5
      if ((frags != null) )
      {
        // 427, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 429, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 432, 1
      for (TableDescriptor systemTable : sysTables)
      {
        // 432, 48
        jamonWriter.write("\n<tr>\n");
        // 434, 1
        TableName tableName = systemTable.getTableName();
        // 435, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 435, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 435, 48
        jamonWriter.write("\">");
        // 435, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 435, 65
        jamonWriter.write("</a></td>\n    ");
        // 436, 5
        if ((frags != null))
        {
          // 436, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 437, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 438, 37
          jamonWriter.write("</td>\n    ");
        }
        // 439, 11
        jamonWriter.write("\n    ");
        // 440, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(Canary.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl.";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups.";
        } else if (tableName.equals(TableName.valueOf("hbase:replication"))) {
            description = "The hbase:replication table tracks cross cluster replication through " +
            "WAL file offsets.";
        }
    
        // 462, 5
        jamonWriter.write("<td>");
        // 462, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 462, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 464, 8
      jamonWriter.write("\n</table>\n");
    }
    // 466, 7
    jamonWriter.write("\n");
  }
  
  
  // 582, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 584, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 584, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 592, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 598, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 600, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 600, 33
      jamonWriter.write("</td>\n        <td>");
      // 601, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 601, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 603, 5
      
        }
    
      // 606, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 608, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 608, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 612, 7
    jamonWriter.write("\n");
  }
  
  
  // 615, 1
  private void __jamon_innerUnit__peerConfigs(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 616, 1
    
    List<ReplicationPeerDescription> peers = null;
    if (master.getReplicationPeerManager() != null) {
        peers = master.getReplicationPeerManager().listPeers(null);
    }

    // 622, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Peer Id</th>\n        <th>Cluster Key</th>\n        <th>Endpoint</th>\n        <th>State</th>\n        <th>IsSerial</th>\n        <th>Bandwidth</th>\n        <th>ReplicateAll</th>\n        <th>Namespaces</th>\n        <th>Exclude Namespaces</th>\n        <th>Table Cfs</th>\n        <th>Exclude Table Cfs</th>\n    </tr>\n");
    // 636, 1
    if ((peers != null && peers.size() > 0))
    {
      // 636, 43
      jamonWriter.write("\n    ");
      // 637, 5
      for (ReplicationPeerDescription peer : peers )
      {
        // 637, 53
        jamonWriter.write("\n    ");
        // 638, 5
        
        String peerId = peer.getPeerId();
        ReplicationPeerConfig peerConfig = peer.getPeerConfig();
    
        // 642, 5
        jamonWriter.write("<tr>\n        <td>");
        // 643, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerId), jamonWriter);
        // 643, 25
        jamonWriter.write("</td>\n        <td>");
        // 644, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getClusterKey()), jamonWriter);
        // 644, 45
        jamonWriter.write("</td>\n        <td>");
        // 645, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getReplicationEndpointImpl()), jamonWriter);
        // 645, 58
        jamonWriter.write("</td>\n        <td>");
        // 646, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peer.isEnabled() ? "ENABLED" : "DISABLED"), jamonWriter);
        // 646, 60
        jamonWriter.write("</td>\n        <td>");
        // 647, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.isSerial()), jamonWriter);
        // 647, 40
        jamonWriter.write("</td>\n        <td>");
        // 648, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getBandwidth() == 0? "UNLIMITED" : StringUtils.humanReadableInt(peerConfig.getBandwidth())), jamonWriter);
        // 648, 120
        jamonWriter.write("</td>\n        <td>");
        // 649, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.replicateAllUserTables()), jamonWriter);
        // 649, 54
        jamonWriter.write("</td>\n        <td>\n           ");
        // 651, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 651, 151
        jamonWriter.write("\n        </td>\n        <td>\n            ");
        // 654, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 654, 166
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 657, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 657, 153
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 660, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 660, 167
        jamonWriter.write("\n        </td>\n    </tr>\n    ");
      }
      // 663, 12
      jamonWriter.write("\n");
    }
    // 664, 7
    jamonWriter.write("\n<tr><td>Total: ");
    // 665, 16
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf((peers != null) ? peers.size() : 0), jamonWriter);
    // 665, 56
    jamonWriter.write("</td></tr>\n</table>\n");
  }
  
  
  // 553, 1
  private void __jamon_innerUnit__userSnapshots(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 554, 1
    
   List<SnapshotDescription> snapshots = master.isInitialized() ?
     master.getSnapshotManager().getCompletedSnapshots() : null;

    // 558, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 558, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 565, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 565, 57
        jamonWriter.write("\n    ");
        // 566, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 569, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 570, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 570, 68
        jamonWriter.write("\">");
        // 570, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 570, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 571, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 571, 74
        jamonWriter.write("\">");
        // 571, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 571, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 573, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 573, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 575, 12
      jamonWriter.write("\n    <p>");
      // 576, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 576, 30
      jamonWriter.write(" snapshot(s) in set. [<a href=\"/snapshotsStats.jsp\">Snapshot Storefile stats</a>]</p>\n</table>\n");
    }
    // 578, 7
    jamonWriter.write("\n");
  }
  
  
  // 469, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 470, 1
    
   List<TableDescriptor> tables = new ArrayList<TableDescriptor>();
   String errorMessage = getUserTables(master, tables);

    // 474, 1
    if ((tables.size() == 0 && errorMessage != null))
    {
      // 474, 52
      jamonWriter.write("\n<p> ");
      // 475, 5
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(errorMessage), jamonWriter);
      // 475, 23
      jamonWriter.write(" </p>\n");
    }
    // 476, 7
    jamonWriter.write("\n\n");
    // 478, 1
    if ((tables != null && tables.size() > 0))
    {
      // 478, 45
      jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Namespace</th>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Name</th>\n        ");
      // 484, 9
      if ((frags != null) )
      {
        // 484, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 486, 15
      jamonWriter.write("\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">State</th>\n        <th style=\"text-align: center\" colspan=\"8\">Regions</th>\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">Description</th>\n    </tr>\n    <tr>\n        <th>OPEN</th>\n        <th>OPENING</th>\n        <th>CLOSED</th>\n        <th>CLOSING</th>\n        <th>OFFLINE</th>\n        <th>FAILED</th>\n        <th>SPLIT</th>\n        <th>Other</th>\n    </tr>\n</thead>\n<tbody>\n    ");
      // 503, 5
      for (TableDescriptor desc : tables)
      {
        // 503, 42
        jamonWriter.write("\n    ");
        // 504, 5
        
      HTableDescriptor htDesc = new HTableDescriptor(desc);
      TableName tableName = htDesc.getTableName();
      TableState tableState = master.getTableStateManager().getTableState(tableName);
      Map<RegionState.State, List<RegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int openingRegionsCount = tableRegions.get(RegionState.State.OPENING).size();
      int closedRegionsCount = tableRegions.get(RegionState.State.CLOSED).size();
      int closingRegionsCount = tableRegions.get(RegionState.State.CLOSING).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<RegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount - openingRegionsCount
                     - closedRegionsCount - closingRegionsCount;
    
        // 529, 5
        jamonWriter.write("<tr>\n        <td>");
        // 530, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 530, 51
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 531, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
        // 531, 69
        jamonWriter.write(">");
        // 531, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getQualifierAsString()), jamonWriter);
        // 531, 108
        jamonWriter.write("</a> </td>\n        ");
        // 532, 9
        if ((frags != null) )
        {
          // 532, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 533, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 533, 150
          jamonWriter.write("</td>\n        ");
        }
        // 534, 15
        jamonWriter.write("\n        <td>");
        // 535, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableState.getState()), jamonWriter);
        // 535, 40
        jamonWriter.write("</td>\n        <td>");
        // 536, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 536, 35
        jamonWriter.write("</td>\n        ");
        // 537, 9
        if ((openingRegionsCount > 0) )
        {
          // 537, 42
          jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
          // 537, 72
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
          // 537, 105
          jamonWriter.write("&state=OPENING\">");
          // 537, 121
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 537, 146
          jamonWriter.write("</td> ");
        }
        // 537, 152
        else
        {
          // 537, 159
          jamonWriter.write("<td>");
          // 537, 163
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 537, 188
          jamonWriter.write("</td> ");
        }
        // 537, 200
        jamonWriter.write("\n        <td>");
        // 538, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
        // 538, 37
        jamonWriter.write("</td>\n        ");
        // 539, 9
        if ((closingRegionsCount > 0) )
        {
          // 539, 42
          jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
          // 539, 72
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
          // 539, 105
          jamonWriter.write("&state=CLOSING\">");
          // 539, 121
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 539, 146
          jamonWriter.write("</td> ");
        }
        // 539, 152
        else
        {
          // 539, 159
          jamonWriter.write("<td>");
          // 539, 163
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 539, 188
          jamonWriter.write("</td> ");
        }
        // 539, 200
        jamonWriter.write("\n        <td>");
        // 540, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 540, 38
        jamonWriter.write("</td>\n        <td>");
        // 541, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 541, 37
        jamonWriter.write("</td>\n        <td>");
        // 542, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 542, 36
        jamonWriter.write("</td>\n        <td>");
        // 543, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 543, 36
        jamonWriter.write("</td>\n        <td>");
        // 544, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 544, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 546, 12
      jamonWriter.write("\n    <p>");
      // 547, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.size()), jamonWriter);
      // 547, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</tbody>\n</table>\n");
    }
    // 550, 7
    jamonWriter.write("\n");
  }
  
  
}
