// Autogenerated Jamon implementation
// /home/zhangduo/hbase/code/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.commons.lang3.time.FastDateFormat;
// 26, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 9
import org.apache.hadoop.hbase.util.Bytes;
// 28, 9
import org.apache.hadoop.hbase.client.RegionInfo;
// 29, 9
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
// 30, 9
import org.apache.hadoop.hbase.regionserver.Region;
// 31, 9
import org.apache.hadoop.hbase.ServerName;
// 32, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 33, 9
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
// 34, 9
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos.ServerInfo;
// 35, 9
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 36, 9
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
// 37, 9
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
// 38, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<RegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 40, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 40, 60
      jamonWriter.write("\n\n    ");
      // 42, 5
      
        Collections.sort(onlineRegions, RegionInfo.COMPARATOR);
    
      // 46, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 56, 17
      {
        // 56, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 56, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 59, 17
      {
        // 59, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 59, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 62, 17
      {
        // 62, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 62, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 65, 17
      {
        // 65, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 65, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 68, 17
      {
        // 68, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 68, 67
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.apache.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 83, 1
    else
    {
      // 83, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 85, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 87, 1
  private void __jamon_innerUnit__baseInfo(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 91, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n\n        ");
    // 99, 9
    for (RegionInfo r: onlineRegions )
    {
      // 99, 45
      jamonWriter.write("\n        <tr>\n            ");
      // 101, 13
      
             String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
               regionServer.getConfiguration());
            
      // 105, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 105, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 105, 66
      jamonWriter.write("\">");
      // 105, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 105, 85
      jamonWriter.write("</a></td>\n            <td>");
      // 106, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(RegionInfoDisplay.getStartKeyForDisplay(r,
                                        regionServer.getConfiguration()))), jamonWriter);
      // 107, 77
      jamonWriter.write("</td>\n            <td>");
      // 108, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(RegionInfoDisplay.getEndKeyForDisplay(r,
                                        regionServer.getConfiguration()))), jamonWriter);
      // 109, 77
      jamonWriter.write("</td>\n            <td>");
      // 110, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getReplicaId()), jamonWriter);
      // 110, 39
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 112, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 192, 1
  private void __jamon_innerUnit__compactStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 196, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting Cells</th>\n            <th>Num. Compacted Cells</th>\n            <th>Compaction Progress</th>\n            <th>Last Major Compaction</th>\n        </tr>\n\n        ");
    // 205, 9
    for (RegionInfo r: onlineRegions )
    {
      // 205, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 208, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            String compactTime = "";
            if  (load != null) {
              if (load.getTotalCompactingKVs() > 0) {
                percentDone = String.format("%.2f", 100 *
                    ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
              }
              if (load.getLastMajorCompactionTs() > 0) {
                FastDateFormat fdf = FastDateFormat.getInstance("yyyy-MM-dd HH:mm ZZ");
                compactTime = fdf.format(load.getLastMajorCompactionTs());
              }
            }
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 225, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 225, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 225, 66
      jamonWriter.write("\">");
      // 225, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 225, 85
      jamonWriter.write("</a></td>\n            ");
      // 226, 13
      if (load != null )
      {
        // 226, 33
        jamonWriter.write("\n            <td>");
        // 227, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalCompactingKVs()), jamonWriter);
        // 227, 51
        jamonWriter.write("</td>\n            <td>");
        // 228, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getCurrentCompactedKVs()), jamonWriter);
        // 228, 52
        jamonWriter.write("</td>\n            <td>");
        // 229, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 229, 34
        jamonWriter.write("</td>\n            <td>");
        // 230, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(compactTime), jamonWriter);
        // 230, 34
        jamonWriter.write("</td>\n            ");
      }
      // 231, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 233, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 237, 1
  private void __jamon_innerUnit__memstoreStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 241, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n\n        ");
    // 247, 9
    for (RegionInfo r: onlineRegions )
    {
      // 247, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 250, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 255, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 255, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 255, 66
      jamonWriter.write("\">");
      // 255, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 255, 85
      jamonWriter.write("</a></td>\n            ");
      // 256, 13
      if (load != null )
      {
        // 256, 33
        jamonWriter.write("\n            <td>");
        // 257, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
                load.getMemStoreSizeMB() * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
        // 258, 90
        jamonWriter.write("</td>\n            ");
      }
      // 259, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 261, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 116, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 120, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Filtered Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n\n        ");
    // 128, 9
    for (RegionInfo r: onlineRegions )
    {
      // 128, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 131, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 136, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 136, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 136, 66
      jamonWriter.write("\">");
      // 136, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 136, 85
      jamonWriter.write("</a></td>\n            ");
      // 137, 13
      if (load != null )
      {
        // 137, 33
        jamonWriter.write("\n            <td>");
        // 138, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getReadRequestsCount()), jamonWriter);
        // 138, 50
        jamonWriter.write("</td>\n            <td>");
        // 139, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getFilteredReadRequestsCount()), jamonWriter);
        // 139, 58
        jamonWriter.write("</td>\n            <td>");
        // 140, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getWriteRequestsCount()), jamonWriter);
        // 140, 51
        jamonWriter.write("</td>\n            ");
      }
      // 141, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 143, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 148, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 152, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n            <th>Data Locality</th>\n        </tr>\n\n        ");
    // 164, 9
    for (RegionInfo r: onlineRegions )
    {
      // 164, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 167, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 172, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 172, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 172, 66
      jamonWriter.write("\">");
      // 172, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 172, 85
      jamonWriter.write("</a></td>\n            ");
      // 173, 13
      if (load != null )
      {
        // 173, 33
        jamonWriter.write("\n            <td>");
        // 174, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStores()), jamonWriter);
        // 174, 39
        jamonWriter.write("</td>\n            <td>");
        // 175, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefiles()), jamonWriter);
        // 175, 43
        jamonWriter.write("</td>\n            <td>");
        // 176, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getStoreUncompressedSizeMB()
                * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
        // 177, 64
        jamonWriter.write("</td>\n            <td>");
        // 178, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getStorefileSizeMB()
                * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
        // 179, 65
        jamonWriter.write("</td>\n            <td>");
        // 180, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getTotalStaticIndexSizeKB()
                * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
        // 181, 65
        jamonWriter.write("</td>\n            <td>");
        // 182, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getTotalStaticBloomSizeKB()
                * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
        // 183, 65
        jamonWriter.write("</td>\n            <td>");
        // 184, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getDataLocality()), jamonWriter);
        // 184, 45
        jamonWriter.write("</td>\n            ");
      }
      // 185, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 187, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
}
