/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerAbort {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerAbort.class);
    private static final byte[] FAMILY_BYTES = Bytes.toBytes((String)"f");
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerAbort.class);
    private HBaseTestingUtility testUtil;
    private Configuration conf;
    private MiniDFSCluster dfsCluster;
    private MiniHBaseCluster cluster;

    @Before
    public void setup() throws Exception {
        this.testUtil = new HBaseTestingUtility();
        this.conf = this.testUtil.getConfiguration();
        this.conf.set("hbase.coprocessor.regionserver.classes", StopBlockingRegionObserver.class.getName());
        this.conf.set("hbase.coprocessor.region.classes", StopBlockingRegionObserver.class.getName());
        this.conf.set("dfs.blocksize", Long.toString(102400L));
        this.conf.set("dfs.client.read.prefetch.size", Long.toString(102400L));
        this.conf.set("hbase.hregion.impl", ErrorThrowingHRegion.class.getName());
        this.testUtil.startMiniZKCluster();
        this.dfsCluster = this.testUtil.startMiniDFSCluster(2);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(2).build();
        this.cluster = this.testUtil.startMiniHBaseCluster(option);
    }

    @After
    public void tearDown() throws Exception {
        StopBlockingRegionObserver obs;
        String className = StopBlockingRegionObserver.class.getName();
        for (JVMClusterUtil.RegionServerThread t : this.cluster.getRegionServerThreads()) {
            HRegionServer rs = t.getRegionServer();
            RegionServerCoprocessorHost cpHost = rs.getRegionServerCoprocessorHost();
            StopBlockingRegionObserver cp = (StopBlockingRegionObserver)cpHost.findCoprocessor(className);
            cp.setStopAllowed(true);
        }
        HMaster master = this.cluster.getMaster();
        RegionServerCoprocessorHost host = master.getRegionServerCoprocessorHost();
        if (host != null && (obs = (StopBlockingRegionObserver)host.findCoprocessor(className)) != null) {
            obs.setStopAllowed(true);
        }
        this.testUtil.shutdownMiniCluster();
    }

    @Test
    public void testAbortFromRPC() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAbortFromRPC");
        Table table = this.testUtil.createTable(tableName, FAMILY_BYTES);
        this.testUtil.loadTable(table, FAMILY_BYTES);
        LOG.info("Wrote data");
        this.cluster.flushcache(tableName);
        LOG.info("Flushed table");
        Put put = new Put(new byte[]{0, 0, 0, 0});
        put.addColumn(FAMILY_BYTES, Bytes.toBytes((String)"c"), new byte[0]);
        put.setAttribute("DO_ABORT", new byte[]{1});
        List<HRegion> regions = this.cluster.findRegionsForTable(tableName);
        HRegion firstRegion = this.cluster.findRegionsForTable(tableName).get(0);
        table.put(put);
        Assert.assertNotNull((Object)firstRegion);
        Assert.assertNotNull((Object)firstRegion.getRegionServerServices());
        LOG.info("isAborted = " + firstRegion.getRegionServerServices().isAborted());
        Assert.assertTrue((boolean)firstRegion.getRegionServerServices().isAborted());
        LOG.info("isStopped = " + firstRegion.getRegionServerServices().isStopped());
        Assert.assertTrue((boolean)firstRegion.getRegionServerServices().isStopped());
    }

    @Test
    public void testStopOverrideFromCoprocessor() throws Exception {
        HBaseAdmin admin = this.testUtil.getHBaseAdmin();
        HRegionServer regionserver = this.cluster.getRegionServer(0);
        admin.stopRegionServer(regionserver.getServerName().getHostAndPort());
        Assert.assertFalse((boolean)this.cluster.getRegionServer(0).isAborted());
        Assert.assertFalse((boolean)this.cluster.getRegionServer(0).isStopped());
    }

    public static class ErrorThrowingHRegion
    extends HRegion {
        public ErrorThrowingHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public ErrorThrowingHRegion(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        protected boolean refreshStoreFiles(boolean force) throws IOException {
            if (force) {
                throw new IOException("Failing file refresh for testing");
            }
            return super.refreshStoreFiles(force);
        }
    }

    @CoreCoprocessor
    public static class StopBlockingRegionObserver
    implements RegionServerCoprocessor,
    RegionCoprocessor,
    RegionServerObserver,
    RegionObserver {
        public static final String DO_ABORT = "DO_ABORT";
        private boolean stopAllowed;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public Optional<RegionServerObserver> getRegionServerObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            if (put.getAttribute(DO_ABORT) != null) {
                RegionServerServices rss = ((HasRegionServerServices)c.getEnvironment()).getRegionServerServices();
                String str = "Aborting for test";
                LOG.info(str + " " + rss.getServerName());
                rss.abort(str, new Throwable(str));
            }
        }

        public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
            if (!this.stopAllowed) {
                throw new IOException("Stop not allowed");
            }
        }

        public void setStopAllowed(boolean allowed) {
            this.stopAllowed = allowed;
        }
    }
}

