/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaTableAccessorNoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaTableAccessorNoCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaTableAccessorNoCluster.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Abortable ABORTABLE = new Abortable(){
        boolean aborted = false;

        public void abort(String why, Throwable e) {
            LOG.info(why, e);
            this.aborted = true;
            throw new RuntimeException(e);
        }

        public boolean isAborted() {
            return this.aborted;
        }
    };

    @Before
    public void before() throws Exception {
        UTIL.startMiniZKCluster();
    }

    @After
    public void after() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testGetHRegionInfo() throws IOException {
        Assert.assertNull((Object)MetaTableAccessor.getRegionInfo((Result)new Result()));
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        Result r = Result.create(kvs);
        Assert.assertNull((Object)MetaTableAccessor.getRegionInfo((Result)r));
        byte[] f = HConstants.CATALOG_FAMILY;
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.SERVER_QUALIFIER, f));
        r = Result.create(kvs);
        Assert.assertNull((Object)MetaTableAccessor.getRegionInfo((Result)r));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, f));
        RegionInfo hri = MetaTableAccessor.getRegionInfo((Result)Result.create(kvs));
        Assert.assertTrue((hri == null ? 1 : 0) != 0);
        kvs.clear();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, RegionInfo.toByteArray((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO)));
        hri = MetaTableAccessor.getRegionInfo((Result)Result.create(kvs));
        Assert.assertNotNull((Object)hri);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(hri, RegionInfoBuilder.FIRST_META_REGIONINFO) == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRideOverServerNotRunning() throws IOException, InterruptedException, ServiceException {
        ZKWatcher zkw = new ZKWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), ABORTABLE, true);
        ServerName sn = ServerName.valueOf((String)"example.com", (int)1234, (long)System.currentTimeMillis());
        ClusterConnection connection = null;
        try {
            ClientProtos.ClientService.BlockingInterface implementation = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
            byte[] rowToVerify = Bytes.toBytes((String)"rowToVerify");
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, RegionInfo.toByteArray((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO)));
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort())));
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode())));
            final ArrayList<Result> cellScannables = new ArrayList<Result>(1);
            cellScannables.add(Result.create(kvs));
            final ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
            for (CellScannable cellScannable : cellScannables) {
                builder.addCellsPerResult(((Result)cellScannable).size());
            }
            Mockito.when((Object)implementation.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException("Server not running (1 of 3)")}).thenThrow(new Throwable[]{new ServiceException("Server not running (2 of 3)")}).thenThrow(new Throwable[]{new ServiceException("Server not running (3 of 3)")}).thenAnswer((Answer)new Answer<ClientProtos.ScanResponse>(){

                public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                    ((HBaseRpcController)invocation.getArgument(0)).setCellScanner(CellUtil.createCellScanner((List)cellScannables));
                    return builder.setScannerId(1234567890L).setMoreResults(false).build();
                }
            });
            connection = HConnectionTestingUtility.getSpiedConnection(UTIL.getConfiguration());
            HRegionLocation anyLocation = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, sn);
            RegionLocations regionLocations = new RegionLocations(new HRegionLocation[]{anyLocation});
            ((ClusterConnection)Mockito.doReturn((Object)regionLocations).when((Object)connection)).locateRegion((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyInt());
            ((ClusterConnection)Mockito.doReturn((Object)implementation).when((Object)connection)).getClient((ServerName)Mockito.any());
            NavigableMap hris = MetaTableAccessor.getServerUserRegions((Connection)connection, (ServerName)sn);
            Assert.assertEquals((long)1L, (long)hris.size());
            Assert.assertTrue((RegionInfo.COMPARATOR.compare(hris.firstEntry().getKey(), RegionInfoBuilder.FIRST_META_REGIONINFO) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])rowToVerify, (byte[])((Result)hris.firstEntry().getValue()).getRow()));
            ((ClientProtos.ClientService.BlockingInterface)Mockito.verify((Object)implementation, (VerificationMode)Mockito.times((int)4))).scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any());
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
            zkw.close();
        }
    }
}

