/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TimestampTestBase;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMultiVersions {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiVersions.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiVersions.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private Admin admin;
    private static final int NUM_SLAVES = 3;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.admin = UTIL.getAdmin();
    }

    @Test
    public void testTimestamps() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor(TimestampTestBase.FAMILY_NAME);
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        this.admin.createTable((TableDescriptor)desc);
        Table table = UTIL.getConnection().getTable(desc.getTableName());
        TimestampTestBase.doTestDelete(table, new TimestampTestBase.FlushCache(){

            @Override
            public void flushcache() throws IOException {
                UTIL.getHBaseCluster().flushcache();
            }
        });
        TimestampTestBase.doTestTimestampScanning(table, new TimestampTestBase.FlushCache(){

            @Override
            public void flushcache() throws IOException {
                UTIL.getMiniHBaseCluster().flushcache();
            }
        });
        table.close();
    }

    @Test
    public void testGetRowVersions() throws Exception {
        byte[] contents = Bytes.toBytes((String)"contents");
        byte[] row = Bytes.toBytes((String)"row");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        long timestamp1 = 100L;
        long timestamp2 = 200L;
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor(contents);
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        this.admin.createTable((TableDescriptor)desc);
        Put put = new Put(row, 100L);
        put.addColumn(contents, contents, value1);
        Table table = UTIL.getConnection().getTable(desc.getTableName());
        table.put(put);
        table.close();
        UTIL.shutdownMiniHBaseCluster();
        LOG.debug("HBase cluster shut down -- restarting");
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(3).build();
        UTIL.startMiniHBaseCluster(option);
        table = UTIL.getConnection().getTable(desc.getTableName());
        put = new Put(row, 200L);
        put.addColumn(contents, contents, value2);
        table.put(put);
        Get get = new Get(row);
        Result r = table.get(get);
        Assert.assertNotNull((Object)r);
        Assert.assertFalse((boolean)r.isEmpty());
        Assert.assertTrue((r.size() == 1 ? 1 : 0) != 0);
        byte[] value = r.getValue(contents, contents);
        Assert.assertTrue((value.length != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])value2));
        get = new Get(row);
        get.setMaxVersions();
        r = table.get(get);
        Assert.assertTrue((r.size() == 2 ? 1 : 0) != 0);
        value = r.getValue(contents, contents);
        Assert.assertTrue((value.length != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])value2));
        NavigableMap map = r.getMap();
        NavigableMap familyMap = (NavigableMap)map.get(contents);
        NavigableMap versionMap = (NavigableMap)familyMap.get(contents);
        Assert.assertTrue((versionMap.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value1, (byte[])((byte[])versionMap.get(100L))));
        Assert.assertTrue((boolean)Bytes.equals((byte[])value2, (byte[])((byte[])versionMap.get(200L))));
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanMultipleVersions() throws Exception {
        int j;
        int i;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        byte[][] rows = new byte[][]{Bytes.toBytes((String)"row_0200"), Bytes.toBytes((String)"row_0800")};
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"row_0500")};
        long[] timestamp = new long[]{100L, 1000L};
        this.admin.createTable((TableDescriptor)desc, (byte[][])splitRows);
        Table table = UTIL.getConnection().getTable(tableName);
        Pair keys = UTIL.getConnection().getRegionLocator(tableName).getStartEndKeys();
        Assert.assertEquals((long)2L, (long)((byte[][])keys.getFirst()).length);
        byte[][] startKeys = (byte[][])keys.getFirst();
        byte[][] endKeys = (byte[][])keys.getSecond();
        for (int i2 = 0; i2 < startKeys.length; ++i2) {
            if (i2 == 0) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])startKeys[i2]));
                Assert.assertTrue((boolean)Bytes.equals((byte[])endKeys[i2], (byte[])splitRows[0]));
                continue;
            }
            if (i2 != 1) continue;
            Assert.assertTrue((boolean)Bytes.equals((byte[])splitRows[0], (byte[])startKeys[i2]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])endKeys[i2], (byte[])HConstants.EMPTY_END_ROW));
        }
        ArrayList<Put> puts = new ArrayList<Put>();
        for (i = 0; i < startKeys.length; ++i) {
            for (j = 0; j < timestamp.length; ++j) {
                Put put = new Put(rows[i], timestamp[j]);
                put.addColumn(HConstants.CATALOG_FAMILY, null, timestamp[j], Bytes.toBytes((long)timestamp[j]));
                puts.add(put);
            }
        }
        table.put(puts);
        for (i = 0; i < rows.length; ++i) {
            for (j = 0; j < timestamp.length; ++j) {
                Get get = new Get(rows[i]);
                get.addFamily(HConstants.CATALOG_FAMILY);
                get.setTimestamp(timestamp[j]);
                Result result = table.get(get);
                int cellCount = 0;
                for (Cell kv : result.listCells()) {
                    ++cellCount;
                }
                Assert.assertTrue((cellCount == 1 ? 1 : 0) != 0);
            }
        }
        int count = 0;
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        try (ResultScanner s = table.getScanner(scan);){
            Result rr = null;
            while ((rr = s.next()) != null) {
                System.out.println(rr.toString());
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        count = 0;
        scan = new Scan();
        scan.setTimeRange(1000L, Long.MAX_VALUE);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimestamp(1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeRange(100L, 1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimestamp(100L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
    }
}

