/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestTransitRegionStateProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTransitRegionStateProcedure.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] CF = Bytes.toBytes((String)"cf");
    @Rule
    public TestName name = new TestName();
    private TableName tableName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.procedure.threads", 1);
        UTIL.startMiniCluster(3);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(this.tableName, CF);
        UTIL.waitTableAvailable(this.tableName);
    }

    private void resetProcExecutorTestingKillFlag() {
        ProcedureExecutor procExec = UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @After
    public void tearDown() throws IOException {
        this.resetProcExecutorTestingKillFlag();
        UTIL.deleteTable(this.tableName);
    }

    private void testRecoveryAndDoubleExcution(TransitRegionStateProcedure proc) throws Exception {
        HMaster master = UTIL.getHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        RegionStateNode regionNode = am.getRegionStates().getRegionStateNode(proc.getRegion());
        Assert.assertFalse((boolean)regionNode.isInTransition());
        regionNode.setProcedure(proc);
        Assert.assertTrue((boolean)regionNode.isInTransition());
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)proc);
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution((ProcedureExecutor<MasterProcedureEnv>)procExec, procId);
        regionNode = am.getRegionStates().getRegionStateNode(proc.getRegion());
        Assert.assertFalse((boolean)regionNode.isInTransition());
    }

    @Test
    public void testRecoveryAndDoubleExecutionMove() throws Exception {
        MasterProcedureEnv env = (MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        HRegion region = UTIL.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        long openSeqNum = region.getOpenSeqNum();
        TransitRegionStateProcedure proc = TransitRegionStateProcedure.move((MasterProcedureEnv)env, (RegionInfo)region.getRegionInfo(), null);
        this.testRecoveryAndDoubleExcution(proc);
        HRegion region2 = UTIL.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        long openSeqNum2 = region2.getOpenSeqNum();
        Assert.assertTrue((openSeqNum2 > openSeqNum ? 1 : 0) != 0);
    }

    @Test
    public void testRecoveryAndDoubleExecutionReopen() throws Exception {
        MasterProcedureEnv env = (MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        HRegionServer rs = UTIL.getRSForFirstRegionInTable(this.tableName);
        HRegion region = (HRegion)rs.getRegions(this.tableName).get(0);
        region.setReadRequestsCount(1L);
        region.setWriteRequestsCount(2L);
        long openSeqNum = region.getOpenSeqNum();
        TransitRegionStateProcedure proc = TransitRegionStateProcedure.reopen((MasterProcedureEnv)env, (RegionInfo)region.getRegionInfo());
        this.testRecoveryAndDoubleExcution(proc);
        HRegion region2 = (HRegion)rs.getRegions(this.tableName).get(0);
        long openSeqNum2 = region2.getOpenSeqNum();
        Assert.assertTrue((openSeqNum2 > openSeqNum ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)region2.getReadRequestsCount());
        Assert.assertEquals((long)2L, (long)region2.getWriteRequestsCount());
    }

    @Test
    public void testRecoveryAndDoubleExecutionUnassignAndAssign() throws Exception {
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterProcedureEnv env = (MasterProcedureEnv)master.getMasterProcedureExecutor().getEnvironment();
        HRegion region = UTIL.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        RegionInfo regionInfo = region.getRegionInfo();
        long openSeqNum = region.getOpenSeqNum();
        TransitRegionStateProcedure unassign = TransitRegionStateProcedure.unassign((MasterProcedureEnv)env, (RegionInfo)regionInfo);
        this.testRecoveryAndDoubleExcution(unassign);
        AssignmentManager am = master.getAssignmentManager();
        Assert.assertTrue((boolean)am.getRegionStates().getRegionState(regionInfo).isClosed());
        TransitRegionStateProcedure assign = TransitRegionStateProcedure.assign((MasterProcedureEnv)env, (RegionInfo)regionInfo, null);
        this.testRecoveryAndDoubleExcution(assign);
        HRegion region2 = UTIL.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        long openSeqNum2 = region2.getOpenSeqNum();
        Assert.assertTrue((openSeqNum2 > openSeqNum ? 1 : 0) != 0);
    }
}

