/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSpaceQuotasWithRegionReplicas {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotasWithRegionReplicas.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpaceQuotasWithRegionReplicas.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testSetQuotaWithRegionReplicaSingleRegion() throws Exception {
        for (SpaceViolationPolicy policy : SpaceViolationPolicy.values()) {
            this.setQuotaAndVerifyForRegionReplication(1, 2, policy);
        }
    }

    @Test
    public void testSetQuotaWithRegionReplicaMultipleRegion() throws Exception {
        for (SpaceViolationPolicy policy : SpaceViolationPolicy.values()) {
            this.setQuotaAndVerifyForRegionReplication(6, 3, policy);
        }
    }

    @Test
    public void testSetQuotaWithSingleRegionZeroRegionReplica() throws Exception {
        for (SpaceViolationPolicy policy : SpaceViolationPolicy.values()) {
            this.setQuotaAndVerifyForRegionReplication(1, 0, policy);
        }
    }

    @Test
    public void testSetQuotaWithMultipleRegionZeroRegionReplicas() throws Exception {
        for (SpaceViolationPolicy policy : SpaceViolationPolicy.values()) {
            this.setQuotaAndVerifyForRegionReplication(6, 0, policy);
        }
    }

    private void setQuotaAndVerifyForRegionReplication(int region, int replicatedRegion, SpaceViolationPolicy policy) throws Exception {
        TableName tn = this.helper.createTableWithRegions(TEST_UTIL.getAdmin(), NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR, region, replicatedRegion);
        this.helper.setQuotaLimit(tn, policy, 5L);
        this.helper.writeData(tn, 0x500000L);
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.helper.verifyViolation(policy, tn, (Mutation)p);
    }
}

