/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestDeleteMobTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDeleteMobTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QF = Bytes.toBytes((String)"qualifier");
    private static Random random = new Random();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[] generateMobValue(int size) {
        byte[] mobVal = new byte[size];
        random.nextBytes(mobVal);
        return mobVal;
    }

    private HTableDescriptor createTableDescriptor(TableName tableName, boolean hasMob) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        if (hasMob) {
            hcd.setMobEnabled(true);
            hcd.setMobThreshold(0L);
        }
        htd.addFamily(hcd);
        return htd;
    }

    private Table createTableWithOneFile(HTableDescriptor htd) throws IOException {
        Table table = TEST_UTIL.createTable((TableDescriptor)htd, (byte[][])null);
        try {
            byte[] value = TestDeleteMobTable.generateMobValue(10);
            byte[] row = Bytes.toBytes((String)"row");
            Put put = new Put(row);
            put.addColumn(FAMILY, QF, EnvironmentEdgeManager.currentTime(), value);
            table.put(put);
            TEST_UTIL.getAdmin().flush(htd.getTableName());
        }
        catch (IOException e) {
            table.close();
            throw e;
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMobTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = this.createTableDescriptor(tableName, true);
        HColumnDescriptor hcd = htd.getFamily(FAMILY);
        String fileName = null;
        Table table = this.createTableWithOneFile(htd);
        try {
            Assert.assertEquals((long)1L, (long)this.countMobFiles(tableName, hcd.getNameAsString()));
            Assert.assertEquals((long)0L, (long)this.countArchiveMobFiles(tableName, hcd.getNameAsString()));
            fileName = this.assertHasOneMobRow(table, tableName, hcd.getNameAsString());
            Assert.assertFalse((boolean)this.mobArchiveExist(tableName, hcd.getNameAsString(), fileName));
            Assert.assertTrue((boolean)this.mobTableDirExist(tableName));
        }
        finally {
            table.close();
            TEST_UTIL.deleteTable(tableName);
        }
        Assert.assertFalse((boolean)TEST_UTIL.getAdmin().tableExists(tableName));
        Assert.assertEquals((long)0L, (long)this.countMobFiles(tableName, hcd.getNameAsString()));
        Assert.assertEquals((long)1L, (long)this.countArchiveMobFiles(tableName, hcd.getNameAsString()));
        Assert.assertTrue((boolean)this.mobArchiveExist(tableName, hcd.getNameAsString(), fileName));
        Assert.assertFalse((boolean)this.mobTableDirExist(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonMobTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = this.createTableDescriptor(tableName, false);
        HColumnDescriptor hcd = htd.getFamily(FAMILY);
        Table table = this.createTableWithOneFile(htd);
        try {
            Assert.assertEquals((long)0L, (long)this.countMobFiles(tableName, hcd.getNameAsString()));
            Assert.assertEquals((long)0L, (long)this.countArchiveMobFiles(tableName, hcd.getNameAsString()));
            Assert.assertFalse((boolean)this.mobTableDirExist(tableName));
        }
        finally {
            table.close();
            TEST_UTIL.deleteTable(tableName);
        }
        Assert.assertFalse((boolean)TEST_UTIL.getAdmin().tableExists(tableName));
        Assert.assertEquals((long)0L, (long)this.countMobFiles(tableName, hcd.getNameAsString()));
        Assert.assertEquals((long)0L, (long)this.countArchiveMobFiles(tableName, hcd.getNameAsString()));
        Assert.assertFalse((boolean)this.mobTableDirExist(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMobFamilyDelete() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = this.createTableDescriptor(tableName, true);
        HColumnDescriptor hcd = htd.getFamily(FAMILY);
        htd.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"family2")));
        Table table = this.createTableWithOneFile(htd);
        try {
            Assert.assertEquals((long)1L, (long)this.countMobFiles(tableName, hcd.getNameAsString()));
            Assert.assertEquals((long)0L, (long)this.countArchiveMobFiles(tableName, hcd.getNameAsString()));
            String fileName = this.assertHasOneMobRow(table, tableName, hcd.getNameAsString());
            Assert.assertFalse((boolean)this.mobArchiveExist(tableName, hcd.getNameAsString(), fileName));
            Assert.assertTrue((boolean)this.mobTableDirExist(tableName));
            TEST_UTIL.getAdmin().deleteColumnFamily(tableName, FAMILY);
            Assert.assertEquals((long)0L, (long)this.countMobFiles(tableName, hcd.getNameAsString()));
            Assert.assertEquals((long)1L, (long)this.countArchiveMobFiles(tableName, hcd.getNameAsString()));
            Assert.assertTrue((boolean)this.mobArchiveExist(tableName, hcd.getNameAsString(), fileName));
            Assert.assertFalse((boolean)this.mobColumnFamilyDirExist(tableName, hcd.getNameAsString()));
        }
        finally {
            table.close();
            TEST_UTIL.deleteTable(tableName);
        }
    }

    private int countMobFiles(TableName tn, String familyName) throws IOException {
        Path mobFileDir;
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        if (fs.exists(mobFileDir = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)familyName))) {
            return fs.listStatus(mobFileDir).length;
        }
        return 0;
    }

    private int countArchiveMobFiles(TableName tn, String familyName) throws IOException {
        Path storePath;
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        if (fs.exists(storePath = HFileArchiveUtil.getStoreArchivePath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)MobUtils.getMobRegionInfo((TableName)tn).getEncodedName(), (String)familyName))) {
            return fs.listStatus(storePath).length;
        }
        return 0;
    }

    private boolean mobTableDirExist(TableName tn) throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)MobUtils.getMobHome((Configuration)TEST_UTIL.getConfiguration()), (TableName)tn);
        return fs.exists(tableDir);
    }

    private boolean mobColumnFamilyDirExist(TableName tn, String familyName) throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path mobFamilyDir = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)familyName);
        return fs.exists(mobFamilyDir);
    }

    private boolean mobArchiveExist(TableName tn, String familyName, String fileName) throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path storePath = HFileArchiveUtil.getStoreArchivePath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)MobUtils.getMobRegionInfo((TableName)tn).getEncodedName(), (String)familyName);
        return fs.exists(new Path(storePath, fileName));
    }

    private String assertHasOneMobRow(Table table, TableName tn, String familyName) throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner rs = table.getScanner(scan);
        Result r = rs.next();
        Assert.assertNotNull((Object)r);
        String fileName = MobUtils.getMobFileName((Cell)r.getColumnLatestCell(FAMILY, QF));
        Path filePath = new Path(MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)familyName), fileName);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Assert.assertTrue((boolean)fs.exists(filePath));
        r = rs.next();
        Assert.assertNull((Object)r);
        return fileName;
    }
}

