/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreLABImpl;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMemStoreChunkPool {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemStoreChunkPool.class);
    private static final Configuration conf = new Configuration();
    private static ChunkCreator chunkCreator;
    private static boolean chunkPoolDisabledBeforeTest;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        conf.setFloat("hbase.hregion.memstore.chunkpool.maxsize", 0.2f);
        chunkPoolDisabledBeforeTest = ChunkCreator.chunkPoolDisabled;
        ChunkCreator.chunkPoolDisabled = false;
        long globalMemStoreLimit = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * MemorySizeUtil.getGlobalMemStoreHeapPercent((Configuration)conf, (boolean)false));
        chunkCreator = ChunkCreator.initialize((int)0x200000, (boolean)false, (long)globalMemStoreLimit, (float)0.2f, (float)0.0f, null, (float)0.1f);
        Assert.assertNotNull((Object)chunkCreator);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ChunkCreator.chunkPoolDisabled = chunkPoolDisabledBeforeTest;
    }

    @After
    public void tearDown() throws Exception {
        chunkCreator.clearChunksInPool();
    }

    @Test
    public void testReusingChunks() {
        Random rand = new Random();
        MemStoreLABImpl mslab = new MemStoreLABImpl(conf);
        int expectedOff = 0;
        ByteBuffer lastBuffer = null;
        byte[] rk = Bytes.toBytes((String)"r1");
        byte[] cf = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        for (int i = 0; i < 100; ++i) {
            int valSize = rand.nextInt(1000);
            KeyValue kv = new KeyValue(rk, cf, q, new byte[valSize]);
            int size = kv.getSerializedSize();
            ByteBufferKeyValue newKv = (ByteBufferKeyValue)mslab.copyCellInto((Cell)kv);
            if (newKv.getBuffer() != lastBuffer) {
                expectedOff = 4;
                lastBuffer = newKv.getBuffer();
            }
            Assert.assertEquals((long)expectedOff, (long)newKv.getOffset());
            Assert.assertTrue((String)"Allocation overruns buffer", (newKv.getOffset() + size <= newKv.getBuffer().capacity() ? 1 : 0) != 0);
            expectedOff += size;
        }
        mslab.close();
        int chunkCount = chunkCreator.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
        mslab = new MemStoreLABImpl(conf);
        KeyValue kv = new KeyValue(rk, cf, q, new byte[10]);
        mslab.copyCellInto((Cell)kv);
        Assert.assertEquals((long)(chunkCount - 1), (long)chunkCreator.getPoolSize());
    }

    @Test
    public void testPuttingBackChunksAfterFlushing() throws UnexpectedStateException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        DefaultMemStore memstore = new DefaultMemStore();
        memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = memstore.snapshot();
        Assert.assertEquals((long)3L, (long)memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)memstore.getActive().getCellsCount());
        memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)memstore.getActive().getCellsCount());
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        memstore.clearSnapshot(snapshot.getId());
        int chunkCount = chunkCreator.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPuttingBackChunksWithOpeningScanner() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] qf6 = Bytes.toBytes((String)"testqualifier6");
        byte[] qf7 = Bytes.toBytes((String)"testqualifier7");
        byte[] val = Bytes.toBytes((String)"testval");
        DefaultMemStore memstore = new DefaultMemStore();
        memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = memstore.snapshot();
        Assert.assertEquals((long)3L, (long)memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)memstore.getActive().getCellsCount());
        memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)memstore.getActive().getCellsCount());
        List scanners = memstore.getScanners(0L);
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() == 0 ? 1 : 0) != 0);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
        chunkCreator.clearChunksInPool();
        snapshot = memstore.snapshot();
        memstore.add((Cell)new KeyValue(row, fam, qf6, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf7, val), null);
        scanners = memstore.getScanners(0L);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutbackChunksMultiThreaded() throws Exception {
        int maxCount = 10;
        int initialCount = 5;
        int chunkSize = 40;
        int valSize = 7;
        ChunkCreator oldCreator = ChunkCreator.getInstance();
        ChunkCreator newCreator = new ChunkCreator(40, false, 400L, 1.0f, 0.5f, null, 0.0f);
        Assert.assertEquals((long)5L, (long)newCreator.getPoolSize());
        Assert.assertEquals((long)10L, (long)newCreator.getMaxCount());
        ChunkCreator.instance = newCreator;
        final KeyValue kv = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), new byte[7]);
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    MemStoreLABImpl memStoreLAB = new MemStoreLABImpl(conf);
                    for (int i = 0; i < 10; ++i) {
                        memStoreLAB.copyCellInto((Cell)kv);
                    }
                    memStoreLAB.close();
                }
            };
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            Thread t3 = new Thread(r);
            t1.start();
            t2.start();
            t3.start();
            t1.join();
            t2.join();
            t3.join();
            Assert.assertTrue((newCreator.getPoolSize() <= 10 ? 1 : 0) != 0);
        }
        finally {
            ChunkCreator.instance = oldCreator;
        }
    }
}

