/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.reflect.Field;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRSChoresScheduled {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSChoresScheduled.class);
    private static HRegionServer hRegionServer;
    private static final HBaseTestingUtility UTIL;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(StartMiniClusterOption.builder().numRegionServers(1).build());
        hRegionServer = UTIL.getMiniHBaseCluster().getRegionServer(0);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDefaultScheduledChores() throws Exception {
        TestChoreField movedRegionsCleanerTestChoreField = new TestChoreField();
        HRegionServer.MovedRegionsCleaner movedRegionsCleaner = (HRegionServer.MovedRegionsCleaner)movedRegionsCleanerTestChoreField.getChoreObj("movedRegionsCleaner");
        movedRegionsCleanerTestChoreField.testIfChoreScheduled((ScheduledChore)movedRegionsCleaner);
        TestChoreField compactedHFilesDischargerTestChoreField = new TestChoreField();
        CompactedHFilesDischarger compactedHFilesDischarger = (CompactedHFilesDischarger)compactedHFilesDischargerTestChoreField.getChoreObj("compactedFileDischarger");
        compactedHFilesDischargerTestChoreField.testIfChoreScheduled((ScheduledChore)compactedHFilesDischarger);
        TestChoreField compactionCheckerTestChoreField = new TestChoreField();
        ScheduledChore compactionChecker = compactionCheckerTestChoreField.getChoreObj("compactionChecker");
        compactionCheckerTestChoreField.testIfChoreScheduled(compactionChecker);
        TestChoreField periodicMemstoreFlusherTestChoreField = new TestChoreField();
        ScheduledChore periodicFlusher = periodicMemstoreFlusherTestChoreField.getChoreObj("periodicFlusher");
        periodicMemstoreFlusherTestChoreField.testIfChoreScheduled(periodicFlusher);
        TestChoreField nonceManagerTestChoreField = new TestChoreField();
        ScheduledChore nonceManagerChore = nonceManagerTestChoreField.getChoreObj("nonceManagerChore");
        nonceManagerTestChoreField.testIfChoreScheduled(nonceManagerChore);
    }

    static {
        UTIL = new HBaseTestingUtility();
    }

    private static class TestChoreField<E extends ScheduledChore> {
        private TestChoreField() {
        }

        private E getChoreObj(String fieldName) throws NoSuchFieldException, IllegalAccessException {
            Field hRegionServerField = HRegionServer.class.getDeclaredField(fieldName);
            hRegionServerField.setAccessible(true);
            ScheduledChore choreFieldVal = (ScheduledChore)hRegionServerField.get(hRegionServer);
            return (E)choreFieldVal;
        }

        private void testIfChoreScheduled(E choreObj) {
            Assert.assertNotNull(choreObj);
            Assert.assertTrue((boolean)hRegionServer.getChoreService().isChoreScheduled(choreObj));
        }
    }
}

