/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationDroppedTables
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationDroppedTables.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationDroppedTables.class);
    private static final int ROWS_COUNT = 1000;

    @Override
    @Before
    public void setUpBase() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : UTIL1.getHBaseCluster().getRegionServerThreads()) {
            UTIL1.getAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        super.setUpBase();
        int rowCount = UTIL1.countRows(tableName);
        UTIL1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 50; ++i) {
            if (i == 49) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(rowCount);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info("Still got " + res.length + " rows");
            Thread.sleep(500L);
        }
        CONF1.setInt("hbase.ipc.max.request.size", 10240);
    }

    @Test
    public void testEditsStuckBehindDroppedTable() throws Exception {
        this.testEditsBehindDroppedTable(false, "test_dropped");
    }

    @Test
    public void testEditsDroppedWithDroppedTable() throws Exception {
        this.testEditsBehindDroppedTable(true, "test_dropped");
    }

    @Test
    public void testEditsDroppedWithDroppedTableNS() throws Exception {
        Connection connection1 = ConnectionFactory.createConnection((Configuration)CONF1);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createNamespace(NamespaceDescriptor.create((String)"NS").build());
        }
        Connection connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createNamespace(NamespaceDescriptor.create((String)"NS").build());
        }
        this.testEditsBehindDroppedTable(true, "NS:test_dropped");
        var4_6 = null;
        try (Admin admin1 = connection1.getAdmin();){
            admin1.deleteNamespace("NS");
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        admin2 = connection2.getAdmin();
        var4_6 = null;
        try {
            admin2.deleteNamespace("NS");
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (admin2 != null) {
                if (var4_6 != null) {
                    try {
                        admin2.close();
                    }
                    catch (Throwable throwable) {
                        var4_6.addSuppressed(throwable);
                    }
                } else {
                    admin2.close();
                }
            }
        }
    }

    private byte[] generateRowKey(int id) {
        return Bytes.toBytes((String)String.format("NormalPut%03d", id));
    }

    private void testEditsBehindDroppedTable(boolean allowProceeding, String tName) throws Exception {
        Put put;
        CONF1.setBoolean("hbase.replication.drop.on.deleted.table", allowProceeding);
        CONF1.setInt("hbase.replication.source.maxthreads", 1);
        UTIL1.shutdownMiniHBaseCluster();
        UTIL1.startMiniHBaseCluster();
        TableName tablename = TableName.valueOf((String)tName);
        byte[] familyName = Bytes.toBytes((String)"fam");
        byte[] row = Bytes.toBytes((String)"row");
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tablename).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setScope(1).build()).build();
        Connection connection1 = ConnectionFactory.createConnection((Configuration)CONF1);
        Connection connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createTable(table);
        }
        var10_10 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable(table);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        UTIL1.waitUntilAllRegionsAssigned(tablename);
        UTIL2.waitUntilAllRegionsAssigned(tablename);
        admin1 = connection1.getAdmin();
        var10_10 = null;
        try {
            admin1.disableReplicationPeer("2");
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var10_10 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        var10_10 = null;
        try (Table droppedTable = connection1.getTable(tablename);){
            byte[] rowKey = Bytes.toBytes((String)"0 put on table to be dropped");
            put = new Put(rowKey);
            put.addColumn(familyName, row, row);
            droppedTable.put(put);
        }
        catch (Throwable rowKey) {
            var10_10 = rowKey;
            throw rowKey;
        }
        var10_10 = null;
        try (Table table1 = connection1.getTable(tableName);){
            for (int i = 0; i < 1000; ++i) {
                put = new Put(this.generateRowKey(i)).addColumn(famName, row, row);
                table1.put(put);
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        admin1 = connection1.getAdmin();
        var10_10 = null;
        try {
            admin1.disableTable(tablename);
            admin1.deleteTable(tablename);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var10_10 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        admin2 = connection2.getAdmin();
        var10_10 = null;
        try {
            admin2.disableTable(tablename);
            admin2.deleteTable(tablename);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (admin2 != null) {
                if (var10_10 != null) {
                    try {
                        admin2.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    admin2.close();
                }
            }
        }
        admin1 = connection1.getAdmin();
        var10_10 = null;
        try {
            admin1.enableReplicationPeer("2");
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var10_10 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        if (allowProceeding) {
            this.verifyReplicationProceeded();
        } else {
            this.verifyReplicationStuck();
        }
        CONF1.setBoolean("hbase.replication.drop.on.deleted.table", false);
    }

    @Test
    public void testEditsBehindDroppedTableTiming() throws Exception {
        Put put;
        CONF1.setBoolean("hbase.replication.drop.on.deleted.table", true);
        CONF1.setInt("hbase.replication.source.maxthreads", 1);
        UTIL1.shutdownMiniHBaseCluster();
        UTIL1.startMiniHBaseCluster();
        TableName tablename = TableName.valueOf((String)"testdroppedtimed");
        byte[] familyName = Bytes.toBytes((String)"fam");
        byte[] row = Bytes.toBytes((String)"row");
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tablename).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setScope(1).build()).build();
        Connection connection1 = ConnectionFactory.createConnection((Configuration)CONF1);
        Connection connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createTable(table);
        }
        var8_8 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable(table);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        UTIL1.waitUntilAllRegionsAssigned(tablename);
        UTIL2.waitUntilAllRegionsAssigned(tablename);
        admin1 = connection1.getAdmin();
        var8_8 = null;
        try {
            admin1.disableReplicationPeer("2");
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var8_8 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        var8_8 = null;
        try (Table droppedTable = connection1.getTable(tablename);){
            byte[] rowKey = Bytes.toBytes((String)"0 put on table to be dropped");
            put = new Put(rowKey);
            put.addColumn(familyName, row, row);
            droppedTable.put(put);
        }
        catch (Throwable rowKey) {
            var8_8 = rowKey;
            throw rowKey;
        }
        var8_8 = null;
        try (Table table1 = connection1.getTable(tableName);){
            for (int i = 0; i < 1000; ++i) {
                put = new Put(this.generateRowKey(i)).addColumn(famName, row, row);
                table1.put(put);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        admin2 = connection2.getAdmin();
        var8_8 = null;
        try {
            admin2.disableTable(tablename);
            admin2.deleteTable(tablename);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (admin2 != null) {
                if (var8_8 != null) {
                    try {
                        admin2.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    admin2.close();
                }
            }
        }
        admin1 = connection1.getAdmin();
        var8_8 = null;
        try {
            admin1.enableReplicationPeer("2");
            this.verifyReplicationStuck();
            admin1.disableTable(tablename);
            this.verifyReplicationStuck();
            admin1.deleteTable(tablename);
            this.verifyReplicationProceeded();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var8_8 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        CONF1.setBoolean("hbase.replication.drop.on.deleted.table", false);
    }

    private boolean peerHasAllNormalRows() throws IOException {
        try (ResultScanner scanner = htable2.getScanner(new Scan());){
            Result[] results = scanner.next(1000);
            if (results.length != 1000) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < results.length; ++i) {
                Assert.assertArrayEquals((byte[])this.generateRowKey(i), (byte[])results[i].getRow());
            }
            boolean bl = true;
            return bl;
        }
    }

    private void verifyReplicationProceeded() throws Exception {
        for (int i = 0; i < 50; ++i) {
            if (i == 49) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (this.peerHasAllNormalRows()) break;
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
    }

    private void verifyReplicationStuck() throws Exception {
        for (int i = 0; i < 50; ++i) {
            if (this.peerHasAllNormalRows()) {
                Assert.fail((String)"Edit should have been stuck behind dropped tables");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
    }
}

