/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContextImpl;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestNamespaceCommands
extends SecureTestUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespaceCommands.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestNamespaceCommands.class);
    private static String TEST_NAMESPACE = "ns1";
    private static String TEST_NAMESPACE2 = "ns2";
    private static Configuration conf;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static User SUPERUSER;
    private static User USER_GLOBAL_ADMIN;
    private static User USER_GLOBAL_CREATE;
    private static User USER_GLOBAL_WRITE;
    private static User USER_GLOBAL_READ;
    private static User USER_GLOBAL_EXEC;
    private static User USER_NS_ADMIN;
    private static User USER_NS_CREATE;
    private static User USER_NS_WRITE;
    private static User USER_NS_READ;
    private static User USER_NS_EXEC;
    private static User USER_TABLE_WRITE;
    private static User USER_TABLE_CREATE;
    private static final String GROUP_ADMIN = "group_admin";
    private static final String GROUP_NS_ADMIN = "group_ns_admin";
    private static final String GROUP_CREATE = "group_create";
    private static final String GROUP_READ = "group_read";
    private static final String GROUP_WRITE = "group_write";
    private static User USER_GROUP_ADMIN;
    private static User USER_GROUP_NS_ADMIN;
    private static User USER_GROUP_CREATE;
    private static User USER_GROUP_READ;
    private static User USER_GROUP_WRITE;
    private static String TEST_TABLE;
    private static byte[] TEST_FAMILY;

    @BeforeClass
    public static void beforeClass() throws Exception {
        JVMClusterUtil.RegionServerThread rst;
        conf = UTIL.getConfiguration();
        TestNamespaceCommands.enableSecurity(conf);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_GLOBAL_ADMIN = User.createUserForTesting((Configuration)conf, (String)"global_admin", (String[])new String[0]);
        USER_GLOBAL_CREATE = User.createUserForTesting((Configuration)conf, (String)"global_create", (String[])new String[0]);
        USER_GLOBAL_WRITE = User.createUserForTesting((Configuration)conf, (String)"global_write", (String[])new String[0]);
        USER_GLOBAL_READ = User.createUserForTesting((Configuration)conf, (String)"global_read", (String[])new String[0]);
        USER_GLOBAL_EXEC = User.createUserForTesting((Configuration)conf, (String)"global_exec", (String[])new String[0]);
        USER_NS_ADMIN = User.createUserForTesting((Configuration)conf, (String)"namespace_admin", (String[])new String[0]);
        USER_NS_CREATE = User.createUserForTesting((Configuration)conf, (String)"namespace_create", (String[])new String[0]);
        USER_NS_WRITE = User.createUserForTesting((Configuration)conf, (String)"namespace_write", (String[])new String[0]);
        USER_NS_READ = User.createUserForTesting((Configuration)conf, (String)"namespace_read", (String[])new String[0]);
        USER_NS_EXEC = User.createUserForTesting((Configuration)conf, (String)"namespace_exec", (String[])new String[0]);
        USER_TABLE_CREATE = User.createUserForTesting((Configuration)conf, (String)"table_create", (String[])new String[0]);
        USER_TABLE_WRITE = User.createUserForTesting((Configuration)conf, (String)"table_write", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        USER_GROUP_NS_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_ns_admin", (String[])new String[]{GROUP_NS_ADMIN});
        USER_GROUP_CREATE = User.createUserForTesting((Configuration)conf, (String)"user_group_create", (String[])new String[]{GROUP_CREATE});
        USER_GROUP_READ = User.createUserForTesting((Configuration)conf, (String)"user_group_read", (String[])new String[]{GROUP_READ});
        USER_GROUP_WRITE = User.createUserForTesting((Configuration)conf, (String)"user_group_write", (String[])new String[]{GROUP_WRITE});
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        UTIL.startMiniCluster();
        UTIL.waitTableAvailable(AccessControlLists.ACL_TABLE_NAME.getName(), 30000L);
        Iterator<JVMClusterUtil.RegionServerThread> iterator = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().iterator();
        while (iterator.hasNext() && (ACCESS_CONTROLLER = (AccessController)(rst = iterator.next()).getRegionServer().getRegionServerCoprocessorHost().findCoprocessor(AccessController.class)) == null) {
        }
        if (ACCESS_CONTROLLER == null) {
            throw new NullPointerException();
        }
        UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)TEST_NAMESPACE).build());
        UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)TEST_NAMESPACE2).build());
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_ADMIN.getShortName(), Permission.Action.ADMIN);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_CREATE.getShortName(), Permission.Action.CREATE);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_WRITE.getShortName(), Permission.Action.WRITE);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_READ.getShortName(), Permission.Action.READ);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_EXEC.getShortName(), Permission.Action.EXEC);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_ADMIN.getShortName(), TEST_NAMESPACE, Permission.Action.ADMIN);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_CREATE.getShortName(), TEST_NAMESPACE, Permission.Action.CREATE);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_WRITE.getShortName(), TEST_NAMESPACE, Permission.Action.WRITE);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_READ.getShortName(), TEST_NAMESPACE, Permission.Action.READ);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_EXEC.getShortName(), TEST_NAMESPACE, Permission.Action.EXEC);
        TestNamespaceCommands.grantOnNamespace(UTIL, AuthUtil.toGroupEntry((String)GROUP_NS_ADMIN), TEST_NAMESPACE, Permission.Action.ADMIN);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_ADMIN.getShortName(), TEST_NAMESPACE2, Permission.Action.ADMIN);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_ADMIN), Permission.Action.ADMIN);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_CREATE), Permission.Action.CREATE);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_READ), Permission.Action.READ);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_WRITE), Permission.Action.WRITE);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.getAdmin().deleteNamespace(TEST_NAMESPACE);
        UTIL.getAdmin().deleteNamespace(TEST_NAMESPACE2);
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAclTableEntries() throws Exception {
        String userTestNamespace = "userTestNsp";
        try (Table acl = UTIL.getConnection().getTable(AccessControlLists.ACL_TABLE_NAME);){
            ListMultimap perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_NAMESPACE);
            for (Map.Entry entry : perms.entries()) {
                LOG.debug(Objects.toString(entry));
            }
            Assert.assertEquals((long)6L, (long)perms.size());
            TestNamespaceCommands.grantOnNamespace(UTIL, userTestNamespace, TEST_NAMESPACE, Permission.Action.WRITE);
            Result result = acl.get(new Get(Bytes.toBytes((String)userTestNamespace)));
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_NAMESPACE);
            Assert.assertEquals((long)7L, (long)perms.size());
            List namespacePerms = perms.get((Object)userTestNamespace);
            Assert.assertTrue((boolean)perms.containsKey((Object)userTestNamespace));
            Assert.assertEquals((long)1L, (long)namespacePerms.size());
            Assert.assertEquals((Object)TEST_NAMESPACE, (Object)((NamespacePermission)((UserPermission)namespacePerms.get(0)).getPermission()).getNamespace());
            Assert.assertEquals((long)1L, (long)((UserPermission)namespacePerms.get(0)).getPermission().getActions().length);
            Assert.assertEquals((Object)Permission.Action.WRITE, (Object)((UserPermission)namespacePerms.get(0)).getPermission().getActions()[0]);
            TestNamespaceCommands.revokeFromNamespace(UTIL, userTestNamespace, TEST_NAMESPACE, Permission.Action.WRITE);
            perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_NAMESPACE);
            Assert.assertEquals((long)6L, (long)perms.size());
        }
    }

    @Test
    public void testModifyNamespace() throws Exception {
        SecureTestUtil.AccessTestAction modifyNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preModifyNamespace(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), NamespaceDescriptor.create((String)TEST_NAMESPACE).addConfiguration("abc", "156").build());
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(modifyNamespace, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(modifyNamespace, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_ADMIN, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testCreateAndDeleteNamespace() throws Exception {
        SecureTestUtil.AccessTestAction createNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCreateNamespace(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), NamespaceDescriptor.create((String)TEST_NAMESPACE2).build());
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteNamespace(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_NAMESPACE2);
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(createNamespace, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(createNamespace, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_ADMIN, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(deleteNamespace, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(deleteNamespace, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_ADMIN, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testGetNamespaceDescriptor() throws Exception {
        SecureTestUtil.AccessTestAction getNamespaceAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGetNamespaceDescriptor(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_NAMESPACE);
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(getNamespaceAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_NS_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(getNamespaceAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testListNamespaces() throws Exception {
        SecureTestUtil.AccessTestAction listAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
                Admin admin = unmanagedConnection.getAdmin();
                try {
                    List<NamespaceDescriptor> list = Arrays.asList(admin.listNamespaceDescriptors());
                    return list;
                }
                finally {
                    admin.close();
                    unmanagedConnection.close();
                }
            }
        };
        TestNamespaceCommands.verifyAllowed(listAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_NS_ADMIN, USER_GROUP_ADMIN);
        Assert.assertEquals((long)4L, (long)((List)SUPERUSER.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)4L, (long)((List)USER_GLOBAL_ADMIN.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)4L, (long)((List)USER_GROUP_ADMIN.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)2L, (long)((List)USER_NS_ADMIN.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_READ.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_EXEC.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_READ.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_EXEC.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_TABLE_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_TABLE_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GROUP_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GROUP_READ.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GROUP_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
    }

    @Test
    public void testGrantRevoke() throws Exception {
        String testUser = "testUser";
        NettyRpcClientConfigHelper.createEventLoopPerClient((Configuration)conf);
        SecureTestUtil.AccessTestAction grantAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    connection.getAdmin().grant(new UserPermission("testUser", Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.WRITE}).build()), false);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction grantNamespaceAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    conn.getAdmin().grant(new UserPermission(USER_GROUP_NS_ADMIN.getShortName(), Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.READ}).build()), false);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    connection.getAdmin().revoke(new UserPermission("testUser", Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.WRITE}).build()));
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeNamespaceAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    connection.getAdmin().revoke(new UserPermission(USER_GROUP_NS_ADMIN.getShortName(), Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.READ}).build()));
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getPermissionsAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    connection.getAdmin().getUserPermissions(GetUserPermissionsRequest.newBuilder((String)TEST_NAMESPACE).build());
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction preGrantAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGrant(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), new UserPermission("testUser", Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.WRITE}).build()), false);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction preRevokeAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRevoke(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), new UserPermission("testUser", Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.WRITE}).build()));
                return null;
            }
        };
        SecureTestUtil.AccessTestAction grantCPAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    AccessControlUtil.grant(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)"testUser", (String)TEST_NAMESPACE, (boolean)false, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeCPAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    AccessControlUtil.revoke(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)"testUser", (String)TEST_NAMESPACE, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
                }
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(grantAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(grantAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(grantNamespaceAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN, USER_GROUP_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(grantNamespaceAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(revokeAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(revokeAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(revokeNamespaceAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN, USER_GROUP_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(revokeNamespaceAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(getPermissionsAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_NS_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(getPermissionsAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(preGrantAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(preGrantAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(preRevokeAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(preRevokeAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(grantCPAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(grantCPAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(revokeCPAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(revokeCPAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testCreateTableWithNamespace() throws Exception {
        SecureTestUtil.AccessTestAction createTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TEST_TABLE));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (TableDescriptor)htd, null);
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(createTable, SUPERUSER, USER_GLOBAL_CREATE, USER_NS_CREATE, USER_GROUP_CREATE, USER_GLOBAL_ADMIN, USER_NS_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(createTable, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    static {
        TEST_TABLE = TEST_NAMESPACE + ":testtable";
        TEST_FAMILY = Bytes.toBytes((String)"f1");
    }
}

