/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.security.HadoopSecurityEnabledUserProviderForTesting;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class TestLoadIncrementalHFilesBase {
    @Rule
    public TestName tn = new TestName();
    protected static final byte[] QUALIFIER = Bytes.toBytes((String)"myqual");
    protected static final byte[] FAMILY = Bytes.toBytes((String)"myfam");
    private static final String NAMESPACE = "bulkNS";
    static final String EXPECTED_MSG_FOR_NON_EXISTING_FAMILY = "Unmatched family names found";
    static final int MAX_FILES_PER_REGION_PER_FAMILY = 4;
    protected static final byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ppp")};
    static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", "");
        util.getConfiguration().setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 4);
        util.getConfiguration().set("hbase.client.rpc.codec", KeyValueCodecWithTags.class.getCanonicalName());
        util.startMiniCluster();
        TestLoadIncrementalHFilesBase.setupNamespace();
    }

    protected static void setupNamespace() throws Exception {
        util.getAdmin().createNamespace(NamespaceDescriptor.create((String)NAMESPACE).build());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    public static void secureSetUpBeforeClass() throws Exception {
        UserProvider.setUserProviderForTesting((Configuration)util.getConfiguration(), HadoopSecurityEnabledUserProviderForTesting.class);
        SecureTestUtil.enableSecurity(util.getConfiguration());
        util.getConfiguration().setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 4);
        util.getConfiguration().set("hbase.client.rpc.codec", KeyValueCodecWithTags.class.getCanonicalName());
        util.startMiniCluster();
        util.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME);
        TestLoadIncrementalHFilesBase.setupNamespace();
    }

    protected void runTest(String testName, BloomType bloomType, byte[][][] hfileRanges) throws Exception {
        this.runTest(testName, bloomType, (byte[][])null, hfileRanges);
    }

    protected void runTest(String testName, BloomType bloomType, byte[][][] hfileRanges, boolean useMap) throws Exception {
        this.runTest(testName, bloomType, null, hfileRanges, useMap);
    }

    protected void runTest(String testName, BloomType bloomType, byte[][] tableSplitKeys, byte[][][] hfileRanges) throws Exception {
        this.runTest(testName, bloomType, tableSplitKeys, hfileRanges, false);
    }

    protected void runTest(String testName, BloomType bloomType, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap) throws Exception {
        byte[] TABLE_NAME = Bytes.toBytes((String)("mytable_" + testName));
        boolean preCreateTable = tableSplitKeys != null;
        TableName TABLE_WITHOUT_NS = TableName.valueOf((byte[])TABLE_NAME);
        this.runTest(testName, TABLE_WITHOUT_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges, useMap, 2);
        if (preCreateTable) {
            this.runTest(testName + 2, TABLE_WITHOUT_NS, bloomType, true, tableSplitKeys, hfileRanges, false, 3);
        }
        TableName TABLE_WITH_NS = TableName.valueOf((byte[])Bytes.toBytes((String)NAMESPACE), (byte[])TABLE_NAME);
        this.runTest(testName, TABLE_WITH_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges, useMap, 2);
    }

    protected void runTest(String testName, TableName tableName, BloomType bloomType, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap, int depth) throws Exception {
        TableDescriptor htd = this.buildHTD(tableName, bloomType);
        this.runTest(testName, htd, preCreateTable, tableSplitKeys, hfileRanges, useMap, false, depth);
    }

    protected void runTest(String testName, TableDescriptor htd, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap, boolean copyFiles, int depth) throws Exception {
        TestLoadIncrementalHFilesBase.loadHFiles(testName, htd, util, FAMILY, QUALIFIER, preCreateTable, tableSplitKeys, hfileRanges, useMap, true, copyFiles, 0, 1000, depth);
        TableName tableName = htd.getTableName();
        Path stagingBasePath = new Path(FSUtils.getRootDir((Configuration)util.getConfiguration()), "staging");
        FileSystem fs = util.getTestFileSystem();
        if (fs.exists(stagingBasePath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(stagingBasePath)) {
                Assert.assertTrue((String)("Folder=" + file.getPath() + " is not cleaned up."), (file.getPath().getName() != "DONOTERASE" ? 1 : 0) != 0);
            }
        }
        util.deleteTable(tableName);
    }

    protected TableDescriptor buildHTD(TableName tableName, BloomType bloomType) {
        return TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setBloomFilterType(bloomType).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadHFiles(String testName, TableDescriptor htd, HBaseTestingUtility util, byte[] fam, byte[] qual, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap, boolean deleteFile, boolean copyFiles, int initRowCount, int factor, int depth) throws Exception {
        Path baseDirectory = util.getDataTestDirOnTestFS(testName);
        FileSystem fs = util.getTestFileSystem();
        Path parentDir = baseDirectory = baseDirectory.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        if (depth == 3) {
            assert (!useMap);
            parentDir = new Path(baseDirectory, "someRegion");
        }
        Path familyDir = new Path(parentDir, Bytes.toString((byte[])fam));
        int hfileIdx = 0;
        TreeMap<byte[], ArrayList<Path>> map = null;
        ArrayList<Path> list = null;
        if (useMap || copyFiles) {
            list = new ArrayList<Path>();
        }
        if (useMap) {
            map = new TreeMap<byte[], ArrayList<Path>>(Bytes.BYTES_COMPARATOR);
            map.put(fam, list);
        }
        Path last = null;
        for (byte[][] range : hfileRanges) {
            byte[] from = range[0];
            byte[] to = range[1];
            Path path = new Path(familyDir, "hfile_" + hfileIdx++);
            HFileTestUtil.createHFile(util.getConfiguration(), fs, path, fam, qual, from, to, factor);
            if (!useMap) continue;
            last = path;
            list.add(path);
        }
        int expectedRows = hfileIdx * factor;
        TableName tableName = htd.getTableName();
        if (!util.getAdmin().tableExists(tableName) && (preCreateTable || map != null)) {
            util.getAdmin().createTable(htd, tableSplitKeys);
        }
        Configuration conf = util.getConfiguration();
        if (copyFiles) {
            conf.setBoolean("always.copy.files", true);
        }
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(conf);
        ArrayList args = Lists.newArrayList((Object[])new String[]{baseDirectory.toString(), tableName.toString()});
        if (depth == 3) {
            args.add("-loadTable");
        }
        if (useMap) {
            if (deleteFile) {
                fs.delete(last, true);
            }
            Map loaded = loader.bulkLoad(tableName, map);
            if (deleteFile) {
                expectedRows -= 1000;
                for (BulkLoadHFiles.LoadQueueItem item : loaded.keySet()) {
                    if (!item.getFilePath().getName().equals(last.getName())) continue;
                    Assert.fail((String)(last + " should be missing"));
                }
            }
        } else {
            loader.run(args.toArray(new String[0]));
        }
        if (copyFiles) {
            for (Path p : list) {
                Assert.assertTrue((String)(p + " should exist"), (boolean)fs.exists(p));
            }
        }
        try (Table table = util.getConnection().getTable(tableName);){
            Assert.assertEquals((long)(initRowCount + expectedRows), (long)util.countRows(table));
        }
        return expectedRows;
    }
}

