/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestFlushRegionEntry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushRegionEntry.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        edge.setValue(12345L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
    }

    @AfterClass
    public static void teardown() {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testFlushRegionEntryEquality() {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setRegionId(1L).setReplicaId(0).build();
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)r)).getRegionInfo();
        MemStoreFlusher.FlushRegionEntry entry = new MemStoreFlusher.FlushRegionEntry(r, true, FlushLifeCycleTracker.DUMMY);
        MemStoreFlusher.FlushRegionEntry other = new MemStoreFlusher.FlushRegionEntry(r, true, FlushLifeCycleTracker.DUMMY);
        Assert.assertEquals((long)entry.hashCode(), (long)other.hashCode());
        Assert.assertEquals((Object)entry, (Object)other);
    }
}

