/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotStoreFileSize {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotStoreFileSize.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"t1");
    private static final String SNAPSHOT_NAME = "s1";
    private static final String FAMILY_NAME = "cf";
    private static Configuration conf;
    private Admin admin;
    private FileSystem fs;

    @BeforeClass
    public static void setup() throws Exception {
        conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.snapshot.enabled", true);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIsStoreFileSizeMatchFilesystemAndManifest() throws IOException {
        this.admin = UTIL.getAdmin();
        this.fs = UTIL.getTestFileSystem();
        UTIL.createTable(TABLE_NAME, FAMILY_NAME.getBytes());
        Table table = this.admin.getConnection().getTable(TABLE_NAME);
        UTIL.loadRandomRows(table, FAMILY_NAME.getBytes(), 3, 1000);
        this.admin.snapshot(SNAPSHOT_NAME, TABLE_NAME);
        HashMap<String, Long> storeFileInfoFromManifest = new HashMap<String, Long>();
        HashMap<String, Long> storeFileInfoFromFS = new HashMap<String, Long>();
        String storeFileName = "";
        long storeFilesize = 0L;
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)SNAPSHOT_NAME, (Path)UTIL.getDefaultRootDirPath());
        SnapshotProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)this.fs, (Path)snapshotDir);
        SnapshotManifest snaphotManifest = SnapshotManifest.open((Configuration)conf, (FileSystem)this.fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)snapshotDesc);
        List regionManifest = snaphotManifest.getRegionManifests();
        for (int i = 0; i < regionManifest.size(); ++i) {
            SnapshotProtos.SnapshotRegionManifest.FamilyFiles family = ((SnapshotProtos.SnapshotRegionManifest)regionManifest.get(i)).getFamilyFiles(0);
            List storeFiles = family.getStoreFilesList();
            for (int j = 0; j < storeFiles.size(); ++j) {
                storeFileName = ((SnapshotProtos.SnapshotRegionManifest.StoreFile)storeFiles.get(j)).getName();
                storeFilesize = ((SnapshotProtos.SnapshotRegionManifest.StoreFile)storeFiles.get(j)).getFileSize();
                storeFileInfoFromManifest.put(storeFileName, storeFilesize);
            }
        }
        List regionsInfo = this.admin.getRegions(TABLE_NAME);
        Path path = FSUtils.getTableDir((Path)UTIL.getDefaultRootDirPath(), (TableName)TABLE_NAME);
        for (RegionInfo regionInfo : regionsInfo) {
            HRegionFileSystem hRegionFileSystem = HRegionFileSystem.openRegionFromFileSystem((Configuration)conf, (FileSystem)this.fs, (Path)path, (RegionInfo)regionInfo, (boolean)true);
            Collection storeFilesFS = hRegionFileSystem.getStoreFiles(FAMILY_NAME);
            for (StoreFileInfo sfi : storeFilesFS) {
                FileStatus[] fileStatus = FSUtils.listStatus((FileSystem)this.fs, (Path)sfi.getPath());
                storeFileName = fileStatus[0].getPath().getName();
                storeFilesize = fileStatus[0].getLen();
                storeFileInfoFromFS.put(storeFileName, storeFilesize);
            }
        }
        Assert.assertEquals(storeFileInfoFromManifest, storeFileInfoFromFS);
    }
}

