/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class HFileTestUtil {
    public static final String OPT_DATA_BLOCK_ENCODING_USAGE = "Encoding algorithm (e.g. prefix compression) to use for data blocks in the test column family, one of " + Arrays.toString(DataBlockEncoding.values()) + ".";
    public static final String OPT_DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING".toLowerCase(Locale.ROOT);
    public static byte[] DEFAULT_COLUMN_FAMILY = Bytes.toBytes((String)"test_cf");
    public static final byte[][] DEFAULT_COLUMN_FAMILIES = new byte[][]{DEFAULT_COLUMN_FAMILY};

    public static void createHFile(Configuration configuration, FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFileTestUtil.createHFile(configuration, fs, path, DataBlockEncoding.NONE, family, qualifier, startKey, endKey, numRows, false);
    }

    public static void createHFileWithDataBlockEncoding(Configuration configuration, FileSystem fs, Path path, DataBlockEncoding encoding, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFileTestUtil.createHFile(configuration, fs, path, encoding, family, qualifier, startKey, endKey, numRows, false);
    }

    public static void createHFileWithTags(Configuration configuration, FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFileTestUtil.createHFile(configuration, fs, path, DataBlockEncoding.NONE, family, qualifier, startKey, endKey, numRows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHFile(Configuration configuration, FileSystem fs, Path path, DataBlockEncoding encoding, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows, boolean withTag) throws IOException {
        HFileContext meta = new HFileContextBuilder().withIncludesTags(withTag).withDataBlockEncoding(encoding).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)configuration, (CacheConfig)new CacheConfig(configuration)).withPath(fs, path).withFileContext(meta).create();
        long now = System.currentTimeMillis();
        try {
            for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (int)(numRows - 2))) {
                ArrayBackedTag tableNameTag;
                Optional tag;
                KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                if (withTag && !(tag = PrivateCellUtil.getTag((Cell)(kv = MobUtils.createMobRefCell((Cell)kv, (byte[])key, (Tag)(tableNameTag = new ArrayBackedTag(6, key)))), (byte)6)).isPresent()) {
                    throw new IllegalStateException("Tag didn't stick to KV " + kv.toString());
                }
                writer.append((Cell)kv);
            }
        }
        finally {
            writer.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
            writer.close();
        }
    }

    public static void verifyTags(Table table) throws IOException {
        ResultScanner s = table.getScanner(new Scan());
        for (Result r : s) {
            for (Cell c : r.listCells()) {
                Optional tag = PrivateCellUtil.getTag((Cell)c, (byte)6);
                if (!tag.isPresent()) {
                    Assert.fail((String)(c.toString() + " has null tag"));
                    continue;
                }
                Tag t = (Tag)tag.get();
                byte[] tval = Tag.cloneValue((Tag)t);
                Assert.assertArrayEquals((String)(c.toString() + " has tag" + Bytes.toString((byte[])tval)), (byte[])r.getRow(), (byte[])tval);
            }
        }
    }
}

