/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionCoprocessorHost {
    private Configuration conf;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionCoprocessorHost.class);
    @Rule
    public final TestName name = new TestName();
    private RegionInfo regionInfo;
    private HRegion region;
    private RegionServerServices rsServices;
    public static final int MAX_VERSIONS = 3;
    public static final int MIN_VERSIONS = 2;
    public static final int TTL = 1000;

    @Before
    public void setup() throws IOException {
        this.conf = HBaseConfiguration.create();
        this.conf.setBoolean("hbase.coprocessor.enabled", true);
        this.conf.setBoolean("hbase.coprocessor.user.enabled", true);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setCoprocessor(SimpleRegionObserver.class.getName()).build();
        this.region = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)this.region.getRegionInfo()).thenReturn((Object)this.regionInfo);
        Mockito.when((Object)this.region.getTableDescriptor()).thenReturn((Object)tableDesc);
        this.rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
    }

    @Test
    public void testLoadDuplicateCoprocessor() throws Exception {
        this.conf.setBoolean("hbase.skip.load.duplicate.table.coprocessor", true);
        this.conf.set("hbase.coprocessor.region.classes", SimpleRegionObserver.class.getName());
        RegionCoprocessorHost host = new RegionCoprocessorHost(this.region, this.rsServices, this.conf);
        Assert.assertEquals((long)1L, (long)host.coprocEnvironments.size());
        this.conf.setBoolean("hbase.skip.load.duplicate.table.coprocessor", false);
        host = new RegionCoprocessorHost(this.region, this.rsServices, this.conf);
        Assert.assertEquals((long)2L, (long)host.coprocEnvironments.size());
    }

    @Test
    public void testPreStoreScannerOpen() throws IOException {
        RegionCoprocessorHost host = new RegionCoprocessorHost(this.region, this.rsServices, this.conf);
        Scan scan = new Scan();
        scan.setTimeRange(0L, Long.MAX_VALUE);
        Assert.assertTrue((String)"Scan is not for all time", (boolean)scan.getTimeRange().isAllTime());
        ScanInfo oldScanInfo = this.getScanInfo();
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getScanInfo()).thenReturn((Object)oldScanInfo);
        ScanInfo newScanInfo = host.preStoreScannerOpen(store, scan);
        this.verifyScanInfo(newScanInfo);
    }

    @Test
    public void testPreCompactScannerOpen() throws IOException {
        RegionCoprocessorHost host = new RegionCoprocessorHost(this.region, this.rsServices, this.conf);
        ScanInfo oldScanInfo = this.getScanInfo();
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getScanInfo()).thenReturn((Object)oldScanInfo);
        ScanInfo newScanInfo = host.preCompactScannerOpen(store, ScanType.COMPACT_DROP_DELETES, (CompactionLifeCycleTracker)Mockito.mock(CompactionLifeCycleTracker.class), (CompactionRequest)Mockito.mock(CompactionRequest.class), (User)Mockito.mock(User.class));
        this.verifyScanInfo(newScanInfo);
    }

    @Test
    public void testPreFlushScannerOpen() throws IOException {
        RegionCoprocessorHost host = new RegionCoprocessorHost(this.region, this.rsServices, this.conf);
        ScanInfo oldScanInfo = this.getScanInfo();
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getScanInfo()).thenReturn((Object)oldScanInfo);
        ScanInfo newScanInfo = host.preFlushScannerOpen(store, (FlushLifeCycleTracker)Mockito.mock(FlushLifeCycleTracker.class));
        this.verifyScanInfo(newScanInfo);
    }

    @Test
    public void testPreMemStoreCompactionCompactScannerOpen() throws IOException {
        RegionCoprocessorHost host = new RegionCoprocessorHost(this.region, this.rsServices, this.conf);
        ScanInfo oldScanInfo = this.getScanInfo();
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getScanInfo()).thenReturn((Object)oldScanInfo);
        ScanInfo newScanInfo = host.preMemStoreCompactionCompactScannerOpen(store);
        this.verifyScanInfo(newScanInfo);
    }

    private void verifyScanInfo(ScanInfo newScanInfo) {
        Assert.assertEquals((Object)KeepDeletedCells.TRUE, (Object)newScanInfo.getKeepDeletedCells());
        Assert.assertEquals((long)3L, (long)newScanInfo.getMaxVersions());
        Assert.assertEquals((long)2L, (long)newScanInfo.getMinVersions());
        Assert.assertEquals((long)1000L, (long)newScanInfo.getTtl());
    }

    private ScanInfo getScanInfo() {
        int oldMaxVersions = 1;
        int oldMinVersions = 0;
        long oldTTL = 10000L;
        return new ScanInfo(this.conf, Bytes.toBytes((String)"cf"), oldMinVersions, oldMaxVersions, oldTTL, KeepDeletedCells.FALSE, Integer.MAX_VALUE, 1000L, CellComparator.getInstance(), true);
    }
}

