/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coordination.ZKSplitLogManagerCoordination;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.master.TestSplitLogManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestDLS {
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitLogManager.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_MASTERS = 2;
    private static final int NUM_RS = 5;
    private static byte[] COLUMN_FAMILY = Bytes.toBytes((String)"family");
    @Rule
    public TestName testName = new TestName();
    private TableName tableName;
    private MiniHBaseCluster cluster;
    private HMaster master;
    private Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected abstract String getWalProvider();

    private void startCluster(final int numRS) throws Exception {
        SplitLogCounters.resetCounters();
        LOG.info("Starting cluster");
        this.conf.setLong("hbase.splitlog.max.resubmit", 0L);
        this.conf.setInt("zookeeper.recovery.retry", 0);
        this.conf.setInt("hbase.regionserver.info.port", -1);
        this.conf.setFloat("hbase.regions.slop", 100.0f);
        this.conf.setInt("hbase.regionserver.wal.max.splitters", 3);
        this.conf.setInt("hbase.regionserver.metahandler.count", 10);
        this.conf.set("hbase.wal.provider", this.getWalProvider());
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(2).numRegionServers(numRS).build();
        TEST_UTIL.startMiniHBaseCluster(option);
        this.cluster = TEST_UTIL.getHBaseCluster();
        LOG.info("Waiting for active/ready master");
        this.cluster.waitForActiveAndReadyMaster();
        this.master = this.cluster.getMaster();
        TEST_UTIL.waitFor(120000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return AbstractTestDLS.this.cluster.getLiveRegionServerThreads().size() >= numRS;
            }
        });
    }

    @Before
    public void before() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.tableName = TableName.valueOf((String)this.testName.getMethodName());
    }

    @After
    public void after() throws Exception {
        TEST_UTIL.shutdownMiniHBaseCluster();
        TEST_UTIL.getTestFileSystem().delete(CommonFSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), true);
        ZKUtil.deleteNodeRecursively((ZKWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)"/hbase");
    }

    @Test
    public void testRecoveredEdits() throws Exception {
        this.conf.setLong("hbase.regionserver.hlog.blocksize", 30720L);
        this.startCluster(5);
        int numLogLines = 10000;
        SplitLogManager slm = this.master.getMasterWalManager().getSplitLogManager();
        this.master.balanceSwitch(false);
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Path rootdir = CommonFSUtils.getRootDir((Configuration)this.conf);
        int numRegions = 50;
        try (Table t = this.installTable(numRegions);){
            List regions = null;
            HRegionServer hrs = null;
            for (int i = 0; i < 5 && (regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)(hrs = rsts.get(i).getRegionServer()).getRSRpcServices())).size() < numRegions / 5; ++i) {
            }
            Path logDir = new Path(rootdir, AbstractFSWALProvider.getWALDirectoryName((String)hrs.getServerName().toString()));
            LOG.info("#regions = " + regions.size());
            Iterator it = regions.iterator();
            while (it.hasNext()) {
                RegionInfo region = (RegionInfo)it.next();
                if (!region.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR)) continue;
                it.remove();
            }
            this.makeWAL(hrs, regions, numLogLines, 100);
            slm.splitLogDistributed(logDir);
            int count = 0;
            for (RegionInfo hri : regions) {
                Path editsdir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)CommonFSUtils.getWALRegionDir((Configuration)this.conf, (TableName)this.tableName, (String)hri.getEncodedName()));
                LOG.debug("Checking edits dir " + editsdir);
                FileStatus[] files = fs.listStatus(editsdir, new PathFilter(){

                    public boolean accept(Path p) {
                        return !WALSplitUtil.isSequenceIdFile((Path)p);
                    }
                });
                LOG.info("Files {}", (Object)Arrays.stream(files).map(f -> f.getPath().toString()).collect(Collectors.joining(",")));
                Assert.assertTrue((String)"Edits dir should have more than a one file", (files.length > 1 ? 1 : 0) != 0);
                for (int i = 0; i < files.length; ++i) {
                    int c = this.countWAL(files[i].getPath(), fs, this.conf);
                    count += c;
                }
                LOG.info(count + " edits in " + files.length + " recovered edits files.");
            }
            Assert.assertFalse((boolean)fs.exists(logDir));
            Assert.assertEquals((long)numLogLines, (long)count);
        }
    }

    @Test
    public void testMasterStartsUpWithLogSplittingWork() throws Exception {
        this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", 4);
        this.startCluster(5);
        final int numRegionsToCreate = 40;
        int numLogLines = 1000;
        this.master.balanceSwitch(false);
        try (Table ht = this.installTable(numRegionsToCreate);){
            HRegionServer hrs = this.findRSToKill(false);
            List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            this.makeWAL(hrs, regions, numLogLines, 100);
            this.abortMaster(this.cluster);
            LOG.info("Aborting region server: " + hrs.getServerName());
            hrs.abort("testing");
            TEST_UTIL.waitFor(120000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return AbstractTestDLS.this.cluster.getLiveRegionServerThreads().size() <= 4;
                }
            });
            Thread.sleep(2000L);
            LOG.info("Current Open Regions:" + HBaseTestingUtility.getAllOnlineRegions(this.cluster).size());
            TEST_UTIL.waitFor(120000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return HBaseTestingUtility.getAllOnlineRegions(AbstractTestDLS.this.cluster).size() >= numRegionsToCreate + 1;
                }
            });
            LOG.info("Current Open Regions After Master Node Starts Up:" + HBaseTestingUtility.getAllOnlineRegions(this.cluster).size());
            Assert.assertEquals((long)numLogLines, (long)TEST_UTIL.countRows(ht));
        }
    }

    @Test
    public void testWorkerAbort() throws Exception {
        LOG.info("testWorkerAbort");
        this.startCluster(3);
        int numLogLines = 10000;
        SplitLogManager slm = this.master.getMasterWalManager().getSplitLogManager();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        final List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        HRegionServer hrs = this.findRSToKill(false);
        Path rootdir = CommonFSUtils.getRootDir((Configuration)this.conf);
        Path logDir = new Path(rootdir, AbstractFSWALProvider.getWALDirectoryName((String)hrs.getServerName().toString()));
        try (Table t = this.installTable(40);){
            this.makeWAL(hrs, ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices()), numLogLines, 100);
            new Thread(){

                @Override
                public void run() {
                    block2: {
                        try {
                            AbstractTestDLS.this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 1L, 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Iterator iterator = rsts.iterator();
                        if (!iterator.hasNext()) break block2;
                        JVMClusterUtil.RegionServerThread rst = (JVMClusterUtil.RegionServerThread)iterator.next();
                        rst.getRegionServer().abort("testing");
                    }
                }
            }.start();
            FileStatus[] logfiles = fs.listStatus(logDir);
            SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
            slm.enqueueSplitTask(logfiles[0].getPath().toString(), batch);
            long curt = System.currentTimeMillis();
            long waitTime = 80000L;
            long endt = curt + waitTime;
            while (curt < endt) {
                if (SplitLogCounters.tot_wkr_task_resigned.sum() + SplitLogCounters.tot_wkr_task_err.sum() + SplitLogCounters.tot_wkr_final_transition_failed.sum() + SplitLogCounters.tot_wkr_task_done.sum() + SplitLogCounters.tot_wkr_preempt_task.sum() == 0L) {
                    Thread.sleep(100L);
                    curt = System.currentTimeMillis();
                    continue;
                }
                Assert.assertTrue((1L <= SplitLogCounters.tot_wkr_task_resigned.sum() + SplitLogCounters.tot_wkr_task_err.sum() + SplitLogCounters.tot_wkr_final_transition_failed.sum() + SplitLogCounters.tot_wkr_task_done.sum() + SplitLogCounters.tot_wkr_preempt_task.sum() ? 1 : 0) != 0);
                return;
            }
            Assert.fail((String)("none of the following counters went up in " + waitTime + " milliseconds - tot_wkr_task_resigned, tot_wkr_task_err, tot_wkr_final_transition_failed, tot_wkr_task_done, tot_wkr_preempt_task"));
        }
    }

    @Test
    public void testThreeRSAbort() throws Exception {
        LOG.info("testThreeRSAbort");
        int numRegionsToCreate = 40;
        int numRowsPerRegion = 100;
        this.startCluster(5);
        try (Table table = this.installTable(numRegionsToCreate);){
            int rows;
            this.populateDataInTable(numRowsPerRegion);
            List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
            Assert.assertEquals((long)5L, (long)rsts.size());
            this.cluster.killRegionServer(rsts.get(0).getRegionServer().getServerName());
            this.cluster.killRegionServer(rsts.get(1).getRegionServer().getServerName());
            this.cluster.killRegionServer(rsts.get(2).getRegionServer().getServerName());
            TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return AbstractTestDLS.this.cluster.getLiveRegionServerThreads().size() <= 2;
                }

                public String explainFailure() throws Exception {
                    return "Timed out waiting for server aborts.";
                }
            });
            TEST_UTIL.waitUntilAllRegionsAssigned(this.tableName);
            try {
                rows = TEST_UTIL.countRows(table);
            }
            catch (Exception e) {
                Threads.printThreadInfo((PrintStream)System.out, (String)"Thread dump before fail");
                throw e;
            }
            Assert.assertEquals((long)(numRegionsToCreate * numRowsPerRegion), (long)rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedDeleteOnFailure() throws Exception {
        LOG.info("testDelayedDeleteOnFailure");
        this.startCluster(1);
        final SplitLogManager slm = this.master.getMasterWalManager().getSplitLogManager();
        final FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        final Path logDir = new Path(new Path(CommonFSUtils.getWALRootDir((Configuration)this.conf), "WALs"), ServerName.valueOf((String)"x", (int)1, (long)1L).toString());
        fs.mkdirs(logDir);
        ExecutorService executor = null;
        try {
            final Path corruptedLogFile = new Path(logDir, "x");
            FSDataOutputStream out = fs.create(corruptedLogFile);
            out.write(0);
            out.write(Bytes.toBytes((String)"corrupted bytes"));
            out.close();
            ZKSplitLogManagerCoordination coordination = (ZKSplitLogManagerCoordination)this.master.getCoordinatedStateManager().getSplitLogManagerCoordination();
            coordination.setIgnoreDeleteForTesting(true);
            executor = Executors.newSingleThreadExecutor();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        slm.splitLogDistributed(logDir);
                    }
                    catch (IOException ioe) {
                        try {
                            Assert.assertTrue((boolean)fs.exists(corruptedLogFile));
                            slm.splitLogDistributed(logDir);
                        }
                        catch (IOException e) {
                            Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                            return;
                        }
                        Assert.fail((String)"did not get the expected IOException from the 2nd call");
                    }
                    Assert.fail((String)"did not get the expected IOException from the 1st call");
                }
            };
            Future<?> result = executor.submit(runnable);
            try {
                result.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            this.waitForCounter(SplitLogCounters.tot_mgr_wait_for_zk_delete, 0L, 1L, 10000L);
            executor.shutdownNow();
            executor = null;
            result.get();
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            fs.delete(logDir, true);
        }
    }

    private Table installTable(int nrs) throws Exception {
        return this.installTable(nrs, 0);
    }

    private Table installTable(int nrs, int existingRegions) throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        LOG.info("Creating table with " + nrs + " regions");
        Table table = TEST_UTIL.createMultiRegionTable(this.tableName, family, nrs);
        int numRegions = -1;
        RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(this.tableName);
        Object object = null;
        try {
            numRegions = r.getStartKeys().length;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (r != null) {
                if (object != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    r.close();
                }
            }
        }
        Assert.assertEquals((long)nrs, (long)numRegions);
        LOG.info("Waiting for no more RIT\n");
        this.blockUntilNoRIT();
        Assert.assertTrue((boolean)TEST_UTIL.getAdmin().isTableEnabled(this.tableName));
        LOG.debug("Disabling table\n");
        TEST_UTIL.getAdmin().disableTable(this.tableName);
        LOG.debug("Waiting for no more RIT\n");
        this.blockUntilNoRIT();
        NavigableSet<String> regions = HBaseTestingUtility.getAllOnlineRegions(this.cluster);
        LOG.debug("Verifying only catalog and namespace regions are assigned\n");
        if (regions.size() != 2) {
            for (String oregion : regions) {
                LOG.debug("Region still online: " + oregion);
            }
        }
        Assert.assertEquals((long)(2 + existingRegions), (long)regions.size());
        LOG.debug("Enabling table\n");
        TEST_UTIL.getAdmin().enableTable(this.tableName);
        LOG.debug("Waiting for no more RIT\n");
        this.blockUntilNoRIT();
        LOG.debug("Verifying there are " + numRegions + " assigned on cluster\n");
        regions = HBaseTestingUtility.getAllOnlineRegions(this.cluster);
        Assert.assertEquals((long)(numRegions + 2 + existingRegions), (long)regions.size());
        return table;
    }

    void populateDataInTable(int nrows) throws Exception {
        HRegion region;
        List hris;
        HRegionServer hrs;
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)5L, (long)rsts.size());
        for (JVMClusterUtil.RegionServerThread rst : rsts) {
            hrs = rst.getRegionServer();
            hris = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (RegionInfo hri : hris) {
                if (hri.getTable().isSystemTable()) continue;
                LOG.debug("adding data to rs = " + rst.getName() + " region = " + hri.getRegionNameAsString());
                region = hrs.getOnlineRegion(hri.getRegionName());
                Assert.assertTrue((region != null ? 1 : 0) != 0);
                this.putData((Region)region, hri.getStartKey(), nrows, Bytes.toBytes((String)"q"), new byte[][]{COLUMN_FAMILY});
            }
        }
        for (JVMClusterUtil.MasterThread mt : this.cluster.getLiveMasterThreads()) {
            hrs = mt.getMaster();
            try {
                hris = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            }
            catch (ServerNotRunningYetException e) {
                continue;
            }
            for (RegionInfo hri : hris) {
                if (hri.getTable().isSystemTable()) continue;
                LOG.debug("adding data to rs = " + mt.getName() + " region = " + hri.getRegionNameAsString());
                region = hrs.getOnlineRegion(hri.getRegionName());
                Assert.assertTrue((region != null ? 1 : 0) != 0);
                this.putData((Region)region, hri.getStartKey(), nrows, Bytes.toBytes((String)"q"), new byte[][]{COLUMN_FAMILY});
            }
        }
    }

    public void makeWAL(HRegionServer hrs, List<RegionInfo> regions, int num_edits, int edit_size) throws IOException {
        this.makeWAL(hrs, regions, num_edits, edit_size, true);
    }

    public void makeWAL(HRegionServer hrs, List<RegionInfo> regions, int numEdits, int editSize, boolean cleanShutdown) throws IOException {
        WAL log;
        regions.remove(RegionInfoBuilder.FIRST_META_REGIONINFO);
        Iterator<RegionInfo> iter = regions.iterator();
        while (iter.hasNext()) {
            RegionInfo regionInfo = iter.next();
            if (!regionInfo.getTable().isSystemTable()) continue;
            iter.remove();
        }
        byte[] value = new byte[editSize];
        ArrayList<RegionInfo> hris = new ArrayList<RegionInfo>();
        for (RegionInfo region : regions) {
            if (region.getTable() != this.tableName) continue;
            hris.add(region);
        }
        LOG.info("Creating wal edits across " + hris.size() + " regions.");
        for (int i = 0; i < editSize; ++i) {
            value[i] = (byte)(97 + i % 26);
        }
        int n = hris.size();
        int[] counts = new int[n];
        int syncEvery = 30720 / editSize;
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        if (n > 0) {
            for (int i = 0; i < numEdits; ++i) {
                WALEdit e = new WALEdit();
                RegionInfo curRegionInfo = (RegionInfo)hris.get(i % n);
                WAL log2 = hrs.getWAL(curRegionInfo);
                byte[] startRow = curRegionInfo.getStartKey();
                if (startRow == null || startRow.length == 0) {
                    startRow = new byte[]{0, 0, 0, 0, 1};
                }
                byte[] row = Bytes.incrementBytes((byte[])startRow, (long)counts[i % n]);
                row = Arrays.copyOfRange(row, 3, 8);
                byte[] qualifier = Bytes.toBytes((String)("c" + Integer.toString(i)));
                e.add((Cell)new KeyValue(row, COLUMN_FAMILY, qualifier, System.currentTimeMillis(), value));
                log2.appendData(curRegionInfo, new WALKeyImpl(curRegionInfo.getEncodedNameAsBytes(), this.tableName, System.currentTimeMillis(), mvcc), e);
                if (0 == i % syncEvery) {
                    log2.sync();
                }
                int n2 = i % n;
                counts[n2] = counts[n2] + 1;
            }
        }
        for (RegionInfo info : hris) {
            log = hrs.getWAL(info);
            log.sync();
        }
        if (cleanShutdown) {
            for (RegionInfo info : hris) {
                log = hrs.getWAL(info);
                log.shutdown();
            }
        }
        for (int i = 0; i < n; ++i) {
            LOG.info("region " + ((RegionInfo)hris.get(i)).getRegionNameAsString() + " has " + counts[i] + " edits");
        }
    }

    private int countWAL(Path log, FileSystem fs, Configuration conf) throws IOException {
        int count = 0;
        try (WAL.Reader in = WALFactory.createReader((FileSystem)fs, (Path)log, (Configuration)conf);){
            WAL.Entry e;
            while ((e = in.next()) != null) {
                if (WALEdit.isMetaEditFamily((Cell)((Cell)e.getEdit().getCells().get(0)))) continue;
                ++count;
            }
        }
        return count;
    }

    private void blockUntilNoRIT() throws Exception {
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
    }

    private void putData(Region region, byte[] startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            Put put = new Put(Bytes.add((byte[])startRow, (byte[])Bytes.toBytes((int)i)));
            for (byte[] family : families) {
                put.addColumn(family, qf, null);
            }
            region.put(put);
        }
    }

    private void waitForCounter(LongAdder ctr, long oldval, long newval, long timems) throws InterruptedException {
        long curt = System.currentTimeMillis();
        long endt = curt + timems;
        while (curt < endt) {
            if (ctr.sum() == oldval) {
                Thread.sleep(100L);
                curt = System.currentTimeMillis();
                continue;
            }
            Assert.assertEquals((long)newval, (long)ctr.sum());
            return;
        }
        Assert.fail();
    }

    private void abortMaster(MiniHBaseCluster cluster) throws InterruptedException {
        for (JVMClusterUtil.MasterThread mt : cluster.getLiveMasterThreads()) {
            if (!mt.getMaster().isActiveMaster()) continue;
            mt.getMaster().abort("Aborting for tests", (Throwable)new Exception("Trace info"));
            mt.join();
            break;
        }
        LOG.debug("Master is aborted");
    }

    private HRegionServer findRSToKill(boolean hasMetaRegion) throws Exception {
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        List regions = null;
        HRegionServer hrs = null;
        for (JVMClusterUtil.RegionServerThread rst : rsts) {
            hrs = rst.getRegionServer();
            while (rst.isAlive() && !hrs.isOnline()) {
                Thread.sleep(100L);
            }
            if (!rst.isAlive()) continue;
            boolean isCarryingMeta = false;
            boolean foundTableRegion = false;
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (RegionInfo region : regions) {
                if (region.isMetaRegion()) {
                    isCarryingMeta = true;
                }
                if (region.getTable() == this.tableName) {
                    foundTableRegion = true;
                }
                if (!foundTableRegion || !isCarryingMeta && hasMetaRegion) continue;
                break;
            }
            if (isCarryingMeta && hasMetaRegion) {
                if (!foundTableRegion) {
                    final HRegionServer destRS = hrs;
                    List tableRegions = TEST_UTIL.getAdmin().getRegions(this.tableName);
                    final RegionInfo hri = (RegionInfo)tableRegions.get(0);
                    TEST_UTIL.getAdmin().move(hri.getEncodedNameAsBytes(), destRS.getServerName());
                    final RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                    TEST_UTIL.waitFor(45000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                        public boolean evaluate() throws Exception {
                            ServerName sn = regionStates.getRegionServerOfRegion(hri);
                            return sn != null && sn.equals((Object)destRS.getServerName());
                        }
                    });
                }
                return hrs;
            }
            if (hasMetaRegion || isCarryingMeta || !foundTableRegion) continue;
            break;
        }
        return hrs;
    }
}

