/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSourceImpl;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, SmallTests.class})
public class TestMetricsWAL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsWAL.class);

    @Test
    public void testLogRollRequested() throws Exception {
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.ERROR);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.LOW_REPLICATION);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.SLOW_SYNC);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.SIZE);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)4))).incrementLogRollRequested();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementErrorLogRoll();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementLowReplicationLogRoll();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementSlowSyncLogRoll();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementSizeLogRoll();
    }

    @Test
    public void testPostSync() throws Exception {
        long nanos = TimeUnit.MILLISECONDS.toNanos(145L);
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        metricsWAL.postSync(nanos, 1);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementSyncTime(145L);
    }

    @Test
    public void testSlowAppend() throws Exception {
        MetricsWALSourceImpl source = new MetricsWALSourceImpl();
        MetricsWAL metricsWAL = new MetricsWAL((MetricsWALSource)source);
        metricsWAL.postAppend(1L, 900L, null, null);
        metricsWAL.postAppend(1L, 1010L, null, null);
        metricsWAL.postAppend(1L, 2000L, null, null);
        Assert.assertEquals((long)2L, (long)source.getSlowAppendCount());
    }

    @Test
    public void testWalWrittenInBytes() throws Exception {
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        metricsWAL.postAppend(100L, 900L, null, null);
        metricsWAL.postAppend(200L, 2000L, null, null);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementWrittenBytes(100L);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementWrittenBytes(200L);
    }
}

