/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class SnapshotTestingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotTestingUtils.class);
    private static byte[] KEYS = Bytes.toBytes((String)"0123456");

    private SnapshotTestingUtils() {
    }

    public static void assertNoSnapshots(Admin admin) throws IOException {
        Assert.assertEquals((String)"Have some previous snapshots", (long)0L, (long)admin.listSnapshots().size());
    }

    public static List<SnapshotDescription> assertExistsMatchingSnapshot(Admin admin, String snapshotName, TableName tableName) throws IOException {
        List snapshots = admin.listSnapshots();
        ArrayList<SnapshotDescription> returnedSnapshots = new ArrayList<SnapshotDescription>();
        for (SnapshotDescription sd : snapshots) {
            if (!snapshotName.equals(sd.getName()) || !tableName.equals((Object)sd.getTableName())) continue;
            returnedSnapshots.add(sd);
        }
        Assert.assertTrue((String)"No matching snapshots found.", (returnedSnapshots.size() > 0 ? 1 : 0) != 0);
        return returnedSnapshots;
    }

    public static void assertOneSnapshotThatMatches(Admin admin, SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot.getName(), TableName.valueOf((String)snapshot.getTable()));
    }

    public static List<SnapshotDescription> assertOneSnapshotThatMatches(Admin admin, String snapshotName, TableName tableName) throws IOException {
        List snapshots = admin.listSnapshots();
        Assert.assertEquals((String)"Should only have 1 snapshot", (long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)snapshotName, (Object)((SnapshotDescription)snapshots.get(0)).getName());
        Assert.assertEquals((Object)tableName, (Object)((SnapshotDescription)snapshots.get(0)).getTableName());
        return snapshots;
    }

    public static List<SnapshotDescription> assertOneSnapshotThatMatches(Admin admin, byte[] snapshot, TableName tableName) throws IOException {
        return SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, Bytes.toString((byte[])snapshot), tableName);
    }

    public static void confirmSnapshotValid(HBaseTestingUtility testUtil, SnapshotProtos.SnapshotDescription snapshotDescriptor, TableName tableName, byte[] family) throws IOException {
        MasterFileSystem mfs = testUtil.getHBaseCluster().getMaster().getMasterFileSystem();
        SnapshotTestingUtils.confirmSnapshotValid(snapshotDescriptor, tableName, family, mfs.getRootDir(), testUtil.getAdmin(), mfs.getFileSystem());
    }

    public static void confirmSnapshotValid(SnapshotProtos.SnapshotDescription snapshotDescriptor, TableName tableName, byte[] testFamily, Path rootDir, Admin admin, FileSystem fs) throws IOException {
        ArrayList<byte[]> nonEmptyTestFamilies = new ArrayList<byte[]>(1);
        nonEmptyTestFamilies.add(testFamily);
        SnapshotTestingUtils.confirmSnapshotValid(snapshotDescriptor, tableName, nonEmptyTestFamilies, null, rootDir, admin, fs);
    }

    public static void confirmEmptySnapshotValid(SnapshotProtos.SnapshotDescription snapshotDescriptor, TableName tableName, byte[] testFamily, Path rootDir, Admin admin, FileSystem fs) throws IOException {
        ArrayList<byte[]> emptyTestFamilies = new ArrayList<byte[]>(1);
        emptyTestFamilies.add(testFamily);
        SnapshotTestingUtils.confirmSnapshotValid(snapshotDescriptor, tableName, null, emptyTestFamilies, rootDir, admin, fs);
    }

    public static void confirmSnapshotValid(SnapshotProtos.SnapshotDescription snapshotDescriptor, TableName tableName, List<byte[]> nonEmptyTestFamilies, List<byte[]> emptyTestFamilies, Path rootDir, Admin admin, FileSystem fs) throws IOException {
        Configuration conf = admin.getConfiguration();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((SnapshotProtos.SnapshotDescription)snapshotDescriptor, (Path)rootDir);
        Assert.assertTrue((String)("target snapshot directory, '" + snapshotDir + "', doesn't exist."), (boolean)fs.exists(snapshotDir));
        SnapshotProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)snapshotDir);
        final TreeSet snapshotFamilies = new TreeSet(Bytes.BYTES_COMPARATOR);
        SnapshotManifest manifest = SnapshotManifest.open((Configuration)conf, (FileSystem)fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)desc);
        Map regionManifests = manifest.getRegionManifestsMap();
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests.values()) {
            SnapshotReferenceUtil.visitRegionStoreFiles((SnapshotProtos.SnapshotRegionManifest)regionManifest, (SnapshotReferenceUtil.StoreFileVisitor)new SnapshotReferenceUtil.StoreFileVisitor(){

                public void storeFile(RegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                    snapshotFamilies.add(Bytes.toBytes((String)family));
                }
            });
        }
        if (nonEmptyTestFamilies != null) {
            for (byte[] familyName : nonEmptyTestFamilies) {
                Assert.assertTrue((String)("Expected snapshot to contain family '" + Bytes.toString((byte[])familyName) + "', but it does not."), (boolean)snapshotFamilies.contains(familyName));
            }
        }
        if (emptyTestFamilies != null) {
            for (byte[] familyName : emptyTestFamilies) {
                Assert.assertFalse((String)("Expected snapshot to skip empty family '" + Bytes.toString((byte[])familyName) + "', but it is present."), (boolean)snapshotFamilies.contains(familyName));
            }
        }
        List regions = admin.getRegions(tableName);
        RegionReplicaUtil.removeNonDefaultRegions((Collection)regions);
        boolean hasMob = regionManifests.containsKey(MobUtils.getMobRegionInfo((TableName)tableName).getEncodedName());
        if (hasMob) {
            Assert.assertEquals((String)"Wrong number of regions.", (long)regions.size(), (long)(regionManifests.size() - 1));
        } else {
            int regionCountExclusiveSplitParent = 0;
            for (SnapshotProtos.SnapshotRegionManifest snapshotRegionManifest : regionManifests.values()) {
                RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)snapshotRegionManifest.getRegionInfo());
                if (hri.isOffline() && (hri.isSplit() || hri.isSplitParent())) continue;
                ++regionCountExclusiveSplitParent;
            }
            Assert.assertEquals((String)"Wrong number of regions.", (long)regions.size(), (long)regionCountExclusiveSplitParent);
        }
        for (RegionInfo info : regions) {
            String regionName = info.getEncodedName();
            Assert.assertTrue((String)("Missing region name: '" + regionName + "'"), (boolean)regionManifests.containsKey(regionName));
        }
    }

    public static void waitForSnapshotToComplete(HMaster master, SnapshotProtos.SnapshotDescription snapshot, long sleep) throws ServiceException {
        MasterProtos.IsSnapshotDoneRequest request = MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsSnapshotDoneResponse done = MasterProtos.IsSnapshotDoneResponse.newBuilder().buildPartial();
        while (!done.getDone()) {
            done = master.getMasterRpcServices().isSnapshotDone(null, request);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    public static void snapshot(Admin admin, String snapshotName, TableName tableName, SnapshotType type, int numTries) throws IOException {
        int tries = 0;
        CorruptedSnapshotException lastEx = null;
        while (tries++ < numTries) {
            try {
                admin.snapshot(snapshotName, tableName, type);
                return;
            }
            catch (CorruptedSnapshotException cse) {
                LOG.warn("Got CorruptedSnapshotException", (Throwable)cse);
                lastEx = cse;
            }
        }
        throw lastEx;
    }

    public static void cleanupSnapshot(Admin admin, byte[] tableName) throws IOException {
        SnapshotTestingUtils.cleanupSnapshot(admin, Bytes.toString((byte[])tableName));
    }

    public static void cleanupSnapshot(Admin admin, String snapshotName) throws IOException {
        admin.deleteSnapshot(snapshotName);
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    public static void expectSnapshotDoneException(HMaster master, MasterProtos.IsSnapshotDoneRequest snapshot, Class<? extends HBaseSnapshotException> clazz) {
        try {
            master.getMasterRpcServices().isSnapshotDone(null, snapshot);
            Assert.fail((String)"didn't fail to lookup a snapshot");
        }
        catch (ServiceException se) {
            try {
                throw ProtobufUtil.handleRemoteException((Exception)((Object)se));
            }
            catch (HBaseSnapshotException e) {
                Assert.assertEquals((String)"Threw wrong snapshot exception!", clazz, ((Object)((Object)e)).getClass());
            }
            catch (Throwable t) {
                Assert.fail((String)("Threw an unexpected exception:" + t));
            }
        }
    }

    public static ArrayList<String> listHFileNames(FileSystem fs, Path tableDir) throws IOException {
        final ArrayList<String> hfiles = new ArrayList<String>();
        FSVisitor.visitTableStoreFiles((FileSystem)fs, (Path)tableDir, (FSVisitor.StoreFileVisitor)new FSVisitor.StoreFileVisitor(){

            public void storeFile(String region, String family, String hfileName) throws IOException {
                hfiles.add(hfileName);
            }
        });
        Collections.sort(hfiles);
        return hfiles;
    }

    public static void createSnapshotAndValidate(Admin admin, TableName tableName, String familyName, String snapshotNameString, Path rootDir, FileSystem fs, boolean onlineSnapshot) throws Exception {
        ArrayList<byte[]> nonEmptyFamilyNames = new ArrayList<byte[]>(1);
        nonEmptyFamilyNames.add(Bytes.toBytes((String)familyName));
        SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, nonEmptyFamilyNames, null, snapshotNameString, rootDir, fs, onlineSnapshot);
    }

    public static void createSnapshotAndValidate(Admin admin, TableName tableName, List<byte[]> nonEmptyFamilyNames, List<byte[]> emptyFamilyNames, String snapshotNameString, Path rootDir, FileSystem fs, boolean onlineSnapshot) throws Exception {
        if (!onlineSnapshot) {
            try {
                LOG.info("prepping for offline snapshot.");
                admin.disableTable(tableName);
            }
            catch (TableNotEnabledException tne) {
                LOG.info("In attempting to disable " + tableName + " it turns out that the this table is already disabled.");
            }
        }
        LOG.info("taking snapshot.");
        admin.snapshot(snapshotNameString, tableName);
        LOG.info("Confirming snapshot exists.");
        List<SnapshotDescription> snapshots = SnapshotTestingUtils.assertExistsMatchingSnapshot(admin, snapshotNameString, tableName);
        if (snapshots == null || snapshots.size() != 1) {
            Assert.fail((String)("Incorrect number of snapshots for table " + tableName));
        }
        LOG.info("validating snapshot.");
        SnapshotTestingUtils.confirmSnapshotValid(ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), tableName, nonEmptyFamilyNames, emptyFamilyNames, rootDir, admin, fs);
    }

    public static ArrayList corruptSnapshot(HBaseTestingUtility util, String snapshotName) throws IOException {
        MasterFileSystem mfs = util.getHBaseCluster().getMaster().getMasterFileSystem();
        final FileSystem fs = mfs.getFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)mfs.getRootDir());
        SnapshotProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)snapshotDir);
        final TableName table = TableName.valueOf((String)snapshotDesc.getTable());
        final ArrayList corruptedFiles = new ArrayList();
        final Configuration conf = util.getConfiguration();
        SnapshotReferenceUtil.visitTableStoreFiles((Configuration)conf, (FileSystem)fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)snapshotDesc, (SnapshotReferenceUtil.StoreFileVisitor)new SnapshotReferenceUtil.StoreFileVisitor(){

            public void storeFile(RegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                String region = regionInfo.getEncodedName();
                String hfile = storeFile.getName();
                HFileLink link = HFileLink.build((Configuration)conf, (TableName)table, (String)region, (String)family, (String)hfile);
                if (corruptedFiles.size() % 2 == 0) {
                    fs.delete(link.getAvailablePath(fs), true);
                    corruptedFiles.add(hfile);
                }
            }
        });
        Assert.assertTrue((corruptedFiles.size() > 0 ? 1 : 0) != 0);
        return corruptedFiles;
    }

    public static void waitForTableToBeOnline(HBaseTestingUtility util, TableName tableName) throws IOException, InterruptedException {
        HRegionServer rs = util.getRSForFirstRegionInTable(tableName);
        List onlineRegions = rs.getRegions(tableName);
        for (HRegion region : onlineRegions) {
            region.waitForFlushesAndCompactions();
        }
        util.waitFor(60000L, util.predicateTableAvailable(tableName));
    }

    public static void createTable(HBaseTestingUtility util, TableName tableName, int regionReplication, int nRegions, byte[] ... families) throws IOException, InterruptedException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(regionReplication);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        byte[][] splitKeys = SnapshotTestingUtils.getSplitKeys(nRegions);
        util.createTable(builder.build(), splitKeys);
        Assert.assertEquals((long)((splitKeys.length + 1) * regionReplication), (long)util.getAdmin().getTableRegions(tableName).size());
    }

    public static byte[][] getSplitKeys() {
        return SnapshotTestingUtils.getSplitKeys(KEYS.length);
    }

    public static byte[][] getSplitKeys(int nRegions) {
        nRegions = nRegions < KEYS.length ? nRegions : KEYS.length - 1;
        byte[][] splitKeys = new byte[nRegions - 1][];
        int step = KEYS.length / nRegions;
        int keyIndex = 1;
        for (int i = 0; i < splitKeys.length; ++i) {
            splitKeys[i] = new byte[]{KEYS[keyIndex]};
            keyIndex += step;
        }
        return splitKeys;
    }

    public static void createTable(HBaseTestingUtility util, TableName tableName, byte[] ... families) throws IOException, InterruptedException {
        SnapshotTestingUtils.createTable(util, tableName, 1, families);
    }

    public static void createTable(HBaseTestingUtility util, TableName tableName, int regionReplication, byte[] ... families) throws IOException, InterruptedException {
        SnapshotTestingUtils.createTable(util, tableName, regionReplication, KEYS.length, families);
    }

    public static void createPreSplitTable(HBaseTestingUtility util, TableName tableName, int nRegions, byte[] ... families) throws IOException, InterruptedException {
        SnapshotTestingUtils.createTable(util, tableName, 1, nRegions, families);
    }

    public static void loadData(HBaseTestingUtility util, TableName tableName, int rows, byte[] ... families) throws IOException, InterruptedException {
        BufferedMutator mutator = util.getConnection().getBufferedMutator(tableName);
        SnapshotTestingUtils.loadData(util, mutator, rows, families);
    }

    public static void loadData(HBaseTestingUtility util, BufferedMutator mutator, int rows, byte[] ... families) throws IOException, InterruptedException {
        Assert.assertTrue((rows >= KEYS.length ? 1 : 0) != 0);
        for (byte k0 : KEYS) {
            byte[] k = new byte[]{k0};
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])k);
            byte[] key = Bytes.add((byte[])k, (byte[])Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value)));
            byte[][] families1 = families;
            byte[] key1 = key;
            byte[] value1 = value;
            mutator.mutate((Mutation)SnapshotTestingUtils.createPut(families1, key1, value1));
            --rows;
        }
        while (rows-- > 0) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])Bytes.toBytes((int)rows));
            byte[] key = Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value));
            byte[][] families1 = families;
            byte[] key1 = key;
            byte[] value1 = value;
            mutator.mutate((Mutation)SnapshotTestingUtils.createPut(families1, key1, value1));
        }
        mutator.flush();
        SnapshotTestingUtils.waitForTableToBeOnline(util, mutator.getName());
    }

    private static Put createPut(byte[][] families, byte[] key, byte[] value) {
        byte[] q = Bytes.toBytes((String)"q");
        Put put = new Put(key);
        put.setDurability(Durability.SKIP_WAL);
        for (byte[] family : families) {
            put.addColumn(family, q, value);
        }
        return put;
    }

    public static void deleteAllSnapshots(Admin admin) throws IOException {
        for (SnapshotDescription snapshot : admin.listSnapshots()) {
            admin.deleteSnapshot(snapshot.getName());
        }
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    public static void deleteArchiveDirectory(HBaseTestingUtility util) throws IOException {
        MasterFileSystem mfs = util.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path archiveDir = new Path(mfs.getRootDir(), "archive");
        mfs.getFileSystem().delete(archiveDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        try (Table table = util.getConnection().getTable(tableName);){
            Assert.assertEquals((long)expectedRows, (long)util.countRows(table));
        }
    }

    public static void verifyReplicasCameOnline(TableName tableName, Admin admin, int regionReplication) throws IOException {
        List regions = admin.getRegions(tableName);
        HashSet<RegionInfo> set = new HashSet<RegionInfo>();
        for (RegionInfo hri : regions) {
            set.add(RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)hri));
            for (int i = 0; i < regionReplication; ++i) {
                RegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)i);
                if (regions.contains(replica)) continue;
                Assert.fail((String)(replica + " is not contained in the list of online regions"));
            }
        }
        Assert.assertEquals((long)(SnapshotTestingUtils.getSplitKeys().length + 1), (long)set.size());
    }

    public static class SnapshotMock {
        protected static final String TEST_FAMILY = "cf";
        public static final int TEST_NUM_REGIONS = 4;
        private final Configuration conf;
        private final FileSystem fs;
        private final Path rootDir;

        public SnapshotMock(Configuration conf, FileSystem fs, Path rootDir) {
            this.fs = fs;
            this.conf = conf;
            this.rootDir = rootDir;
        }

        public SnapshotBuilder createSnapshotV1(String snapshotName, String tableName) throws IOException {
            return this.createSnapshot(snapshotName, tableName, 0);
        }

        public SnapshotBuilder createSnapshotV1(String snapshotName, String tableName, int numRegions) throws IOException {
            return this.createSnapshot(snapshotName, tableName, numRegions, 0);
        }

        public SnapshotBuilder createSnapshotV2(String snapshotName, String tableName) throws IOException {
            return this.createSnapshot(snapshotName, tableName, 2);
        }

        public SnapshotBuilder createSnapshotV2(String snapshotName, String tableName, int numRegions) throws IOException {
            return this.createSnapshot(snapshotName, tableName, numRegions, 2);
        }

        public SnapshotBuilder createSnapshotV2(String snapshotName, String tableName, int numRegions, long ttl) throws IOException {
            return this.createSnapshot(snapshotName, tableName, numRegions, 2, ttl);
        }

        private SnapshotBuilder createSnapshot(String snapshotName, String tableName, int version) throws IOException {
            return this.createSnapshot(snapshotName, tableName, 4, version);
        }

        private SnapshotBuilder createSnapshot(String snapshotName, String tableName, int numRegions, int version) throws IOException {
            TableDescriptor htd = this.createHtd(tableName);
            RegionData[] regions = this.createTable(htd, numRegions);
            SnapshotProtos.SnapshotDescription desc = SnapshotProtos.SnapshotDescription.newBuilder().setTable(htd.getTableName().getNameAsString()).setName(snapshotName).setVersion(version).build();
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)desc, (Path)this.rootDir, (Configuration)this.conf);
            FileSystem workingFs = workingDir.getFileSystem(this.conf);
            SnapshotDescriptionUtils.writeSnapshotInfo((SnapshotProtos.SnapshotDescription)desc, (Path)workingDir, (FileSystem)workingFs);
            return new SnapshotBuilder(this.conf, this.fs, this.rootDir, htd, desc, regions);
        }

        private SnapshotBuilder createSnapshot(String snapshotName, String tableName, int numRegions, int version, long ttl) throws IOException {
            TableDescriptor htd = this.createHtd(tableName);
            RegionData[] regions = this.createTable(htd, numRegions);
            SnapshotProtos.SnapshotDescription desc = SnapshotProtos.SnapshotDescription.newBuilder().setTable(htd.getTableName().getNameAsString()).setName(snapshotName).setVersion(version).setCreationTime(EnvironmentEdgeManager.currentTime()).setTtl(ttl).build();
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)desc, (Path)this.rootDir, (Configuration)this.conf);
            SnapshotDescriptionUtils.writeSnapshotInfo((SnapshotProtos.SnapshotDescription)desc, (Path)workingDir, (FileSystem)this.fs);
            return new SnapshotBuilder(this.conf, this.fs, this.rootDir, htd, desc, regions);
        }

        public TableDescriptor createHtd(String tableName) {
            return TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)TEST_FAMILY)).build();
        }

        private RegionData[] createTable(TableDescriptor htd, int nregions) throws IOException {
            Path tableDir = CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)htd.getTableName());
            new FSTableDescriptors(this.conf).createTableDescriptorForTableDirectory(tableDir, htd, false);
            Assert.assertTrue((nregions % 2 == 0 ? 1 : 0) != 0);
            RegionData[] regions = new RegionData[nregions];
            for (int i = 0; i < regions.length; i += 2) {
                int j;
                byte[] startKey = Bytes.toBytes((int)(0 + i * 2));
                byte[] endKey = Bytes.toBytes((int)(1 + i * 2));
                RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).setStartKey(startKey).setEndKey(endKey).build();
                HRegionFileSystem rfs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)tableDir, (RegionInfo)hri);
                regions[i] = new RegionData(tableDir, hri, 3);
                for (j = 0; j < regions[i].files.length; ++j) {
                    Path storeFile = this.createStoreFile(rfs.createTempName());
                    regions[i].files[j] = rfs.commitStoreFile(TEST_FAMILY, storeFile);
                }
                startKey = Bytes.toBytes((int)(2 + i * 2));
                endKey = Bytes.toBytes((int)(3 + i * 2));
                hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
                rfs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)tableDir, (RegionInfo)hri);
                regions[i + 1] = new RegionData(tableDir, hri, regions[i].files.length);
                for (j = 0; j < regions[i].files.length; ++j) {
                    String refName = regions[i].files[j].getName() + '.' + regions[i].hri.getEncodedName();
                    Path refFile = this.createStoreFile(new Path(this.rootDir, refName));
                    regions[i + 1].files[j] = rfs.commitStoreFile(TEST_FAMILY, refFile);
                }
            }
            return regions;
        }

        private Path createStoreFile(Path storeFile) throws IOException {
            try (FSDataOutputStream out = this.fs.create(storeFile);){
                out.write(Bytes.toBytes((String)storeFile.toString()));
            }
            return storeFile;
        }

        public static class SnapshotBuilder {
            private final RegionData[] tableRegions;
            private final SnapshotProtos.SnapshotDescription desc;
            private final TableDescriptor htd;
            private final Configuration conf;
            private final FileSystem fs;
            private final Path rootDir;
            private Path snapshotDir;
            private int snapshotted = 0;

            public SnapshotBuilder(Configuration conf, FileSystem fs, Path rootDir, TableDescriptor htd, SnapshotProtos.SnapshotDescription desc, RegionData[] tableRegions) throws IOException {
                this.fs = fs;
                this.conf = conf;
                this.rootDir = rootDir;
                this.htd = htd;
                this.desc = desc;
                this.tableRegions = tableRegions;
                this.snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)desc, (Path)rootDir, (Configuration)conf);
                new FSTableDescriptors(conf);
                FSTableDescriptors.createTableDescriptorForTableDirectory((FileSystem)this.snapshotDir.getFileSystem(conf), (Path)this.snapshotDir, (TableDescriptor)htd, (boolean)false);
            }

            public TableDescriptor getTableDescriptor() {
                return this.htd;
            }

            public SnapshotProtos.SnapshotDescription getSnapshotDescription() {
                return this.desc;
            }

            public Path getSnapshotsDir() {
                return this.snapshotDir;
            }

            public Path[] addRegion() throws IOException {
                return this.addRegion(this.desc);
            }

            public Path[] addRegionV1() throws IOException {
                return this.addRegion(this.desc.toBuilder().setVersion(0).build());
            }

            public Path[] addRegionV2() throws IOException {
                return this.addRegion(this.desc.toBuilder().setVersion(2).build());
            }

            private Path[] addRegion(SnapshotProtos.SnapshotDescription desc) throws IOException {
                if (this.snapshotted == this.tableRegions.length) {
                    throw new UnsupportedOperationException("No more regions in the table");
                }
                RegionData regionData = this.tableRegions[this.snapshotted++];
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (SnapshotProtos.SnapshotDescription)desc, (ForeignExceptionSnare)monitor);
                manifest.addRegion(regionData.tableDir, regionData.hri);
                return regionData.files;
            }

            private void corruptFile(Path p) throws IOException {
                String manifestName = p.getName();
                Path newP = new Path(p.getParent(), manifestName + "1");
                this.fs.rename(p, newP);
                FSDataOutputStream out = this.fs.create(p);
                FSDataInputStream input = this.fs.open(newP);
                byte[] buffer = new byte[25];
                int len = input.read(0L, buffer, 0, 25);
                if (len > 1) {
                    out.write(buffer, 0, len - 1);
                }
                out.close();
                this.fs.delete(newP);
            }

            public void corruptOneRegionManifest() throws IOException {
                FileStatus[] manifestFiles = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir, (PathFilter)new PathFilter(){

                    public boolean accept(Path path) {
                        return path.getName().startsWith("region-manifest.");
                    }
                });
                if (manifestFiles.length == 0) {
                    return;
                }
                Path p = manifestFiles[0].getPath();
                this.corruptFile(p);
            }

            public void missOneRegionSnapshotFile() throws IOException {
                FileStatus[] manifestFiles;
                for (FileStatus fileStatus : manifestFiles = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir)) {
                    String fileName = fileStatus.getPath().getName();
                    if (!fileName.endsWith(".snapshotinfo") && !fileName.endsWith(".tabledesc") && !fileName.endsWith(".tmp")) continue;
                    this.fs.delete(fileStatus.getPath(), true);
                }
            }

            public void corruptDataManifest() throws IOException {
                FileStatus[] manifestFiles = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir, (PathFilter)new PathFilter(){

                    public boolean accept(Path path) {
                        return path.getName().startsWith("data.manifest");
                    }
                });
                if (manifestFiles.length == 0) {
                    return;
                }
                Path p = manifestFiles[0].getPath();
                this.corruptFile(p);
            }

            public Path commit() throws IOException {
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (SnapshotProtos.SnapshotDescription)this.desc, (ForeignExceptionSnare)monitor);
                manifest.addTableDescriptor(this.htd);
                manifest.consolidate();
                Path finishedDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((SnapshotProtos.SnapshotDescription)this.desc, (Path)this.rootDir);
                SnapshotDescriptionUtils.completeSnapshot((Path)finishedDir, (Path)this.snapshotDir, (FileSystem)this.fs, (FileSystem)this.snapshotDir.getFileSystem(this.conf), (Configuration)this.conf);
                this.snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((SnapshotProtos.SnapshotDescription)this.desc, (Path)this.rootDir);
                return this.snapshotDir;
            }

            public void consolidate() throws IOException {
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (SnapshotProtos.SnapshotDescription)this.desc, (ForeignExceptionSnare)monitor);
                manifest.addTableDescriptor(this.htd);
                manifest.consolidate();
            }
        }

        static class RegionData {
            public RegionInfo hri;
            public Path tableDir;
            public Path[] files;

            public RegionData(Path tableDir, RegionInfo hri, int nfiles) {
                this.tableDir = tableDir;
                this.hri = hri;
                this.files = new Path[nfiles];
            }
        }
    }
}

