// Autogenerated Jamon implementation
// /home/apurtell/tmp/RM/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/common/TaskMonitorTmpl.jamon

package org.apache.hadoop.hbase.tmpl.common;

// 20, 1
import java.util.*;
// 21, 1
import org.apache.hadoop.hbase.monitoring.*;
// 22, 1
import org.apache.hadoop.util.StringUtils;

public class TaskMonitorTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.Intf

{
  private final String filter;
  private final String format;
  private final String parent;
  private final TaskMonitor taskMonitor;
  protected static org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getParent__IsNotDefault())
    {
      p_implData.setParent("");
    }
    if(! p_implData.getTaskMonitor__IsNotDefault())
    {
      p_implData.setTaskMonitor(TaskMonitor.get());
    }
    return p_implData;
  }
  public TaskMonitorTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    parent = p_implData.getParent();
    taskMonitor = p_implData.getTaskMonitor();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 31, 1
    if (format.equals("json"))
    {
      // 31, 29
      jamonWriter.write("\n    ");
      // 32, 5
      {
        // 32, 5
        __jamon_innerUnit__renderTasks(jamonWriter, filter );
      }
      // 32, 37
      jamonWriter.write("\n");
    }
    // 33, 1
    else
    {
      // 33, 8
      jamonWriter.write("\n  <h2><a name=\"tasks\">Tasks</a></h2>\n\n  <div class=\"tabbable\">\n      <ul class=\"nav nav-pills\">\n        <li class=\"\">\n            <a href=\"#tab_alltasks\" data-toggle=\"tab\">Show All Monitored Tasks</a>\n        </li>\n        <li class=\"active\">\n            <a href=\"#tab_generaltasks\" data-toggle=\"tab\">Show non-RPC Tasks</a>\n        </li>\n        <li class=\"\">\n            <a href=\"#tab_handlertasks\" data-toggle=\"tab\">Show All RPC Handler Tasks</a>\n        </li>\n        <li class=\"\">\n            <a href=\"#tab_rpctasks\" data-toggle=\"tab\">Show Active RPC Calls</a>\n        </li>\n        <li>\n            <a href=\"#tab_operationtasks\" data-toggle=\"tab\">Show Client Operations</a>\n        </li>\n      </ul>\n      <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane\" id=\"tab_alltasks\">\n            ");
      // 56, 13
      {
        // 56, 13
        __jamon_innerUnit__jsonView(jamonWriter, "all" );
      }
      // 56, 41
      jamonWriter.write("\n            ");
      // 57, 13
      {
        // 57, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "all" );
      }
      // 57, 44
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane active\" id=\"tab_generaltasks\">\n            ");
      // 60, 13
      {
        // 60, 13
        __jamon_innerUnit__jsonView(jamonWriter, "general" );
      }
      // 60, 45
      jamonWriter.write("\n            ");
      // 61, 13
      {
        // 61, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "general" );
      }
      // 61, 48
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_handlertasks\">\n            ");
      // 64, 13
      {
        // 64, 13
        __jamon_innerUnit__jsonView(jamonWriter, "handler" );
      }
      // 64, 45
      jamonWriter.write("\n            ");
      // 65, 13
      {
        // 65, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "handler" );
      }
      // 65, 48
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rpctasks\">\n            ");
      // 68, 13
      {
        // 68, 13
        __jamon_innerUnit__jsonView(jamonWriter, "rpc" );
      }
      // 68, 41
      jamonWriter.write("\n            ");
      // 69, 13
      {
        // 69, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "rpc" );
      }
      // 69, 44
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_operationtasks\">\n            ");
      // 72, 13
      {
        // 72, 13
        __jamon_innerUnit__jsonView(jamonWriter, "operation" );
      }
      // 72, 47
      jamonWriter.write("\n            ");
      // 73, 13
      {
        // 73, 13
        __jamon_innerUnit__renderTasks(jamonWriter, "operation" );
      }
      // 73, 50
      jamonWriter.write("\n        </div>\n      </div>\n  </div>\n");
    }
    // 77, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 79, 1
  private void __jamon_innerUnit__jsonView(final java.io.Writer jamonWriter, final String filter)
    throws java.io.IOException
  {
    // 83, 5
    jamonWriter.write("<a href=\"");
    // 83, 14
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(parent), jamonWriter);
    // 83, 26
    jamonWriter.write("?format=json&filter=");
    // 83, 46
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(filter), jamonWriter);
    // 83, 58
    jamonWriter.write("\">View as JSON</a>\n");
  }
  
  
  // 86, 1
  private void __jamon_innerUnit__renderTasks(final java.io.Writer jamonWriter, final String filter)
    throws java.io.IOException
  {
    // 90, 5
    
       List<? extends MonitoredTask> tasks = taskMonitor.getTasks(filter);
       long now = System.currentTimeMillis();
       Collections.sort(tasks, (t1, t2) -> Long.compare(t1.getStateTime(), t2.getStateTime()));
       boolean first = true;
    
    // 96, 5
    if (format.equals("json") )
    {
      // 96, 34
      jamonWriter.write("\n        [");
      // 97, 10
      for (MonitoredTask task : tasks)
      {
        // 97, 44
        if (first)
        {
          // 97, 56
          first = false;
        }
        // 97, 85
        else
        {
          // 97, 92
          jamonWriter.write(",");
        }
        // 97, 99
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.toJSON()), jamonWriter);
      }
      // 97, 125
      jamonWriter.write("]\n    ");
    }
    // 98, 5
    else
    {
      // 98, 12
      jamonWriter.write("\n        ");
      // 99, 9
      if (tasks.isEmpty())
      {
        // 99, 31
        jamonWriter.write("\n            <p>No tasks currently running on this node.</p>\n        ");
      }
      // 101, 9
      else
      {
        // 101, 16
        jamonWriter.write("\n            <table class=\"table table-striped\">\n                <tr>\n                      <th>Start Time</th>\n                      <th>Description</th>\n                      <th>State</th>\n                      <th>Status</th>\n                </tr>\n                ");
        // 109, 17
        for (MonitoredTask task : tasks )
        {
          // 109, 52
          jamonWriter.write("\n                    <tr class=\"");
          // 110, 32
          {
            // 110, 32
            __jamon_innerUnit__stateCss(jamonWriter, task.getState() );
          }
          // 110, 71
          jamonWriter.write("\">\n                      <td>");
          // 111, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(task.getStartTime())), jamonWriter);
          // 111, 62
          jamonWriter.write("</td>\n                      <td>");
          // 112, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getDescription()), jamonWriter);
          // 112, 54
          jamonWriter.write("</td>\n                      <td>");
          // 113, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getState()), jamonWriter);
          // 113, 48
          jamonWriter.write("\n                          (since ");
          // 114, 34
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStateTime())), jamonWriter);
          // 114, 92
          jamonWriter.write(" ago)\n                      </td>\n                      <td>");
          // 116, 27
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getStatus()), jamonWriter);
          // 116, 49
          jamonWriter.write("\n                          (since ");
          // 117, 34
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStatusTime())), jamonWriter);
          // 117, 93
          jamonWriter.write("\n                          ago)</td>\n                    </tr>\n                ");
        }
        // 120, 24
        jamonWriter.write("\n            </table>\n        ");
      }
      // 122, 15
      jamonWriter.write("\n    ");
    }
    // 123, 11
    jamonWriter.write("\n");
  }
  
  
  // 126, 1
  private void __jamon_innerUnit__stateCss(final java.io.Writer jamonWriter, final MonitoredTask.State state)
    throws java.io.IOException
  {
    // 130, 1
           if (state == MonitoredTask.State.COMPLETE) { 
    // 130, 68
    jamonWriter.write("alert alert-success");
    // 130, 87
     } 
    // 131, 1
      else if (state == MonitoredTask.State.ABORTED)  { 
    // 131, 68
    jamonWriter.write("alert alert-error");
    // 131, 85
       } 
  }
  
  
}
