/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestBadReplicationPeer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBadReplicationPeer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBadReplicationPeer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.getConfiguration().setBoolean("replication.source.regionserver.abort", false);
        TEST_UTIL.startMiniCluster();
        conf = TEST_UTIL.getConfiguration();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemovePeerSucceeds() throws IOException {
        String peerId = "dummypeer_1";
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = connection.getAdmin();){
            ReplicationPeerConfigBuilder rpcBuilder = ReplicationPeerConfig.newBuilder();
            String quorum = TEST_UTIL.getHBaseCluster().getMaster().getZooKeeper().getQuorum();
            rpcBuilder.setClusterKey(quorum + ":/1");
            ReplicationPeerConfig rpc = rpcBuilder.build();
            admin.addReplicationPeer(peerId, rpc);
            LOG.info("Added replication peer with peer id: {}", (Object)peerId);
        }
        finally {
            LOG.info("Removing replication peer with peer id: {}", (Object)peerId);
            TestBadReplicationPeer.cleanPeer(peerId);
        }
    }

    private static void cleanPeer(String peerId) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = connection.getAdmin();){
            admin.removeReplicationPeer(peerId);
        }
    }
}

