/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RPCTests.class, MediumTests.class})
public class TestNettyRpcServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyRpcServer.class);
    @Rule
    public TestName name = new TestName();
    private static HBaseTestingUtility TEST_UTIL;
    private static TableName TABLE;
    private static byte[] FAMILY;
    private static byte[] PRIVATE_COL;
    private static byte[] PUBLIC_COL;

    @Before
    public void setup() {
        TABLE = TableName.valueOf((String)this.name.getMethodName());
    }

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().set("hbase.rpc.server.impl", NettyRpcServer.class.getName());
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyRpcServer() throws Exception {
        try (Table table = TEST_UTIL.createTable(TABLE, FAMILY);){
            ArrayList<Put> puts = new ArrayList<Put>(100);
            for (int i = 0; i < 100; ++i) {
                Put p = new Put(Bytes.toBytes((int)i));
                p.addColumn(FAMILY, PRIVATE_COL, Bytes.toBytes((String)("secret " + i)));
                p.addColumn(FAMILY, PUBLIC_COL, Bytes.toBytes((String)("info " + i)));
                puts.add(p);
            }
            table.put(puts);
            Scan scan = new Scan();
            scan.setCaching(16);
            ResultScanner rs = table.getScanner(scan);
            int rowcnt = 0;
            for (Result r : rs) {
                ++rowcnt;
                int rownum = Bytes.toInt((byte[])r.getRow());
                Assert.assertTrue((boolean)r.containsColumn(FAMILY, PRIVATE_COL));
                Assert.assertEquals((Object)("secret " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PRIVATE_COL)));
                Assert.assertTrue((boolean)r.containsColumn(FAMILY, PUBLIC_COL));
                Assert.assertEquals((Object)("info " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PUBLIC_COL)));
            }
            Assert.assertEquals((String)"Expected 100 rows returned", (long)100L, (long)rowcnt);
        }
    }

    static {
        FAMILY = Bytes.toBytes((String)"f1");
        PRIVATE_COL = Bytes.toBytes((String)"private");
        PUBLIC_COL = Bytes.toBytes((String)"public");
    }
}

