/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandlerImpl;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestTaskMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(TestTaskMonitor.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTaskMonitor.class);

    @Test
    public void testTaskMonitorBasics() {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        MonitoredTask task = tm.createStatus("Test task");
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)task.getDescription(), (Object)taskFromTm.getDescription());
        Assert.assertEquals((long)-1L, (long)taskFromTm.getCompletionTimestamp());
        Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)taskFromTm.getState());
        task.markComplete("Finished!");
        Assert.assertEquals((Object)MonitoredTask.State.COMPLETE, (Object)task.getState());
        Assert.assertEquals((long)1L, (long)tm.getTasks().size());
        task.expireNow();
        Assert.assertEquals((long)0L, (long)tm.getTasks().size());
        tm.shutdown();
    }

    @Test
    public void testTasksGetAbortedOnLeak() throws InterruptedException {
        final TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        final AtomicBoolean threadSuccess = new AtomicBoolean(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                MonitoredTask task = tm.createStatus("Test task");
                Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)task.getState());
                threadSuccess.set(true);
            }
        };
        t.start();
        t.join();
        Assert.assertTrue((boolean)threadSuccess.get());
        System.gc();
        System.gc();
        System.gc();
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)MonitoredTask.State.ABORTED, (Object)taskFromTm.getState());
        tm.shutdown();
    }

    @Test
    public void testTaskLimit() throws Exception {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        for (int i = 0; i < 1010; ++i) {
            tm.createStatus("task " + i);
        }
        Assert.assertEquals((long)1000L, (long)tm.getTasks().size());
        Assert.assertEquals((Object)"task 10", (Object)((MonitoredTask)tm.getTasks().get(0)).getDescription());
        tm.shutdown();
    }

    @Test
    public void testDoNotPurgeRPCTask() throws Exception {
        int i;
        int RPCTaskNums = 10;
        TaskMonitor tm = TaskMonitor.get();
        for (i = 0; i < RPCTaskNums; ++i) {
            tm.createRPCStatus("PRCTask" + i);
        }
        for (i = 0; i < 1000; ++i) {
            tm.createStatus("otherTask" + i);
        }
        int remainRPCTask = 0;
        for (MonitoredTask task : tm.getTasks()) {
            if (!(task instanceof MonitoredRPCHandler)) continue;
            ++remainRPCTask;
        }
        Assert.assertEquals((String)"RPC Tasks have been purged!", (long)RPCTaskNums, (long)remainRPCTask);
        tm.shutdown();
    }

    @Test
    public void testWarnStuckTasks() throws Exception {
        int RPC_WARN_TIME = 1500;
        int MONITOR_INTERVAL = 500;
        Configuration conf = new Configuration();
        conf.setLong("hbase.taskmonitor.rpc.warn.time", 1500L);
        conf.setLong("hbase.taskmonitor.monitor.interval", 500L);
        TaskMonitor tm = new TaskMonitor(conf);
        MonitoredRPCHandler t = tm.createRPCStatus("test task");
        long beforeSetRPC = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((String)"Validating initialization assumption", (t.getWarnTime() <= beforeSetRPC ? 1 : 0) != 0);
        Thread.sleep(1000L);
        t.setRPC("testMethod", new Object[0], beforeSetRPC);
        long afterSetRPC = EnvironmentEdgeManager.currentTime();
        Thread.sleep(1000L);
        Assert.assertTrue((String)"Validating no warn after starting RPC", (t.getWarnTime() <= afterSetRPC ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Assert.assertTrue((String)"Validating warn after RPC_WARN_TIME", (t.getWarnTime() > afterSetRPC ? 1 : 0) != 0);
        tm.shutdown();
    }

    @Test
    public void testGetTasksWithFilter() throws Exception {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        tm.createStatus("General task1");
        tm.createStatus("General task2");
        tm.createStatus("General task3");
        tm.createStatus("General task4");
        tm.createStatus("General task5");
        int length = 5;
        ArrayList<MonitoredRPCHandler> rpcHandlers = new ArrayList<MonitoredRPCHandler>(length);
        for (int i = 0; i < length; ++i) {
            MonitoredRPCHandler rpcHandler = tm.createRPCStatus("Rpc task" + i);
            rpcHandlers.add(rpcHandler);
        }
        byte[] row = new byte[]{1};
        Put m = new Put(row);
        Scan q = new Scan();
        String notOperation = "for test";
        ((MonitoredRPCHandler)rpcHandlers.get(0)).setRPC("operations", new Object[]{m, q}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(1)).setRPC("operations", new Object[]{m, q}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(2)).setRPC("operations", new Object[]{m, q}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(3)).setRPC("operations", new Object[]{notOperation}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(4)).setRPC("operations", new Object[]{m, q}, 3000L);
        MonitoredRPCHandler completed = (MonitoredRPCHandler)rpcHandlers.get(4);
        completed.markComplete("Completed!");
        List generalTasks = tm.getTasks("general");
        Assert.assertEquals((long)5L, (long)generalTasks.size());
        List handlerTasks = tm.getTasks("handler");
        Assert.assertEquals((long)5L, (long)handlerTasks.size());
        List rpcTasks = tm.getTasks("rpc");
        Assert.assertEquals((long)4L, (long)rpcTasks.size());
        List operationTasks = tm.getTasks("operation");
        Assert.assertEquals((long)3L, (long)operationTasks.size());
        tm.shutdown();
    }

    @Test
    public void testStatusJournal() {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        MonitoredTask task = tm.createStatus("Test task");
        Assert.assertTrue((boolean)task.getStatusJournal().isEmpty());
        task.disableStatusJournal();
        task.setStatus("status1");
        Assert.assertTrue((boolean)task.getStatusJournal().isEmpty());
        task.enableStatusJournal(true);
        Assert.assertEquals((Object)"status1", (Object)((MonitoredTask.StatusJournalEntry)task.getStatusJournal().get(0)).getStatus());
        Assert.assertTrue((((MonitoredTask.StatusJournalEntry)task.getStatusJournal().get(0)).getTimeStamp() > 0L ? 1 : 0) != 0);
        task.disableStatusJournal();
        task.setStatus("status2");
        Assert.assertEquals((long)1L, (long)task.getStatusJournal().size());
        task.enableStatusJournal(false);
        Assert.assertEquals((long)1L, (long)task.getStatusJournal().size());
        task.setStatus("status3");
        Assert.assertEquals((Object)"status3", (Object)((MonitoredTask.StatusJournalEntry)task.getStatusJournal().get(1)).getStatus());
        tm.shutdown();
    }

    @Test
    public void testClone() throws Exception {
        MonitoredRPCHandlerImpl monitor = new MonitoredRPCHandlerImpl();
        monitor.abort("abort RPC");
        TestParam testParam = new TestParam("param1");
        monitor.setRPC("method1", new Object[]{testParam}, 0L);
        MonitoredRPCHandlerImpl clone = monitor.clone();
        Assert.assertEquals((Object)clone.getDescription(), (Object)monitor.getDescription());
        Assert.assertEquals((Object)clone.getState(), (Object)monitor.getState());
        Assert.assertEquals((Object)clone.getStatus(), (Object)monitor.getStatus());
        Assert.assertEquals((Object)clone.toString(), (Object)monitor.toString());
        Assert.assertEquals((Object)clone.toMap(), (Object)monitor.toMap());
        Assert.assertEquals((Object)clone.toJSON(), (Object)monitor.toJSON());
        monitor.markComplete("complete RPC");
        testParam.setParam("dirtyParam");
        Assert.assertEquals((Object)clone.getDescription(), (Object)monitor.getDescription());
        Assert.assertNotEquals((Object)clone.getState(), (Object)monitor.getState());
        Assert.assertNotEquals((Object)clone.getStatus(), (Object)monitor.getStatus());
        monitor.setState(MonitoredTask.State.RUNNING);
        try {
            monitor.toMap();
            Assert.fail((String)"Should not call toMap successfully, because param=null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotEquals((Object)"[dirtyString]", (Object)String.valueOf(((Map)clone.toMap().get("rpcCall")).get("params")));
        monitor.resume("resume");
        monitor.setRPC("method2", new Object[]{new TestParam("param2")}, 1L);
        Assert.assertNotEquals(((Map)clone.toMap().get("rpcCall")).get("params"), ((Map)monitor.toMap().get("rpcCall")).get("params"));
        LOG.info(String.valueOf(clone.toMap()));
        LOG.info(String.valueOf(monitor.toMap()));
        Assert.assertNotEquals((Object)clone.toString(), (Object)monitor.toString());
        Assert.assertNotEquals((long)clone.getRPCQueueTime(), (long)monitor.getRPCQueueTime());
        Assert.assertNotEquals((Object)clone.toMap(), (Object)monitor.toMap());
        Assert.assertNotEquals((Object)clone.toJSON(), (Object)monitor.toJSON());
    }

    private class TestParam {
        public String param = null;

        public TestParam(String param) {
            this.param = param;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public String toString() {
            return this.param;
        }
    }
}

