/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestHMobStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHMobStore.class);
    public static final Logger LOG = LoggerFactory.getLogger(TestHMobStore.class);
    @Rule
    public TestName name = new TestName();
    private HMobStore store;
    private HRegion region;
    private FileSystem fs;
    private byte[] table = Bytes.toBytes((String)"table");
    private byte[] family = Bytes.toBytes((String)"family");
    private byte[] row = Bytes.toBytes((String)"row");
    private byte[] row2 = Bytes.toBytes((String)"row2");
    private byte[] qf1 = Bytes.toBytes((String)"qf1");
    private byte[] qf2 = Bytes.toBytes((String)"qf2");
    private byte[] qf3 = Bytes.toBytes((String)"qf3");
    private byte[] qf4 = Bytes.toBytes((String)"qf4");
    private byte[] qf5 = Bytes.toBytes((String)"qf5");
    private byte[] qf6 = Bytes.toBytes((String)"qf6");
    private byte[] value = Bytes.toBytes((String)"value");
    private byte[] value2 = Bytes.toBytes((String)"value2");
    private Path mobFilePath;
    private Date currentDate = new Date();
    private Cell seekKey1;
    private Cell seekKey2;
    private Cell seekKey3;
    private NavigableSet<byte[]> qualifiers = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    private List<Cell> expected = new ArrayList<Cell>();
    private long id = System.currentTimeMillis();
    private Get get = new Get(this.row);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String DIR = TEST_UTIL.getDataTestDir("TestHMobStore").toString();

    @Before
    public void setUp() throws Exception {
        this.qualifiers.add(this.qf1);
        this.qualifiers.add(this.qf3);
        this.qualifiers.add(this.qf5);
        for (byte[] next : this.qualifiers) {
            this.expected.add((Cell)new KeyValue(this.row, this.family, next, 1L, this.value));
            this.get.addColumn(this.family, next);
            this.get.readAllVersions();
        }
    }

    private void init(String methodName, Configuration conf, boolean testStore) throws IOException {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMobEnabled(true).setMobThreshold(3L).setMaxVersions(4).build();
        this.init(methodName, conf, cfd, testStore);
    }

    private void init(String methodName, Configuration conf, ColumnFamilyDescriptor cfd, boolean testStore) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)).setColumnFamily(cfd).build();
        Path basedir = new Path(this.DIR + methodName);
        Path tableDir = CommonFSUtils.getTableDir((Path)basedir, (TableName)td.getTableName());
        String logName = "logs";
        Path logdir = new Path(basedir, logName);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(logdir, true);
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)td.getTableName()).build();
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        Configuration walConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)basedir);
        WALFactory wals = new WALFactory(walConf, methodName);
        this.region = new HRegion(tableDir, wals.getWAL(info), fs, conf, info, td, null);
        this.region.setMobFileCache(new MobFileCache(conf));
        this.store = new HMobStore(this.region, cfd, conf, false);
        if (testStore) {
            this.init(conf, cfd);
        }
    }

    private void init(Configuration conf, ColumnFamilyDescriptor cfd) throws IOException {
        Path basedir = CommonFSUtils.getRootDir((Configuration)conf);
        this.fs = FileSystem.get((Configuration)conf);
        Path homePath = new Path(basedir, Bytes.toString((byte[])this.family) + "/" + Bytes.toString((byte[])this.family));
        this.fs.mkdirs(homePath);
        KeyValue key1 = new KeyValue(this.row, this.family, this.qf1, 1L, this.value);
        KeyValue key2 = new KeyValue(this.row, this.family, this.qf2, 1L, this.value);
        KeyValue key3 = new KeyValue(this.row2, this.family, this.qf3, 1L, this.value2);
        KeyValue[] keys = new KeyValue[]{key1, key2, key3};
        int maxKeyCount = keys.length;
        StoreFileWriter mobWriter = this.store.createWriterInTmp(this.currentDate, (long)maxKeyCount, cfd.getCompactionCompressionType(), this.region.getRegionInfo().getStartKey(), false);
        this.mobFilePath = mobWriter.getPath();
        mobWriter.append((Cell)key1);
        mobWriter.append((Cell)key2);
        mobWriter.append((Cell)key3);
        mobWriter.close();
        String targetPathName = MobUtils.formatDate((Date)this.currentDate);
        byte[] referenceValue = Bytes.toBytes((String)(targetPathName + "/" + this.mobFilePath.getName()));
        ArrayBackedTag tableNameTag = new ArrayBackedTag(6, this.store.getTableName().getName());
        KeyValue kv1 = new KeyValue(this.row, this.family, this.qf1, Long.MAX_VALUE, referenceValue);
        KeyValue kv2 = new KeyValue(this.row, this.family, this.qf2, Long.MAX_VALUE, referenceValue);
        KeyValue kv3 = new KeyValue(this.row2, this.family, this.qf3, Long.MAX_VALUE, referenceValue);
        this.seekKey1 = MobUtils.createMobRefCell((Cell)kv1, (byte[])referenceValue, (Tag)tableNameTag);
        this.seekKey2 = MobUtils.createMobRefCell((Cell)kv2, (byte[])referenceValue, (Tag)tableNameTag);
        this.seekKey3 = MobUtils.createMobRefCell((Cell)kv3, (byte[])referenceValue, (Tag)tableNameTag);
    }

    @Test
    public void testGetFromMemStore() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        this.init(this.name.getMethodName(), conf, false);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, this.value), null);
        Scan scan = new Scan(this.get);
        InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.store.getColumnFamilyDescriptor().getName()), 0L);
        ArrayList results = new ArrayList();
        scanner.next(results);
        Collections.sort(results, CellComparatorImpl.COMPARATOR);
        scanner.close();
        Assert.assertEquals((long)this.expected.size(), (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), results.get(i));
        }
    }

    @Test
    public void testGetFromFiles() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        this.init(this.name.getMethodName(), conf, false);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, this.value), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, this.value), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, this.value), null);
        this.flush(3);
        Scan scan = new Scan(this.get);
        InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.store.getColumnFamilyDescriptor().getName()), 0L);
        ArrayList results = new ArrayList();
        scanner.next(results);
        Collections.sort(results, CellComparatorImpl.COMPARATOR);
        scanner.close();
        Assert.assertEquals((long)this.expected.size(), (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), results.get(i));
        }
    }

    @Test
    public void testGetReferencesFromFiles() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        this.init(this.name.getMethodName(), conf, false);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, this.value), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, this.value), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, this.value), null);
        this.flush(3);
        Scan scan = new Scan(this.get);
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.store.getColumnFamilyDescriptor().getName()), 0L);
        ArrayList results = new ArrayList();
        scanner.next(results);
        Collections.sort(results, CellComparatorImpl.COMPARATOR);
        scanner.close();
        Assert.assertEquals((long)this.expected.size(), (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            Cell cell = (Cell)results.get(i);
            Assert.assertTrue((boolean)MobUtils.isMobReferenceCell((Cell)cell));
        }
    }

    @Test
    public void testGetFromMemStoreAndFiles() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        this.init(this.name.getMethodName(), conf, false);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, this.value), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, this.value), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, this.value), null);
        Scan scan = new Scan(this.get);
        InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.store.getColumnFamilyDescriptor().getName()), 0L);
        ArrayList results = new ArrayList();
        scanner.next(results);
        Collections.sort(results, CellComparatorImpl.COMPARATOR);
        scanner.close();
        Assert.assertEquals((long)this.expected.size(), (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), results.get(i));
        }
    }

    @Test
    public void testMobCellSizeThreshold() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMobEnabled(true).setMobThreshold(100L).setMaxVersions(4).build();
        this.init(this.name.getMethodName(), conf, cfd, false);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, this.value), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, this.value), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, this.value), null);
        this.flush(3);
        Scan scan = new Scan(this.get);
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.store.getColumnFamilyDescriptor().getName()), 0L);
        ArrayList results = new ArrayList();
        scanner.next(results);
        Collections.sort(results, CellComparatorImpl.COMPARATOR);
        scanner.close();
        Assert.assertEquals((long)this.expected.size(), (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            Cell cell = (Cell)results.get(i);
            Assert.assertFalse((boolean)MobUtils.isMobReferenceCell((Cell)cell));
            Assert.assertEquals((Object)this.expected.get(i), results.get(i));
            Assert.assertEquals((long)100L, (long)this.store.getColumnFamilyDescriptor().getMobThreshold());
        }
    }

    @Test
    public void testCommitFile() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        this.init(this.name.getMethodName(), conf, true);
        String targetPathName = MobUtils.formatDate((Date)new Date());
        Path targetPath = new Path(this.store.getPath(), targetPathName + "/" + this.mobFilePath.getName());
        this.fs.delete(targetPath, true);
        Assert.assertFalse((boolean)this.fs.exists(targetPath));
        this.store.commitFile(this.mobFilePath, targetPath);
        Assert.assertTrue((boolean)this.fs.exists(targetPath));
    }

    @Test
    public void testResolve() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        this.init(this.name.getMethodName(), conf, true);
        String targetPathName = MobUtils.formatDate((Date)this.currentDate);
        Path targetPath = new Path(this.store.getPath(), targetPathName);
        this.store.commitFile(this.mobFilePath, targetPath);
        Cell resultCell1 = this.store.resolve(this.seekKey1, false).getCell();
        Cell resultCell2 = this.store.resolve(this.seekKey2, false).getCell();
        Cell resultCell3 = this.store.resolve(this.seekKey3, false).getCell();
        Assert.assertEquals((Object)Bytes.toString((byte[])this.value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)resultCell1)));
        Assert.assertEquals((Object)Bytes.toString((byte[])this.value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)resultCell2)));
        Assert.assertEquals((Object)Bytes.toString((byte[])this.value2), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)resultCell3)));
    }

    private void flush(int storeFilesSize) throws IOException {
        this.store.snapshot();
        TestHMobStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)storeFilesSize, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)0L, (long)((AbstractMemStore)this.store.memstore).getActive().getCellsCount());
    }

    private static void flushStore(HMobStore store, long id) throws IOException {
        StoreFlushContext storeFlushCtx = store.createFlushContext(id, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
    }

    @Test
    public void testMOBStoreEncryption() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        byte[] keyBytes = new byte[16];
        Bytes.secureRandom((byte[])keyBytes);
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        SecretKeySpec cfKey = new SecretKeySpec(keyBytes, algorithm);
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMobEnabled(true).setMobThreshold(100L).setMaxVersions(4).setEncryptionType(algorithm).setEncryptionKey(EncryptionUtil.wrapKey((Configuration)conf, (String)conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)cfKey)).build();
        this.init(this.name.getMethodName(), conf, cfd, false);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, this.value), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, this.value), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, this.value), null);
        this.flush(2);
        Collection storefiles = this.store.getStorefiles();
        this.checkMobHFileEncrytption(storefiles);
        Scan scan = new Scan(this.get);
        InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.store.getColumnFamilyDescriptor().getName()), 0L);
        ArrayList results = new ArrayList();
        scanner.next(results);
        Collections.sort(results, CellComparatorImpl.COMPARATOR);
        scanner.close();
        Assert.assertEquals((long)this.expected.size(), (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), results.get(i));
        }
        this.store.triggerMajorCompaction();
        Optional requestCompaction = this.store.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, null);
        this.store.compact((CompactionContext)requestCompaction.get(), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        Assert.assertEquals((long)1L, (long)this.store.getStorefiles().size());
        this.checkMobHFileEncrytption(this.store.getStorefiles());
    }

    private void checkMobHFileEncrytption(Collection<HStoreFile> storefiles) {
        HStoreFile storeFile = storefiles.iterator().next();
        HFile.Reader reader = storeFile.getReader().getHFileReader();
        byte[] encryptionKey = reader.getTrailer().getEncryptionKey();
        Assert.assertTrue((null != encryptionKey ? 1 : 0) != 0);
        Assert.assertTrue((boolean)reader.getFileContext().getEncryptionContext().getCipher().getName().equals("AES"));
    }
}

