// Autogenerated Jamon implementation
// /home/apurtell/tmp/RM/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/BlockCacheTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 32, 1
import java.util.Map;
// 33, 1
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
// 34, 1
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil.CachedBlocksByFile;
// 35, 1
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
// 36, 1
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
// 37, 1
import org.apache.hadoop.conf.Configuration;
// 38, 1
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
// 39, 1
import org.apache.hadoop.hbase.io.hfile.BlockCache;
// 40, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCacheStats;
// 41, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
// 42, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
// 43, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator.Bucket;
// 44, 1
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class BlockCacheTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.Intf

{
  private final CacheConfig cacheConfig;
  private final Configuration config;
  private final BlockCache bc;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public BlockCacheTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    cacheConfig = p_implData.getCacheConfig();
    config = p_implData.getConfig();
    bc = p_implData.getBc();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 25, 1
    
  String bcUrl = bc == null ? null : "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
  String bcName = bc == null ? null : bc.getClass().getSimpleName();
  BlockCache [] bcs = bc == null ? null : bc.getBlockCaches();
  boolean evictions = bcs != null && bcs.length > 1;

    // 46, 1
    jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_bc_baseInfo\" data-toggle=\"tab\">Base Info</a></li>\n        <li class=\"\"><a href=\"#tab_bc_config\" data-toggle=\"tab\">Config</a></li>\n        <li class=\"\"><a href=\"#tab_bc_stats\" data-toggle=\"tab\">Stats</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l1\" data-toggle=\"tab\">L1</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l2\" data-toggle=\"tab\">L2</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_bc_baseInfo\">\n            ");
    // 56, 13
    {
      // 56, 13
      __jamon_innerUnit__bc_baseInfo(jamonWriter, bc, bcUrl, bcName);
    }
    // 56, 73
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_config\">\n            ");
    // 59, 13
    {
      // 59, 13
      __jamon_innerUnit__bc_config(jamonWriter, cacheConfig );
    }
    // 59, 55
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_stats\">\n            ");
    // 62, 13
    {
      // 62, 13
      __jamon_innerUnit__bc_stats(jamonWriter, bc );
    }
    // 62, 36
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l1\">\n            ");
    // 65, 13
    {
      // 65, 13
      __jamon_innerUnit__bc_l(jamonWriter, bcs == null? bc: bcs[0], "L1", evictions);
    }
    // 65, 90
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l2\">\n            ");
    // 68, 13
    {
      // 68, 13
      __jamon_innerUnit__bc_l(jamonWriter, bcs == null? null: bcs.length <= 1? null: bcs[1], "L2", evictions);
    }
    // 68, 115
    jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
  }
  
  
  // 73, 1
  private void __jamon_innerUnit__bc_baseInfo(final java.io.Writer jamonWriter, final BlockCache bc, final String bcUrl, final String bcName)
    throws java.io.IOException
  {
    // 79, 1
    
  BlockCache [] bcs = bc == null? null: bc.getBlockCaches();
  String bcl1Url = null;
  String bcl1Name = null;
  String bcl2Url = null;
  String bcl2Name = null;
  if (bcs != null) {
    BlockCache bcl1 = bcs[0];
    if (bcl1 != null) {
      bcl1Url = "http://hbase.apache.org/devapidocs/" + bcl1.getClass().getName().replaceAll("\\.", "/") + ".html";
      bcl1Name = bcl1.getClass().getSimpleName();
    }
    if (bcs.length == 2) {
      BlockCache bcl2 = bcs[1];
      bcl2Url = "http://hbase.apache.org/devapidocs/" + bcl2.getClass().getName().replaceAll("\\.", "/") + ".html";
      bcl2Name = bcl2.getClass().getSimpleName();
    }
  }

    // 98, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
    // 107, 22
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcUrl), jamonWriter);
    // 107, 33
    jamonWriter.write("\">");
    // 107, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcName), jamonWriter);
    // 107, 47
    jamonWriter.write("</a></td>\n        <td>Block cache implementing class</td>\n    </tr>\n</table>\n<p>See <a href=\"http://hbase.apache.org/book.html#block.cache\">block cache</a> in the HBase Reference Guide for help.</p>\n");
  }
  
  
  // 114, 1
  private void __jamon_innerUnit__bc_config(final java.io.Writer jamonWriter, final CacheConfig cacheConfig)
    throws java.io.IOException
  {
    // 118, 1
    if (cacheConfig == null )
    {
      // 118, 28
      jamonWriter.write("\n<p>CacheConfig is null</p>\n");
    }
    // 120, 1
    else
    {
      // 120, 8
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Cache DATA on Read</td>\n        <td>");
      // 129, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataOnRead()), jamonWriter);
      // 129, 54
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on read\n        (INDEX & BLOOM blocks are always cached)</td>\n    </tr>\n    <tr>\n        <td>Cache DATA on Write</td>\n        <td>");
      // 135, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataOnWrite()), jamonWriter);
      // 135, 55
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on write.</td>\n    </tr>\n    <tr>\n        <td>Cache INDEX on Write</td>\n        <td>");
      // 140, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheIndexesOnWrite()), jamonWriter);
      // 140, 58
      jamonWriter.write("</td>\n        <td>True if INDEX blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Cache BLOOM on Write</td>\n        <td>");
      // 145, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheBloomsOnWrite()), jamonWriter);
      // 145, 57
      jamonWriter.write("</td>\n        <td>True if BLOOM blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Evict blocks on Close</td>\n        <td>");
      // 150, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldEvictOnClose()), jamonWriter);
      // 150, 51
      jamonWriter.write("</td>\n        <td>True if blocks are evicted from cache when an HFile\n        reader is closed</td>\n    </tr>\n    <tr>\n        <td>Cache DATA in compressed format</td>\n        <td>");
      // 156, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataCompressed()), jamonWriter);
      // 156, 58
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached in their compressed form</td>\n    </tr>\n    <tr>\n        <td>Prefetch on Open</td>\n        <td>");
      // 161, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldPrefetchOnOpen()), jamonWriter);
      // 161, 53
      jamonWriter.write("</td>\n        <td>True if blocks are prefetched into cache on open</td>\n    </tr>\n</table>\n");
    }
    // 165, 7
    jamonWriter.write("\n");
  }
  
  
  // 263, 1
  private void __jamon_innerUnit__bc_l(final java.io.Writer jamonWriter, final BlockCache bc, final String name, final boolean evictions)
    throws java.io.IOException
  {
    // 269, 1
    if (bc == null )
    {
      // 269, 19
      jamonWriter.write("\n<p>No ");
      // 270, 7
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
      // 270, 17
      jamonWriter.write(" deployed</p>\n");
    }
    // 271, 1
    else
    {
      // 271, 8
      jamonWriter.write("\n");
      // 272, 1
      {
        // 272, 1
        __jamon_innerUnit__block_cache(jamonWriter, bc, name, evictions);
      }
      // 272, 65
      jamonWriter.write("\n");
    }
    // 273, 7
    jamonWriter.write("\n");
  }
  
  
  // 225, 1
  private void __jamon_innerUnit__bc_stats(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 229, 1
    if (bc == null )
    {
      // 229, 19
      jamonWriter.write("\n<p>BlockCache is null</p>\n");
    }
    // 231, 1
    else
    {
      // 231, 8
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Size</td>\n        <td>");
      // 240, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentSize(),
            "B", 1)), jamonWriter);
      // 241, 23
      jamonWriter.write("</td>\n        <td>Current size of block cache in use</td>\n    </tr>\n    <tr>\n        <td>Free</td>\n        <td>");
      // 246, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getFreeSize(),
            "B", 1)), jamonWriter);
      // 247, 23
      jamonWriter.write("</td>\n        <td>The total free memory currently available to store more cache entries</td>\n    </tr>\n    <tr>\n        <td>Count</td>\n        <td>");
      // 252, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getBlockCount())), jamonWriter);
      // 252, 59
      jamonWriter.write("</td>\n        <td>Number of blocks in block cache</td>\n    </tr>\n    ");
      // 255, 5
      {
        // 255, 5
        __jamon_innerUnit__evictions_tmpl(jamonWriter, bc);
      }
      // 255, 35
      jamonWriter.write("\n    ");
      // 256, 5
      {
        // 256, 5
        __jamon_innerUnit__hits_tmpl(jamonWriter, bc);
      }
      // 256, 30
      jamonWriter.write("\n</table>\n<p>If block cache is made up of more than one cache -- i.e. a L1 and a L2 -- then the above\nare combined counts. Request count is sum of hits and misses.</p>\n");
    }
    // 260, 7
    jamonWriter.write("\n");
  }
  
  
  // 276, 1
  private void __jamon_innerUnit__block_cache(final java.io.Writer jamonWriter, final BlockCache bc, final String name, final boolean evictions)
    throws java.io.IOException
  {
    // 282, 1
    
  String bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
  String bcName = bc.getClass().getSimpleName();
  int maxCachedBlocksByFile = BlockCacheUtil.getMaxCachedBlocksByFile(config);

  boolean bucketCache = bc.getClass().getSimpleName().equals("BucketCache");
  BucketCacheStats bucketCacheStats = null;
  BucketAllocator bucketAllocator = null;

  if (bucketCache) {
    bucketCacheStats = (BucketCacheStats)bc.getStats();
    bucketAllocator = ((BucketCache)bc).getAllocator();
  }

    // 296, 1
    jamonWriter.write("<table id=\"blocks_summary\" class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
    // 304, 22
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcUrl), jamonWriter);
    // 304, 33
    jamonWriter.write("\">");
    // 304, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bc.getClass().getSimpleName()), jamonWriter);
    // 304, 70
    jamonWriter.write("</a></td>\n        <td>Class implementing this block cache Level</td>\n    </tr>\n");
    // 307, 1
    if (bucketCache )
    {
      // 307, 20
      jamonWriter.write("\n    <tr>\n        <td>Implementation</td>\n        <td>");
      // 310, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(((BucketCache)bc).getIoEngine()), jamonWriter);
      // 310, 50
      jamonWriter.write("</a></td>\n        <td>IOEngine</td>\n    </tr>\n");
    }
    // 313, 7
    jamonWriter.write("\n    <tr>\n        <td>Cache Size Limit</td>\n        <td>");
    // 316, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getMaxSize(), "B", 1)), jamonWriter);
    // 316, 79
    jamonWriter.write("</td>\n        <td>Max size of cache</td>\n    </tr>\n    <tr>\n        <td>Block Count</td>\n        <td>");
    // 321, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getBlockCount())), jamonWriter);
    // 321, 59
    jamonWriter.write("</td>\n        <td>Count of Blocks</td>\n    </tr>\n");
    // 324, 1
    if (!bucketCache )
    {
      // 324, 21
      jamonWriter.write("\n    <tr>\n        <td>Data Block Count</td>\n        <td>");
      // 327, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getDataBlockCount())), jamonWriter);
      // 327, 63
      jamonWriter.write("</td>\n        <td>Count of DATA Blocks</td>\n    </tr>\n");
    }
    // 330, 7
    jamonWriter.write("\n    <tr>\n        <td>Size of Blocks</td>\n        <td>");
    // 333, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentSize(), "B", 1)), jamonWriter);
    // 333, 83
    jamonWriter.write("</td>\n        <td>Size of Blocks</td>\n    </tr>\n");
    // 336, 1
    if (!bucketCache )
    {
      // 336, 21
      jamonWriter.write("\n    <tr>\n        <td>Size of Data Blocks</td>\n        <td>");
      // 339, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentDataSize(), "B", 1)), jamonWriter);
      // 339, 87
      jamonWriter.write("</td>\n        <td>Size of DATA Blocks</td>\n    </tr>\n");
    }
    // 342, 7
    jamonWriter.write(" \n");
    // 343, 1
    {
      // 343, 1
      __jamon_innerUnit__evictions_tmpl(jamonWriter, bc);
    }
    // 343, 31
    jamonWriter.write("\n");
    // 344, 1
    {
      // 344, 1
      __jamon_innerUnit__hits_tmpl(jamonWriter, bc);
    }
    // 344, 26
    jamonWriter.write("\n\n");
    // 346, 1
    if (bucketCache )
    {
      // 346, 20
      jamonWriter.write("\n    <tr>\n        <td>Hits per Second</td>\n        <td>");
      // 349, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bucketCacheStats.getIOHitsPerSecond()), jamonWriter);
      // 349, 56
      jamonWriter.write("</td>\n        <td>Block gets against this cache per second</td>\n    </tr>\n    <tr>\n        <td>Time per Hit</td>\n        <td>");
      // 354, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bucketCacheStats.getIOTimePerHit()), jamonWriter);
      // 354, 53
      jamonWriter.write("</td>\n        <td>Time per cache hit</td>\n    </tr>\n");
    }
    // 357, 7
    jamonWriter.write("\n</table>\n<p>\nView block cache <a href=\"?format=json&bcn=");
    // 361, 44
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
    // 361, 54
    jamonWriter.write("\">as JSON</a> | Block cache <a href=\"?format=json&bcn=");
    // 361, 108
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
    // 361, 118
    jamonWriter.write("&bcv=file\">as JSON by file</a>\n");
    // 362, 1
    if (bc.getBlockCount() > maxCachedBlocksByFile )
    {
      // 362, 51
      jamonWriter.write("\n<br>\n<b>Note</b>: JSON view of block cache will be incomplete, because block count ");
      // 364, 79
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bc.getBlockCount()), jamonWriter);
      // 364, 103
      jamonWriter.write(" is greater than <i>hbase.ui.blockcache.by.file.max</i> value of ");
      // 364, 168
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(maxCachedBlocksByFile), jamonWriter);
      // 364, 195
      jamonWriter.write(".\nIncrease that value to get a complete picture.\n");
    }
    // 366, 7
    jamonWriter.write("\n</p>\n");
  }
  
  
  // 168, 1
  private void __jamon_innerUnit__evictions_tmpl(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 172, 1
    
  AgeSnapshot ageAtEvictionSnapshot = bc.getStats().getAgeAtEvictionSnapshot();
  // Only show if non-zero mean and stddev as is the case in combinedblockcache

    // 176, 5
    jamonWriter.write("<tr>\n        <td>Evicted</td>\n        <td>");
    // 178, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getEvictedCount())), jamonWriter);
    // 178, 72
    jamonWriter.write("</td>\n        <td>The total number of blocks evicted</td>\n    </tr>\n    <tr>\n        <td>Evictions</td>\n        <td>");
    // 183, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getEvictionCount())), jamonWriter);
    // 183, 73
    jamonWriter.write("</td>\n        <td>The total number of times an eviction has occurred</td>\n    </tr>\n    <tr>\n        <td>Mean</td>\n        <td>");
    // 188, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", (long)ageAtEvictionSnapshot.getMean())), jamonWriter);
    // 188, 78
    jamonWriter.write("</td>\n        <td>Mean age of Blocks at eviction time (seconds)</td>\n    </tr>\n");
  }
  
  
  // 193, 1
  private void __jamon_innerUnit__hits_tmpl(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 197, 5
    jamonWriter.write("<tr>\n        <td>Hits</td>\n        <td>");
    // 199, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getHitCount())), jamonWriter);
    // 199, 68
    jamonWriter.write("</td>\n        <td>Number requests that were cache hits</td>\n    </tr>\n    <tr>\n        <td>Hits Caching</td>\n        <td>");
    // 204, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getHitCachingCount())), jamonWriter);
    // 204, 75
    jamonWriter.write("</td>\n        <td>Cache hit block requests but only requests set to cache block if a miss</td>\n    </tr>\n    <tr>\n        <td>Misses</td>\n        <td>");
    // 209, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getMissCount())), jamonWriter);
    // 209, 69
    jamonWriter.write("</td>\n        <td>Block requests that were cache misses but set to cache missed blocks</td>\n    </tr>\n    <tr>\n        <td>Misses Caching</td>\n        <td>");
    // 214, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getMissCachingCount())), jamonWriter);
    // 214, 76
    jamonWriter.write("</td>\n        <td>Block requests that were cache misses but only requests set to use block cache</td>\n    </tr>\n    <tr>\n        <td>Hit Ratio</td>\n        <td>");
    // 219, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,.2f", bc.getStats().getHitRatio() * 100)), jamonWriter);
    // 219, 76
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 219, 85
    jamonWriter.write("</td>\n        <td>Hit Count divided by total requests count</td>\n    </tr>\n\n");
  }
  
  
}
