/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterShutdown {
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterShutdown.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterShutdown.class);
    private HBaseTestingUtility htu;

    @Before
    public void shutdownCluster() throws IOException {
        if (this.htu != null) {
            LOG.warn("found non-null TestingUtility -- previous test did not terminate cleanly.");
            this.htu.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterShutdown() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        try {
            this.htu = new HBaseTestingUtility(conf);
            StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(3).numRegionServers(1).numDataNodes(1).build();
            MiniHBaseCluster cluster = this.htu.startMiniCluster(option);
            long thirtySeconds = TimeUnit.SECONDS.toMillis(30L);
            long oneSecond = TimeUnit.SECONDS.toMillis(1L);
            Assert.assertNotEquals((long)-1L, (long)this.htu.waitFor(thirtySeconds, oneSecond, () -> {
                List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
                return masterThreads != null && masterThreads.size() >= 3 && masterThreads.stream().allMatch(Thread::isAlive);
            }));
            HMaster active = cluster.getMaster();
            Assert.assertNotNull((Object)active);
            ClusterMetrics status = active.getClusterMetrics();
            Assert.assertEquals((long)2L, (long)status.getBackupMasterNames().size());
            active.shutdown();
            Assert.assertNotEquals((long)-1L, (long)this.htu.waitFor(thirtySeconds, oneSecond, () -> CollectionUtils.isEmpty(cluster.getLiveMasterThreads())));
            Assert.assertNotEquals((long)-1L, (long)this.htu.waitFor(thirtySeconds, oneSecond, () -> CollectionUtils.isEmpty(cluster.getLiveRegionServerThreads())));
        }
        finally {
            if (this.htu != null) {
                this.htu.shutdownMiniCluster();
                this.htu = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterShutdownBeforeStartingAnyRegionServer() throws Exception {
        LocalHBaseCluster hbaseCluster = null;
        try {
            this.htu = new HBaseTestingUtility(TestMasterShutdown.createMasterShutdownBeforeStartingAnyRegionServerConfiguration());
            StartMiniClusterOption options = StartMiniClusterOption.builder().numDataNodes(1).numMasters(1).numRegionServers(0).masterClass(HMaster.class).rsClass(MiniHBaseCluster.MiniHBaseClusterRegionServer.class).createRootDir(true).build();
            this.htu.startMiniDFSCluster(options.getNumDataNodes());
            this.htu.startMiniZKCluster(options.getNumZkServers(), new int[0]);
            this.htu.createRootDir();
            hbaseCluster = new LocalHBaseCluster(this.htu.getConfiguration(), options.getNumMasters(), options.getNumRegionServers(), options.getMasterClass(), options.getRsClass());
            JVMClusterUtil.MasterThread masterThread = (JVMClusterUtil.MasterThread)hbaseCluster.getMasters().get(0);
            masterThread.start();
            long timeout = TimeUnit.MINUTES.toMillis(10L);
            Assert.assertNotEquals((String)"Timeout waiting for server manager to become available.", (long)-1L, (long)Waiter.waitFor((Configuration)this.htu.getConfiguration(), (long)timeout, () -> masterThread.getMaster().getServerManager() != null));
            this.htu.getConnection().getAdmin().shutdown();
            masterThread.join();
        }
        finally {
            if (hbaseCluster != null) {
                hbaseCluster.shutdown();
            }
            if (this.htu != null) {
                this.htu.shutdownMiniCluster();
                this.htu = null;
            }
        }
    }

    private static Configuration createMasterShutdownBeforeStartingAnyRegionServerConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        conf.setInt("dfs.replication", 1);
        return conf;
    }

    private static Configuration createResponsiveZkConfig(Configuration baseConf) {
        Configuration conf = HBaseConfiguration.create((Configuration)baseConf);
        conf.setInt("zookeeper.recovery.retry", 3);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 100);
        return conf;
    }
}

