/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFileWriterImpl
implements HFile.Writer {
    private static final Logger LOG = LoggerFactory.getLogger(HFileWriterImpl.class);
    private static final long UNSET = -1L;
    public static final String UNIFIED_ENCODED_BLOCKSIZE_RATIO = "hbase.writer.unified.encoded.blocksize.ratio";
    private final int encodedBlockSizeLimit;
    protected Cell lastCell = null;
    protected FSDataOutputStream outputStream;
    protected final boolean closeOutputStream;
    protected HFileInfo fileInfo = new HFileInfo();
    protected long entryCount = 0L;
    protected long totalKeyLength = 0L;
    protected long totalValueLength = 0L;
    protected long totalUncompressedBytes = 0L;
    protected List<byte[]> metaNames = new ArrayList<byte[]>();
    protected List<Writable> metaData = new ArrayList<Writable>();
    protected Cell firstCellInBlock = null;
    protected final Path path;
    protected final CacheConfig cacheConf;
    protected final String name;
    protected final HFileDataBlockEncoder blockEncoder;
    protected final HFileContext hFileContext;
    private int maxTagsLength = 0;
    public static final byte[] KEY_VALUE_VERSION = Bytes.toBytes((String)"KEY_VALUE_VERSION");
    public static final int KEY_VALUE_VER_WITH_MEMSTORE = 1;
    private List<InlineBlockWriter> inlineBlockWriters = new ArrayList<InlineBlockWriter>();
    protected HFileBlock.Writer blockWriter;
    private HFileBlockIndex.BlockIndexWriter dataBlockIndexWriter;
    private HFileBlockIndex.BlockIndexWriter metaBlockIndexWriter;
    private long firstDataBlockOffset = -1L;
    protected long lastDataBlockOffset = -1L;
    private Cell lastCellOfPreviousBlock = null;
    private List<HFileBlock.BlockWritable> additionalLoadOnOpenData = new ArrayList<HFileBlock.BlockWritable>();
    protected long maxMemstoreTS = 0L;

    public HFileWriterImpl(Configuration conf, CacheConfig cacheConf, Path path, FSDataOutputStream outputStream, HFileContext fileContext) {
        this.outputStream = outputStream;
        this.path = path;
        this.name = path != null ? path.getName() : outputStream.toString();
        this.hFileContext = fileContext;
        DataBlockEncoding encoding = this.hFileContext.getDataBlockEncoding();
        this.blockEncoder = encoding != DataBlockEncoding.NONE ? new HFileDataBlockEncoderImpl(encoding) : NoOpDataBlockEncoder.INSTANCE;
        this.closeOutputStream = path != null;
        this.cacheConf = cacheConf;
        float encodeBlockSizeRatio = conf.getFloat(UNIFIED_ENCODED_BLOCKSIZE_RATIO, 1.0f);
        this.encodedBlockSizeLimit = (int)((float)this.hFileContext.getBlocksize() * encodeBlockSizeRatio);
        this.finishInit(conf);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writer" + (path != null ? " for " + path : "") + " initialized with cacheConf: " + cacheConf + " fileContext: " + fileContext);
        }
    }

    @Override
    public void appendFileInfo(byte[] k, byte[] v) throws IOException {
        this.fileInfo.append(k, v, true);
    }

    protected final void writeFileInfo(FixedFileTrailer trailer, DataOutputStream out) throws IOException {
        trailer.setFileInfoOffset(this.outputStream.getPos());
        this.finishFileInfo();
        long startTime = System.currentTimeMillis();
        this.fileInfo.write(out);
        HFile.updateWriteLatency(System.currentTimeMillis() - startTime);
    }

    protected boolean checkKey(Cell cell) throws IOException {
        boolean isDuplicateKey = false;
        if (cell == null) {
            throw new IOException("Key cannot be null or empty");
        }
        if (this.lastCell != null) {
            int keyComp = PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)this.hFileContext.getCellComparator(), (Cell)this.lastCell, (Cell)cell);
            if (keyComp > 0) {
                String message = this.getLexicalErrorMessage(cell);
                throw new IOException(message);
            }
            if (keyComp == 0) {
                isDuplicateKey = true;
            }
        }
        return isDuplicateKey;
    }

    private String getLexicalErrorMessage(Cell cell) {
        StringBuilder sb = new StringBuilder();
        sb.append("Added a key not lexically larger than previous. Current cell = ");
        sb.append(cell);
        sb.append(", lastCell = ");
        sb.append(this.lastCell);
        sb.append("fileContext=");
        sb.append(this.hFileContext);
        return sb.toString();
    }

    protected void checkValue(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            throw new IOException("Value cannot be null");
        }
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return "writer=" + (this.path != null ? this.path.toString() : null) + ", name=" + this.name + ", compression=" + this.hFileContext.getCompression().getName();
    }

    public static Compression.Algorithm compressionByName(String algoName) {
        if (algoName == null) {
            return HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        return Compression.getCompressionAlgorithmByName((String)algoName);
    }

    protected static FSDataOutputStream createOutputStream(Configuration conf, FileSystem fs, Path path, InetSocketAddress[] favoredNodes) throws IOException {
        FsPermission perms = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)conf, (String)"hbase.data.umask");
        return FSUtils.create(conf, fs, path, perms, favoredNodes);
    }

    protected void finishInit(Configuration conf) {
        if (this.blockWriter != null) {
            throw new IllegalStateException("finishInit called twice");
        }
        this.blockWriter = new HFileBlock.Writer(this.blockEncoder, this.hFileContext, this.cacheConf.getByteBuffAllocator());
        boolean cacheIndexesOnWrite = this.cacheConf.shouldCacheIndexesOnWrite();
        this.dataBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter(this.blockWriter, cacheIndexesOnWrite ? this.cacheConf : null, cacheIndexesOnWrite ? this.name : null);
        this.dataBlockIndexWriter.setMaxChunkSize(HFileBlockIndex.getMaxChunkSize(conf));
        this.dataBlockIndexWriter.setMinIndexNumEntries(HFileBlockIndex.getMinIndexNumEntries(conf));
        this.inlineBlockWriters.add(this.dataBlockIndexWriter);
        this.metaBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter();
        LOG.trace("Initialized with {}", (Object)this.cacheConf);
    }

    protected void checkBlockBoundary() throws IOException {
        if (this.blockWriter.encodedBlockSizeWritten() >= this.encodedBlockSizeLimit || this.blockWriter.blockSizeWritten() >= this.hFileContext.getBlocksize()) {
            this.finishBlock();
            this.writeInlineBlocks(false);
            this.newBlock();
        }
    }

    private void finishBlock() throws IOException {
        if (!this.blockWriter.isWriting() || this.blockWriter.blockSizeWritten() == 0) {
            return;
        }
        if (this.firstDataBlockOffset == -1L) {
            this.firstDataBlockOffset = this.outputStream.getPos();
        }
        this.lastDataBlockOffset = this.outputStream.getPos();
        this.blockWriter.writeHeaderAndData(this.outputStream);
        int onDiskSize = this.blockWriter.getOnDiskSizeWithHeader();
        Cell indexEntry = HFileWriterImpl.getMidpoint(this.hFileContext.getCellComparator(), this.lastCellOfPreviousBlock, this.firstCellInBlock);
        this.dataBlockIndexWriter.addEntry(PrivateCellUtil.getCellKeySerializedAsKeyValueKey((Cell)indexEntry), this.lastDataBlockOffset, onDiskSize);
        this.totalUncompressedBytes += (long)this.blockWriter.getUncompressedSizeWithHeader();
        if (this.cacheConf.shouldCacheDataOnWrite()) {
            this.doCacheOnWrite(this.lastDataBlockOffset);
        }
    }

    public static Cell getMidpoint(CellComparator comparator, Cell left, Cell right) {
        boolean bufferBacked;
        if (right == null) {
            throw new IllegalArgumentException("right cell can not be null");
        }
        if (left == null) {
            return right;
        }
        if (comparator instanceof MetaCellComparator) {
            return right;
        }
        int diff = comparator.compareRows(left, right);
        if (diff > 0) {
            throw new IllegalArgumentException("Left row sorts after right row; left=" + CellUtil.getCellKeyAsString((Cell)left) + ", right=" + CellUtil.getCellKeyAsString((Cell)right));
        }
        boolean bl = bufferBacked = left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell;
        if (diff < 0) {
            byte[] midRow = bufferBacked ? HFileWriterImpl.getMinimumMidpointArray(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)left.getRowLength(), ((ByteBufferExtendedCell)right).getRowByteBuffer(), ((ByteBufferExtendedCell)right).getRowPosition(), (int)right.getRowLength()) : HFileWriterImpl.getMinimumMidpointArray(left.getRowArray(), left.getRowOffset(), (int)left.getRowLength(), right.getRowArray(), right.getRowOffset(), (int)right.getRowLength());
            if (midRow == null) {
                return right;
            }
            return PrivateCellUtil.createFirstOnRow((byte[])midRow);
        }
        diff = comparator.compareFamilies(left, right);
        if (diff > 0) {
            throw new IllegalArgumentException("Left family sorts after right family; left=" + CellUtil.getCellKeyAsString((Cell)left) + ", right=" + CellUtil.getCellKeyAsString((Cell)right));
        }
        if (diff < 0) {
            byte[] midRow = bufferBacked ? HFileWriterImpl.getMinimumMidpointArray(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)left.getFamilyLength(), ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), (int)right.getFamilyLength()) : HFileWriterImpl.getMinimumMidpointArray(left.getFamilyArray(), left.getFamilyOffset(), (int)left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), (int)right.getFamilyLength());
            if (midRow == null) {
                return right;
            }
            return PrivateCellUtil.createFirstOnRowFamily((Cell)right, (byte[])midRow, (int)0, (int)midRow.length);
        }
        diff = comparator.compareQualifiers(left, right);
        if (diff > 0) {
            throw new IllegalArgumentException("Left qualifier sorts after right qualifier; left=" + CellUtil.getCellKeyAsString((Cell)left) + ", right=" + CellUtil.getCellKeyAsString((Cell)right));
        }
        if (diff < 0) {
            byte[] midRow = bufferBacked ? HFileWriterImpl.getMinimumMidpointArray(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), left.getQualifierLength(), ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), right.getQualifierLength()) : HFileWriterImpl.getMinimumMidpointArray(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
            if (midRow == null) {
                return right;
            }
            return PrivateCellUtil.createFirstOnRowCol((Cell)right, (byte[])midRow, (int)0, (int)midRow.length);
        }
        return right;
    }

    private static byte[] getMinimumMidpointArray(byte[] leftArray, int leftOffset, int leftLength, byte[] rightArray, int rightOffset, int rightLength) {
        int diffIdx;
        int minLength = leftLength < rightLength ? leftLength : rightLength;
        for (diffIdx = 0; diffIdx < minLength && leftArray[leftOffset + diffIdx] == rightArray[rightOffset + diffIdx]; ++diffIdx) {
        }
        byte[] minimumMidpointArray = null;
        if (diffIdx >= minLength) {
            minimumMidpointArray = new byte[diffIdx + 1];
            System.arraycopy(rightArray, rightOffset, minimumMidpointArray, 0, diffIdx + 1);
        } else {
            byte diffByte = leftArray[leftOffset + diffIdx];
            if ((0xFF & diffByte) < 255 && diffByte + 1 < (rightArray[rightOffset + diffIdx] & 0xFF)) {
                minimumMidpointArray = new byte[diffIdx + 1];
                System.arraycopy(leftArray, leftOffset, minimumMidpointArray, 0, diffIdx);
                minimumMidpointArray[diffIdx] = (byte)(diffByte + 1);
            } else {
                minimumMidpointArray = new byte[diffIdx + 1];
                System.arraycopy(rightArray, rightOffset, minimumMidpointArray, 0, diffIdx + 1);
            }
        }
        return minimumMidpointArray;
    }

    private static byte[] getMinimumMidpointArray(ByteBuffer left, int leftOffset, int leftLength, ByteBuffer right, int rightOffset, int rightLength) {
        int diffIdx;
        int minLength = leftLength < rightLength ? leftLength : rightLength;
        for (diffIdx = 0; diffIdx < minLength && ByteBufferUtils.toByte((ByteBuffer)left, (int)(leftOffset + diffIdx)) == ByteBufferUtils.toByte((ByteBuffer)right, (int)(rightOffset + diffIdx)); ++diffIdx) {
        }
        byte[] minMidpoint = null;
        if (diffIdx >= minLength) {
            minMidpoint = new byte[diffIdx + 1];
            ByteBufferUtils.copyFromBufferToArray((byte[])minMidpoint, (ByteBuffer)right, (int)rightOffset, (int)0, (int)(diffIdx + 1));
        } else {
            byte diffByte = ByteBufferUtils.toByte((ByteBuffer)left, (int)(leftOffset + diffIdx));
            if ((0xFF & diffByte) < 255 && diffByte + 1 < (ByteBufferUtils.toByte((ByteBuffer)right, (int)(rightOffset + diffIdx)) & 0xFF)) {
                minMidpoint = new byte[diffIdx + 1];
                ByteBufferUtils.copyFromBufferToArray((byte[])minMidpoint, (ByteBuffer)left, (int)leftOffset, (int)0, (int)diffIdx);
                minMidpoint[diffIdx] = (byte)(diffByte + 1);
            } else {
                minMidpoint = new byte[diffIdx + 1];
                ByteBufferUtils.copyFromBufferToArray((byte[])minMidpoint, (ByteBuffer)right, (int)rightOffset, (int)0, (int)(diffIdx + 1));
            }
        }
        return minMidpoint;
    }

    private void writeInlineBlocks(boolean closing) throws IOException {
        for (InlineBlockWriter ibw : this.inlineBlockWriters) {
            while (ibw.shouldWriteBlock(closing)) {
                long offset = this.outputStream.getPos();
                boolean cacheThisBlock = ibw.getCacheOnWrite();
                ibw.writeInlineBlock(this.blockWriter.startWriting(ibw.getInlineBlockType()));
                this.blockWriter.writeHeaderAndData(this.outputStream);
                ibw.blockWritten(offset, this.blockWriter.getOnDiskSizeWithHeader(), this.blockWriter.getUncompressedSizeWithoutHeader());
                this.totalUncompressedBytes += (long)this.blockWriter.getUncompressedSizeWithHeader();
                if (!cacheThisBlock) continue;
                this.doCacheOnWrite(offset);
            }
        }
    }

    private void doCacheOnWrite(long offset) {
        this.cacheConf.getBlockCache().ifPresent(cache -> {
            HFileBlock cacheFormatBlock = this.blockWriter.getBlockForCaching(this.cacheConf);
            try {
                cache.cacheBlock(new BlockCacheKey(this.name, offset, true, cacheFormatBlock.getBlockType()), cacheFormatBlock, this.cacheConf.isInMemory(), true);
            }
            finally {
                cacheFormatBlock.release();
            }
        });
    }

    protected void newBlock() throws IOException {
        this.blockWriter.startWriting(BlockType.DATA);
        this.firstCellInBlock = null;
        if (this.lastCell != null) {
            this.lastCellOfPreviousBlock = this.lastCell;
        }
    }

    @Override
    public void appendMetaBlock(String metaBlockName, Writable content) {
        byte[] cur;
        int i;
        byte[] key = Bytes.toBytes((String)metaBlockName);
        for (i = 0; i < this.metaNames.size() && Bytes.BYTES_RAWCOMPARATOR.compare(cur = this.metaNames.get(i), 0, cur.length, key, 0, key.length) <= 0; ++i) {
        }
        this.metaNames.add(i, key);
        this.metaData.add(i, content);
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        this.blockEncoder.saveMetadata(this);
        this.finishBlock();
        this.writeInlineBlocks(true);
        FixedFileTrailer trailer = new FixedFileTrailer(this.getMajorVersion(), this.getMinorVersion());
        if (!this.metaNames.isEmpty()) {
            for (int i = 0; i < this.metaNames.size(); ++i) {
                long offset = this.outputStream.getPos();
                DataOutputStream dos = this.blockWriter.startWriting(BlockType.META);
                this.metaData.get(i).write((DataOutput)dos);
                this.blockWriter.writeHeaderAndData(this.outputStream);
                this.totalUncompressedBytes += (long)this.blockWriter.getUncompressedSizeWithHeader();
                this.metaBlockIndexWriter.addEntry(this.metaNames.get(i), offset, this.blockWriter.getOnDiskSizeWithHeader());
            }
        }
        long rootIndexOffset = this.dataBlockIndexWriter.writeIndexBlocks(this.outputStream);
        trailer.setLoadOnOpenOffset(rootIndexOffset);
        this.metaBlockIndexWriter.writeSingleLevelIndex(this.blockWriter.startWriting(BlockType.ROOT_INDEX), "meta");
        this.blockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.blockWriter.getUncompressedSizeWithHeader();
        if (this.hFileContext.isIncludesMvcc()) {
            this.appendFileInfo(MAX_MEMSTORE_TS_KEY, Bytes.toBytes((long)this.maxMemstoreTS));
            this.appendFileInfo(KEY_VALUE_VERSION, Bytes.toBytes((int)1));
        }
        this.writeFileInfo(trailer, this.blockWriter.startWriting(BlockType.FILE_INFO));
        this.blockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.blockWriter.getUncompressedSizeWithHeader();
        for (HFileBlock.BlockWritable w : this.additionalLoadOnOpenData) {
            this.blockWriter.writeBlock(w, this.outputStream);
            this.totalUncompressedBytes += (long)this.blockWriter.getUncompressedSizeWithHeader();
        }
        trailer.setNumDataIndexLevels(this.dataBlockIndexWriter.getNumLevels());
        trailer.setUncompressedDataIndexSize(this.dataBlockIndexWriter.getTotalUncompressedSize());
        trailer.setFirstDataBlockOffset(this.firstDataBlockOffset);
        trailer.setLastDataBlockOffset(this.lastDataBlockOffset);
        trailer.setComparatorClass(this.hFileContext.getCellComparator().getClass());
        trailer.setDataIndexCount(this.dataBlockIndexWriter.getNumRootEntries());
        this.finishClose(trailer);
        this.blockWriter.release();
    }

    @Override
    public void addInlineBlockWriter(InlineBlockWriter ibw) {
        this.inlineBlockWriters.add(ibw);
    }

    @Override
    public void addGeneralBloomFilter(BloomFilterWriter bfw) {
        this.addBloomFilter(bfw, BlockType.GENERAL_BLOOM_META);
    }

    @Override
    public void addDeleteFamilyBloomFilter(BloomFilterWriter bfw) {
        this.addBloomFilter(bfw, BlockType.DELETE_FAMILY_BLOOM_META);
    }

    private void addBloomFilter(final BloomFilterWriter bfw, final BlockType blockType) {
        if (bfw.getKeyCount() <= 0L) {
            return;
        }
        if (blockType != BlockType.GENERAL_BLOOM_META && blockType != BlockType.DELETE_FAMILY_BLOOM_META) {
            throw new RuntimeException("Block Type: " + blockType.toString() + "is not supported");
        }
        this.additionalLoadOnOpenData.add(new HFileBlock.BlockWritable(){

            @Override
            public BlockType getBlockType() {
                return blockType;
            }

            @Override
            public void writeToBlock(DataOutput out) throws IOException {
                bfw.getMetaWriter().write(out);
                Writable dataWriter = bfw.getDataWriter();
                if (dataWriter != null) {
                    dataWriter.write(out);
                }
            }
        });
    }

    @Override
    public HFileContext getFileContext() {
        return this.hFileContext;
    }

    @Override
    public void append(Cell cell) throws IOException {
        boolean dupKey = this.checkKey(cell);
        if (!dupKey) {
            this.checkBlockBoundary();
        }
        if (!this.blockWriter.isWriting()) {
            this.newBlock();
        }
        this.blockWriter.write(cell);
        this.totalKeyLength += (long)PrivateCellUtil.estimatedSerializedSizeOfKey((Cell)cell);
        this.totalValueLength += (long)cell.getValueLength();
        if (this.firstCellInBlock == null) {
            this.firstCellInBlock = cell;
        }
        this.lastCell = cell;
        ++this.entryCount;
        this.maxMemstoreTS = Math.max(this.maxMemstoreTS, cell.getSequenceId());
        int tagsLength = cell.getTagsLength();
        if (tagsLength > this.maxTagsLength) {
            this.maxTagsLength = tagsLength;
        }
    }

    @Override
    public void beforeShipped() throws IOException {
        this.blockWriter.beforeShipped();
        if (this.lastCell != null) {
            this.lastCell = KeyValueUtil.toNewKeyCell((Cell)this.lastCell);
        }
        if (this.firstCellInBlock != null) {
            this.firstCellInBlock = KeyValueUtil.toNewKeyCell((Cell)this.firstCellInBlock);
        }
        if (this.lastCellOfPreviousBlock != null) {
            this.lastCellOfPreviousBlock = KeyValueUtil.toNewKeyCell((Cell)this.lastCellOfPreviousBlock);
        }
    }

    public Cell getLastCell() {
        return this.lastCell;
    }

    protected void finishFileInfo() throws IOException {
        if (this.lastCell != null) {
            byte[] lastKey = PrivateCellUtil.getCellKeySerializedAsKeyValueKey((Cell)this.lastCell);
            this.fileInfo.append(HFileInfo.LASTKEY, lastKey, false);
        }
        int avgKeyLen = this.entryCount == 0L ? 0 : (int)(this.totalKeyLength / this.entryCount);
        this.fileInfo.append(HFileInfo.AVG_KEY_LEN, Bytes.toBytes((int)avgKeyLen), false);
        this.fileInfo.append(HFileInfo.CREATE_TIME_TS, Bytes.toBytes((long)this.hFileContext.getFileCreateTime()), false);
        int avgValueLen = this.entryCount == 0L ? 0 : (int)(this.totalValueLength / this.entryCount);
        this.fileInfo.append(HFileInfo.AVG_VALUE_LEN, Bytes.toBytes((int)avgValueLen), false);
        if (this.hFileContext.isIncludesTags()) {
            this.fileInfo.append(HFileInfo.MAX_TAGS_LEN, Bytes.toBytes((int)this.maxTagsLength), false);
            boolean tagsCompressed = this.hFileContext.getDataBlockEncoding() != DataBlockEncoding.NONE && this.hFileContext.isCompressTags();
            this.fileInfo.append(HFileInfo.TAGS_COMPRESSED, Bytes.toBytes((boolean)tagsCompressed), false);
        }
    }

    protected int getMajorVersion() {
        return 3;
    }

    protected int getMinorVersion() {
        return 3;
    }

    protected void finishClose(FixedFileTrailer trailer) throws IOException {
        Encryption.Context cryptoContext = this.hFileContext.getEncryptionContext();
        if (cryptoContext != Encryption.Context.NONE) {
            trailer.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)cryptoContext.getConf(), (String)cryptoContext.getConf().get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)cryptoContext.getKey()));
        }
        trailer.setMetaIndexCount(this.metaNames.size());
        trailer.setTotalUncompressedBytes(this.totalUncompressedBytes + (long)trailer.getTrailerSize());
        trailer.setEntryCount(this.entryCount);
        trailer.setCompressionCodec(this.hFileContext.getCompression());
        long startTime = System.currentTimeMillis();
        trailer.serialize((DataOutputStream)this.outputStream);
        HFile.updateWriteLatency(System.currentTimeMillis() - startTime);
        if (this.closeOutputStream) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }
}

