/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.ChecksumUtil;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestChecksum {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestChecksum.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestChecksum.class);
    static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    static final int[] BYTES_PER_CHECKSUM = new int[]{50, 500, 688, 16384, 17364, 65536};
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private FileSystem fs;
    private HFileSystem hfs;

    @Before
    public void setUp() throws Exception {
        this.fs = HFileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        this.hfs = (HFileSystem)this.fs;
    }

    @Test
    public void testNewBlocksHaveDefaultChecksum() throws IOException {
        Path path = new Path(TEST_UTIL.getDataTestDir(), "default_checksum");
        FSDataOutputStream os = this.fs.create(path);
        HFileContext meta = new HFileContextBuilder().build();
        HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
        DataOutputStream dos = hbw.startWriting(BlockType.DATA);
        for (int i = 0; i < 1000; ++i) {
            dos.writeInt(i);
        }
        hbw.writeHeaderAndData(os);
        int totalSize = hbw.getOnDiskSizeWithHeader();
        os.close();
        Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
        FSDataInputStreamWrapper is = new FSDataInputStreamWrapper(this.fs, path);
        meta = new HFileContextBuilder().withHBaseCheckSum(true).build();
        ReaderContext context = new ReaderContextBuilder().withInputStreamWrapper(is).withFileSize((long)totalSize).withFileSystem((HFileSystem)this.fs).withFilePath(path).build();
        HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(context, meta, ByteBuffAllocator.HEAP);
        HFileBlock b = hbr.readBlockData(0L, -1L, false, false, true);
        Assert.assertTrue((!b.isSharedMem() ? 1 : 0) != 0);
        Assert.assertEquals((long)b.getChecksumType(), (long)ChecksumType.getDefaultChecksumType().getCode());
    }

    private void verifyMBBCheckSum(ByteBuff buf) throws IOException {
        int size = buf.remaining() / 2 + 1;
        MultiByteBuff mbb = new MultiByteBuff(new ByteBuffer[]{ByteBuffer.allocate(size), ByteBuffer.allocate(size)}).position(0).limit(buf.remaining());
        for (int i = buf.position(); i < buf.limit(); ++i) {
            mbb.put(buf.get(i));
        }
        mbb.position(0).limit(buf.remaining());
        Assert.assertEquals((long)mbb.remaining(), (long)buf.remaining());
        Assert.assertTrue((mbb.remaining() > size ? 1 : 0) != 0);
        ChecksumUtil.validateChecksum((ByteBuff)mbb, (String)"test", (long)0L, (int)24);
    }

    private void verifySBBCheckSum(ByteBuff buf) throws IOException {
        ChecksumUtil.validateChecksum((ByteBuff)buf, (String)"test", (long)0L, (int)24);
    }

    @Test
    public void testVerifyCheckSum() throws IOException {
        int intCount = 10000;
        for (ChecksumType ckt : ChecksumType.values()) {
            Path path = new Path(TEST_UTIL.getDataTestDir(), "checksum" + ckt.getName());
            FSDataOutputStream os = this.fs.create(path);
            HFileContext meta = new HFileContextBuilder().withChecksumType(ckt).build();
            HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
            DataOutputStream dos = hbw.startWriting(BlockType.DATA);
            for (int i = 0; i < intCount; ++i) {
                dos.writeInt(i);
            }
            hbw.writeHeaderAndData(os);
            int totalSize = hbw.getOnDiskSizeWithHeader();
            os.close();
            Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
            FSDataInputStreamWrapper is = new FSDataInputStreamWrapper(this.fs, path);
            meta = new HFileContextBuilder().withHBaseCheckSum(true).build();
            ReaderContext context = new ReaderContextBuilder().withInputStreamWrapper(is).withFileSize((long)totalSize).withFileSystem((HFileSystem)this.fs).withFilePath(path).build();
            HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(context, meta, ByteBuffAllocator.HEAP);
            HFileBlock b = hbr.readBlockData(0L, -1L, false, false, true);
            Assert.assertTrue((!b.isSharedMem() ? 1 : 0) != 0);
            ByteBuff bufferWithChecksum = this.getBufferWithChecksum(b);
            this.verifySBBCheckSum(bufferWithChecksum);
            this.verifyMBBCheckSum(bufferWithChecksum);
            ByteBuff data = b.getBufferWithoutHeader();
            for (int i = 0; i < intCount; ++i) {
                Assert.assertEquals((long)i, (long)data.getInt());
            }
            try {
                data.getInt();
                Assert.fail();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
        }
    }

    private ByteBuff getBufferWithChecksum(HFileBlock block) throws IOException {
        ByteBuff buf = block.getBufferReadOnly();
        int numBytes = (int)ChecksumUtil.numBytes((long)buf.remaining(), (int)block.getHFileContext().getBytesPerChecksum());
        byte[] checksum = new byte[numBytes];
        ChecksumUtil.generateChecksums((byte[])buf.array(), (int)0, (int)buf.limit(), (byte[])checksum, (int)0, (ChecksumType)block.getHFileContext().getChecksumType(), (int)block.getBytesPerChecksum());
        ByteBuff bufWithChecksum = ByteBuffAllocator.HEAP.allocate(buf.limit() + numBytes);
        bufWithChecksum.put(buf.array(), 0, buf.limit());
        bufWithChecksum.put(checksum);
        return bufWithChecksum.rewind();
    }

    @Test
    public void testChecksumCorruption() throws IOException {
        this.testChecksumCorruptionInternals(false);
        this.testChecksumCorruptionInternals(true);
    }

    protected void testChecksumCorruptionInternals(boolean useTags) throws IOException {
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : new boolean[]{false, true}) {
                LOG.info("testChecksumCorruption: Compression algorithm: " + algo + ", pread=" + pread);
                Path path = new Path(TEST_UTIL.getDataTestDir(), "blocks_v2_" + algo);
                FSDataOutputStream os = this.fs.create(path);
                HFileContext meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withBytesPerCheckSum(16384).build();
                HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
                long totalSize = 0L;
                for (int blockId = 0; blockId < 2; ++blockId) {
                    DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                    }
                    hbw.writeHeaderAndData(os);
                    totalSize += (long)hbw.getOnDiskSizeWithHeader();
                }
                os.close();
                Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
                FSDataInputStreamWrapper is = new FSDataInputStreamWrapper(this.fs, path);
                meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withHBaseCheckSum(true).build();
                ReaderContext context = new ReaderContextBuilder().withInputStreamWrapper(is).withFileSize(totalSize).withFileSystem(this.fs).withFilePath(path).build();
                CorruptedFSReaderImpl hbr = new CorruptedFSReaderImpl(context, meta);
                HFileBlock b = hbr.readBlockData(0L, -1L, pread, false, true);
                b.sanityCheck();
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                ByteBuff bb = b.unpack(meta, (HFileBlock.FSReader)hbr).getBufferWithoutHeader();
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(bb.array(), bb.arrayOffset(), bb.limit()));
                Assert.assertEquals((long)1L, (long)HFile.getAndResetChecksumFailuresCount());
                this.validateData(in);
                for (int i = 0; i < 4; ++i) {
                    b = hbr.readBlockData(0L, -1L, pread, false, true);
                    Assert.assertTrue((boolean)(b.getBufferReadOnly() instanceof SingleByteBuff));
                    Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
                }
                b = hbr.readBlockData(0L, -1L, pread, false, true);
                Assert.assertTrue((boolean)(b.getBufferReadOnly() instanceof SingleByteBuff));
                Assert.assertEquals((long)1L, (long)HFile.getAndResetChecksumFailuresCount());
                b = hbr.readBlockData(0L, -1L, pread, false, true);
                Assert.assertTrue((boolean)(b.getBufferReadOnly() instanceof SingleByteBuff));
                Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
                is.close();
                HFileSystem newfs = new HFileSystem(TEST_UTIL.getConfiguration(), false);
                Assert.assertEquals((Object)false, (Object)newfs.useHBaseChecksum());
                is = new FSDataInputStreamWrapper((FileSystem)newfs, path);
                context = new ReaderContextBuilder().withInputStreamWrapper(is).withFileSize(totalSize).withFileSystem(newfs).withFilePath(path).build();
                hbr = new CorruptedFSReaderImpl(context, meta);
                b = hbr.readBlockData(0L, -1L, pread, false, true);
                is.close();
                b.sanityCheck();
                b = b.unpack(meta, (HFileBlock.FSReader)hbr);
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                bb = b.getBufferWithoutHeader();
                in = new DataInputStream(new ByteArrayInputStream(bb.array(), bb.arrayOffset(), bb.limit()));
                Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
                this.validateData(in);
            }
        }
    }

    @Test
    public void testChecksumChunks() throws IOException {
        this.testChecksumInternals(false);
        this.testChecksumInternals(true);
    }

    protected void testChecksumInternals(boolean useTags) throws IOException {
        Compression.Algorithm algo = Compression.Algorithm.NONE;
        for (boolean pread : new boolean[]{false, true}) {
            for (int bytesPerChecksum : BYTES_PER_CHECKSUM) {
                Path path = new Path(TEST_UTIL.getDataTestDir(), "checksumChunk_" + algo + bytesPerChecksum);
                FSDataOutputStream os = this.fs.create(path);
                HFileContext meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withHBaseCheckSum(true).withBytesPerCheckSum(bytesPerChecksum).build();
                HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
                long dataSize = 0L;
                DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                while (dataSize < (long)(6 * bytesPerChecksum)) {
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                        dataSize += 4L;
                    }
                }
                hbw.writeHeaderAndData(os);
                long totalSize = hbw.getOnDiskSizeWithHeader();
                os.close();
                long expectedChunks = ChecksumUtil.numChunks((long)(dataSize + 33L), (int)bytesPerChecksum);
                LOG.info("testChecksumChunks: pread={}, bytesPerChecksum={}, fileSize={}, dataSize={}, expectedChunks={}, compression={}", new Object[]{pread, bytesPerChecksum, totalSize, dataSize, expectedChunks, algo.toString()});
                Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
                FSDataInputStream is = this.fs.open(path);
                FSDataInputStream nochecksum = this.hfs.getNoChecksumFs().open(path);
                meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withHBaseCheckSum(true).withBytesPerCheckSum(bytesPerChecksum).build();
                ReaderContext context = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(is, nochecksum)).withFileSize(totalSize).withFileSystem(this.hfs).withFilePath(path).build();
                HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(context, meta, ByteBuffAllocator.HEAP);
                HFileBlock b = hbr.readBlockData(0L, -1L, pread, false, true);
                Assert.assertTrue((boolean)(b.getBufferReadOnly() instanceof SingleByteBuff));
                is.close();
                b.sanityCheck();
                Assert.assertEquals((long)dataSize, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)totalSize, (long)(33L + dataSize + expectedChunks * 4L));
                Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
            }
        }
    }

    private void validateData(DataInputStream in) throws IOException {
        for (int i = 0; i < 1234; ++i) {
            int val = in.readInt();
            Assert.assertEquals((String)("testChecksumCorruption: data mismatch at index " + i), (long)i, (long)val);
        }
    }

    private static class CorruptedFSReaderImpl
    extends HFileBlock.FSReaderImpl {
        boolean corruptDataStream = false;

        public CorruptedFSReaderImpl(ReaderContext context, HFileContext meta) throws IOException {
            super(context, meta, ByteBuffAllocator.HEAP);
        }

        protected HFileBlock readBlockDataInternal(FSDataInputStream is, long offset, long onDiskSizeWithHeaderL, boolean pread, boolean verifyChecksum, boolean updateMetrics, boolean useHeap) throws IOException {
            if (verifyChecksum) {
                this.corruptDataStream = true;
            }
            HFileBlock b = super.readBlockDataInternal(is, offset, onDiskSizeWithHeaderL, pread, verifyChecksum, updateMetrics, useHeap);
            this.corruptDataStream = false;
            return b;
        }

        protected boolean readAtOffset(FSDataInputStream istream, ByteBuff dest, int size, boolean peekIntoNextBlock, long fileOffset, boolean pread) throws IOException {
            int destOffset = dest.position();
            boolean returnValue = super.readAtOffset(istream, dest, size, peekIntoNextBlock, fileOffset, pread);
            if (!this.corruptDataStream) {
                return returnValue;
            }
            if (peekIntoNextBlock) {
                dest.put(destOffset + size + 3, (byte)0);
            }
            dest.put(destOffset + 1, (byte)0);
            if (size > this.hdrSize) {
                dest.put(destOffset + this.hdrSize + 1, (byte)0);
            }
            return returnValue;
        }
    }
}

