/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.MetricsIO;
import org.apache.hadoop.hbase.io.MetricsIOWrapperImpl;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFilePreadReader;
import org.apache.hadoop.hbase.io.hfile.HFilePrettyPrinter;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileStreamReader;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class HFile {
    static final Logger LOG = LoggerFactory.getLogger(HFile.class);
    public static final int MAXIMUM_KEY_LENGTH = Integer.MAX_VALUE;
    public static final Compression.Algorithm DEFAULT_COMPRESSION_ALGORITHM = Compression.Algorithm.NONE;
    public static final int MIN_FORMAT_VERSION = 2;
    public static final int MAX_FORMAT_VERSION = 3;
    public static final int MIN_FORMAT_VERSION_WITH_TAGS = 3;
    public static final String DEFAULT_COMPRESSION = DEFAULT_COMPRESSION_ALGORITHM.getName();
    public static final String BLOOM_FILTER_DATA_KEY = "BLOOM_FILTER_DATA";
    public static final int MIN_NUM_HFILE_PATH_LEVELS = 5;
    public static final int DEFAULT_BYTES_PER_CHECKSUM = 16384;
    static final LongAdder CHECKSUM_FAILURES = new LongAdder();
    public static final LongAdder DATABLOCK_READ_COUNT = new LongAdder();
    static final MetricsIO metrics = new MetricsIO(new MetricsIOWrapperImpl());
    public static final String FORMAT_VERSION_KEY = "hfile.format.version";

    private HFile() {
    }

    public static final long getAndResetChecksumFailuresCount() {
        return CHECKSUM_FAILURES.sumThenReset();
    }

    public static final long getChecksumFailuresCount() {
        return CHECKSUM_FAILURES.sum();
    }

    public static final void updateReadLatency(long latencyMillis, boolean pread) {
        if (pread) {
            metrics.updateFsPreadTime(latencyMillis);
        } else {
            metrics.updateFsReadTime(latencyMillis);
        }
    }

    public static final void updateWriteLatency(long latencyMillis) {
        metrics.updateFsWriteTime(latencyMillis);
    }

    public static int getFormatVersion(Configuration conf) {
        int version = conf.getInt(FORMAT_VERSION_KEY, 3);
        HFile.checkFormatVersion(version);
        return version;
    }

    public static final WriterFactory getWriterFactoryNoCache(Configuration conf) {
        return HFile.getWriterFactory(conf, CacheConfig.DISABLED);
    }

    public static final WriterFactory getWriterFactory(Configuration conf, CacheConfig cacheConf) {
        int version = HFile.getFormatVersion(conf);
        switch (version) {
            case 2: {
                throw new IllegalArgumentException("This should never happen. Did you change hfile.format.version to read v2? This version of the software writes v3 hfiles only (but it can read v2 files without having to update hfile.format.version in hbase-site.xml)");
            }
            case 3: {
                return new WriterFactory(conf, cacheConf);
            }
        }
        throw new IllegalArgumentException("Cannot create writer for HFile format version " + version);
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="Intentional")
    public static Reader createReader(ReaderContext context, HFileInfo fileInfo, CacheConfig cacheConf, Configuration conf) throws IOException {
        try {
            if (context.getReaderType() == ReaderContext.ReaderType.STREAM) {
                HFileStreamReader hFileStreamReader = new HFileStreamReader(context, fileInfo, cacheConf, conf);
                return hFileStreamReader;
            }
            FixedFileTrailer trailer = fileInfo.getTrailer();
            switch (trailer.getMajorVersion()) {
                case 2: {
                    LOG.debug("Opening HFile v2 with v3 reader");
                }
                case 3: {
                    HFilePreadReader hFilePreadReader = new HFilePreadReader(context, fileInfo, cacheConf, conf);
                    return hFilePreadReader;
                }
            }
            try {
                throw new IllegalArgumentException("Invalid HFile version " + trailer.getMajorVersion());
            }
            catch (Throwable t) {
                IOUtils.closeQuietly((Closeable)context.getInputStreamWrapper());
                throw new CorruptHFileException("Problem reading HFile Trailer from file " + context.getFilePath(), t);
            }
        }
        finally {
            context.getInputStreamWrapper().unbuffer();
        }
    }

    public static Reader createReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        return HFile.createReader(fs, path, CacheConfig.DISABLED, true, conf);
    }

    public static Reader createReader(FileSystem fs, Path path, CacheConfig cacheConf, boolean primaryReplicaReader, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)cacheConf, (Object)"Cannot create Reader with null CacheConf");
        FSDataInputStreamWrapper stream = new FSDataInputStreamWrapper(fs, path);
        ReaderContext context = new ReaderContextBuilder().withFilePath(path).withInputStreamWrapper(stream).withFileSize(fs.getFileStatus(path).getLen()).withFileSystem(stream.getHfs()).withPrimaryReplicaReader(primaryReplicaReader).withReaderType(ReaderContext.ReaderType.PREAD).build();
        HFileInfo fileInfo = new HFileInfo(context, conf);
        Reader reader = HFile.createReader(context, fileInfo, cacheConf, conf);
        fileInfo.initMetaAndIndex(reader);
        return reader;
    }

    public static boolean isHFileFormat(FileSystem fs, Path path) throws IOException {
        return HFile.isHFileFormat(fs, fs.getFileStatus(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHFileFormat(FileSystem fs, FileStatus fileStatus) throws IOException {
        Path path = fileStatus.getPath();
        long size = fileStatus.getLen();
        try (FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(fs, path);){
            boolean isHBaseChecksum = fsdis.shouldUseHBaseChecksum();
            assert (!isHBaseChecksum);
            FixedFileTrailer.readFromStream(fsdis.getStream(isHBaseChecksum), size);
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return Compression.getSupportedAlgorithms();
    }

    static int longToInt(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public static List<Path> getStoreFiles(FileSystem fs, Path regionDir) throws IOException {
        FileStatus[] familyDirs;
        ArrayList<Path> regionHFiles = new ArrayList<Path>();
        FSUtils.DirFilter dirFilter = new FSUtils.DirFilter(fs);
        for (FileStatus dir : familyDirs = fs.listStatus(regionDir, (PathFilter)dirFilter)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(dir.getPath())) {
                if (file.isDirectory() || file.getPath().toString().contains("oldWALs") || file.getPath().toString().contains("recovered.edits")) continue;
                regionHFiles.add(file.getPath());
            }
        }
        return regionHFiles;
    }

    public static void checkFormatVersion(int version) throws IllegalArgumentException {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("Invalid HFile version: " + version + " (expected to be between " + 2 + " and " + 3 + ")");
        }
    }

    public static void checkHFileVersion(Configuration c) {
        int version = c.getInt(FORMAT_VERSION_KEY, 3);
        if (version < 3 || version > 3) {
            throw new IllegalArgumentException("The setting for hfile.format.version (in your hbase-*.xml files) is " + version + " which does not match " + 3 + "; are you running with a configuration from an older or newer hbase install (an incompatible hbase-default.xml or hbase-site.xml on your CLASSPATH)?");
        }
    }

    public static void main(String[] args) throws Exception {
        HFilePrettyPrinter.main(args);
    }

    public static interface Reader
    extends Closeable,
    CachingBlockReader {
        public String getName();

        public CellComparator getComparator();

        public HFileScanner getScanner(boolean var1, boolean var2, boolean var3);

        public HFileBlock getMetaBlock(String var1, boolean var2) throws IOException;

        public Optional<Cell> getLastKey();

        public Optional<Cell> midKey() throws IOException;

        public long length();

        public long getEntries();

        public Optional<Cell> getFirstKey();

        public long indexSize();

        public Optional<byte[]> getFirstRowKey();

        public Optional<byte[]> getLastRowKey();

        public FixedFileTrailer getTrailer();

        public void setDataBlockIndexReader(HFileBlockIndex.CellBasedKeyBlockIndexReader var1);

        public HFileBlockIndex.CellBasedKeyBlockIndexReader getDataBlockIndexReader();

        public void setMetaBlockIndexReader(HFileBlockIndex.ByteArrayKeyBlockIndexReader var1);

        public HFileBlockIndex.ByteArrayKeyBlockIndexReader getMetaBlockIndexReader();

        public HFileScanner getScanner(boolean var1, boolean var2);

        public DataInput getGeneralBloomFilterMetadata() throws IOException;

        public DataInput getDeleteBloomFilterMetadata() throws IOException;

        public Path getPath();

        public void close(boolean var1) throws IOException;

        public DataBlockEncoding getDataBlockEncoding();

        public boolean hasMVCCInfo();

        public HFileContext getFileContext();

        public boolean isPrimaryReplicaReader();

        public DataBlockEncoding getEffectiveEncodingInCache(boolean var1);

        public HFileBlock.FSReader getUncachedBlockReader();

        public boolean prefetchComplete();

        public void unbufferStream();

        public ReaderContext getContext();

        public HFileInfo getHFileInfo();

        public void setDataBlockEncoder(HFileDataBlockEncoder var1);
    }

    public static interface CachingBlockReader {
        public HFileBlock readBlock(long var1, long var3, boolean var5, boolean var6, boolean var7, boolean var8, BlockType var9, DataBlockEncoding var10) throws IOException;
    }

    public static class WriterFactory {
        protected final Configuration conf;
        protected final CacheConfig cacheConf;
        protected FileSystem fs;
        protected Path path;
        protected FSDataOutputStream ostream;
        protected InetSocketAddress[] favoredNodes;
        private HFileContext fileContext;
        protected boolean shouldDropBehind = false;

        WriterFactory(Configuration conf, CacheConfig cacheConf) {
            this.conf = conf;
            this.cacheConf = cacheConf;
        }

        public WriterFactory withPath(FileSystem fs, Path path) {
            Preconditions.checkNotNull((Object)fs);
            Preconditions.checkNotNull((Object)path);
            this.fs = fs;
            this.path = path;
            return this;
        }

        public WriterFactory withOutputStream(FSDataOutputStream ostream) {
            Preconditions.checkNotNull((Object)ostream);
            this.ostream = ostream;
            return this;
        }

        public WriterFactory withFavoredNodes(InetSocketAddress[] favoredNodes) {
            this.favoredNodes = favoredNodes;
            return this;
        }

        public WriterFactory withFileContext(HFileContext fileContext) {
            this.fileContext = fileContext;
            return this;
        }

        public WriterFactory withShouldDropCacheBehind(boolean shouldDropBehind) {
            this.shouldDropBehind = shouldDropBehind;
            return this;
        }

        public Writer create() throws IOException {
            if ((this.path != null ? 1 : 0) + (this.ostream != null ? 1 : 0) != 1) {
                throw new AssertionError((Object)"Please specify exactly one of filesystem/path or path");
            }
            if (this.path != null) {
                this.ostream = HFileWriterImpl.createOutputStream(this.conf, this.fs, this.path, this.favoredNodes);
                try {
                    this.ostream.setDropBehind(Boolean.valueOf(this.shouldDropBehind && this.cacheConf.shouldDropBehindCompaction()));
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.trace("Unable to set drop behind on {}", (Object)this.path, (Object)uoe);
                    LOG.debug("Unable to set drop behind on {}", (Object)this.path.getName());
                }
            }
            return new HFileWriterImpl(this.conf, this.cacheConf, this.path, this.ostream, this.fileContext);
        }
    }

    public static interface Writer
    extends Closeable,
    CellSink,
    ShipperListener {
        public static final byte[] MAX_MEMSTORE_TS_KEY = Bytes.toBytes((String)"MAX_MEMSTORE_TS_KEY");

        public void appendFileInfo(byte[] var1, byte[] var2) throws IOException;

        public Path getPath();

        public void addInlineBlockWriter(InlineBlockWriter var1);

        public void appendMetaBlock(String var1, Writable var2);

        public void addGeneralBloomFilter(BloomFilterWriter var1);

        public void addDeleteFamilyBloomFilter(BloomFilterWriter var1) throws IOException;

        public HFileContext getFileContext();
    }
}

