/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class HFileLinkCleaner
extends BaseHFileCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(HFileLinkCleaner.class);
    private FileSystem fs = null;

    @Override
    public synchronized boolean isFileDeletable(FileStatus fStat) {
        if (this.fs == null) {
            return false;
        }
        Path filePath = fStat.getPath();
        if (HFileLink.isHFileLink(filePath)) {
            return true;
        }
        Path parentDir = filePath.getParent();
        if (HFileLink.isBackReferencesDir(parentDir)) {
            Path hfilePath = null;
            try {
                hfilePath = HFileLink.getHFileFromBackReference(new Path(CommonFSUtils.getRootDir((Configuration)this.getConf()), ".tmp"), filePath);
                if (this.fs.exists(hfilePath)) {
                    return false;
                }
                hfilePath = HFileLink.getHFileFromBackReference(MobUtils.getMobHome(this.getConf()), filePath);
                if (this.fs.exists(hfilePath)) {
                    return false;
                }
                hfilePath = HFileLink.getHFileFromBackReference(CommonFSUtils.getRootDir((Configuration)this.getConf()), filePath);
                return !this.fs.exists(hfilePath);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Couldn't verify if the referenced file still exists, keep it just in case: " + hfilePath);
                }
                return false;
            }
        }
        Path backRefDir = null;
        try {
            backRefDir = HFileLink.getBackReferencesDir(parentDir, filePath.getName());
            return CommonFSUtils.listStatus((FileSystem)this.fs, (Path)backRefDir) == null;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't get the references, not deleting file, just in case. filePath=" + filePath + ", backRefDir=" + backRefDir);
            }
            return false;
        }
    }

    public synchronized void setConf(Configuration conf) {
        block2: {
            super.setConf(conf);
            try {
                this.fs = FileSystem.get((Configuration)this.getConf());
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Couldn't instantiate the file system, not deleting file, just in case. fs.defaultFS=" + this.getConf().get("fs.defaultFS", "file:///"));
            }
        }
    }
}

