/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class RingBufferTruck {
    private Type type = Type.EMPTY;
    private SyncFuture sync;
    private FSWALEntry entry;

    RingBufferTruck() {
    }

    void load(FSWALEntry entry) {
        this.entry = entry;
        this.type = Type.APPEND;
    }

    void load(SyncFuture syncFuture) {
        this.sync = syncFuture;
        this.type = Type.SYNC;
    }

    Type type() {
        return this.type;
    }

    FSWALEntry unloadAppend() {
        FSWALEntry entry = this.entry;
        this.entry = null;
        this.type = Type.EMPTY;
        return entry;
    }

    SyncFuture unloadSync() {
        SyncFuture sync = this.sync;
        this.sync = null;
        this.type = Type.EMPTY;
        return sync;
    }

    public static enum Type {
        APPEND,
        SYNC,
        EMPTY;

    }
}

