/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    private static int MAX_KEY_VALUE_SIZE = 65536;
    private static AsyncConnection ASYNC_CONN;
    @Rule
    public TestName testName = new TestName();
    private byte[] row;
    @Parameterized.Parameter
    public Supplier<AsyncTable<?>> getTable;

    private static AsyncTable<?> getRawTable() {
        return ASYNC_CONN.getTable(TABLE_NAME);
    }

    private static AsyncTable<?> getTable() {
        return ASYNC_CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({TestAsyncTable::getRawTable}, {TestAsyncTable::getTable});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.keyvalue.maxsize", MAX_KEY_VALUE_SIZE);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        Assert.assertFalse((boolean)ASYNC_CONN.isClosed());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        IOUtils.closeQuietly((Closeable)ASYNC_CONN);
        Assert.assertTrue((boolean)ASYNC_CONN.isClosed());
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException, ExecutionException {
        this.row = Bytes.toBytes((String)this.testName.getMethodName().replaceAll("[^0-9A-Za-z]", "_"));
        if (((Boolean)ASYNC_CONN.getAdmin().isTableDisabled(TABLE_NAME).get()).booleanValue()) {
            ASYNC_CONN.getAdmin().enableTable(TABLE_NAME).get();
        }
    }

    @Test
    public void testSimple() throws Exception {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).get();
        Assert.assertTrue((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()));
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
        table.delete(new Delete(this.row)).get();
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()));
    }

    private byte[] concat(byte[] base, int index) {
        return Bytes.toBytes((String)(Bytes.toString((byte[])base) + "-" + index));
    }

    @Test
    public void testSimpleMultiple() throws Exception {
        int i2;
        AsyncTable<?> table = this.getTable.get();
        int count = 100;
        CountDownLatch putLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER, this.concat(VALUE, i))).thenAccept(x -> putLatch.countDown()));
        putLatch.await();
        ArrayBlockingQueue existsResp = new ArrayBlockingQueue(count);
        IntStream.range(0, count).forEach(i -> table.exists(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> existsResp.add(x)));
        for (int i3 = 0; i3 < count; ++i3) {
            Assert.assertTrue((boolean)((Boolean)existsResp.take()));
        }
        ArrayBlockingQueue getResp = new ArrayBlockingQueue(count);
        IntStream.range(0, count).forEach(i -> table.get(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> getResp.add(Pair.newPair((Object)i, (Object)x))));
        for (int i4 = 0; i4 < count; ++i4) {
            Pair pair = (Pair)getResp.take();
            Assert.assertArrayEquals((byte[])this.concat(VALUE, (Integer)pair.getFirst()), (byte[])((Result)pair.getSecond()).getValue(FAMILY, QUALIFIER));
        }
        CountDownLatch deleteLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.delete(new Delete(this.concat(this.row, i))).thenAccept(x -> deleteLatch.countDown()));
        deleteLatch.await();
        IntStream.range(0, count).forEach(i -> table.exists(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> existsResp.add(x)));
        for (i2 = 0; i2 < count; ++i2) {
            Assert.assertFalse((boolean)((Boolean)existsResp.take()));
        }
        IntStream.range(0, count).forEach(i -> table.get(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> getResp.add(Pair.newPair((Object)i, (Object)x))));
        for (i2 = 0; i2 < count; ++i2) {
            Pair pair = (Pair)getResp.take();
            Assert.assertTrue((boolean)((Result)pair.getSecond()).isEmpty());
        }
    }

    @Test
    public void testIncrement() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 100;
        CountDownLatch latch = new CountDownLatch(count);
        AtomicLong sum = new AtomicLong(0L);
        IntStream.range(0, count).forEach(i -> table.incrementColumnValue(this.row, FAMILY, QUALIFIER, 1L).thenAccept(x -> {
            sum.addAndGet((long)x);
            latch.countDown();
        }));
        latch.await();
        Assert.assertEquals((long)count, (long)Bytes.toLong((byte[])((Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()).getValue(FAMILY, QUALIFIER)));
        Assert.assertEquals((long)((1 + count) * count / 2), (long)sum.get());
    }

    @Test
    public void testAppend() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch latch = new CountDownLatch(count);
        char suffix = ':';
        AtomicLong suffixCount = new AtomicLong(0L);
        IntStream.range(0, count).forEachOrdered(i -> table.append(new Append(this.row).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("" + i + suffix)))).thenAccept(r -> {
            suffixCount.addAndGet(Bytes.toString((byte[])r.getValue(FAMILY, QUALIFIER)).chars().filter(x -> x == suffix).count());
            latch.countDown();
        }));
        latch.await();
        Assert.assertEquals((long)((1 + count) * count / 2), (long)suffixCount.get());
        String value = Bytes.toString((byte[])((Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()).getValue(FAMILY, QUALIFIER));
        int[] actual = Arrays.asList(value.split("" + suffix)).stream().mapToInt(Integer::parseInt).sorted().toArray();
        Assert.assertArrayEquals((int[])IntStream.range(0, count).toArray(), (int[])actual);
    }

    @Test
    public void testMutateRow() throws InterruptedException, ExecutionException, IOException {
        AsyncTable<?> table = this.getTable.get();
        RowMutations mutation = new RowMutations(this.row);
        mutation.add(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 1), VALUE));
        Result result = (Result)table.mutateRow(mutation).get();
        Assert.assertTrue((boolean)result.getExists());
        Assert.assertTrue((boolean)result.isEmpty());
        result = (Result)table.get(new Get(this.row)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 1)));
        mutation = new RowMutations(this.row);
        mutation.add(new Delete(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 1)));
        mutation.add(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 2), VALUE));
        mutation.add((Mutation)new Increment(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 3), 2L));
        mutation.add((Mutation)new Append(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 4), Bytes.toBytes((String)"abc")));
        result = (Result)table.mutateRow(mutation).get();
        Assert.assertTrue((boolean)result.getExists());
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 3))));
        Assert.assertEquals((Object)"abc", (Object)Bytes.toString((byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 4))));
        result = (Result)table.get(new Get(this.row)).get();
        Assert.assertNull((Object)result.getValue(FAMILY, this.concat(QUALIFIER, 1)));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 2)));
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 3))));
        Assert.assertEquals((Object)"abc", (Object)Bytes.toString((byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 4))));
    }

    @Test
    @Deprecated
    public void testCheckAndPutForOldApi() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        int count = 10;
        CountDownLatch latch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(new Put(this.row).addColumn(FAMILY, QUALIFIER, this.concat(VALUE, i))).thenAccept(x -> {
            if (x.booleanValue()) {
                successCount.incrementAndGet();
                successIndex.set(i);
            }
            latch.countDown();
        }));
        latch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        String actual = Bytes.toString((byte[])((Result)table.get(new Get(this.row)).get()).getValue(FAMILY, QUALIFIER));
        Assert.assertTrue((boolean)actual.endsWith(Integer.toString(successIndex.get())));
    }

    @Test
    @Deprecated
    public void testCheckAndDeleteForOldApi() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch putLatch = new CountDownLatch(count + 1);
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).thenRun(() -> putLatch.countDown());
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), VALUE)).thenRun(() -> putLatch.countDown()));
        putLatch.await();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        CountDownLatch deleteLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenDelete(new Delete(this.row).addColumn(FAMILY, QUALIFIER).addColumn(FAMILY, this.concat(QUALIFIER, i))).thenAccept(x -> {
            if (x.booleanValue()) {
                successCount.incrementAndGet();
                successIndex.set(i);
            }
            deleteLatch.countDown();
        }));
        deleteLatch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        Result result = (Result)table.get(new Get(this.row)).get();
        IntStream.range(0, count).forEach(i -> {
            if (i == successIndex.get()) {
                Assert.assertFalse((boolean)result.containsColumn(FAMILY, this.concat(QUALIFIER, i)));
            } else {
                Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            }
        });
    }

    @Test
    @Deprecated
    public void testCheckAndMutateForOldApi() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch putLatch = new CountDownLatch(count + 1);
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).thenRun(() -> putLatch.countDown());
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), VALUE)).thenRun(() -> putLatch.countDown()));
        putLatch.await();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        CountDownLatch mutateLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> {
            RowMutations mutation = new RowMutations(this.row);
            try {
                mutation.add((Mutation)new Delete(this.row).addColumn(FAMILY, QUALIFIER));
                mutation.add((Mutation)new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), this.concat(VALUE, i)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenMutate(mutation).thenAccept(x -> {
                if (x.booleanValue()) {
                    successCount.incrementAndGet();
                    successIndex.set(i);
                }
                mutateLatch.countDown();
            });
        });
        mutateLatch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        Result result = (Result)table.get(new Get(this.row)).get();
        IntStream.range(0, count).forEach(i -> {
            if (i == successIndex.get()) {
                Assert.assertArrayEquals((byte[])this.concat(VALUE, i), (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            } else {
                Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            }
        });
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithTimeRangeForOldApi() throws Exception {
        AsyncTable<?> table = this.getTable.get();
        long ts = System.currentTimeMillis() / 2L;
        Put put = new Put(this.row);
        put.addColumn(FAMILY, QUALIFIER, ts, VALUE);
        boolean ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put).get();
        Assert.assertTrue((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenPut(put).get();
        Assert.assertFalse((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenPut(put).get();
        Assert.assertTrue((boolean)ok);
        RowMutations rm = new RowMutations(this.row).add((Mutation)put);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenMutate(rm).get();
        Assert.assertFalse((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenMutate(rm).get();
        Assert.assertTrue((boolean)ok);
        Delete delete = new Delete(this.row).addColumn(FAMILY, QUALIFIER);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenDelete(delete).get();
        Assert.assertFalse((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenDelete(delete).get();
        Assert.assertTrue((boolean)ok);
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithSingleFilterForOldApi() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        Put put = new Put(this.row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        table.put(put).get();
        boolean ok = (Boolean)table.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).get();
        Assert.assertTrue((boolean)ok);
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e"))).get();
        Assert.assertFalse((boolean)ok);
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"))).get()));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).thenDelete(new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertTrue((boolean)ok);
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get()));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).thenMutate(new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A")))).get();
        Assert.assertTrue((boolean)ok);
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get()));
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithMultipleFiltersForOldApi() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        Put put = new Put(this.row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        table.put(put).get();
        boolean ok = (Boolean)table.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).get();
        Assert.assertTrue((boolean)ok);
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e"))).get();
        Assert.assertFalse((boolean)ok);
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"))).get()));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenDelete(new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertTrue((boolean)ok);
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get()));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenMutate(new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A")))).get();
        Assert.assertTrue((boolean)ok);
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get()));
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithTimestampFilterForOldApi() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a"))).get();
        boolean ok = (Boolean)table.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(100L))})).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))).get();
        Assert.assertTrue((boolean)ok);
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(101L))})).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"))).get();
        Assert.assertFalse((boolean)ok);
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get()));
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithFilterAndTimeRangeForOldApi() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a"))).get();
        boolean ok = (Boolean)table.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)101L)).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))).get();
        Assert.assertTrue((boolean)ok);
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        ok = (Boolean)table.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)100L)).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"))).get();
        Assert.assertFalse((boolean)ok);
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get()));
    }

    @Test(expected=NullPointerException.class)
    @Deprecated
    public void testCheckAndMutateWithoutConditionForOldApi() {
        this.getTable.get().checkAndMutate(this.row, FAMILY).thenPut(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
    }

    @Test
    public void testCheckAndPut() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        int count = 10;
        CountDownLatch latch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, QUALIFIER).build(new Put(this.row).addColumn(FAMILY, QUALIFIER, this.concat(VALUE, i)))).thenAccept(x -> {
            if (x.isSuccess()) {
                successCount.incrementAndGet();
                successIndex.set(i);
            }
            Assert.assertNull((Object)x.getResult());
            latch.countDown();
        }));
        latch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        String actual = Bytes.toString((byte[])((Result)table.get(new Get(this.row)).get()).getValue(FAMILY, QUALIFIER));
        Assert.assertTrue((boolean)actual.endsWith(Integer.toString(successIndex.get())));
    }

    @Test
    public void testCheckAndDelete() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch putLatch = new CountDownLatch(count + 1);
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).thenRun(() -> putLatch.countDown());
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), VALUE)).thenRun(() -> putLatch.countDown()));
        putLatch.await();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        CountDownLatch deleteLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).build(new Delete(this.row).addColumn(FAMILY, QUALIFIER).addColumn(FAMILY, this.concat(QUALIFIER, i)))).thenAccept(x -> {
            if (x.isSuccess()) {
                successCount.incrementAndGet();
                successIndex.set(i);
            }
            Assert.assertNull((Object)x.getResult());
            deleteLatch.countDown();
        }));
        deleteLatch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        Result result = (Result)table.get(new Get(this.row)).get();
        IntStream.range(0, count).forEach(i -> {
            if (i == successIndex.get()) {
                Assert.assertFalse((boolean)result.containsColumn(FAMILY, this.concat(QUALIFIER, i)));
            } else {
                Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            }
        });
    }

    @Test
    public void testCheckAndMutate() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch putLatch = new CountDownLatch(count + 1);
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).thenRun(() -> putLatch.countDown());
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), VALUE)).thenRun(() -> putLatch.countDown()));
        putLatch.await();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        CountDownLatch mutateLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> {
            RowMutations mutation = new RowMutations(this.row);
            try {
                mutation.add((Mutation)new Delete(this.row).addColumn(FAMILY, QUALIFIER));
                mutation.add((Mutation)new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), this.concat(VALUE, i)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).build(mutation)).thenAccept(x -> {
                if (x.isSuccess()) {
                    successCount.incrementAndGet();
                    successIndex.set(i);
                }
                Assert.assertNull((Object)x.getResult());
                mutateLatch.countDown();
            });
        });
        mutateLatch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        Result result = (Result)table.get(new Get(this.row)).get();
        IntStream.range(0, count).forEach(i -> {
            if (i == successIndex.get()) {
                Assert.assertArrayEquals((byte[])this.concat(VALUE, i), (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            } else {
                Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            }
        });
    }

    @Test
    public void testCheckAndMutateWithTimeRange() throws Exception {
        AsyncTable<?> table = this.getTable.get();
        long ts = System.currentTimeMillis() / 2L;
        Put put = new Put(this.row);
        put.addColumn(FAMILY, QUALIFIER, ts, VALUE);
        CheckAndMutateResult result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, QUALIFIER).build(put)).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).timeRange(TimeRange.at((long)(ts + 10000L))).build(put)).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).timeRange(TimeRange.at((long)ts)).build(put)).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        RowMutations rm = new RowMutations(this.row).add((Mutation)put);
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).timeRange(TimeRange.at((long)(ts + 10000L))).build(rm)).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).timeRange(TimeRange.at((long)ts)).build(rm)).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Delete delete = new Delete(this.row).addColumn(FAMILY, QUALIFIER);
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).timeRange(TimeRange.at((long)(ts + 10000L))).build(delete)).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, QUALIFIER, VALUE).timeRange(TimeRange.at((long)ts)).build(delete)).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
    }

    @Test
    public void testCheckAndMutateWithSingleFilter() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        Put put = new Put(this.row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        table.put(put).get();
        CheckAndMutateResult result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Result r = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")))).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"))).get()));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).build(new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"D")))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get()));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).build(new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A"))))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        r = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get()));
    }

    @Test
    public void testCheckAndMutateWithMultipleFilters() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        Put put = new Put(this.row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        table.put(put).get();
        CheckAndMutateResult result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Result r = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")))).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"))).get()));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"D")))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get()));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A"))))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        r = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get()));
    }

    @Test
    public void testCheckAndMutateWithTimestampFilter() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a"))).get();
        CheckAndMutateResult result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(100L))})).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Result r = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(101L))})).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")))).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get()));
    }

    @Test
    public void testCheckAndMutateWithFilterAndTimeRange() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a"))).get();
        CheckAndMutateResult result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)101L)).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")))).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Result r = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)100L)).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")))).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get()));
    }

    @Test
    public void testCheckAndIncrement() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"))).get();
        CheckAndMutateResult res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L))).get();
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"b")).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L))).get();
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
        res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 2L))).get();
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"d"))})).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 2L))).get();
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
    }

    @Test
    public void testCheckAndAppend() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"))).get();
        CheckAndMutateResult res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")))).get();
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"b")).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")))).get();
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        table.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
        res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"bb")))).get();
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = (CheckAndMutateResult)table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"d"))})).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"bb")))).get();
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
    }

    @Test
    public void testCheckAndRowMutations() throws Throwable {
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] q3 = Bytes.toBytes((String)"q3");
        byte[] q4 = Bytes.toBytes((String)"q4");
        String v1 = "v1";
        AsyncTable<?> table = this.getTable.get();
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, q2, Bytes.toBytes((String)"toBeDeleted")), new Put(this.row).addColumn(FAMILY, q3, Bytes.toBytes((long)5L)), new Put(this.row).addColumn(FAMILY, q4, Bytes.toBytes((String)"a")))).get();
        CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, q1).build(new RowMutations(this.row).add(Arrays.asList(new Put(this.row).addColumn(FAMILY, q1, Bytes.toBytes((String)"v1")), new Delete(this.row).addColumns(FAMILY, q2), new Increment(this.row).addColumn(FAMILY, q3, 1L), new Append(this.row).addColumn(FAMILY, q4, Bytes.toBytes((String)"b")))));
        CheckAndMutateResult result = (CheckAndMutateResult)table.checkAndMutate(checkAndMutate).get();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])result.getResult().getValue(FAMILY, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])result.getResult().getValue(FAMILY, q4)));
        Result r = (Result)table.get(new Get(this.row)).get();
        Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q1)));
        Assert.assertNull((Object)r.getValue(FAMILY, q2));
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])r.getValue(FAMILY, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q4)));
        checkAndMutate = CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, q1).build(new RowMutations(this.row).add(Arrays.asList(new Delete(this.row).addColumns(FAMILY, q1), new Put(this.row).addColumn(FAMILY, q2, Bytes.toBytes((String)"v1")), new Increment(this.row).addColumn(FAMILY, q3, 1L), new Append(this.row).addColumn(FAMILY, q4, Bytes.toBytes((String)"b")))));
        result = (CheckAndMutateResult)table.checkAndMutate(checkAndMutate).get();
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        r = (Result)table.get(new Get(this.row)).get();
        Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q1)));
        Assert.assertNull((Object)r.getValue(FAMILY, q2));
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])r.getValue(FAMILY, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q4)));
    }

    @Test
    public void testCheckAndMutateBatch() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        byte[] row3 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "3"));
        byte[] row4 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "4"));
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"e")));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifEquals(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"a")).build(new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"f")));
        List results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get();
        Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"e")).build(new Delete(this.row));
        checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifEquals(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"a")).build(new Delete(row2));
        results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get()));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        checkAndMutate1 = CheckAndMutate.newBuilder((byte[])row3).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).build(new RowMutations(row3).add((Mutation)new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))).add((Mutation)new Delete(row3).addColumns(FAMILY, Bytes.toBytes((String)"C"))));
        checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row4).ifEquals(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"f")).build(new RowMutations(row4).add((Mutation)new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))).add((Mutation)new Delete(row4).addColumns(FAMILY, Bytes.toBytes((String)"D"))));
        results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        result = (Result)table.get(new Get(row3)).get();
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"D")));
        result = (Result)table.get(new Get(row4)).get();
        Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"F")));
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
    }

    @Test
    public void testCheckAndMutateBatch2() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        byte[] row3 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "3"));
        byte[] row4 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "4"));
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"C"), 100L, Bytes.toBytes((String)"c")), new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"D"), 100L, Bytes.toBytes((String)"d")))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, Bytes.toBytes((String)"B")).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"e")));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifNotExists(FAMILY, Bytes.toBytes((String)"B")).build(new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"f")));
        List results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get();
        Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifMatches(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.NOT_EQUAL, Bytes.toBytes((String)"a")).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")));
        checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifMatches(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.GREATER, Bytes.toBytes((String)"b")).build(new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"f")));
        results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).get();
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        checkAndMutate1 = CheckAndMutate.newBuilder((byte[])row3).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).timeRange(TimeRange.between((long)0L, (long)101L)).build(new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"e")));
        checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row4).ifEquals(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")).timeRange(TimeRange.between((long)0L, (long)100L)).build(new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"f")));
        results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        result = (Result)table.get(new Get(row3).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get();
        Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
        result = (Result)table.get(new Get(row4).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
    }

    @Test
    public void testCheckAndMutateBatchWithFilter() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f")))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"g")));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"h")));
        List results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get();
        Assert.assertEquals((Object)"g", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"F"))).get();
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"C")));
        checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Delete(row2).addColumn(FAMILY, Bytes.toBytes((String)"F")));
        results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get()));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"F"))).get();
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
        checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new RowMutations(row2).add((Mutation)new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"g"))).add((Mutation)new Delete(row2).addColumns(FAMILY, Bytes.toBytes((String)"D"))));
        results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        result = (Result)table.get(new Get(this.row)).get();
        Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"A")));
        Assert.assertEquals((Object)"c", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
        result = (Result)table.get(new Get(row2)).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
    }

    @Test
    public void testCheckAndMutateBatchWithFilterAndTimeRange() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), 100L, Bytes.toBytes((String)"b")).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"D"), 100L, Bytes.toBytes((String)"d")).addColumn(FAMILY, Bytes.toBytes((String)"E"), 100L, Bytes.toBytes((String)"e")).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f")))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).timeRange(TimeRange.between((long)0L, (long)101L)).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"g")));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"d")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"e"))})).timeRange(TimeRange.between((long)0L, (long)100L)).build(new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"h")));
        List results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).get();
        Assert.assertEquals((Object)"g", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"F"))).get();
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
    }

    @Test
    public void testCheckAndIncrementBatch() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((long)0L)), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((long)0L)))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"d")).build(new Increment(row2).addColumn(FAMILY, Bytes.toBytes((String)"D"), 1L));
        List results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((long)0L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
    }

    @Test
    public void testCheckAndAppendBatch() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"d")).build(new Append(row2).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
        List results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertEquals((Object)"bb", (Object)Bytes.toString((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"))).get();
        Assert.assertEquals((Object)"bb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = (Result)table.get(new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"D"))).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
    }

    @Test
    public void testCheckAndRowMutationsBatch() throws Throwable {
        AsyncTable<?> table = this.getTable.get();
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        table.putAll(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((long)1L)).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f")).addColumn(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((long)1L)).addColumn(FAMILY, Bytes.toBytes((String)"H"), Bytes.toBytes((String)"h")))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")).build(new RowMutations(this.row).add(Arrays.asList(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"B")), new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), 1L), new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")))));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifEquals(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"a")).build(new RowMutations(row2).add(Arrays.asList(new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")), new Delete(row2).addColumns(FAMILY, Bytes.toBytes((String)"F")), new Increment(row2).addColumn(FAMILY, Bytes.toBytes((String)"G"), 1L), new Append(row2).addColumn(FAMILY, Bytes.toBytes((String)"H"), Bytes.toBytes((String)"h")))));
        List results = (List)table.checkAndMutateAll(Arrays.asList(checkAndMutate1, checkAndMutate2)).get();
        Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"C"))));
        Assert.assertEquals((Object)"dd", (Object)Bytes.toString((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
        Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
        Result result = (Result)table.get(new Get(this.row)).get();
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
        Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
        Assert.assertEquals((Object)"dd", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        result = (Result)table.get(new Get(row2)).get();
        Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"E")));
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"G"))));
        Assert.assertEquals((Object)"h", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"H"))));
    }

    @Test
    public void testDisabled() throws InterruptedException, ExecutionException {
        ASYNC_CONN.getAdmin().disableTable(TABLE_NAME).get();
        try {
            this.getTable.get().get(new Get(this.row)).get();
            Assert.fail((String)"Should fail since table has been disabled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(TableNotEnabledException.class));
            MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.containsString((String)TABLE_NAME.getNameAsString()));
        }
    }

    @Test
    public void testInvalidPut() {
        try {
            this.getTable.get().put(new Put(Bytes.toBytes((int)0)));
            Assert.fail((String)"Should fail since the put does not contain any cells");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No columns to insert"));
        }
        try {
            this.getTable.get().put(new Put(Bytes.toBytes((int)0)).addColumn(FAMILY, QUALIFIER, new byte[MAX_KEY_VALUE_SIZE]));
            Assert.fail((String)"Should fail since the put exceeds the max key value size");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"KeyValue size too large"));
        }
    }

    @Test
    public void testInvalidPutInRowMutations() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        try {
            this.getTable.get().mutateRow(new RowMutations(row).add((Mutation)new Put(row)));
            Assert.fail((String)"Should fail since the put does not contain any cells");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No columns to insert"));
        }
        try {
            this.getTable.get().mutateRow(new RowMutations(row).add((Mutation)new Put(row).addColumn(FAMILY, QUALIFIER, new byte[MAX_KEY_VALUE_SIZE])));
            Assert.fail((String)"Should fail since the put exceeds the max key value size");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"KeyValue size too large"));
        }
    }

    @Test
    public void testInvalidPutInRowMutationsInCheckAndMutate() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        try {
            this.getTable.get().checkAndMutate(CheckAndMutate.newBuilder((byte[])row).ifNotExists(FAMILY, QUALIFIER).build(new RowMutations(row).add((Mutation)new Put(row))));
            Assert.fail((String)"Should fail since the put does not contain any cells");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No columns to insert"));
        }
        try {
            this.getTable.get().checkAndMutate(CheckAndMutate.newBuilder((byte[])row).ifNotExists(FAMILY, QUALIFIER).build(new RowMutations(row).add((Mutation)new Put(row).addColumn(FAMILY, QUALIFIER, new byte[MAX_KEY_VALUE_SIZE]))));
            Assert.fail((String)"Should fail since the put exceeds the max key value size");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"KeyValue size too large"));
        }
    }
}

