/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSplitTableRegionProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitTableRegionProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitTableRegionProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String columnFamilyName1 = "cf1";
    private static String columnFamilyName2 = "cf2";
    private static final int startRowNum = 11;
    private static final int rowCount = 60;
    private AssignmentManager am;
    private ProcedureMetrics splitProcMetrics;
    private ProcedureMetrics assignProcMetrics;
    private ProcedureMetrics unassignProcMetrics;
    private long splitSubmittedCount = 0L;
    private long splitFailedCount = 0L;
    private long assignSubmittedCount = 0L;
    private long assignFailedCount = 0L;
    private long unassignSubmittedCount = 0L;
    private long unassignFailedCount = 0L;
    @Rule
    public TestName name = new TestName();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setLong("hbase.hregion.majorcompaction", 0L);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSplitTableRegionProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(false);
        this.am = UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        this.splitProcMetrics = this.am.getAssignmentManagerMetrics().getSplitProcMetrics();
        this.assignProcMetrics = this.am.getAssignmentManagerMetrics().getAssignProcMetrics();
        this.unassignProcMetrics = this.am.getAssignmentManagerMetrics().getUnassignProcMetrics();
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (TableDescriptor htd : UTIL.getAdmin().listTableDescriptors()) {
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testSplitTableRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 41;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        this.collectAssignmentManagerMetrics();
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        this.verify(tableName, splitRowNum);
        Assert.assertEquals((long)(this.splitSubmittedCount + 1L), (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.splitFailedCount, (long)this.splitProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.assignSubmittedCount + 2L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 1L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.unassignFailedCount, (long)this.unassignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testSplitTableRegionNoStoreFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 41;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        this.collectAssignmentManagerMetrics();
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        Assert.assertTrue((UTIL.getMiniHBaseCluster().getRegions(tableName).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((UTIL.countRows(tableName) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)(this.splitSubmittedCount + 1L), (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.splitFailedCount, (long)this.splitProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testSplitTableRegionUnevenDaughter() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 26;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        this.collectAssignmentManagerMetrics();
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        this.verify(tableName, splitRowNum);
        Assert.assertEquals((long)(this.splitSubmittedCount + 1L), (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.splitFailedCount, (long)this.splitProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testSplitTableRegionEmptyDaughter() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 71;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        this.collectAssignmentManagerMetrics();
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        List<HRegion> daughters = UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertTrue((daughters.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((UTIL.countRows(tableName) == 60 ? 1 : 0) != 0);
        Assert.assertTrue((UTIL.countRows((Region)daughters.get(0)) == 0 || UTIL.countRows((Region)daughters.get(1)) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)(this.splitSubmittedCount + 1L), (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.splitFailedCount, (long)this.splitProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testSplitTableRegionDeletedRowsDaughter() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 60;
        this.deleteData(tableName, splitRowNum);
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        this.collectAssignmentManagerMetrics();
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        UTIL.getAdmin().majorCompact(tableName);
        UTIL.waitFor(6000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return UTIL.getAdmin().getCompactionState(tableName) == CompactionState.NONE;
            }
        });
        List<HRegion> daughters = UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertTrue((daughters.size() == 2 ? 1 : 0) != 0);
        int currentRowCount = splitRowNum - 11;
        Assert.assertTrue((UTIL.countRows(tableName) == currentRowCount ? 1 : 0) != 0);
        Assert.assertTrue((UTIL.countRows((Region)daughters.get(0)) == 0 || UTIL.countRows((Region)daughters.get(1)) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)(this.splitSubmittedCount + 1L), (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.splitFailedCount, (long)this.splitProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testInvalidSplitKey() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        this.collectAssignmentManagerMetrics();
        try {
            long procId1 = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], null));
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
            Assert.fail((String)"unexpected procedure start with invalid split-key");
        }
        catch (DoNotRetryIOException e) {
            LOG.debug("Expected Split procedure construction failure: " + e.getMessage());
        }
        Assert.assertEquals((long)this.splitSubmittedCount, (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.splitFailedCount, (long)this.splitProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 41;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        this.collectAssignmentManagerMetrics();
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        int lastStep = 7;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep, true);
        Assert.assertEquals((long)1L, (long)UTIL.getAdmin().getRegions(tableName).size());
        UTIL.waitUntilAllRegionsAssigned(tableName);
        List<HRegion> newRegions = UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)newRegions.size());
        this.verifyData(newRegions.get(0), 11, 60, Bytes.toBytes((String)columnFamilyName1), Bytes.toBytes((String)columnFamilyName2));
        Assert.assertEquals((long)(this.splitSubmittedCount + 1L), (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)(this.splitFailedCount + 1L), (long)this.splitProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 41;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillIfHasParent(procExec, (boolean)false);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        this.collectAssignmentManagerMetrics();
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        this.verify(tableName, splitRowNum);
        Assert.assertEquals((long)(this.splitSubmittedCount + 1L), (long)this.splitProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.splitFailedCount, (long)this.splitProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testSplitWithoutPONR() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, columnFamilyName1, columnFamilyName2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 60, 11, columnFamilyName1, columnFamilyName2);
        int splitRowNum = 41;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, 7, false);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        MasterProcedureTestingUtility.restartMasterProcedureExecutor(procExec);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        this.verify(tableName, splitRowNum);
    }

    private void deleteData(TableName tableName, int startDeleteRowNum) throws IOException, InterruptedException {
        Table t = UTIL.getConnection().getTable(tableName);
        int numRows = 71 - startDeleteRowNum;
        for (int i = startDeleteRowNum; i <= numRows + startDeleteRowNum; ++i) {
            Delete d = new Delete(Bytes.toBytes((String)("" + i)));
            t.delete(d);
            if (i % 5 != 0) continue;
            UTIL.getAdmin().flush(tableName);
        }
    }

    private void verify(TableName tableName, int splitRowNum) throws IOException {
        List<HRegion> daughters = UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertTrue((daughters.size() == 2 ? 1 : 0) != 0);
        LOG.info("Row Count = " + UTIL.countRows(tableName));
        Assert.assertTrue((UTIL.countRows(tableName) == 60 ? 1 : 0) != 0);
        for (int i = 0; i < daughters.size(); ++i) {
            int numRows;
            int startRow;
            if (Bytes.compareTo((byte[])daughters.get(i).getRegionInfo().getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0) {
                startRow = 11;
                numRows = splitRowNum - 11;
            } else {
                startRow = splitRowNum;
                numRows = 71 - splitRowNum;
            }
            this.verifyData(daughters.get(i), startRow, numRows, Bytes.toBytes((String)columnFamilyName1), Bytes.toBytes((String)columnFamilyName2));
        }
    }

    private void verifyData(HRegion newReg, int startRow, int numRows, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            byte[] row = Bytes.toBytes((String)("" + i));
            Get get = new Get(row);
            Result result = newReg.get(get);
            Cell[] raw = result.rawCells();
            Assert.assertEquals((long)families.length, (long)result.size());
            for (int j = 0; j < families.length; ++j) {
                Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)raw[j], (byte[])row));
                Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)raw[j], (byte[])families[j]));
            }
        }
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void collectAssignmentManagerMetrics() {
        this.splitSubmittedCount = this.splitProcMetrics.getSubmittedCounter().getCount();
        this.splitFailedCount = this.splitProcMetrics.getFailedCounter().getCount();
        this.assignSubmittedCount = this.assignProcMetrics.getSubmittedCounter().getCount();
        this.assignFailedCount = this.assignProcMetrics.getFailedCounter().getCount();
        this.unassignSubmittedCount = this.unassignProcMetrics.getSubmittedCounter().getCount();
        this.unassignFailedCount = this.unassignProcMetrics.getFailedCounter().getCount();
    }
}

