/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSnapshotHFileCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotHFileCleaner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLE_NAME_STR = "testSnapshotManifest";
    private static final String SNAPSHOT_NAME_STR = "testSnapshotManifest-snapshot";
    private static Path rootDir;
    private static FileSystem fs;
    private static Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        fs = FileSystem.get((Configuration)conf);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        fs.delete(rootDir, true);
    }

    @Test
    public void testFindsSnapshotFilesWhenCleaning() throws IOException {
        CommonFSUtils.setRootDir((Configuration)conf, (Path)TEST_UTIL.getDataTestDir());
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        Path archivedHfileDir = new Path(TEST_UTIL.getDataTestDir(), "archive");
        FileSystem fs = FileSystem.get((Configuration)conf);
        SnapshotHFileCleaner cleaner = new SnapshotHFileCleaner();
        cleaner.setConf(conf);
        String snapshotName = "snapshot";
        byte[] snapshot = Bytes.toBytes((String)snapshotName);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        HRegionInfo mockRegion = new HRegionInfo(tableName);
        Path regionSnapshotDir = new Path(snapshotDir, mockRegion.getEncodedName());
        Path familyDir = new Path(regionSnapshotDir, "family");
        String hfile = "fd1e73e8a96c486090c5cec07b4894c4";
        Path refFile = new Path(familyDir, hfile);
        fs.create(refFile);
        fs.mkdirs(archivedHfileDir);
        fs.createNewFile(new Path(archivedHfileDir, hfile));
        Assert.assertFalse((boolean)cleaner.isFileDeletable(fs.getFileStatus(refFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedRegionManifest() throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(conf, fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(SNAPSHOT_NAME_STR, TABLE_NAME_STR);
        builder.addRegionV2();
        builder.corruptOneRegionManifest();
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(conf, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        try {
            cache.getSnapshotsInProgress();
        }
        finally {
            fs.delete(SnapshotDescriptionUtils.getWorkingSnapshotDir((Path)rootDir, (Configuration)conf), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedDataManifest() throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(conf, fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(SNAPSHOT_NAME_STR, TABLE_NAME_STR);
        builder.addRegionV2();
        builder.consolidate();
        builder.corruptDataManifest();
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(conf, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        try {
            cache.getSnapshotsInProgress();
        }
        finally {
            fs.delete(SnapshotDescriptionUtils.getWorkingSnapshotDir((Path)rootDir, (Configuration)TEST_UTIL.getConfiguration()), true);
        }
    }

    @Test
    public void testMissedTmpSnapshot() throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(conf, fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(SNAPSHOT_NAME_STR, TABLE_NAME_STR);
        builder.addRegionV2();
        builder.missOneRegionSnapshotFile();
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(conf, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        cache.getSnapshotsInProgress();
        Assert.assertTrue((boolean)fs.exists(builder.getSnapshotsDir()));
    }

    static class SnapshotFiles
    implements SnapshotFileCache.SnapshotFileInspector {
        SnapshotFiles() {
        }

        public Collection<String> filesUnderSnapshot(FileSystem workingFs, Path snapshotDir) throws IOException {
            HashSet<String> files = new HashSet<String>();
            files.addAll(SnapshotReferenceUtil.getHFileNames((Configuration)conf, (FileSystem)workingFs, (Path)snapshotDir));
            return files;
        }
    }
}

