/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRSRpcServices {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSRpcServices.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSRpcServices.class);

    @Test
    public void testRegionScannerHolderToString() throws UnknownHostException {
        RpcCall call = (RpcCall)Mockito.mock(RpcCall.class);
        int port = 1234;
        Mockito.when((Object)call.getRemotePort()).thenReturn((Object)port);
        InetAddress address = InetAddress.getLocalHost();
        Mockito.when((Object)call.getRemoteAddress()).thenReturn((Object)address);
        RpcServer.setCurrentCall((RpcCall)call);
        String clientIpAndPort = RSRpcServices.getRemoteClientIpAndPort();
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)region.getRegionInfo()).thenReturn((Object)RegionInfoBuilder.FIRST_META_REGIONINFO);
        RSRpcServices.RegionScannerHolder rsh = new RSRpcServices.RegionScannerHolder(null, region, null, null, false, false, clientIpAndPort);
        LOG.info("rsh={}", (Object)rsh);
    }
}

