/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class CloneSnapshotFromClientTestBase {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected final byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected byte[] emptySnapshot;
    protected byte[] snapshotName0;
    protected byte[] snapshotName1;
    protected byte[] snapshotName2;
    protected TableName tableName;
    protected int snapshot0Rows;
    protected int snapshot1Rows;
    protected Admin admin;
    @Rule
    public TestName name = new TestName();

    protected static void setupConfiguration() {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CloneSnapshotFromClientTestBase.setupConfiguration();
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected final String getValidMethodName() {
        return this.name.getMethodName().replaceAll("[^0-9A-Za-z_]", "_");
    }

    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf((String)(this.getValidMethodName() + tid));
        this.emptySnapshot = Bytes.toBytes((String)("emptySnaptb-" + tid));
        this.snapshotName0 = Bytes.toBytes((String)("snaptb0-" + tid));
        this.snapshotName1 = Bytes.toBytes((String)("snaptb1-" + tid));
        this.snapshotName2 = Bytes.toBytes((String)("snaptb2-" + tid));
        this.createTableAndSnapshots();
    }

    protected void createTable() throws IOException, InterruptedException {
        SnapshotTestingUtils.createTable(TEST_UTIL, this.tableName, this.getNumReplicas(), (byte[][])new byte[][]{this.FAMILY});
    }

    protected int numRowsToLoad() {
        return 500;
    }

    protected int countRows(Table table) throws IOException {
        return TEST_UTIL.countRows(table);
    }

    private void createTableAndSnapshots() throws Exception {
        this.createTable();
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, this.numRowsToLoad(), (byte[][])new byte[][]{this.FAMILY});
        try (Table table = TEST_UTIL.getConnection().getTable(this.tableName);){
            this.snapshot0Rows = this.countRows(table);
        }
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName0, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, this.numRowsToLoad(), (byte[][])new byte[][]{this.FAMILY});
        table = TEST_UTIL.getConnection().getTable(this.tableName);
        var2_2 = null;
        try {
            this.snapshot1Rows = this.countRows(table);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var2_2 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName1, this.tableName);
        this.admin.enableTable(this.tableName);
    }

    protected int getNumReplicas() {
        return 1;
    }

    protected void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        SnapshotTestingUtils.verifyRowCount(util, tableName, expectedRows);
    }

    @After
    public void tearDown() throws Exception {
        if (this.admin.tableExists(this.tableName)) {
            TEST_UTIL.deleteTable(this.tableName);
        }
        SnapshotTestingUtils.deleteAllSnapshots(this.admin);
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }
}

