/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestBucketCacheRefCnt {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBucketCacheRefCnt.class);
    private static final String IO_ENGINE = "offheap";
    private static final long CAPACITY_SIZE = 0x2000000L;
    private static final int BLOCK_SIZE = 1024;
    private static final int[] BLOCK_SIZE_ARRAY = new int[]{64, 128, 256, 512, 1024, 2048, 4096, 8192};
    private static final String PERSISTENCE_PATH = null;
    private static final HFileContext CONTEXT = new HFileContextBuilder().build();
    private BucketCache cache;

    private static BucketCache create(int writerSize, int queueSize) throws IOException {
        return new BucketCache(IO_ENGINE, 0x2000000L, 1024, BLOCK_SIZE_ARRAY, writerSize, queueSize, PERSISTENCE_PATH);
    }

    private static HFileBlock createBlock(int offset, int size) {
        return TestBucketCacheRefCnt.createBlock(offset, size, ByteBuffAllocator.HEAP);
    }

    private static HFileBlock createBlock(int offset, int size, ByteBuffAllocator alloc) {
        return new HFileBlock(BlockType.DATA, size, size, -1L, ByteBuff.wrap((ByteBuffer)ByteBuffer.allocate(size)), true, (long)offset, 52, size, CONTEXT, alloc);
    }

    private static BlockCacheKey createKey(String hfileName, long offset) {
        return new BlockCacheKey(hfileName, offset);
    }

    private void disableWriter() {
        if (this.cache != null) {
            for (BucketCache.WriterThread wt : this.cache.writerThreads) {
                wt.disableWriter();
                wt.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testBlockInRAMCache() throws IOException {
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        this.cache.wait_when_cache = true;
        this.disableWriter();
        String prefix = "testBlockInRamCache";
        try {
            int i;
            for (i = 0; i < 10; ++i) {
                HFileBlock blk = TestBucketCacheRefCnt.createBlock(i, 1020);
                BlockCacheKey key = TestBucketCacheRefCnt.createKey("testBlockInRamCache", i);
                Assert.assertEquals((long)1L, (long)blk.refCnt());
                this.cache.cacheBlock(key, (Cacheable)blk);
                Assert.assertEquals((long)(i + 1), (long)this.cache.getBlockCount());
                Assert.assertEquals((long)2L, (long)blk.refCnt());
                Cacheable block = this.cache.getBlock(key, false, false, false);
                try {
                    Assert.assertEquals((long)3L, (long)blk.refCnt());
                    Assert.assertEquals((long)3L, (long)block.refCnt());
                    Assert.assertEquals((Object)blk, (Object)block);
                }
                finally {
                    block.release();
                }
                Assert.assertEquals((long)2L, (long)blk.refCnt());
                Assert.assertEquals((long)2L, (long)block.refCnt());
            }
            for (i = 0; i < 10; ++i) {
                BlockCacheKey key = TestBucketCacheRefCnt.createKey("testBlockInRamCache", i);
                Cacheable blk = this.cache.getBlock(key, false, false, false);
                Assert.assertEquals((long)3L, (long)blk.refCnt());
                Assert.assertFalse((boolean)blk.release());
                Assert.assertEquals((long)2L, (long)blk.refCnt());
                Assert.assertTrue((boolean)this.cache.evictBlock(key));
                Assert.assertEquals((long)1L, (long)blk.refCnt());
                Assert.assertTrue((boolean)blk.release());
                Assert.assertEquals((long)0L, (long)blk.refCnt());
            }
        }
        finally {
            this.cache.shutdown();
        }
    }

    private void waitUntilFlushedToCache(BlockCacheKey key) throws InterruptedException {
        while (!this.cache.backingMap.containsKey(key) || this.cache.ramCache.containsKey(key)) {
            Thread.sleep(100L);
        }
        Thread.sleep(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockInBackingMap() throws Exception {
        ByteBuffAllocator alloc = ByteBuffAllocator.create((Configuration)HBaseConfiguration.create(), (boolean)true);
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        try {
            HFileBlock blk = TestBucketCacheRefCnt.createBlock(200, 1020, alloc);
            BlockCacheKey key = TestBucketCacheRefCnt.createKey("testHFile-00", 200L);
            this.cache.cacheBlock(key, (Cacheable)blk);
            this.waitUntilFlushedToCache(key);
            Assert.assertEquals((long)1L, (long)blk.refCnt());
            Cacheable block = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((boolean)(block instanceof HFileBlock));
            Assert.assertTrue((((HFileBlock)block).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)block.refCnt());
            block.retain();
            Assert.assertEquals((long)3L, (long)block.refCnt());
            Cacheable newBlock = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((boolean)(newBlock instanceof HFileBlock));
            Assert.assertTrue((((HFileBlock)newBlock).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertEquals((long)4L, (long)newBlock.refCnt());
            Assert.assertFalse((boolean)newBlock.release());
            Assert.assertEquals((long)3L, (long)newBlock.refCnt());
            Assert.assertEquals((long)3L, (long)block.refCnt());
            this.cache.evictBlock(key);
            Assert.assertEquals((long)2L, (long)block.refCnt());
            this.cache.evictBlock(key);
            Assert.assertEquals((long)2L, (long)block.refCnt());
            Assert.assertFalse((boolean)block.release());
            Assert.assertEquals((long)1L, (long)block.refCnt());
            newBlock = this.cache.getBlock(key, false, false, false);
            Assert.assertEquals((long)2L, (long)block.refCnt());
            Assert.assertEquals((long)2L, (long)newBlock.refCnt());
            Assert.assertTrue((((HFileBlock)newBlock).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertFalse((boolean)block.release());
            Assert.assertEquals((long)1L, (long)block.refCnt());
            Assert.assertTrue((boolean)newBlock.release());
            Assert.assertEquals((long)0L, (long)newBlock.refCnt());
        }
        finally {
            this.cache.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInBucketCache() throws IOException {
        ByteBuffAllocator alloc = ByteBuffAllocator.create((Configuration)HBaseConfiguration.create(), (boolean)true);
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        try {
            HFileBlock blk = TestBucketCacheRefCnt.createBlock(200, 1020, alloc);
            BlockCacheKey key = TestBucketCacheRefCnt.createKey("testHFile-00", 200L);
            this.cache.cacheBlock(key, (Cacheable)blk);
            Assert.assertTrue((blk.refCnt() == 1 || blk.refCnt() == 2 ? 1 : 0) != 0);
            Cacheable block1 = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((block1.refCnt() >= 2 ? 1 : 0) != 0);
            Assert.assertTrue((((HFileBlock)block1).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Cacheable block2 = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((((HFileBlock)block2).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertTrue((block2.refCnt() >= 3 ? 1 : 0) != 0);
            this.cache.evictBlock(key);
            Assert.assertTrue((blk.refCnt() >= 1 ? 1 : 0) != 0);
            Assert.assertTrue((block1.refCnt() >= 2 ? 1 : 0) != 0);
            Assert.assertTrue((block2.refCnt() >= 2 ? 1 : 0) != 0);
            Cacheable block3 = this.cache.getBlock(key, false, false, false);
            if (block3 != null) {
                Assert.assertTrue((((HFileBlock)block3).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
                Assert.assertTrue((block3.refCnt() >= 3 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)block3.release());
            }
            blk.release();
            boolean ret1 = block1.release();
            boolean ret2 = block2.release();
            Assert.assertTrue((ret1 || ret2 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)blk.refCnt());
            Assert.assertEquals((long)0L, (long)block1.refCnt());
            Assert.assertEquals((long)0L, (long)block2.refCnt());
        }
        finally {
            this.cache.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarkStaleAsEvicted() throws Exception {
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        try {
            HFileBlock blk = TestBucketCacheRefCnt.createBlock(200, 1020);
            BlockCacheKey key = TestBucketCacheRefCnt.createKey("testMarkStaleAsEvicted", 200L);
            this.cache.cacheBlock(key, (Cacheable)blk);
            this.waitUntilFlushedToCache(key);
            Assert.assertEquals((long)1L, (long)blk.refCnt());
            Assert.assertNotNull(this.cache.backingMap.get(key));
            Assert.assertEquals((long)1L, (long)((BucketEntry)this.cache.backingMap.get(key)).refCnt());
            Cacheable block1 = this.cache.getBlock(key, false, false, false);
            Assert.assertEquals((long)2L, (long)block1.refCnt());
            BucketEntry be1 = (BucketEntry)this.cache.backingMap.get(key);
            Assert.assertNotNull((Object)be1);
            Assert.assertEquals((long)2L, (long)be1.refCnt());
            Assert.assertFalse((boolean)be1.markStaleAsEvicted());
            Assert.assertEquals((long)2L, (long)block1.refCnt());
            Assert.assertEquals((long)2L, (long)((BucketEntry)this.cache.backingMap.get(key)).refCnt());
            block1.release();
            Assert.assertEquals((long)1L, (long)block1.refCnt());
            Assert.assertEquals((long)1L, (long)((BucketEntry)this.cache.backingMap.get(key)).refCnt());
            Assert.assertTrue((boolean)be1.markStaleAsEvicted());
            Assert.assertEquals((long)0L, (long)block1.refCnt());
            Assert.assertNull(this.cache.backingMap.get(key));
            Assert.assertEquals((long)0L, (long)this.cache.size());
        }
        finally {
            this.cache.shutdown();
        }
    }
}

