/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicasWithModifyTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicasWithModifyTable.class);
    private static final int NB_SERVERS = 3;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final byte[] f = HConstants.CATALOG_FAMILY;
    @Parameterized.Parameter
    public boolean disableBeforeModifying;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({true}, {false});
    }

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster(3);
    }

    private void enableReplicationByModification(boolean withReplica, int initialReplicaCount, int enableReplicaCount, int splitCount) throws IOException, InterruptedException {
        TableName tableName = this.name.getTableName();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        if (withReplica) {
            builder.setRegionReplication(initialReplicaCount);
        }
        TableDescriptor htd = builder.build();
        if (splitCount > 0) {
            byte[][] splits = TestRegionReplicasWithModifyTable.getSplits(splitCount);
            HTU.createTable(htd, (byte[][])new byte[][]{f}, splits, new Configuration(HTU.getConfiguration()));
        } else {
            HTU.createTable(htd, (byte[][])new byte[][]{f}, (byte[][])null, new Configuration(HTU.getConfiguration()));
        }
        if (this.disableBeforeModifying) {
            HTU.getAdmin().disableTable(tableName);
        }
        HBaseTestingUtility.setReplicas(HTU.getAdmin(), tableName, enableReplicaCount);
        if (this.disableBeforeModifying) {
            HTU.getAdmin().enableTable(tableName);
        }
        int expectedRegionCount = splitCount > 0 ? enableReplicaCount * splitCount : enableReplicaCount;
        this.assertTotalRegions(expectedRegionCount);
    }

    private static byte[][] getSplits(int numRegions) {
        RegionSplitter.UniformSplit split = new RegionSplitter.UniformSplit();
        split.setFirstRow(Bytes.toBytes((long)0L));
        split.setLastRow(Bytes.toBytes((long)Long.MAX_VALUE));
        return split.split(numRegions);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws IOException {
        TableName tableName = this.name.getTableName();
        HTU.getAdmin().disableTable(tableName);
        HTU.getAdmin().deleteTable(tableName);
    }

    private void assertTotalRegions(int expected) {
        int actual = HTU.getHBaseCluster().getRegions(this.name.getTableName()).size();
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testRegionReplicasUsingEnableTable() throws Exception {
        this.enableReplicationByModification(false, 0, 3, 0);
    }

    @Test
    public void testRegionReplicasUsingEnableTableForMultipleRegions() throws Exception {
        this.enableReplicationByModification(false, 0, 3, 10);
    }

    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsIncreased() throws Exception {
        this.enableReplicationByModification(true, 2, 3, 0);
    }

    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsDecreased() throws Exception {
        this.enableReplicationByModification(true, 3, 2, 0);
    }

    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsDecreasedWithMultipleRegions() throws Exception {
        this.enableReplicationByModification(true, 3, 2, 20);
    }

    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsIncreasedWithmultipleRegions() throws Exception {
        this.enableReplicationByModification(true, 2, 3, 15);
    }
}

