/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionRequest;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMajorCompactionRequest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMajorCompactionRequest.class);
    protected static final HBaseTestingUtility UTILITY = new HBaseTestingUtility();
    protected static final String FAMILY = "a";
    protected Path rootRegionDir;
    protected Path regionStoreDir;

    @Before
    public void setUp() throws Exception {
        this.rootRegionDir = UTILITY.getDataTestDirOnTestFS("TestMajorCompactionRequest");
        this.regionStoreDir = new Path(this.rootRegionDir, FAMILY);
    }

    @Test
    public void testStoresNeedingCompaction() throws Exception {
        List<StoreFileInfo> storeFiles = this.mockStoreFiles(this.regionStoreDir, 5, 10L);
        MajorCompactionRequest request = this.makeMockRequest(storeFiles, false);
        Optional result = request.createRequest((Configuration)Mockito.mock(Configuration.class), (Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 100L);
        Assert.assertTrue((boolean)result.isPresent());
        storeFiles = this.mockStoreFiles(this.regionStoreDir, 5, 101L);
        request = this.makeMockRequest(storeFiles, false);
        result = request.createRequest((Configuration)Mockito.mock(Configuration.class), (Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 100L);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testIfWeHaveNewReferenceFilesButOldStoreFiles() throws Exception {
        TableName table = TableName.valueOf((String)"TestMajorCompactor");
        HTableDescriptor htd = UTILITY.createTableDescriptor(table, Bytes.toBytes((String)FAMILY));
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        HRegion region = HBaseTestingUtility.createRegionAndWAL(hri, this.rootRegionDir, UTILITY.getConfiguration(), (TableDescriptor)htd);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        List<StoreFileInfo> storeFiles = this.mockStoreFiles(this.regionStoreDir, 4, 101L);
        List paths = storeFiles.stream().map(StoreFileInfo::getPath).collect(Collectors.toList());
        HRegionFileSystem fileSystem = this.mockFileSystem(region.getRegionInfo(), true, storeFiles, 50L);
        MajorCompactionRequest majorCompactionRequest = (MajorCompactionRequest)Mockito.spy((Object)new MajorCompactionRequest(configuration, region.getRegionInfo(), (Set)Sets.newHashSet((Object[])new String[]{FAMILY})));
        ((MajorCompactionRequest)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)majorCompactionRequest)).getConnection((Configuration)ArgumentMatchers.eq((Object)configuration));
        ((MajorCompactionRequest)Mockito.doReturn(paths).when((Object)majorCompactionRequest)).getReferenceFilePaths((FileSystem)ArgumentMatchers.any(FileSystem.class), (Path)ArgumentMatchers.any(Path.class));
        ((MajorCompactionRequest)Mockito.doReturn((Object)fileSystem).when((Object)majorCompactionRequest)).getFileSystem((Connection)ArgumentMatchers.any(Connection.class));
        Set result = majorCompactionRequest.getStoresRequiringCompaction((Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 100L);
        Assert.assertEquals((Object)FAMILY, (Object)Iterables.getOnlyElement((Iterable)result));
    }

    protected HRegionFileSystem mockFileSystem(RegionInfo info, boolean hasReferenceFiles, List<StoreFileInfo> storeFiles) throws IOException {
        long timestamp = ((StoreFileInfo)storeFiles.stream().findFirst().get()).getModificationTime();
        return this.mockFileSystem(info, hasReferenceFiles, storeFiles, timestamp);
    }

    private HRegionFileSystem mockFileSystem(RegionInfo info, boolean hasReferenceFiles, List<StoreFileInfo> storeFiles, long referenceFileTimestamp) throws IOException {
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        if (hasReferenceFiles) {
            FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
            ((FileStatus)Mockito.doReturn((Object)referenceFileTimestamp).when((Object)fileStatus)).getModificationTime();
            ((FileSystem)Mockito.doReturn((Object)fileStatus).when((Object)fileSystem)).getFileLinkStatus((Path)ArgumentMatchers.isA(Path.class));
        }
        HRegionFileSystem mockSystem = (HRegionFileSystem)Mockito.mock(HRegionFileSystem.class);
        ((HRegionFileSystem)Mockito.doReturn((Object)info).when((Object)mockSystem)).getRegionInfo();
        ((HRegionFileSystem)Mockito.doReturn((Object)this.regionStoreDir).when((Object)mockSystem)).getStoreDir(FAMILY);
        ((HRegionFileSystem)Mockito.doReturn((Object)hasReferenceFiles).when((Object)mockSystem)).hasReferences(Matchers.anyString());
        ((HRegionFileSystem)Mockito.doReturn(storeFiles).when((Object)mockSystem)).getStoreFiles(Matchers.anyString());
        ((HRegionFileSystem)Mockito.doReturn((Object)fileSystem).when((Object)mockSystem)).getFileSystem();
        return mockSystem;
    }

    protected List<StoreFileInfo> mockStoreFiles(Path regionStoreDir, int howMany, long timestamp) throws IOException {
        ArrayList infos = Lists.newArrayList();
        for (int i = 0; i < howMany; ++i) {
            StoreFileInfo storeFileInfo = (StoreFileInfo)Mockito.mock(StoreFileInfo.class);
            ((StoreFileInfo)Mockito.doReturn((Object)timestamp).doReturn((Object)timestamp).when((Object)storeFileInfo)).getModificationTime();
            ((StoreFileInfo)Mockito.doReturn((Object)new Path(regionStoreDir, RandomStringUtils.randomAlphabetic((int)10))).when((Object)storeFileInfo)).getPath();
            infos.add(storeFileInfo);
        }
        return infos;
    }

    private MajorCompactionRequest makeMockRequest(List<StoreFileInfo> storeFiles, boolean references) throws IOException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        RegionInfo regionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)regionInfo.getEncodedName()).thenReturn((Object)"HBase");
        Mockito.when((Object)regionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"foo"));
        MajorCompactionRequest request = new MajorCompactionRequest(configuration, regionInfo, (Set)Sets.newHashSet((Object[])new String[]{FAMILY}));
        MajorCompactionRequest spy = (MajorCompactionRequest)Mockito.spy((Object)request);
        HRegionFileSystem fileSystem = this.mockFileSystem(regionInfo, references, storeFiles);
        ((MajorCompactionRequest)Mockito.doReturn((Object)fileSystem).when((Object)spy)).getFileSystem((Connection)ArgumentMatchers.isA(Connection.class));
        ((MajorCompactionRequest)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)spy)).getConnection((Configuration)ArgumentMatchers.eq((Object)configuration));
        return spy;
    }
}

