/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HbckRegionInfo;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HbckChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger((String)HbckChore.class.getName());
    private static final String HBCK_CHORE_INTERVAL = "hbase.master.hbck.chore.interval";
    private static final int DEFAULT_HBCK_CHORE_INTERVAL = 3600000;
    private final MasterServices master;
    private final Map<String, HbckRegionInfo> regionInfoMap = new HashMap<String, HbckRegionInfo>();
    private final Set<String> disabledTableRegions = new HashSet<String>();
    private final Set<String> splitParentRegions = new HashSet<String>();
    private final Map<String, ServerName> orphanRegionsOnRS = new HashMap<String, ServerName>();
    private final Map<String, Path> orphanRegionsOnFS = new HashMap<String, Path>();
    private final Map<String, Pair<ServerName, List<ServerName>>> inconsistentRegions = new HashMap<String, Pair<ServerName, List<ServerName>>>();
    private final Map<String, ServerName> orphanRegionsOnRSSnapshot = new HashMap<String, ServerName>();
    private final Map<String, Path> orphanRegionsOnFSSnapshot = new HashMap<String, Path>();
    private final Map<String, Pair<ServerName, List<ServerName>>> inconsistentRegionsSnapshot = new HashMap<String, Pair<ServerName, List<ServerName>>>();
    ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private volatile boolean running = false;
    private volatile long checkingStartTimestamp = 0L;
    private volatile long checkingEndTimestamp = 0L;
    private boolean disabled = false;

    public HbckChore(MasterServices master) {
        super("HbckChore-", (Stoppable)master, master.getConfiguration().getInt(HBCK_CHORE_INTERVAL, 3600000));
        this.master = master;
        int interval = master.getConfiguration().getInt(HBCK_CHORE_INTERVAL, 3600000);
        if (interval <= 0) {
            LOG.warn("hbase.master.hbck.chore.interval is <=0 hence disabling hbck chore");
            this.disableChore();
        }
    }

    protected synchronized void chore() {
        if (this.isDisabled() || this.isRunning()) {
            LOG.warn("hbckChore is either disabled or is already running. Can't run the chore");
            return;
        }
        this.regionInfoMap.clear();
        this.disabledTableRegions.clear();
        this.splitParentRegions.clear();
        this.orphanRegionsOnRS.clear();
        this.orphanRegionsOnFS.clear();
        this.inconsistentRegions.clear();
        this.checkingStartTimestamp = EnvironmentEdgeManager.currentTime();
        this.running = true;
        try {
            this.loadRegionsFromInMemoryState();
            this.loadRegionsFromRSReport();
            try {
                this.loadRegionsFromFS(this.scanForMergedParentRegions());
            }
            catch (IOException e) {
                LOG.warn("Failed to load the regions from filesystem", (Throwable)e);
            }
            this.saveCheckResultToSnapshot();
        }
        catch (Throwable t) {
            LOG.warn("Unexpected", t);
        }
        this.running = false;
        this.updateAssignmentManagerMetrics();
    }

    protected boolean runChore() {
        if (this.isDisabled() || this.isRunning()) {
            if (this.isDisabled()) {
                LOG.warn("hbck chore is disabled! Set hbase.master.hbck.chore.interval > 0 to enable it.");
            } else {
                LOG.warn("hbck chore already running. Can't run till it finishes.");
            }
            return false;
        }
        this.chore();
        return true;
    }

    private void disableChore() {
        this.disabled = true;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private void saveCheckResultToSnapshot() {
        this.rwLock.writeLock().lock();
        try {
            this.orphanRegionsOnRSSnapshot.clear();
            this.orphanRegionsOnRS.entrySet().forEach(e -> this.orphanRegionsOnRSSnapshot.put((String)e.getKey(), (ServerName)e.getValue()));
            this.orphanRegionsOnFSSnapshot.clear();
            this.orphanRegionsOnFS.entrySet().forEach(e -> this.orphanRegionsOnFSSnapshot.put((String)e.getKey(), (Path)e.getValue()));
            this.inconsistentRegionsSnapshot.clear();
            this.inconsistentRegions.entrySet().forEach(e -> this.inconsistentRegionsSnapshot.put((String)e.getKey(), (Pair<ServerName, List<ServerName>>)e.getValue()));
            this.checkingEndTimestamp = EnvironmentEdgeManager.currentTime();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private HashSet<String> scanForMergedParentRegions() throws IOException {
        HashSet<String> mergedParentRegions = new HashSet<String>();
        MetaTableAccessor.scanMetaForTableRegions((Connection)this.master.getConnection(), r -> {
            List mergeParents = MetaTableAccessor.getMergeRegions((Cell[])r.rawCells());
            if (mergeParents != null) {
                for (RegionInfo mergeRegion : mergeParents) {
                    if (mergeRegion == null) continue;
                    mergedParentRegions.add(mergeRegion.getEncodedName());
                }
            }
            return true;
        }, null);
        return mergedParentRegions;
    }

    private void loadRegionsFromInMemoryState() {
        ArrayList<RegionState> regionStates = this.master.getAssignmentManager().getRegionStates().getRegionStates();
        for (RegionState regionState : regionStates) {
            RegionInfo regionInfo = regionState.getRegion();
            if (this.master.getTableStateManager().isTableState(regionInfo.getTable(), TableState.State.DISABLED)) {
                this.disabledTableRegions.add(regionInfo.getRegionNameAsString());
            }
            if (regionState.isSplit() || regionInfo.isSplit()) {
                this.splitParentRegions.add(regionInfo.getRegionNameAsString());
            }
            HbckRegionInfo.MetaEntry metaEntry = new HbckRegionInfo.MetaEntry(regionInfo, regionState.getServerName(), regionState.getStamp());
            this.regionInfoMap.put(regionInfo.getEncodedName(), new HbckRegionInfo(metaEntry));
        }
        LOG.info("Loaded {} regions ({} disabled, {} split parents) from in-memory state", new Object[]{regionStates.size(), this.disabledTableRegions.size(), this.splitParentRegions.size()});
        if (LOG.isDebugEnabled()) {
            HashMap<RegionState.State, Integer> stateCountMap = new HashMap<RegionState.State, Integer>();
            for (RegionState regionState : regionStates) {
                stateCountMap.compute(regionState.getState(), (k, v) -> v == null ? 1 : v + 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Regions by state: ");
            stateCountMap.entrySet().forEach(e -> {
                sb.append(e.getKey());
                sb.append('=');
                sb.append(e.getValue());
                sb.append(' ');
            });
            LOG.debug(stringBuffer.toString());
        }
        if (LOG.isTraceEnabled()) {
            for (RegionState regionState : regionStates) {
                LOG.trace("{}: {}, serverName=", new Object[]{regionState.getRegion(), regionState.getState(), regionState.getServerName()});
            }
        }
    }

    private void loadRegionsFromRSReport() {
        int numRegions = 0;
        Map<ServerName, Set<byte[]>> rsReports = this.master.getAssignmentManager().getRSReports();
        for (Map.Entry<ServerName, Set<byte[]>> entry : rsReports.entrySet()) {
            ServerName serverName = entry.getKey();
            for (byte[] regionName : entry.getValue()) {
                String encodedRegionName = RegionInfo.encodeRegionName((byte[])regionName);
                HbckRegionInfo hri = this.regionInfoMap.get(encodedRegionName);
                if (hri == null) {
                    this.orphanRegionsOnRS.put(RegionInfo.getRegionNameAsString((byte[])regionName), serverName);
                    continue;
                }
                hri.addServer((RegionInfo)hri.getMetaEntry(), serverName);
            }
            numRegions += entry.getValue().size();
        }
        LOG.info("Loaded {} regions from {} regionservers' reports and found {} orphan regions", new Object[]{numRegions, rsReports.size(), this.orphanRegionsOnRS.size()});
        for (Map.Entry<Object, Object> entry : this.regionInfoMap.entrySet()) {
            HbckRegionInfo hri = (HbckRegionInfo)entry.getValue();
            ServerName locationInMeta = hri.getMetaEntry().getRegionServer();
            if (locationInMeta == null) continue;
            if (hri.getDeployedOn().size() == 0) {
                if (this.disabledTableRegions.contains(hri.getRegionNameAsString()) || this.splitParentRegions.contains(hri.getRegionNameAsString())) continue;
                this.inconsistentRegions.put(hri.getRegionNameAsString(), (Pair<ServerName, List<ServerName>>)new Pair((Object)locationInMeta, new LinkedList()));
                continue;
            }
            if (hri.getDeployedOn().size() > 1) {
                this.inconsistentRegions.put(hri.getRegionNameAsString(), (Pair<ServerName, List<ServerName>>)new Pair((Object)locationInMeta, hri.getDeployedOn()));
                continue;
            }
            if (hri.getDeployedOn().get(0).equals((Object)locationInMeta)) continue;
            this.inconsistentRegions.put(hri.getRegionNameAsString(), (Pair<ServerName, List<ServerName>>)new Pair((Object)locationInMeta, hri.getDeployedOn()));
        }
    }

    private void loadRegionsFromFS(HashSet<String> mergedParentRegions) throws IOException {
        Path rootDir = this.master.getMasterFileSystem().getRootDir();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        int numRegions = 0;
        List<Path> tableDirs = FSUtils.getTableDirs(fs, rootDir);
        for (Path tableDir : tableDirs) {
            List<Path> regionDirs = FSUtils.getRegionDirs(fs, tableDir);
            for (Path regionDir : regionDirs) {
                String encodedRegionName = regionDir.getName();
                if (encodedRegionName == null) {
                    LOG.warn("Failed get of encoded name from {}", (Object)regionDir);
                    continue;
                }
                HbckRegionInfo hri = this.regionInfoMap.get(encodedRegionName);
                if (hri != null || mergedParentRegions.contains(encodedRegionName)) continue;
                this.orphanRegionsOnFS.put(encodedRegionName, regionDir);
            }
            numRegions += regionDirs.size();
        }
        LOG.info("Loaded {} tables {} regions from filesystem and found {} orphan regions", new Object[]{tableDirs.size(), numRegions, this.orphanRegionsOnFS.size()});
    }

    private void updateAssignmentManagerMetrics() {
        this.master.getAssignmentManager().getAssignmentManagerMetrics().updateOrphanRegionsOnRs(this.getOrphanRegionsOnRS().size());
        this.master.getAssignmentManager().getAssignmentManagerMetrics().updateOrphanRegionsOnFs(this.getOrphanRegionsOnFS().size());
        this.master.getAssignmentManager().getAssignmentManagerMetrics().updateInconsistentRegions(this.getInconsistentRegions().size());
    }

    public boolean isRunning() {
        return this.running;
    }

    public Map<String, ServerName> getOrphanRegionsOnRS() {
        this.rwLock.readLock().lock();
        try {
            Map<String, ServerName> map = this.orphanRegionsOnRSSnapshot;
            return map;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Map<String, Path> getOrphanRegionsOnFS() {
        this.rwLock.readLock().lock();
        try {
            Map<String, Path> map = this.orphanRegionsOnFSSnapshot;
            return map;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Map<String, Pair<ServerName, List<ServerName>>> getInconsistentRegions() {
        this.rwLock.readLock().lock();
        try {
            Map<String, Pair<ServerName, List<ServerName>>> map = this.inconsistentRegionsSnapshot;
            return map;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public long getCheckingStartTimestamp() {
        return this.checkingStartTimestamp;
    }

    public long getCheckingEndTimestamp() {
        return this.checkingEndTimestamp;
    }
}

