/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ServerNonceManager {
    public static final String HASH_NONCE_GRACE_PERIOD_KEY = "hbase.server.hashNonce.gracePeriod";
    private static final Logger LOG = LoggerFactory.getLogger(ServerNonceManager.class);
    private int conflictWaitIterationMs = 30000;
    private static final SimpleDateFormat tsFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private ConcurrentHashMap<NonceKey, OperationContext> nonces = new ConcurrentHashMap();
    private int deleteNonceGracePeriod;

    public ServerNonceManager(Configuration conf) {
        this.deleteNonceGracePeriod = conf.getInt(HASH_NONCE_GRACE_PERIOD_KEY, 1800000);
        if (this.deleteNonceGracePeriod < 60000) {
            LOG.warn("Nonce grace period " + this.deleteNonceGracePeriod + " is less than a minute; might be too small to be useful");
        }
    }

    public void setConflictWaitIterationMs(int conflictWaitIterationMs) {
        this.conflictWaitIterationMs = conflictWaitIterationMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startOperation(long group, long nonce, Stoppable stoppable) throws InterruptedException {
        if (nonce == 0L) {
            return true;
        }
        NonceKey nk = new NonceKey(group, nonce);
        OperationContext ctx = new OperationContext();
        OperationContext oldResult;
        while ((oldResult = this.nonces.putIfAbsent(nk, ctx)) != null) {
            OperationContext operationContext = oldResult;
            synchronized (operationContext) {
                int oldState = oldResult.getState();
                LOG.debug("Conflict detected by nonce: " + nk + ", " + oldResult);
                if (oldState != 2) {
                    return oldState == 1;
                }
                oldResult.setHasWait();
                oldResult.wait(this.conflictWaitIterationMs);
                if (stoppable.isStopped()) {
                    throw new InterruptedException("Server stopped");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperation(long group, long nonce, boolean success) {
        if (nonce == 0L) {
            return;
        }
        NonceKey nk = new NonceKey(group, nonce);
        OperationContext newResult = this.nonces.get(nk);
        assert (newResult != null);
        OperationContext operationContext = newResult;
        synchronized (operationContext) {
            assert (newResult.getState() == 2);
            newResult.setState(success ? 0 : 1);
            if (success) {
                newResult.reportActivity();
            } else {
                OperationContext val = this.nonces.remove(nk);
                assert (val == newResult);
            }
            if (newResult.hasWait()) {
                LOG.debug("Conflict with running op ended: " + nk + ", " + newResult);
                newResult.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMvccToOperationContext(long group, long nonce, long mvcc) {
        if (nonce == 0L) {
            return;
        }
        NonceKey nk = new NonceKey(group, nonce);
        OperationContext result = this.nonces.get(nk);
        assert (result != null);
        OperationContext operationContext = result;
        synchronized (operationContext) {
            result.setMvcc(mvcc);
        }
    }

    public long getMvccFromOperationContext(long group, long nonce) {
        if (nonce == 0L) {
            return Long.MAX_VALUE;
        }
        NonceKey nk = new NonceKey(group, nonce);
        OperationContext result = this.nonces.get(nk);
        return result == null ? Long.MAX_VALUE : result.getMvcc();
    }

    public void reportOperationFromWal(long group, long nonce, long writeTime) {
        if (nonce == 0L) {
            return;
        }
        long now = EnvironmentEdgeManager.currentTime();
        if ((double)now > (double)writeTime + (double)this.deleteNonceGracePeriod * 1.5) {
            return;
        }
        OperationContext newResult = new OperationContext();
        newResult.setState(0);
        NonceKey nk = new NonceKey(group, nonce);
        OperationContext oldResult = this.nonces.putIfAbsent(nk, newResult);
        if (oldResult != null) {
            LOG.warn("Nonce collision during WAL recovery: " + nk + ", " + oldResult + " with " + newResult);
        }
    }

    public ScheduledChore createCleanupScheduledChore(Stoppable stoppable) {
        return new ScheduledChore("nonceCleaner", stoppable, this.deleteNonceGracePeriod / 5){

            protected void chore() {
                ServerNonceManager.this.cleanUpOldNonces();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOldNonces() {
        long cutoff = EnvironmentEdgeManager.currentTime() - (long)this.deleteNonceGracePeriod;
        for (Map.Entry<NonceKey, OperationContext> entry : this.nonces.entrySet()) {
            OperationContext oc = entry.getValue();
            if (!oc.isExpired(cutoff)) continue;
            OperationContext operationContext = oc;
            synchronized (operationContext) {
                if (oc.getState() == 2 || !oc.isExpired(cutoff)) {
                    continue;
                }
                this.nonces.remove(entry.getKey());
            }
        }
    }

    private static class OperationContext {
        static final int DONT_PROCEED = 0;
        static final int PROCEED = 1;
        static final int WAIT = 2;
        private long data = 0L;
        private static final long STATE_BITS = 3L;
        private static final long WAITING_BIT = 4L;
        private static final long ALL_FLAG_BITS = 7L;
        private volatile long mvcc;

        public String toString() {
            return "[state " + this.getState() + ", hasWait " + this.hasWait() + ", activity " + tsFormat.format(new Date(this.getActivityTime())) + "]";
        }

        public OperationContext() {
            this.setState(2);
            this.reportActivity();
        }

        public void setState(int state) {
            this.data = this.data & 0xFFFFFFFFFFFFFFFCL | (long)state;
        }

        public int getState() {
            return (int)(this.data & 3L);
        }

        public void setHasWait() {
            this.data |= 4L;
        }

        public boolean hasWait() {
            return (this.data & 4L) == 4L;
        }

        public void reportActivity() {
            long now = EnvironmentEdgeManager.currentTime();
            this.data = this.data & 7L | now << 3;
        }

        public boolean isExpired(long minRelevantTime) {
            return this.getActivityTime() < (minRelevantTime & 0x1FFFFFFFFFFFFFFFL);
        }

        public void setMvcc(long mvcc) {
            this.mvcc = mvcc;
        }

        public long getMvcc() {
            return this.mvcc;
        }

        private long getActivityTime() {
            return this.data >>> 3;
        }
    }
}

