// Autogenerated Jamon implementation
// /home/apurtell/tmp/RM/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
// 30, 9
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
// 31, 9
import org.apache.hadoop.hbase.RegionMetrics;
// 32, 9
import org.apache.hadoop.hbase.ServerMetrics;
// 33, 9
import org.apache.hadoop.hbase.ServerName;
// 34, 9
import org.apache.hadoop.hbase.Size;
// 35, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 36, 9
import org.apache.hadoop.hbase.util.Pair;
// 37, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 40, 1
    if ((servers != null && servers.size() > 0))
    {
      // 40, 47
      jamonWriter.write("\n\n");
      // 42, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 47, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n        <li class=\"\"><a href=\"#tab_replicationStats\" data-toggle=\"tab\">Replications</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 58, 13
      {
        // 58, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 58, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 61, 13
      {
        // 61, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 61, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 64, 13
      {
        // 64, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 64, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 67, 13
      {
        // 67, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 67, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStats\">\n            ");
      // 70, 13
      {
        // 70, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 70, 62
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_replicationStats\">\n            ");
      // 73, 13
      {
        // 73, 13
        __jamon_innerUnit__replicationStats(jamonWriter, serverNames);
      }
      // 73, 63
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 78, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 80, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 84, 1
    jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n</thead>\n<tbody>\n");
    // 96, 1
    
    int totalRegions = 0;
    int totalRequestsPerSecond = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerMetrics sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }

    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestCountPerSecond();
        numRegionsOnline = sl.getRegionMetrics().size();
        totalRegions += sl.getRegionMetrics().size();
        totalRequestsPerSecond += sl.getRequestCountPerSecond();
        lastContact = (System.currentTimeMillis() - sl.getReportTimestamp())/1000;
    }
    long startcode = serverName.getStartcode();

    // 122, 1
    jamonWriter.write("<tr>\n    <td>");
    // 123, 9
    {
      // 123, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 123, 53
    jamonWriter.write("</td>\n    <td>");
    // 124, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 124, 34
    jamonWriter.write("</td>\n    <td>");
    // 125, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 125, 71
    jamonWriter.write("</td>\n    <td>");
    // 126, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 126, 22
    jamonWriter.write("</td>\n    <td>");
    // 127, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,.0f", requestsPerSecond)), jamonWriter);
    // 127, 56
    jamonWriter.write("</td>\n    <td>");
    // 128, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", numRegionsOnline)), jamonWriter);
    // 128, 53
    jamonWriter.write("</td>\n</tr>\n");
    // 130, 1
    
}

    // 133, 1
    jamonWriter.write("</tbody>\n<tr><td>Total:");
    // 134, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 134, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
    // 137, 1
    if (inconsistentNodeNum > 0)
    {
      // 137, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 138, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 138, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 139, 1
    else
    {
      // 139, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 141, 7
    jamonWriter.write("\n<td>");
    // 142, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequestsPerSecond), jamonWriter);
    // 142, 33
    jamonWriter.write("</td>\n<td>");
    // 143, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 143, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 339, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 343, 1
    jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n</thead>\n<tbody>\n");
    // 354, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
long totalCompactingCells = 0;
long totalCompactedCells = 0;
for (RegionMetrics rl : sl.getRegionMetrics().values()) {
  totalCompactingCells += rl.getCompactingCellCount();
  totalCompactedCells += rl.getCompactedCellCount();
}
String percentDone = "";
if  (totalCompactingCells > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) totalCompactedCells / totalCompactingCells)) + "%";
}

    // 371, 1
    jamonWriter.write("<tr>\n<td>");
    // 372, 5
    {
      // 372, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 372, 49
    jamonWriter.write("</td>\n<td>");
    // 373, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", totalCompactingCells)), jamonWriter);
    // 373, 53
    jamonWriter.write("</td>\n<td>");
    // 374, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", totalCompactedCells)), jamonWriter);
    // 374, 52
    jamonWriter.write("</td>\n<td>");
    // 375, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", totalCompactingCells - totalCompactedCells)), jamonWriter);
    // 375, 75
    jamonWriter.write("</td>\n<td>");
    // 376, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 376, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 378, 1
    
        }  else {
        
    // 381, 1
    {
      // 381, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 381, 40
    jamonWriter.write("\n");
    // 382, 1
    
    }
}

    // 386, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 472, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 476, 5
    jamonWriter.write("<tr>\n    <td>");
    // 477, 9
    {
      // 477, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 477, 53
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 148, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 152, 1
    jamonWriter.write("<table id=\"memoryStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n</thead>\n<tbody>\n");
    // 163, 1
    
final String ZEROMB = "0 MB";
for (ServerName serverName: serverNames) {
  String usedHeapStr = ZEROMB;
  String maxHeapStr = ZEROMB;
  String memStoreSizeMBStr = ZEROMB;
  ServerMetrics sl = master.getServerManager().getLoad(serverName);
  if (sl != null) {
    long memStoreSizeMB = 0;
    for (RegionMetrics rl : sl.getRegionMetrics().values()) {
      memStoreSizeMB += rl.getMemStoreSize().get(Size.Unit.MEGABYTE);
    }
    if (memStoreSizeMB > 0) {
      memStoreSizeMBStr = TraditionalBinaryPrefix.long2String(memStoreSizeMB
                                * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }

    double usedHeapSizeMB = sl.getUsedHeapSize().get(Size.Unit.MEGABYTE);
    if (usedHeapSizeMB > 0) {
      usedHeapStr = TraditionalBinaryPrefix.long2String((long) usedHeapSizeMB
                          * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }
    double maxHeapSizeMB = sl.getMaxHeapSize().get(Size.Unit.MEGABYTE);
    if (maxHeapSizeMB > 0) {
      maxHeapStr = TraditionalBinaryPrefix.long2String((long) maxHeapSizeMB
                         * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }

    // 191, 1
    jamonWriter.write("<tr>\n    <td>");
    // 192, 9
    {
      // 192, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 192, 53
    jamonWriter.write("</td>\n    <td>");
    // 193, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(usedHeapStr), jamonWriter);
    // 193, 26
    jamonWriter.write("</td>\n    <td>");
    // 194, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(maxHeapStr), jamonWriter);
    // 194, 25
    jamonWriter.write("</td>\n    <td>");
    // 195, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(memStoreSizeMBStr), jamonWriter);
    // 195, 32
    jamonWriter.write("</td>\n</tr>\n");
    // 197, 1
    
  } else {

    // 200, 1
    {
      // 200, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 200, 40
    jamonWriter.write("\n");
    // 201, 1
    
  }
}

    // 205, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 390, 1
  private void __jamon_innerUnit__replicationStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 394, 1
    
        HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>> replicationLoadSourceMap
            = master.getReplicationLoad(serverNames);
        List<String> peers = null;
        if (replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0){
            peers = new ArrayList<>(replicationLoadSourceMap.keySet());
            Collections.sort(peers);
        }

    // 404, 1
    if ((replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0) )
    {
      // 404, 82
      jamonWriter.write("\n\n<div class=\"tabbable\">\n    <ul class=\"nav nav-tabs\">\n        ");
      // 408, 9
      
        String active = "active";
        for (String peer : peers){
        
      // 412, 13
      jamonWriter.write("<li class=");
      // 412, 23
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 412, 35
      jamonWriter.write("><a href=\"#tab_");
      // 412, 50
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 412, 60
      jamonWriter.write("\" data-toggle=\"tab\">Peer ");
      // 412, 85
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 412, 95
      jamonWriter.write("</a> </li>\n        ");
      // 413, 9
      
        active = "";
        }
        
      // 417, 5
      jamonWriter.write("</ul>\n    <div class=\"tab-content\">\n        ");
      // 419, 9
      
            active = "active";
            for (String peer : peers){
        
      // 423, 13
      jamonWriter.write("<div class=\"tab-pane ");
      // 423, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 423, 46
      jamonWriter.write("\" id=\"tab_");
      // 423, 56
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 423, 66
      jamonWriter.write("\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Server</th>\n                        <th>AgeOfLastShippedOp</th>\n                        <th>SizeOfLogQueue</th>\n                        <th>ReplicationLag</th>\n                    </tr>\n\n                    ");
      // 432, 21
      for (Pair<ServerName, ReplicationLoadSource> pair: replicationLoadSourceMap.get(peer) )
      {
        // 432, 110
        jamonWriter.write("\n                    <tr>\n                        <td>");
        // 434, 29
        {
          // 434, 29
          __jamon_innerUnit__serverNameLink(jamonWriter, pair.getFirst());
        }
        // 434, 78
        jamonWriter.write("</td>\n                        <td>");
        // 435, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanTimeDiff(pair.getSecond().getAgeOfLastShippedOp())), jamonWriter);
        // 435, 102
        jamonWriter.write("</td>\n                        <td>");
        // 436, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(pair.getSecond().getSizeOfLogQueue()), jamonWriter);
        // 436, 71
        jamonWriter.write("</td>\n                        <td>");
        // 437, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(pair.getSecond().getReplicationLag() == Long.MAX_VALUE ? "UNKNOWN" : StringUtils.humanTimeDiff(pair.getSecond().getReplicationLag())), jamonWriter);
        // 437, 167
        jamonWriter.write("</td>\n                    </tr>\n                    ");
      }
      // 439, 28
      jamonWriter.write("\n        </table>\n            </div>\n        ");
      // 442, 9
      
                active = "";
                }
        
      // 446, 5
      jamonWriter.write("</div>\n    <p>If the replication delay is UNKNOWN, that means this walGroup doesn't start replicate yet and it may get disabled.</p>\n</div>\n");
    }
    // 449, 1
    else
    {
      // 449, 8
      jamonWriter.write("\n    <p>No Peers Metrics</p>\n");
    }
    // 451, 7
    jamonWriter.write("\n");
  }
  
  
  // 210, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 214, 1
    jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n</thead>\n<tbody>\n");
    // 225, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
  long readRequestCount = 0;
  long writeRequestCount = 0;
  long filteredReadRequestCount = 0;
  for (RegionMetrics rl : sl.getRegionMetrics().values()) {
    readRequestCount += rl.getReadRequestCount();
    writeRequestCount += rl.getWriteRequestCount();
    filteredReadRequestCount += rl.getFilteredReadRequestCount();
  }

    // 239, 1
    jamonWriter.write("<tr>\n<td>");
    // 240, 5
    {
      // 240, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 240, 49
    jamonWriter.write("</td>\n<td>");
    // 241, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", sl.getRequestCountPerSecond())), jamonWriter);
    // 241, 62
    jamonWriter.write("</td>\n<td>");
    // 242, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", readRequestCount)), jamonWriter);
    // 242, 49
    jamonWriter.write("</td>\n<td>");
    // 243, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", filteredReadRequestCount)), jamonWriter);
    // 243, 57
    jamonWriter.write("</td>\n<td>");
    // 244, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", writeRequestCount)), jamonWriter);
    // 244, 50
    jamonWriter.write("</td>\n</tr>\n");
    // 246, 1
    
        }  else {
        
    // 249, 1
    {
      // 249, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 249, 40
    jamonWriter.write("\n");
    // 250, 1
    
        }
}

    // 254, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 456, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 460, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 465, 9
    if (infoPort > 0)
    {
      // 465, 28
      jamonWriter.write("\n            <a href=\"");
      // 466, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 466, 31
      jamonWriter.write("\">");
      // 466, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 466, 65
      jamonWriter.write("</a>\n        ");
    }
    // 467, 9
    else
    {
      // 467, 16
      jamonWriter.write("\n            ");
      // 468, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 468, 45
      jamonWriter.write("\n        ");
    }
    // 469, 15
    jamonWriter.write("\n");
  }
  
  
  // 259, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 263, 1
    jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n</thead>\n<tbody>\n");
    // 276, 1
    
final String ZEROKB = "0 KB";
final String ZEROMB = "0 MB";
for (ServerName serverName: serverNames) {

  String storeUncompressedSizeMBStr = ZEROMB;
  String storeFileSizeMBStr = ZEROMB;
  String totalStaticIndexSizeKBStr = ZEROKB;
  String totalStaticBloomSizeKBStr = ZEROKB;
  ServerMetrics sl = master.getServerManager().getLoad(serverName);
  if (sl != null) {
    long storeCount = 0;
    long storeFileCount = 0;
    long storeUncompressedSizeMB = 0;
    long storeFileSizeMB = 0;
    long totalStaticIndexSizeKB = 0;
    long totalStaticBloomSizeKB = 0;
    for (RegionMetrics rl : sl.getRegionMetrics().values()) {
      storeCount += rl.getStoreCount();
      storeFileCount += rl.getStoreFileCount();
      storeUncompressedSizeMB += rl.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
      storeFileSizeMB += rl.getStoreFileSize().get(Size.Unit.MEGABYTE);
      totalStaticIndexSizeKB += rl.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
      totalStaticBloomSizeKB += rl.getBloomFilterSize().get(Size.Unit.KILOBYTE);
    }
    if (storeUncompressedSizeMB > 0) {
      storeUncompressedSizeMBStr = TraditionalBinaryPrefix.
      long2String(storeUncompressedSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }
    if (storeFileSizeMB > 0) {
      storeFileSizeMBStr = TraditionalBinaryPrefix.
      long2String(storeFileSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }
    if (totalStaticIndexSizeKB > 0) {
      totalStaticIndexSizeKBStr = TraditionalBinaryPrefix.
      long2String(totalStaticIndexSizeKB * TraditionalBinaryPrefix.KILO.value, "B", 1);
    }
    if (totalStaticBloomSizeKB > 0) {
      totalStaticBloomSizeKBStr = TraditionalBinaryPrefix.
      long2String(totalStaticBloomSizeKB * TraditionalBinaryPrefix.KILO.value, "B", 1);
    }

    // 318, 1
    jamonWriter.write("<tr>\n<td>");
    // 319, 5
    {
      // 319, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 319, 49
    jamonWriter.write("</td>\n<td>");
    // 320, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", storeCount)), jamonWriter);
    // 320, 43
    jamonWriter.write("</td>\n<td>");
    // 321, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", storeFileCount)), jamonWriter);
    // 321, 47
    jamonWriter.write("</td>\n<td>");
    // 322, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeUncompressedSizeMBStr), jamonWriter);
    // 322, 37
    jamonWriter.write("</td>\n<td>");
    // 323, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeFileSizeMBStr), jamonWriter);
    // 323, 29
    jamonWriter.write("</td>\n<td>");
    // 324, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalStaticIndexSizeKBStr), jamonWriter);
    // 324, 36
    jamonWriter.write("</td>\n<td>");
    // 325, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalStaticBloomSizeKBStr), jamonWriter);
    // 325, 36
    jamonWriter.write("</td>\n</tr>\n");
    // 327, 1
    
  } else {

    // 330, 1
    {
      // 330, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 330, 40
    jamonWriter.write("\n");
    // 331, 1
    
  }
}

    // 335, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
}
