/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.OpenRegionProcedure;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestOpenRegionProcedureHang {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOpenRegionProcedureHang.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestOpenRegionProcedureHang.class);
    private static CountDownLatch ARRIVE;
    private static CountDownLatch RESUME;
    private static CountDownLatch FINISH;
    private static CountDownLatch ABORT;
    private static final HBaseTestingUtility UTIL;
    private static TableName NAME;
    private static byte[] CF;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        conf.setInt("hbase.client.operation.timeout", 600000);
        conf.setInt("hbase.rpc.shortoperation.timeout", 600000);
        UTIL.startMiniCluster(StartMiniClusterOption.builder().numMasters(2).numRegionServers(3).build());
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, KeeperException, IOException {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        HRegionServer rs1 = UTIL.getRSForFirstRegionInTable(NAME);
        HRegionServer rs2 = UTIL.getOtherRegionServer(rs1);
        ARRIVE = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        FINISH = new CountDownLatch(1);
        ABORT = new CountDownLatch(1);
        am.moveAsync(new RegionPlan(region, rs1.getServerName(), rs2.getServerName()));
        ARRIVE.await();
        ARRIVE = null;
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        master.getZooKeeper().close();
        UTIL.waitFor(30000L, () -> {
            for (JVMClusterUtil.MasterThread mt : UTIL.getMiniHBaseCluster().getMasterThreads()) {
                if (mt.getMaster() == master || !mt.getMaster().isActiveMaster()) continue;
                return mt.getMaster().isInitialized();
            }
            return false;
        });
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        UTIL.waitFor(30000L, () -> procExec.getProcedures().stream().filter(p -> p instanceof OpenRegionProcedure).map(p -> (OpenRegionProcedure)p).anyMatch(p -> p.region.getTable().equals((Object)NAME)));
        OpenRegionProcedure proc = procExec.getProcedures().stream().filter(p -> p instanceof OpenRegionProcedure).map(p -> (OpenRegionProcedure)p).filter(p -> p.region.getTable().equals((Object)NAME)).findFirst().get();
        Thread.sleep(2000L);
        RESUME.countDown();
        if (!FINISH.await(15L, TimeUnit.SECONDS)) {
            LOG.info("Wait reportRegionStateTransition to finish timed out, this is possible if we update the procedure store, as the WALProcedureStore will retry forever to roll the writer if it is not closed");
        }
        FINISH = null;
        Thread.sleep(2000L);
        ABORT.countDown();
        UTIL.waitFor(30000L, () -> procExec.isFinished(proc.getProcId()));
        UTIL.waitFor(30000L, () -> procExec.isFinished(proc.getParentProcId()));
    }

    static {
        UTIL = new HBaseTestingUtility();
        NAME = TableName.valueOf((String)"Open");
        CF = Bytes.toBytes((String)"cf");
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master, MasterRegion masterRegion) {
            return new AssignmentManagerForTest(master, masterRegion);
        }

        public void abort(String reason, Throwable cause) {
            if (ABORT != null) {
                try {
                    ABORT.await();
                    ABORT = null;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            super.abort(reason, cause);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master, MasterRegion masterRegion) {
            super(master, masterRegion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
            RegionServerStatusProtos.RegionStateTransition transition = req.getTransition(0);
            if (transition.getTransitionCode() == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED && ProtobufUtil.toTableName((HBaseProtos.TableName)transition.getRegionInfo(0).getTableName()).equals((Object)NAME) && ARRIVE != null) {
                ARRIVE.countDown();
                try {
                    RESUME.await();
                    RESUME = null;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                try {
                    RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransitionResponse = super.reportRegionStateTransition(req);
                    return reportRegionStateTransitionResponse;
                }
                finally {
                    FINISH.countDown();
                }
            }
            return super.reportRegionStateTransition(req);
        }
    }
}

