/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.replication.regionserver.SwitchRpcThrottleRemoteCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SwitchRpcThrottleRemoteProcedure
extends ServerRemoteProcedure
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchRpcThrottleRemoteProcedure.class);
    private boolean rpcThrottleEnabled;

    public SwitchRpcThrottleRemoteProcedure() {
    }

    public SwitchRpcThrottleRemoteProcedure(ServerName serverName, boolean rpcThrottleEnabled) {
        this.targetServer = serverName;
        this.rpcThrottleEnabled = rpcThrottleEnabled;
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SwitchRpcThrottleRemoteStateData.Builder builder = MasterProcedureProtos.SwitchRpcThrottleRemoteStateData.newBuilder();
        builder.setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer)).setRpcThrottleEnabled(this.rpcThrottleEnabled).setState(this.state).build();
        if (this.remoteError != null) {
            ErrorHandlingProtos.ForeignExceptionMessage fem = ForeignExceptionUtil.toProtoForeignException((Throwable)this.remoteError);
            builder.setError(fem);
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SwitchRpcThrottleRemoteStateData data = (MasterProcedureProtos.SwitchRpcThrottleRemoteStateData)serializer.deserialize(MasterProcedureProtos.SwitchRpcThrottleRemoteStateData.class);
        this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getTargetServer());
        this.rpcThrottleEnabled = data.getRpcThrottleEnabled();
        this.state = data.getState();
        if (data.hasError()) {
            this.remoteError = ForeignExceptionUtil.toException((ErrorHandlingProtos.ForeignExceptionMessage)data.getError());
        }
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv masterProcedureEnv, ServerName remote) {
        assert (this.targetServer.equals((Object)remote));
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), SwitchRpcThrottleRemoteCallable.class, MasterProcedureProtos.SwitchRpcThrottleRemoteStateData.newBuilder().setTargetServer(ProtobufUtil.toServerName((ServerName)remote)).setRpcThrottleEnabled(this.rpcThrottleEnabled).build().toByteArray()));
    }

    @Override
    public ServerName getServerName() {
        return this.targetServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.SWITCH_RPC_THROTTLE;
    }

    @Override
    protected boolean complete(MasterProcedureEnv env, Throwable error) {
        if (error != null) {
            LOG.warn("Failed to switch rpc throttle to {} on server {}", new Object[]{this.rpcThrottleEnabled, this.targetServer, error});
            return false;
        }
        return true;
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" server=");
        sb.append(this.targetServer);
        sb.append(", rpcThrottleEnabled=");
        sb.append(this.rpcThrottleEnabled);
    }
}

